/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class VariableNode
implements TreeNode {
    private String name;
    private String hexDump;
    private String textValue;
    private int offset;
    private int length;
    private String className;
    private VariableNode parent;
    private boolean hasChildren;
    private Vector children = new Vector();

    public VariableNode(String string, String string2, String string3, VariableNode variableNode) {
        this(string, string2, string3, 0, 0, variableNode);
    }

    public VariableNode(String string, String string2, String string3, int n2, int n3, VariableNode variableNode) {
        this.name = string;
        this.className = string2;
        this.init(string3, n2, n3);
        this.parent = variableNode;
        if (this.parent != null) {
            this.parent.children.addElement(this);
        }
    }

    public void init(String string, int n2, int n3) {
        this.hexDump = string;
        this.offset = n2;
        this.length = n3;
        if (this.hexDump != null) {
            int n4 = string.indexOf("\u0001");
            if (n4 >= 0) {
                if (n4 == this.hexDump.length() - 1) {
                    this.textValue = "";
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = this.hexDump.substring(n4 + 1).toCharArray();
                    for (int i2 = 0; i2 < cArray.length; ++i2) {
                        char c2 = cArray[i2];
                        if (c2 < ' ') {
                            stringBuffer.append(' ');
                            continue;
                        }
                        stringBuffer.append(cArray[i2]);
                    }
                    this.textValue = stringBuffer.toString();
                }
                this.hexDump = this.hexDump.substring(0, n4);
            } else {
                this.textValue = this.hexDump;
                this.hexDump = "<n/a>";
            }
        }
    }

    public Object[] getPath() {
        ArrayList<VariableNode> arrayList = new ArrayList<VariableNode>();
        VariableNode variableNode = this;
        while (variableNode != null) {
            arrayList.add(0, variableNode);
            variableNode = variableNode.parent;
        }
        return arrayList.toArray();
    }

    private int indexOf(VariableNode variableNode) {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (this.children.elementAt(i2) != variableNode) continue;
            return i2;
        }
        return -1;
    }

    private String getPathStr() {
        StringBuffer stringBuffer = new StringBuffer();
        VariableNode variableNode = this;
        while (variableNode != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "/");
            }
            String string = variableNode.name;
            if (variableNode.parent != null) {
                string = string + "#" + variableNode.parent.indexOf(variableNode);
            }
            stringBuffer.insert(0, string);
            variableNode = variableNode.parent;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof VariableNode)) {
            return false;
        }
        return this.getPathStr().equals(((VariableNode)object).getPathStr());
    }

    public int hashCode() {
        return this.getPathStr().hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void addChild(TreeNode treeNode) {
        this.children.add(treeNode);
        ((VariableNode)treeNode).parent = this;
    }

    public void removeAllChildren() {
        this.children.removeAllElements();
    }

    public void removeChildAt(int n2) {
        this.children.removeElementAt(n2);
    }

    @Override
    public TreeNode getChildAt(int n2) {
        return (VariableNode)this.children.elementAt(n2);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return !this.hasChildren && this.children.size() == 0;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean bl) {
        this.hasChildren = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getHexDump() {
        return this.hexDump;
    }

    public void setHexDump(String string) {
        this.hexDump = string;
        this.textValue = null;
    }

    public String getTextValue() {
        if (this.textValue == null && this.hexDump != null) {
            this.textValue = VariableNode.getTextValue(this.hexDump);
        }
        return this.textValue;
    }

    public void setTextValue(String string) {
        this.textValue = string;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setChildren(Vector vector) {
        this.children = vector;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    private static String getTextValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            for (int i2 = 0; i2 < string.length(); i2 += 2) {
                int n2 = Integer.parseInt(string.substring(i2, i2 + 2), 16);
                if (VariableNode.isPrintableChar(n2)) {
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append('.');
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isPrintableChar(int n2) {
        return n2 >= 32 && n2 <= 126;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getClassName() {
        return this.className;
    }
}

