/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.gui.client.swing.treetable.AbstractTreeTableModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class VectorModel
extends AbstractTreeTableModel {
    protected Vector vector;
    protected Map cache = new HashMap();
    protected Class[] columnTypes;
    protected String[] columnNames;
    protected boolean[] editableColumn;
    protected GraphDebugger graphDebug;

    public VectorModel(Class[] classArray, String[] stringArray, GraphDebugger graphDebugger) {
        this(classArray, stringArray, new int[0], graphDebugger);
    }

    public VectorModel(Class[] classArray, String[] stringArray, int n2, GraphDebugger graphDebugger) {
        this(classArray, stringArray, new int[]{n2}, graphDebugger);
    }

    public VectorModel(Class[] classArray, String[] stringArray, int[] nArray, GraphDebugger graphDebugger) {
        super(new Vector());
        this.vector = (Vector)this.getRoot();
        this.columnTypes = classArray;
        this.columnNames = stringArray;
        this.editableColumn = new boolean[classArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.editableColumn[nArray[i2]] = true;
        }
        this.graphDebug = graphDebugger;
    }

    public void setItems(Object[] objectArray) {
        this.vector.clear();
        this.cache.clear();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                this.vector.addElement(objectArray[i2]);
            }
        }
    }

    @Override
    public boolean isCellEditable(Object object, int n2) {
        return object != this.vector && n2 < this.editableColumn.length && this.editableColumn[n2] && !this.graphDebug.isProcessing();
    }

    @Override
    public Class getColumnClass(int n2) {
        if (n2 >= 0 && n2 < this.columnTypes.length) {
            return this.columnTypes[n2];
        }
        return Object.class;
    }

    @Override
    public int getChildCount(Object object) {
        return this.getChildren(object).length;
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = (Object[])this.cache.get(object);
        if (objectArray == null) {
            objectArray = object == this.vector ? this.vector.toArray() : new Object[]{};
            this.cache.put(object, objectArray);
        }
        return objectArray;
    }

    @Override
    public Object getChild(Object object, int n2) {
        return this.getChildren(object)[n2];
    }

    @Override
    public String getColumnName(int n2) {
        if (n2 >= 0 && n2 < this.columnNames.length) {
            return this.columnNames[n2];
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    public Object elementAt(int n2) {
        return this.vector.elementAt(n2);
    }

    public int size() {
        return this.vector.size();
    }

    public int indexOf(Object object) {
        return this.vector.indexOf(object);
    }

    public Object[] toArray() {
        return this.vector.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.vector.toArray(objectArray);
    }
}

