/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.isdb;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.commandline.CommandLineDebugger;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;

public class Isdb
extends CommandLineDebugger {
    private static final String PROMPT = "isdb> ";

    public Isdb(DebuggerInvoker debuggerInvoker) {
        super(debuggerInvoker);
    }

    @Override
    public String getPrompt() {
        return PROMPT;
    }

    @Override
    public void version(PrintStream printStream, ResourceBundle resourceBundle) {
        String string = Config.a(".licinfo", "Missing license!");
        String string2 = string.substring(string.length() - 8).equals("99991231") ? "None" : string.substring(string.length() - 8);
        String[] stringArray = string.substring(0, string.length() - 8).split("(##)");
        String string3 = stringArray.length > 1 ? stringArray[1] : resourceBundle.getString("message.fragment.missing.license.id");
        String string4 = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String string5 = MessageFormat.format(resourceBundle.getString("message.version"), RuntimeProperties.getProductDisplayName() + "_" + RuntimeProperties.getFullVersionNumber(), stringArray[0], string3, string2, RuntimeProperties.getProductCopyright(), string4, System.getProperty("java.home"));
        printStream.println(string5);
    }

    @Override
    public boolean isCobolProgram(String string, String[] stringArray) throws ClassNotFoundException {
        try {
            return this.isIsCobolClass(DebugUtilities.classForNameNoInitialize(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.isIsCobolClass(Config.a("iscobol.code_prefix", ""), string)) {
                return true;
            }
            String string2 = "-Discobol.code_prefix=";
            String string3 = "-Discobol.conf=";
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Object object;
                if (stringArray[i2].startsWith("-Discobol.code_prefix=")) {
                    object = stringArray[i2].substring("-Discobol.code_prefix=".length());
                    return this.isIsCobolClass((String)object, string);
                }
                if (!stringArray[i2].startsWith("-Discobol.conf=")) continue;
                object = new Properties();
                try {
                    RtsUtil.loadPropertiesWithImport((Properties)object, stringArray[i2].substring("-Discobol.conf=".length()));
                    String string4 = ((Properties)object).getProperty("iscobol.code_prefix");
                    if (string4 == null) continue;
                    return this.isIsCobolClass(string4, string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw classNotFoundException;
        }
    }

    private boolean isIsCobolClass(String string, String string2) throws ClassNotFoundException {
        CallLoader callLoader = CallLoader.getInstance(string);
        if (callLoader != null) {
            return this.isIsCobolClass(callLoader.loadClass(string2));
        }
        return false;
    }

    boolean isIsCobolClass(Class clazz) {
        try {
            Class<?> clazz2 = Class.forName("com.iscobol.rts.IscobolClass", false, Isdb.class.getClassLoader());
            return clazz2.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public int launchCobolProgram(String[] stringArray) {
        return this.invoker.launchIsCobolProgram(stringArray);
    }

    @Override
    public void setPrefix() {
    }

    @Override
    public boolean isDebuggable(String string) throws ClassNotFoundException {
        Class clazz = DebugUtilities.classForNameNoInitialize(string);
        try {
            Class<?> clazz2 = Class.forName("com.iscobol.debugger.IscobolDebugger", false, Isdb.class.getClassLoader());
            return clazz2.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public int processGetInfo(boolean bl) {
        DebugResponse debugResponse = bl ? this.invoker.getResponse() : this.invoker.processCommand(new RunCommand());
        int n2 = debugResponse.getReturnCode();
        if (n2 != 103) {
            ThreadObject threadObject = debugResponse.getThreads()[debugResponse.getCurThreadIdx()];
            ParagraphObject[] paragraphObjectArray = threadObject.getParStack();
            String string = paragraphObjectArray[paragraphObjectArray.length - 1].getProgName();
            LocalDebugInfo localDebugInfo = this.invoker.getInfo(string, false, false);
            this.invoker.setInfo(localDebugInfo);
            if (localDebugInfo != null) {
                String string2 = localDebugInfo.getSourcefile();
                this.invoker.setCurrFile(string2);
            }
            this.printMessage(this.invoker.showLine(debugResponse.getLine(), debugResponse.getLastFile()), true);
        }
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        Isdb isdb = new Isdb(new DebuggerInvoker());
        isdb.init(stringArray);
    }

    @Override
    public String getName() {
        return "isdb";
    }

    @Override
    public String getRemoteOptionName() {
        return "-r";
    }
}

