/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.tree;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.interfaces.debugger.ITree;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Tree
implements DataExternalizable,
ITree {
    private static final long serialVersionUID = 1000006L;
    private TreeNode root;
    private boolean hex;
    private String className;

    public Tree() {
    }

    public Tree(TreeNode treeNode, boolean bl) {
        this.root = treeNode;
        this.hex = bl;
    }

    @Override
    public TreeNode getRoot() {
        return this.root;
    }

    @Override
    public boolean isHex() {
        return this.hex;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String toString() {
        return this.root.toString();
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        this.root.writeExternal(dataOutput);
        dataOutput.writeBoolean(this.hex);
        RtsUtil.writeUTFOptmz(this.className, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.root = new TreeNode();
        this.root.readExternal(dataInput);
        this.hex = dataInput.readBoolean();
        this.className = RtsUtil.readUTFOptmz(dataInput);
    }
}

