/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.tree;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.ITreeNodeExtension;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class TreeNode
implements DataExternalizable,
ITreeNodeExtension {
    private static final long serialVersionUID = 1000006L;
    private static final String eol = System.getProperty("line.separator", "\n");
    private String varName;
    private String varValue;
    private int varOffset;
    private int varLength;
    private boolean hasChildren;
    private ArrayList<TreeNode> children;
    private transient TreeNode parent;

    public TreeNode() {
    }

    public TreeNode(String string, String string2) {
        this(string, string2, 0, 0);
    }

    public TreeNode(String string, String string2, int n2, int n3) {
        this.varName = string;
        this.varValue = string2;
        this.varOffset = n2;
        this.varLength = n3;
        this.children = new ArrayList();
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean bl) {
        this.hasChildren = bl;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public String getVarValue() {
        return this.varValue;
    }

    public void setVarValue(String string) {
        this.varValue = string;
    }

    public void setVarName(String string) {
        this.varName = string;
    }

    @Override
    public int getVarLength() {
        return this.varLength;
    }

    @Override
    public int getVarOffset() {
        return this.varOffset;
    }

    public TreeNode[] getChildren() {
        return this.children.toArray(new TreeNode[this.children.size()]);
    }

    public void addNode(TreeNode treeNode) {
        this.children.add(treeNode);
        treeNode.parent = this;
    }

    private int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        int n2 = 0;
        TreeNode treeNode = this.parent;
        while (treeNode != null) {
            treeNode = treeNode.parent;
            ++n2;
        }
        return n2;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = this.getDepth();
        if (n3 > 0) {
            for (n2 = 1; n2 < n3; ++n2) {
                stringBuffer.append("  ");
            }
            stringBuffer.append("- " + this.varName);
            if (this.varValue != null) {
                stringBuffer.append(" = " + this.varValue);
            }
            stringBuffer.append(eol);
        }
        n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.children.get(i2));
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.varName, dataOutput);
        RtsUtil.writeUTF(this.varValue, dataOutput);
        dataOutput.writeInt(this.varOffset);
        dataOutput.writeInt(this.varLength);
        dataOutput.writeInt(this.children.size());
        for (TreeNode treeNode : this.children) {
            treeNode.writeExternal(dataOutput);
        }
        dataOutput.writeBoolean(this.hasChildren);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.varName = RtsUtil.readUTFOptmz(dataInput);
        this.varValue = RtsUtil.readUTF(dataInput);
        this.varOffset = dataInput.readInt();
        this.varLength = dataInput.readInt();
        int n2 = dataInput.readInt();
        this.children = new ArrayList();
        for (int i2 = 0; i2 < n2; ++i2) {
            TreeNode treeNode = new TreeNode();
            treeNode.readExternal(dataInput);
            this.children.add(treeNode);
        }
        this.hasChildren = dataInput.readBoolean();
    }
}

