/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import com.iscobol.docking.eleritec.BorderManager;
import com.iscobol.docking.eleritec.Dockable;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.docking.eleritec.SubComponentProvider;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultDockingPort
extends JPanel
implements DockingPort {
    private static final WeakHashMap COMPONENT_TITLES = new WeakHashMap();
    private static final SubComponentProvider DEFAULT_CMP_PROVIDER = new DefaultComponentProvider();
    private SubComponentProvider subComponentProvider;
    private int borrowedTabIndex;
    private int cachedSplitDividerSize;
    private Component dockedComponent;
    private boolean dockingAllowed;
    private Insets dockingInsets;
    private boolean resizableDesired;
    private BorderManager borderManager;

    public DefaultDockingPort(String string) {
        this.setDockingInsets(new Insets(12, 12, 8, 8));
        this.setDockingAllowed(true);
        this.setName(string);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public Component add(Component component) {
        return this.setComponent(component);
    }

    @Override
    public Component add(Component component, int n2) {
        return this.setComponent(component);
    }

    @Override
    public void add(Component component, Object object) {
        this.setComponent(component);
    }

    @Override
    public void add(Component component, Object object, int n2) {
        this.setComponent(component);
    }

    @Override
    public Component add(String string, Component component) {
        return this.setComponent(component);
    }

    private void addCmp(DockingPort dockingPort, Component component) {
        if (dockingPort instanceof Container) {
            ((Container)((Object)dockingPort)).add(component);
        }
    }

    @Override
    public boolean allowsDocking(String string) {
        return this.dockingAllowed && this.isValidDockingRegion(string);
    }

    public final void evaluateDockingBorderStatus() {
        if (this.borderManager == null) {
            return;
        }
        Component component = this.getDockedComponent();
        if (component == null) {
            this.borderManager.managePortNullChild(this);
        } else if (component instanceof JSplitPane) {
            this.borderManager.managePortSplitChild(this);
        } else if (component instanceof JTabbedPane) {
            this.borderManager.managePortTabbedChild(this);
        } else {
            this.borderManager.managePortSimpleChild(this);
        }
    }

    private DockingPort createChildPort() {
        DockingPort dockingPort;
        DockingPort dockingPort2 = dockingPort = this.subComponentProvider == null ? null : this.subComponentProvider.createChildPort(this.getName());
        if (dockingPort == null) {
            dockingPort = DEFAULT_CMP_PROVIDER.createChildPort(this.getName());
        }
        if (dockingPort instanceof DefaultDockingPort) {
            ((DefaultDockingPort)dockingPort).setBorderManager(this.borderManager);
        }
        return dockingPort;
    }

    private JSplitPane createSplitPane(String string, boolean bl) {
        JSplitPane jSplitPane;
        JSplitPane jSplitPane2 = jSplitPane = this.subComponentProvider == null ? new JSplitPane() : this.subComponentProvider.createSplitPane();
        if (jSplitPane == null) {
            jSplitPane = DEFAULT_CMP_PROVIDER.createSplitPane();
        }
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(3);
        jSplitPane.setResizeWeight(0.5);
        int n2 = 1;
        if ("NORTH".equals(string) || "SOUTH".equals(string)) {
            n2 = 0;
        }
        jSplitPane.setOrientation(n2);
        this.cachedSplitDividerSize = jSplitPane.getDividerSize();
        if (!bl) {
            jSplitPane.setDividerSize(0);
        }
        return jSplitPane;
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = this.subComponentProvider == null ? null : this.subComponentProvider.createTabbedPane();
        return jTabbedPane == null ? DEFAULT_CMP_PROVIDER.createTabbedPane() : jTabbedPane;
    }

    @Override
    public boolean dock(Dockable dockable, String string) {
        if (dockable == null) {
            return false;
        }
        return this.dock(dockable.getDockable(), dockable.getDockableDesc(), string, dockable.isDockedLayoutResizable());
    }

    @Override
    public boolean dock(Component component, String string, String string2, boolean bl) {
        boolean bl2;
        Component component2;
        if (component == null || !this.allowsDocking(string2)) {
            return false;
        }
        String string3 = string = string == null ? "null" : string.trim();
        if (string.length() == 0) {
            string = "null";
        }
        if (component == (component2 = this.getDockedComponent())) {
            return false;
        }
        if (component2 instanceof JSplitPane) {
            Component component3 = ((JSplitPane)component2).getLeftComponent();
            if (component3 instanceof DockingPort) {
                return ((DockingPort)((Object)component3)).dock(component, string, string2, bl);
            }
            return false;
        }
        this.resizableDesired = bl;
        COMPONENT_TITLES.put(component, string);
        if (component2 == null) {
            this.setComponent(component);
            this.evaluateDockingBorderStatus();
            return true;
        }
        boolean bl3 = bl2 = "CENTER".equals(string2) ? this.dockInCenterRegion(component) : this.dockInOuterRegion(component, string2);
        if (bl2) {
            this.evaluateDockingBorderStatus();
            if (!"CENTER".equals(string2)) {
                this.resolveSplitDividerLocation();
            }
        }
        return bl2;
    }

    private void resolveSplitDividerLocation() {
        double d2;
        Component component = this.getDockedComponent();
        if (!(component instanceof JSplitPane)) {
            return;
        }
        JSplitPane jSplitPane = (JSplitPane)component;
        Insets insets = this.getInsets();
        boolean bl = jSplitPane.getOrientation() == 0;
        int n2 = bl ? this.getHeight() - insets.top - insets.bottom : this.getWidth() - insets.left - insets.right;
        double d3 = d2 = this.subComponentProvider == null ? DEFAULT_CMP_PROVIDER.getInitialDividerLocation() : this.subComponentProvider.getInitialDividerLocation();
        if (d2 < 0.0 || d2 > 1.0) {
            d2 = 0.5;
        }
        jSplitPane.setDividerLocation((int)((double)n2 * d2));
    }

    private boolean dockInCenterRegion(Component component) {
        Component component2 = this.getDockedComponent();
        if (component2 instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = null;
            jTabbedPane = (JTabbedPane)component2;
            jTabbedPane.add(component, this.getValidTabTitle(jTabbedPane, component));
            jTabbedPane.revalidate();
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            return true;
        }
        final JTabbedPane jTabbedPane = this.createTabbedPane();
        if (jTabbedPane == null) {
            return false;
        }
        this.remove(component2);
        jTabbedPane.add(component2, this.getValidTabTitle(jTabbedPane, component2));
        jTabbedPane.add(component, this.getValidTabTitle(jTabbedPane, component));
        this.setComponent(jTabbedPane);
        jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Dockable dockable = (Dockable)((Object)jTabbedPane.getSelectedComponent());
                if (dockable != null) {
                    dockable.setSelected();
                }
            }
        });
        ((Dockable)((Object)component)).setSelected();
        return true;
    }

    @Override
    public void dockingComplete(String string) {
    }

    private boolean dockInOuterRegion(Component component, String string) {
        Dimension dimension = this.getSize();
        dimension.width /= 2;
        dimension.height /= 2;
        Component component2 = this.getDockedComponent();
        this.remove(component2);
        DockingPort dockingPort = this.createChildPort();
        DockingPort dockingPort2 = this.createChildPort();
        this.addCmp(dockingPort, component2);
        this.addCmp(dockingPort2, component);
        DockingPort[] dockingPortArray = this.putPortsInOrder(dockingPort, dockingPort2, string);
        this.setPreferredSize(dockingPortArray[0], dimension);
        this.setPreferredSize(dockingPortArray[1], dimension);
        JSplitPane jSplitPane = this.createSplitPane(string, this.resizableDesired);
        if (dockingPortArray[0] instanceof Component) {
            jSplitPane.setLeftComponent((Component)((Object)dockingPortArray[0]));
        }
        if (dockingPortArray[1] instanceof Component) {
            jSplitPane.setRightComponent((Component)((Object)dockingPortArray[1]));
        }
        this.setComponent(jSplitPane);
        return true;
    }

    @Override
    public void doLayout() {
        Component component = this.getDockedComponent();
        if (component == null) {
            return;
        }
        Insets insets = this.getInsets();
        int n2 = this.getWidth() - insets.left - insets.right;
        int n3 = this.getHeight() - insets.top - insets.bottom;
        component.setBounds(insets.left, insets.top, n2, n3);
    }

    @Override
    public Component getDockedComponent() {
        return this.dockedComponent;
    }

    private JSplitPane getDockedSplitPane() {
        Component component = this.getDockedComponent();
        return component instanceof JSplitPane ? (JSplitPane)component : null;
    }

    @Override
    public Insets getDockingInsets() {
        return this.dockingInsets;
    }

    private String getValidTabTitle(JTabbedPane jTabbedPane, Component component) {
        String string = (String)COMPONENT_TITLES.get(component);
        if (string == null || string.trim().length() == 0) {
            string = "null";
        }
        int n2 = jTabbedPane.getTabCount();
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            string2 = jTabbedPane.getTitleAt(i2).toLowerCase();
            hashSet.add(string2);
            if (!string2.startsWith(string.toLowerCase())) continue;
            ++n3;
        }
        if (hashSet.contains(string) && n3 > 0) {
            string = string + n3;
        }
        COMPONENT_TITLES.put(component, string);
        return string;
    }

    @Override
    public boolean hasDockedChild(Component component) {
        Container container;
        if (component == null) {
            return false;
        }
        Container container2 = component.getParent();
        if (container2 == null) {
            return false;
        }
        return !(container2 instanceof JTabbedPane || container2 instanceof JSplitPane ? (container = container2.getParent()) != this : container2 != this);
    }

    @Override
    public boolean isLayoutResizable() {
        JSplitPane jSplitPane = this.getDockedSplitPane();
        return jSplitPane == null ? false : jSplitPane.getDividerSize() != 0;
    }

    private boolean isValidDockingRegion(String string) {
        return "CENTER".equals(string) || "NORTH".equals(string) || "SOUTH".equals(string) || "EAST".equals(string) || "WEST".equals(string);
    }

    @Override
    public Component lendDockedComponent() {
        Component component = this.getDockedComponent();
        if (component == null) {
            return null;
        }
        super.remove(component);
        return component;
    }

    private DockingPort[] putPortsInOrder(DockingPort dockingPort, DockingPort dockingPort2, String string) {
        if ("NORTH".equals(string) || "WEST".equals(string)) {
            return new DockingPort[]{dockingPort2, dockingPort};
        }
        return new DockingPort[]{dockingPort, dockingPort2};
    }

    public void reevaluateContainerTree() {
        this.reevaluateDockingWrapper();
        this.reevaluateTabbedPane();
        this.evaluateDockingBorderStatus();
        this.revalidate();
    }

    private void reevaluateDockingWrapper() {
        Container container;
        Component component = this.getDockedComponent();
        Container container2 = this.getParent();
        Container container3 = container = container2 == null ? null : container2.getParent();
        if (component == null && container2 instanceof JSplitPane && container instanceof DefaultDockingPort) {
            container2.remove(this);
            ((DefaultDockingPort)container).reevaluateContainerTree();
        } else if (component instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)component;
            Component component2 = jSplitPane.getLeftComponent();
            Component component3 = jSplitPane.getRightComponent();
            if (component2 != null && component3 != null) {
                return;
            }
            if (component2 == component3) {
                this.removeAll();
                return;
            }
            Component component4 = component2 == null ? component3 : component2;
            jSplitPane.remove(component4);
            super.remove(jSplitPane);
            if (component4 instanceof DefaultDockingPort) {
                component4 = ((DefaultDockingPort)component4).getDockedComponent();
            }
            if (component4 != null) {
                this.setComponent(component4);
            }
        }
    }

    private void reevaluateTabbedPane() {
        Component component = this.getDockedComponent();
        if (!(component instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)component;
        int n2 = jTabbedPane.getComponentCount();
        if (n2 > 1) {
            return;
        }
        Component component2 = n2 == 1 ? jTabbedPane.getComponent(0) : null;
        this.removeAll();
        if (component2 != null) {
            this.setComponent(component2);
        }
    }

    @Override
    public void remove(int n2) {
        Component component = this.getDockedComponent();
        Component component2 = this.getComponent(n2);
        super.remove(n2);
        if (component == component2) {
            this.dockedComponent = null;
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.dockedComponent = null;
    }

    @Override
    public void retainDockedComponent() {
        Component component = this.getDockedComponent();
        if (component == null) {
            return;
        }
        Container container = component.getParent();
        if (container != null) {
            container.remove(component);
        }
        this.setComponent(component);
        this.revalidate();
    }

    public void setComponentProvider(SubComponentProvider subComponentProvider) {
        this.subComponentProvider = subComponentProvider;
    }

    public void setBorderManager(BorderManager borderManager) {
        this.borderManager = borderManager;
    }

    private Component setComponent(Component component) {
        if (this.getDockedComponent() != null) {
            this.removeAll();
        }
        this.dockedComponent = component;
        Component component2 = super.add(this.dockedComponent);
        return component2;
    }

    @Override
    public void setDockingAllowed(boolean bl) {
        this.dockingAllowed = bl;
    }

    @Override
    public void setDockingInsets(Insets insets) {
        this.dockingInsets = insets == null ? new Insets(0, 0, 0, 0) : insets;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void setLayoutResizable(boolean bl) {
        this.resizableDesired = bl;
        JSplitPane jSplitPane = this.getDockedSplitPane();
        if (jSplitPane == null) {
            return;
        }
        int n2 = bl ? this.cachedSplitDividerSize : 0;
        jSplitPane.setDividerSize(n2);
    }

    private void setPreferredSize(DockingPort dockingPort, Dimension dimension) {
        if (dockingPort instanceof JComponent) {
            ((JComponent)((Object)dockingPort)).setPreferredSize(dimension);
        }
    }

    @Override
    public boolean undock(Component component) {
        if (!this.hasDockedChild(component)) {
            return false;
        }
        component.getParent().remove(component);
        this.reevaluateContainerTree();
        return true;
    }

    private static class DefaultComponentProvider
    implements SubComponentProvider {
        private DefaultComponentProvider() {
        }

        @Override
        public DockingPort createChildPort(String string) {
            return new DefaultDockingPort(string);
        }

        @Override
        public JSplitPane createSplitPane() {
            return new JSplitPane();
        }

        @Override
        public JTabbedPane createTabbedPane() {
            return new JTabbedPane(3);
        }

        @Override
        public double getInitialDividerLocation() {
            return 0.5;
        }
    }
}

