/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import com.iscobol.docking.eleritec.CursorProvider;
import com.iscobol.docking.eleritec.Dockable;
import com.iscobol.docking.eleritec.DockableComponentWrapper;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.docking.eleritec.ResourceManager;
import com.iscobol.docking.eleritec.RootSwingContainer;
import com.iscobol.docking.eleritec.UndockCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class DockingManager
extends JPanel {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final HashMap GLASSPANES_BY_ROOT_CONTAINER = new HashMap();
    private static final HashMap DEFAULT_CURSOR_IMAGES = DockingManager.createCursorImages();
    private static final Image EMPTY_IMAGE = ResourceManager.createImage("resources/images/emptyIcon.gif");
    private static final WeakHashMap CACHED_DRAG_INITIATORS_BY_COMPONENT = new WeakHashMap();
    private static final int DROP_FAIL = 0;
    private static final int DROP_SUCCESS = 1;
    private static final int DROP_UNDOCK = 2;
    private Dockable dockableImpl;
    private Component currentMouseoverComponent;
    private Point mouseLocation;
    private Point mouseOffsetFromDragSource;
    private boolean mouseOutOfBounds;
    private RootSwingContainer rootContainer;
    private DragEventManager dragEventManger;
    private Image currentMouseImage;
    private Dimension dragSourceSize;
    private Component cachedGlassPane;
    private String currentDockingRegion;
    private EventListener[] cachedListeners;
    private Point lastMouse;
    private UndockCursor undockWin;
    private Point mouseDragged;

    private DockingManager(RootSwingContainer rootSwingContainer) {
        super(null);
        this.rootContainer = rootSwingContainer;
        this.setOpaque(false);
        this.setBorder(null);
        this.mouseOffsetFromDragSource = new Point();
        this.setCursor(ResourceManager.createCursor("resources/images/emptyIcon.gif", new Point(8, 8), "Empty"));
        this.dragEventManger = new DragEventManager();
        this.addMouseListener(this.dragEventManger);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.getInsets();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.paintComponentImpl(graphics);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(null);
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(false);
    }

    @Override
    public Component add(Component component, int n2) {
        return null;
    }

    @Override
    public void add(Component component, Object object, int n2) {
    }

    @Override
    public void add(Component component, Object object) {
    }

    @Override
    public Component add(Component component) {
        return null;
    }

    @Override
    public Component add(String string, Component component) {
        return null;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        super.setLayout(null);
    }

    private static HashMap createCursorImages() {
        HashMap<String, Image> hashMap = new HashMap<String, Image>();
        hashMap.put("NORTH", ResourceManager.createImage("resources/images/upArrow.gif"));
        hashMap.put("SOUTH", ResourceManager.createImage("resources/images/downArrow.gif"));
        hashMap.put("EAST", ResourceManager.createImage("resources/images/rightArrow.gif"));
        hashMap.put("WEST", ResourceManager.createImage("resources/images/leftArrow.gif"));
        hashMap.put("CENTER", ResourceManager.createImage("resources/images/stacked.gif"));
        hashMap.put("UNKNOWN", ResourceManager.createImage("resources/images/notAllowed.gif"));
        hashMap.put("EMPTY", EMPTY_IMAGE);
        return hashMap;
    }

    private Frame getFrame() {
        Container container = this;
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    private static DockingManager getDockingManager(Component component) {
        if (component == null) {
            return null;
        }
        RootSwingContainer rootSwingContainer = RootSwingContainer.getRootContainer(component);
        if (rootSwingContainer == null) {
            return null;
        }
        DockingManager dockingManager = (DockingManager)GLASSPANES_BY_ROOT_CONTAINER.get(rootSwingContainer.getRootContainer());
        if (dockingManager == null) {
            dockingManager = new DockingManager(rootSwingContainer);
            GLASSPANES_BY_ROOT_CONTAINER.put(rootSwingContainer.getRootContainer(), dockingManager);
        }
        return dockingManager;
    }

    public static void startDrag(Component component, Point point) {
        DockingManager.startDrag(component, point, null);
    }

    public static void startDrag(Component component, Point point, String string) {
        DockingManager.startDrag(component, point, string, false);
    }

    public static void startDrag(Component component, Point point, String string, boolean bl) {
        if (point == null) {
            return;
        }
        DockableComponentWrapper dockableComponentWrapper = DockableComponentWrapper.create(component, string, bl);
        if (dockableComponentWrapper != null) {
            DockingManager.startDrag(dockableComponentWrapper, point);
        }
    }

    public static void startDrag(Dockable dockable, Point point) {
        if (dockable == null) {
            return;
        }
        Component component = dockable.getInitiator();
        if (component == null || dockable.getDockable() == null) {
            return;
        }
        DockingManager dockingManager = DockingManager.getDockingManager(component);
        if (dockingManager != null) {
            dockingManager.startDragImpl(dockable, point);
        }
    }

    public static void stopDrag(Component component) {
        DockableComponentWrapper dockableComponentWrapper = DockableComponentWrapper.create(component, null, false);
        if (dockableComponentWrapper != null) {
            DockingManager.stopDrag(dockableComponentWrapper);
        }
    }

    public static void stopDrag(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        DockingManager dockingManager = DockingManager.getDockingManager(dockable.getDockable());
        if (dockingManager != null) {
            dockingManager.stopDragImpl(dockable);
        }
    }

    private static DockingPortCursorPane createDockingPortCursorProxy(DockingPort dockingPort) {
        DockingPortCursorPane dockingPortCursorPane = new DockingPortCursorPane(dockingPort, "CENTER");
        Insets insets = dockingPort.getDockingInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        dockingPortCursorPane.createNorthRegion(insets.top);
        dockingPortCursorPane.createSouthRegion(insets.bottom);
        dockingPortCursorPane.createEastRegion(insets.right);
        dockingPortCursorPane.createWestRegion(insets.left);
        return dockingPortCursorPane;
    }

    private Image getCursorImageForRegion(String string) {
        CursorProvider cursorProvider;
        Image image;
        if (string == null) {
            string = "UNKNOWN";
        }
        Image image2 = image = (cursorProvider = this.dockableImpl.getCursorProvider()) == null ? null : this.getCursorFromProvider(cursorProvider, string);
        if (image == null) {
            image = (Image)DEFAULT_CURSOR_IMAGES.get(string);
        }
        if (image == null) {
            return this.getCursorImageForRegion("UNKNOWN");
        }
        return image;
    }

    private Image getCursorFromProvider(CursorProvider cursorProvider, String string) {
        if ("NORTH".equals(string)) {
            return cursorProvider.getNorthImage();
        }
        if ("SOUTH".equals(string)) {
            return cursorProvider.getSouthImage();
        }
        if ("EAST".equals(string)) {
            return cursorProvider.getEastImage();
        }
        if ("WEST".equals(string)) {
            return cursorProvider.getWestImage();
        }
        if ("CENTER".equals(string)) {
            return cursorProvider.getCenterImage();
        }
        return cursorProvider.getDisallowedImage();
    }

    public static void registerDockable(Component component, String string, boolean bl) {
        if (component == null) {
            return;
        }
        DockableComponentWrapper dockableComponentWrapper = DockableComponentWrapper.create(component, string, bl);
        DockingManager.registerDockable(dockableComponentWrapper);
    }

    public static void registerDockable(Dockable dockable) {
        if (dockable == null || dockable.getDockable() == null || dockable.getInitiator() == null) {
            return;
        }
        DragInitiationListener dragInitiationListener = DockingManager.getInitiationListener(dockable);
        if (dragInitiationListener == null) {
            dragInitiationListener = new DragInitiationListener();
            dragInitiationListener.setInitiator(dockable);
            dockable.getInitiator().addMouseMotionListener(dragInitiationListener);
        }
        CACHED_DRAG_INITIATORS_BY_COMPONENT.put(dockable.getDockable(), dockable);
    }

    private static Dockable getDragInitiator(Component component) {
        if (component == null) {
            return null;
        }
        Dockable dockable = (Dockable)CACHED_DRAG_INITIATORS_BY_COMPONENT.get(component);
        if (dockable == null) {
            dockable = DockableComponentWrapper.create(component, null, false);
            CACHED_DRAG_INITIATORS_BY_COMPONENT.put(component, dockable);
        }
        return dockable;
    }

    private static DragInitiationListener getInitiationListener(Dockable dockable) {
        EventListener[] eventListenerArray = dockable.getInitiator().getListeners(MouseMotionListener.class);
        if (eventListenerArray == null || eventListenerArray.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < eventListenerArray.length; ++i2) {
            if (!(eventListenerArray[i2] instanceof DragInitiationListener)) continue;
            return (DragInitiationListener)eventListenerArray[i2];
        }
        return null;
    }

    public static void setDockingResizablePolicy(Component component, boolean bl) {
        Dockable dockable = DockingManager.getDragInitiator(component);
        DockingManager.setDockingResizablePolicy(dockable, bl);
    }

    public static void setDockingResizablePolicy(Dockable dockable, boolean bl) {
        if (dockable != null) {
            dockable.setDockedLayoutResizable(bl);
        }
    }

    public static void setDockingDescription(Component component, String string) {
        Dockable dockable = DockingManager.getDragInitiator(component);
        DockingManager.setDockingDescription(dockable, string);
    }

    public static void setDockingDescription(Dockable dockable, String string) {
        if (dockable != null) {
            dockable.setDockableDesc(string);
        }
    }

    private void startDragImpl(Dockable dockable, Point point) {
        this.removeAll();
        this.dockableImpl = dockable;
        this.cachedGlassPane = this.rootContainer.getGlassPane();
        this.rootContainer.setGlassPane(this);
        Component component = this.dockableImpl.getDockable();
        this.dragSourceSize = component.getSize();
        this.initMouseCursorOffset(point);
        this.determineMouseLocationBasedOnDragSource(point);
        this.currentDockingRegion = null;
        this.lastMouse = null;
        this.initializeListenerCaching();
        this.dockableImpl.getInitiator().addMouseMotionListener(this.dragEventManger);
        this.dockableImpl.getInitiator().addMouseListener(this.dragEventManger);
        this.setVisible(true);
        this.manageCursor();
    }

    private void stopDragImpl(Dockable dockable) {
        if (this.dockableImpl == null || dockable == null || this.dockableImpl.getDockable() != dockable.getDockable()) {
            return;
        }
        int n2 = this.dropComponent();
        Dockable dockable2 = this.dockableImpl;
        Component component = this.dockableImpl.getDockable();
        this.dockableImpl.getInitiator().removeMouseMotionListener(this.dragEventManger);
        this.dockableImpl.getInitiator().removeMouseListener(this.dragEventManger);
        this.restoreCachedListeners();
        DragInitiationListener dragInitiationListener = DockingManager.getInitiationListener(this.dockableImpl);
        if (dragInitiationListener != null) {
            dragInitiationListener.setEnabled(true);
        }
        this.dockableImpl = null;
        this.setVisible(false);
        this.rootContainer.setGlassPane(this.cachedGlassPane);
        this.cachedGlassPane = null;
        if (n2 == 1) {
            DockingPort dockingPort = ((DockingPortCursorPane)this.currentMouseoverComponent).dockingPort;
            dockingPort.dockingComplete(this.currentDockingRegion);
            dockable2.dockingCompleted(dockingPort);
        } else if (n2 == 2) {
            dockable2.undock(this.mouseDragged);
        } else {
            dockable2.dockingCanceled();
        }
        this.currentDockingRegion = null;
    }

    private void paintComponentImpl(Graphics graphics) {
        if (this.currentDockingRegion == null) {
            this.resolveMouseCursorRegion();
        }
        if (!this.mouseOutOfBounds) {
            graphics.drawImage(this.currentMouseImage, this.mouseLocation.x - 8, this.mouseLocation.y - 8, null, null);
        }
    }

    private void initializeListenerCaching() {
        if (!this.dockableImpl.mouseMotionListenersBlockedWhileDragging()) {
            return;
        }
        Component component = this.dockableImpl.getInitiator();
        this.cachedListeners = component.getListeners(MouseMotionListener.class);
        if (this.cachedListeners != null) {
            for (int i2 = 0; i2 < this.cachedListeners.length; ++i2) {
                component.removeMouseMotionListener((MouseMotionListener)this.cachedListeners[i2]);
            }
        }
    }

    private void restoreCachedListeners() {
        if (this.cachedListeners == null) {
            return;
        }
        Component component = this.dockableImpl.getInitiator();
        for (int i2 = 0; i2 < this.cachedListeners.length; ++i2) {
            component.addMouseMotionListener((MouseMotionListener)this.cachedListeners[i2]);
        }
        this.cachedListeners = null;
    }

    private void determineMouseLocationBasedOnDragSource(Point point) {
        if (this.mouseLocation != null) {
            if (this.lastMouse == null) {
                this.lastMouse = (Point)this.mouseLocation.clone();
            } else {
                this.lastMouse.setLocation(this.mouseLocation);
            }
        }
        this.mouseLocation = SwingUtilities.convertPoint(this.dockableImpl.getInitiator(), point, this);
    }

    private Component resolveCurrentMouseoverComponent() {
        return SwingUtilities.getDeepestComponentAt(this, this.mouseLocation.x, this.mouseLocation.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageCursor() {
        try {
            if (this.mouseOutOfBounds) {
                this.currentMouseoverComponent = null;
                return;
            }
            this.currentMouseoverComponent = this.resolveCurrentMouseoverComponent();
            if (this.currentMouseoverComponent != this) {
                return;
            }
            DockingPort dockingPort = this.resolveDockingPortComponent();
            if (dockingPort == null) {
                return;
            }
            Component component = (Component)((Object)dockingPort);
            Point point = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), this);
            Dimension dimension = component.getSize();
            DockingPortCursorPane dockingPortCursorPane = DockingManager.createDockingPortCursorProxy(dockingPort);
            super.add(dockingPortCursorPane);
            dockingPortCursorPane.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.revalidate();
            this.resolveCurrentMouseoverComponent();
        }
        finally {
            this.resolveMouseCursorRegion();
            if (this.lastMouse == null) {
                this.repaint();
            } else {
                this.repaintRect();
            }
        }
    }

    private void repaintRect() {
        int n2 = Math.min(this.lastMouse.x, this.mouseLocation.x);
        int n3 = Math.min(this.lastMouse.y, this.mouseLocation.y);
        int n4 = Math.max(this.lastMouse.x, this.mouseLocation.x);
        int n5 = Math.max(this.lastMouse.y, this.mouseLocation.y);
        int n6 = this.dragSourceSize.width + n4 - n2;
        int n7 = this.dragSourceSize.height + n5 - n3;
        this.repaint(n2 - this.mouseOffsetFromDragSource.x - 10, n3 - this.mouseOffsetFromDragSource.y - 10, n6 + 20, n7 + 20);
    }

    private void resolveMouseCursorRegion() {
        if (this.mouseOutOfBounds) {
            this.currentDockingRegion = "UNKNOWN";
            this.currentMouseImage = EMPTY_IMAGE;
            return;
        }
        if (this.currentMouseoverComponent == this || this.currentMouseoverComponent == null) {
            this.currentDockingRegion = "UNKNOWN";
            this.currentMouseImage = this.getCursorImageForRegion(this.currentDockingRegion);
            return;
        }
        DockingPortCursorPane dockingPortCursorPane = (DockingPortCursorPane)this.currentMouseoverComponent;
        this.currentDockingRegion = dockingPortCursorPane.region;
        if (!dockingPortCursorPane.dockingPort.allowsDocking(this.currentDockingRegion)) {
            this.currentDockingRegion = "UNKNOWN";
        } else if (dockingPortCursorPane.dockingPort.getDockedComponent() == this.dockableImpl.getDockable()) {
            this.currentDockingRegion = "UNKNOWN";
        }
        this.currentMouseImage = this.getCursorImageForRegion(this.currentDockingRegion);
    }

    private DockingPort resolveDockingPortComponent() {
        return this.resolveDockingPortComponent(this.mouseLocation, this.rootContainer);
    }

    private DockingPort resolveDockingPortComponent(Point point, RootSwingContainer rootSwingContainer) {
        Point point2 = SwingUtilities.convertPoint(this, point, rootSwingContainer.getContentPane());
        Component component = SwingUtilities.getDeepestComponentAt(rootSwingContainer.getContentPane(), point2.x, point2.y);
        if (component == null) {
            return null;
        }
        if (component instanceof DockingPort) {
            return (DockingPort)((Object)component);
        }
        return (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, component));
    }

    private int dropComponent() {
        DockingPort dockingPort;
        Component component;
        Component component2;
        Component component3;
        if (this.undockWin != null) {
            this.undockWin.dispose();
            this.undockWin = null;
            return 2;
        }
        if ("UNKNOWN".equals(this.currentDockingRegion)) {
            return 0;
        }
        if (!(this.currentMouseoverComponent instanceof DockingPortCursorPane)) {
            return 0;
        }
        DockingPort dockingPort2 = ((DockingPortCursorPane)this.currentMouseoverComponent).dockingPort;
        Component component4 = dockingPort2.getDockedComponent();
        Component component5 = this.dockableImpl.getDockable();
        if (component5 == component4) {
            return 0;
        }
        for (component3 = this.rootContainer.getRootContainer(); component3 != null && !(component3 instanceof Window); component3 = component3.getParent()) {
        }
        if (component3 != null) {
            for (component2 = component = ((Window)component3).getFocusOwner(); component2 != null && component2 != component5; component2 = component2.getParent()) {
            }
            if (component2 != component5) {
                component = null;
            }
        } else {
            component = null;
        }
        component2 = component5.getParent();
        if (component2 != null) {
            dockingPort = this.getParentDockingPort(component5);
            if (dockingPort != null) {
                dockingPort.undock(component5);
            } else {
                ((Container)component2).remove(component5);
            }
            this.revalidateComponent(this.rootContainer.getContentPane());
        }
        if ((dockingPort = this.resolveDockingPortComponent()) != dockingPort2) {
            dockingPort2 = dockingPort;
            ((DockingPortCursorPane)this.currentMouseoverComponent).dockingPort = dockingPort2;
        }
        boolean bl = dockingPort2.dock(component5, this.dockableImpl.getDockableDesc(), this.currentDockingRegion, this.dockableImpl.isDockedLayoutResizable());
        this.revalidateComponent((Component)((Object)dockingPort2));
        if (component != null) {
            component.requestFocus();
        }
        return bl ? 1 : 0;
    }

    private DockingPort getParentDockingPort(Component component) {
        DockingPort dockingPort = (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, component));
        if (dockingPort == null) {
            return null;
        }
        return dockingPort.hasDockedChild(component) ? dockingPort : null;
    }

    private void revalidateComponent(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).revalidate();
        }
    }

    private void initMouseCursorOffset(Point point) {
        boolean bl;
        boolean bl2 = bl = this.dockableImpl.getInitiator() != this.dockableImpl.getDockable();
        if (bl) {
            point = SwingUtilities.convertPoint(this.dockableImpl.getInitiator(), point, this.dockableImpl.getDockable());
        }
        this.mouseOffsetFromDragSource.x = point.x;
        this.mouseOffsetFromDragSource.y = point.y;
    }

    private static class DragInitiationListener
    extends MouseMotionAdapter {
        private boolean enabled;
        private Dockable initiator;

        private DragInitiationListener() {
            this.setEnabled(true);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.enabled && this.initiator != null && this.initiator.isDockingEnabled()) {
                this.setEnabled(false);
                DockingManager.startDrag(this.initiator, mouseEvent.getPoint());
            }
        }

        private void setInitiator(Dockable dockable) {
            this.initiator = dockable;
        }

        private void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    private static class DockingPortCursorPane
    extends JPanel {
        private String region;
        private DockingPort dockingPort;

        private DockingPortCursorPane(DockingPort dockingPort, String string) {
            super(null);
            this.setOpaque(false);
            this.region = string;
            this.dockingPort = dockingPort;
            if ("CENTER".equals(this.region)) {
                this.setLayout(new BorderLayout(0, 0));
            }
        }

        private void createNorthRegion(int n2) {
            this.createRegion(n2, "NORTH", "North");
        }

        private void createSouthRegion(int n2) {
            this.createRegion(n2, "SOUTH", "South");
        }

        private void createEastRegion(int n2) {
            this.createRegion(n2, "EAST", "East");
        }

        private void createWestRegion(int n2) {
            this.createRegion(n2, "WEST", "West");
        }

        private void createRegion(int n2, String string, String string2) {
            DockingPortCursorPane dockingPortCursorPane = new DockingPortCursorPane(this.dockingPort, string);
            Dimension dimension = dockingPortCursorPane.getPreferredSize();
            dockingPortCursorPane.setPreferredSize(new Dimension(n2, n2));
            super.add((Component)dockingPortCursorPane, string2);
        }
    }

    private class DragEventManager
    extends MouseAdapter
    implements MouseMotionListener {
        private DragEventManager() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            DockingManager.this.determineMouseLocationBasedOnDragSource(mouseEvent.getPoint());
            if (DockingManager.this.undockWin != null) {
                DockingManager.this.mouseDragged = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(DockingManager.this.mouseDragged, (Component)mouseEvent.getSource());
                DockingManager.this.undockWin.setLocation(((DockingManager)DockingManager.this).mouseDragged.x + 1, ((DockingManager)DockingManager.this).mouseDragged.y + 1);
            }
            DockingManager.this.manageCursor();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            DockingManager.this.mouseOutOfBounds = false;
            if (DockingManager.this.undockWin != null) {
                DockingManager.this.undockWin.dispose();
                DockingManager.this.undockWin = null;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            DockingManager.this.mouseOutOfBounds = true;
            Component component = DockingManager.this.dockableImpl.getDockable();
            DockingManager.this.undockWin = new UndockCursor(DockingManager.this.getFrame(), component.getName());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DockingManager.this.stopDragImpl(DockingManager.this.dockableImpl);
        }
    }
}

