/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class RootSwingContainer {
    public static final Integer DEFAULT_MAXED_LAYER = new Integer(JLayeredPane.PALETTE_LAYER - 10);
    private static final HashMap MAP_BY_ROOT_CONTAINER = new HashMap();
    private LayoutManager maxedLayout;
    private Integer maximizationLayer;
    private Component root;

    private static Component getRoot(Component component) {
        Container container;
        if (component == null) {
            return null;
        }
        if (RootSwingContainer.isValidRootContainer(component)) {
            return component;
        }
        for (container = component.getParent(); container != null && !RootSwingContainer.isValidRootContainer(container); container = container.getParent()) {
        }
        return container;
    }

    public static RootSwingContainer getRootContainer(Component component) {
        Component component2 = RootSwingContainer.getRoot(component);
        if (!RootSwingContainer.isValidRootContainer(component2)) {
            return null;
        }
        RootSwingContainer rootSwingContainer = (RootSwingContainer)MAP_BY_ROOT_CONTAINER.get(component2);
        if (rootSwingContainer == null) {
            rootSwingContainer = new RootSwingContainer(component2);
            MAP_BY_ROOT_CONTAINER.put(component2, rootSwingContainer);
        }
        if (rootSwingContainer.getRootContainer() != component2) {
            rootSwingContainer.setRootContainer(component2);
        }
        return rootSwingContainer;
    }

    protected static boolean isValidRootContainer(Component component) {
        return component instanceof JFrame || component instanceof JApplet || component instanceof JWindow || component instanceof JDialog;
    }

    protected RootSwingContainer(Component component) {
        this.setMaximizationLayer(DEFAULT_MAXED_LAYER);
        this.setRootContainer(component);
    }

    public Container getContentPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getContentPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getContentPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getContentPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getContentPane();
        }
        return null;
    }

    public Component getGlassPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getGlassPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getGlassPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getGlassPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getGlassPane();
        }
        return null;
    }

    public JLayeredPane getLayeredPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getLayeredPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getLayeredPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getLayeredPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getLayeredPane();
        }
        return null;
    }

    public Point getLocationOnScreen() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getLocationOnScreen();
        }
        return null;
    }

    public Integer getMaximizationLayer() {
        return this.maximizationLayer;
    }

    public LayoutManager getMaximizedLayout() {
        return this.maxedLayout;
    }

    public Component getRootContainer() {
        return this.root;
    }

    public JRootPane getRootPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getRootPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getRootPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getRootPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getRootPane();
        }
        return null;
    }

    public void revalidateContentPane() {
        Container container = this.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).revalidate();
        }
    }

    public void setContentPane(Container container) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setContentPane(container);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setContentPane(container);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setContentPane(container);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setContentPane(container);
        }
    }

    public void setGlassPane(Component component) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setGlassPane(component);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setGlassPane(component);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setGlassPane(component);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setGlassPane(component);
        }
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setLayeredPane(jLayeredPane);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setLayeredPane(jLayeredPane);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setLayeredPane(jLayeredPane);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setLayeredPane(jLayeredPane);
        }
    }

    public void setMaximizationLayer(Integer n2) {
        if (n2 == null) {
            n2 = DEFAULT_MAXED_LAYER;
        }
        this.maximizationLayer = n2;
    }

    public void setMaximizedLayout(LayoutManager layoutManager) {
        this.maxedLayout = layoutManager;
    }

    protected void setRootContainer(Component component) {
        this.root = component;
    }
}

