/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MultiSplitLayout
implements LayoutManager {
    private final Map childMap = new HashMap();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Node model;
    private int dividerSize;
    private boolean floatingDividers = true;

    public MultiSplitLayout() {
        this(new Leaf("default"));
    }

    public MultiSplitLayout(Node node) {
        this.model = node;
        this.dividerSize = 3;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private void firePCS(String string, Object object, Object object2) {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.pcs.firePropertyChange(string, object, object2);
        }
    }

    public Node getModel() {
        return this.model;
    }

    public void setModel(Node node) {
        if (node == null || node instanceof Divider) {
            throw new IllegalArgumentException("invalid model");
        }
        Node node2 = node;
        this.model = node;
        this.firePCS("model", node2, node);
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid dividerSize");
        }
        int n3 = this.dividerSize;
        this.dividerSize = n2;
        this.firePCS("dividerSize", new Integer(n3), new Integer(n2));
    }

    public boolean getFloatingDividers() {
        return this.floatingDividers;
    }

    public void setFloatingDividers(boolean bl) {
        boolean bl2 = this.floatingDividers;
        this.floatingDividers = bl;
        this.firePCS("floatingDividers", new Boolean(bl2), new Boolean(bl));
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            throw new IllegalArgumentException("name not specified");
        }
        this.childMap.put(string, component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        String string = component.getName();
        if (string != null) {
            this.childMap.remove(string);
        }
    }

    private Component childForNode(Node node) {
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            String string = leaf.getName();
            return string != null ? (Component)this.childMap.get(string) : null;
        }
        return null;
    }

    private Dimension preferredComponentSize(Node node) {
        Component component = this.childForNode(node);
        return component != null ? component.getPreferredSize() : new Dimension(0, 0);
    }

    private Dimension minimumComponentSize(Node node) {
        Component component = this.childForNode(node);
        return component != null ? component.getMinimumSize() : new Dimension(0, 0);
    }

    private Dimension preferredNodeSize(Node node) {
        if (node instanceof Leaf) {
            return this.preferredComponentSize(node);
        }
        if (node instanceof Divider) {
            int n2 = this.getDividerSize();
            return new Dimension(n2, n2);
        }
        Split split = (Split)node;
        List list = split.getChildren();
        int n3 = 0;
        int n4 = 0;
        if (split.isRowLayout()) {
            for (Node node2 : list) {
                Dimension dimension = this.preferredNodeSize(node2);
                n3 += dimension.width;
                n4 = Math.max(n4, dimension.height);
            }
        } else {
            for (Node node3 : list) {
                Dimension dimension = this.preferredNodeSize(node3);
                n3 = Math.max(n3, dimension.width);
                n4 += dimension.height;
            }
        }
        return new Dimension(n3, n4);
    }

    private Dimension minimumNodeSize(Node node) {
        if (node instanceof Leaf) {
            Component component = this.childForNode(node);
            return component != null ? component.getMinimumSize() : new Dimension(0, 0);
        }
        if (node instanceof Divider) {
            int n2 = this.getDividerSize();
            return new Dimension(n2, n2);
        }
        Split split = (Split)node;
        List list = split.getChildren();
        int n3 = 0;
        int n4 = 0;
        if (split.isRowLayout()) {
            for (Node node2 : list) {
                Dimension dimension = this.minimumNodeSize(node2);
                n3 += dimension.width;
                n4 = Math.max(n4, dimension.height);
            }
        } else {
            for (Node node3 : list) {
                Dimension dimension = this.minimumNodeSize(node3);
                n3 = Math.max(n3, dimension.width);
                n4 += dimension.height;
            }
        }
        return new Dimension(n3, n4);
    }

    private Dimension sizeWithInsets(Container container, Dimension dimension) {
        Insets insets = container.getInsets();
        int n2 = dimension.width + insets.left + insets.right;
        int n3 = dimension.height + insets.top + insets.bottom;
        return new Dimension(n2, n3);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.preferredNodeSize(this.getModel());
        return this.sizeWithInsets(container, dimension);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.minimumNodeSize(this.getModel());
        return this.sizeWithInsets(container, dimension);
    }

    private Rectangle boundsWithYandHeight(Rectangle rectangle, double d2, double d3) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setBounds((int)rectangle.getX(), (int)d2, (int)rectangle.getWidth(), (int)d3);
        return rectangle2;
    }

    private Rectangle boundsWithXandWidth(Rectangle rectangle, double d2, double d3) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setBounds((int)d2, (int)rectangle.getY(), (int)d3, (int)rectangle.getHeight());
        return rectangle2;
    }

    private void minimizeSplitBounds(Split split, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 0, 0);
        List list = split.getChildren();
        Node node = (Node)list.get(list.size() - 1);
        Rectangle rectangle3 = node.getBounds();
        if (split.isRowLayout()) {
            int n2 = rectangle3.x + rectangle3.width;
            rectangle2.add(n2, rectangle.y + rectangle.height);
        } else {
            int n3 = rectangle3.y + rectangle3.height;
            rectangle2.add(rectangle.x + rectangle.width, n3);
        }
        split.setBounds(rectangle2);
    }

    private void layoutShrink(Split split, Rectangle rectangle) {
        Rectangle rectangle2 = split.getBounds();
        ListIterator listIterator = split.getChildren().listIterator();
        Node node = split.lastWeightedChild();
        if (split.isRowLayout()) {
            boolean bl;
            double d2;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (Node node2 : split.getChildren()) {
                int n5 = node2.getBounds().width;
                int n6 = Math.min(n5, this.minimumNodeSize((Node)node2).width);
                n2 += n5;
                if (!(node2.getWeight() > 0.0)) continue;
                n3 += n6;
                n4 += n5;
            }
            double d3 = rectangle.getX();
            double d4 = d2 = rectangle2.getWidth() - rectangle.getWidth();
            boolean bl2 = bl = (double)(n4 - n3) > d2;
            while (listIterator.hasNext()) {
                Rectangle rectangle3;
                double d5;
                double d6;
                Node node3 = (Node)listIterator.next();
                Rectangle rectangle4 = node3.getBounds();
                double d7 = this.minimumNodeSize(node3).getWidth();
                double d8 = d6 = bl ? node3.getWeight() : rectangle4.getWidth() / (double)n2;
                if (!listIterator.hasNext()) {
                    d5 = Math.max(d7, rectangle.getMaxX() - d3);
                    rectangle3 = this.boundsWithXandWidth(rectangle, d3, d5);
                    this.layout2(node3, rectangle3);
                } else if (d4 > 0.0 && d6 > 0.0) {
                    d5 = Math.rint(d6 * d2);
                    double d9 = rectangle4.getWidth();
                    double d10 = Math.max(d7, d9 - d5);
                    Rectangle rectangle5 = this.boundsWithXandWidth(rectangle, d3, d10);
                    this.layout2(node3, rectangle5);
                    d4 -= d9 - node3.getBounds().getWidth();
                } else {
                    d5 = rectangle4.getWidth();
                    rectangle3 = this.boundsWithXandWidth(rectangle, d3, d5);
                    this.layout2(node3, rectangle3);
                }
                d3 = node3.getBounds().getMaxX();
            }
        } else {
            boolean bl;
            double d11;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            for (Node node4 : split.getChildren()) {
                int n10 = node4.getBounds().height;
                int n11 = Math.min(n10, this.minimumNodeSize((Node)node4).height);
                n7 += n10;
                if (!(node4.getWeight() > 0.0)) continue;
                n8 += n11;
                n9 += n10;
            }
            double d12 = rectangle.getY();
            double d13 = d11 = rectangle2.getHeight() - rectangle.getHeight();
            boolean bl3 = bl = (double)(n9 - n8) > d11;
            while (listIterator.hasNext()) {
                double d14;
                double d15;
                Node node5 = (Node)listIterator.next();
                Rectangle rectangle6 = node5.getBounds();
                double d16 = this.minimumNodeSize(node5).getHeight();
                double d17 = d15 = bl ? node5.getWeight() : rectangle6.getHeight() / (double)n7;
                if (!listIterator.hasNext()) {
                    d14 = rectangle6.getHeight();
                    double d18 = Math.max(d16, rectangle.getMaxY() - d12);
                    Rectangle rectangle7 = this.boundsWithYandHeight(rectangle, d12, d18);
                    this.layout2(node5, rectangle7);
                    d13 -= d14 - node5.getBounds().getHeight();
                } else if (d13 > 0.0 && d15 > 0.0) {
                    d14 = Math.rint(d15 * d11);
                    double d19 = rectangle6.getHeight();
                    double d20 = Math.max(d16, d19 - d14);
                    Rectangle rectangle8 = this.boundsWithYandHeight(rectangle, d12, d20);
                    this.layout2(node5, rectangle8);
                    d13 -= d19 - node5.getBounds().getHeight();
                } else {
                    d14 = rectangle6.getHeight();
                    Rectangle rectangle9 = this.boundsWithYandHeight(rectangle, d12, d14);
                    this.layout2(node5, rectangle9);
                }
                d12 = node5.getBounds().getMaxY();
            }
        }
        this.minimizeSplitBounds(split, rectangle);
    }

    private void layoutGrow(Split split, Rectangle rectangle) {
        Rectangle rectangle2 = split.getBounds();
        ListIterator listIterator = split.getChildren().listIterator();
        Node node = split.lastWeightedChild();
        if (split.isRowLayout()) {
            double d2;
            double d3 = rectangle.getX();
            double d4 = d2 = rectangle.getWidth() - rectangle2.getWidth();
            while (listIterator.hasNext()) {
                Rectangle rectangle3;
                double d5;
                Node node2 = (Node)listIterator.next();
                Rectangle rectangle4 = node2.getBounds();
                double d6 = node2.getWeight();
                if (!listIterator.hasNext()) {
                    d5 = rectangle.getMaxX() - d3;
                    rectangle3 = this.boundsWithXandWidth(rectangle, d3, d5);
                    this.layout2(node2, rectangle3);
                } else if (d4 > 0.0 && d6 > 0.0) {
                    d5 = node2.equals(node) ? d4 : Math.rint(d6 * d2);
                    double d7 = rectangle4.getWidth() + d5;
                    Rectangle rectangle5 = this.boundsWithXandWidth(rectangle, d3, d7);
                    this.layout2(node2, rectangle5);
                    d4 -= d5;
                } else {
                    d5 = rectangle4.getWidth();
                    rectangle3 = this.boundsWithXandWidth(rectangle, d3, d5);
                    this.layout2(node2, rectangle3);
                }
                d3 = node2.getBounds().getMaxX();
            }
        } else {
            double d8;
            double d9 = rectangle.getY();
            double d10 = d8 = rectangle.getMaxY() - rectangle2.getHeight();
            while (listIterator.hasNext()) {
                double d11;
                Node node3 = (Node)listIterator.next();
                Rectangle rectangle6 = node3.getBounds();
                double d12 = node3.getWeight();
                if (!listIterator.hasNext()) {
                    d11 = rectangle.getMaxY() - d9;
                    Rectangle rectangle7 = this.boundsWithYandHeight(rectangle, d9, d11);
                    this.layout2(node3, rectangle7);
                } else if (d10 > 0.0 && d12 > 0.0) {
                    d11 = node3.equals(node) ? d10 : Math.rint(d12 * d8);
                    double d13 = rectangle6.getHeight() + d11;
                    Rectangle rectangle8 = this.boundsWithYandHeight(rectangle, d9, d13);
                    this.layout2(node3, rectangle8);
                    d10 -= d11;
                } else {
                    d11 = rectangle6.getHeight();
                    Rectangle rectangle9 = this.boundsWithYandHeight(rectangle, d9, d11);
                    this.layout2(node3, rectangle9);
                }
                d9 = node3.getBounds().getMaxY();
            }
        }
    }

    private void layout2(Node node, Rectangle rectangle) {
        if (node instanceof Leaf) {
            Component component = this.childForNode(node);
            if (component != null) {
                component.setBounds(rectangle);
            }
            node.setBounds(rectangle);
        } else if (node instanceof Divider) {
            node.setBounds(rectangle);
        } else if (node instanceof Split) {
            boolean bl;
            Split split = (Split)node;
            boolean bl2 = split.isRowLayout() ? split.getBounds().width <= rectangle.width : (bl = split.getBounds().height <= rectangle.height);
            if (bl) {
                this.layoutGrow(split, rectangle);
                node.setBounds(rectangle);
            } else {
                this.layoutShrink(split, rectangle);
            }
        }
    }

    private void layout1(Node node, Rectangle rectangle) {
        if (node instanceof Leaf) {
            node.setBounds(rectangle);
        } else if (node instanceof Split) {
            Split split = (Split)node;
            Iterator iterator = split.getChildren().iterator();
            Rectangle rectangle2 = null;
            int n2 = this.getDividerSize();
            if (split.isRowLayout()) {
                double d2 = rectangle.getX();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    Divider divider = iterator.hasNext() ? (Divider)iterator.next() : null;
                    double d3 = 0.0;
                    d3 = this.getFloatingDividers() ? this.preferredNodeSize(node2).getWidth() : (divider != null ? divider.getBounds().getX() - d2 : split.getBounds().getMaxX() - d2);
                    rectangle2 = this.boundsWithXandWidth(rectangle, d2, d3);
                    this.layout1(node2, rectangle2);
                    if (this.getFloatingDividers() && divider != null) {
                        double d4 = rectangle2.getMaxX();
                        Rectangle rectangle3 = this.boundsWithXandWidth(rectangle, d4, n2);
                        divider.setBounds(rectangle3);
                    }
                    if (divider == null) continue;
                    d2 = divider.getBounds().getMaxX();
                }
            } else {
                double d5 = rectangle.getY();
                while (iterator.hasNext()) {
                    Node node3 = (Node)iterator.next();
                    Divider divider = iterator.hasNext() ? (Divider)iterator.next() : null;
                    double d6 = 0.0;
                    d6 = this.getFloatingDividers() ? this.preferredNodeSize(node3).getHeight() : (divider != null ? divider.getBounds().getY() - d5 : split.getBounds().getMaxY() - d5);
                    rectangle2 = this.boundsWithYandHeight(rectangle, d5, d6);
                    this.layout1(node3, rectangle2);
                    if (this.getFloatingDividers() && divider != null) {
                        double d7 = rectangle2.getMaxY();
                        Rectangle rectangle4 = this.boundsWithYandHeight(rectangle, d7, n2);
                        divider.setBounds(rectangle4);
                    }
                    if (divider == null) continue;
                    d5 = divider.getBounds().getMaxY();
                }
            }
            this.minimizeSplitBounds(split, rectangle);
        }
    }

    private void throwInvalidLayout(String string, Node node) {
        throw new InvalidLayoutException(string, node);
    }

    private void checkLayout(Node node) {
        if (node instanceof Split) {
            Split split = (Split)node;
            if (split.getChildren().size() <= 2) {
                this.throwInvalidLayout("Split must have > 2 children", node);
            }
            Iterator iterator = split.getChildren().iterator();
            double d2 = 0.0;
            while (iterator.hasNext()) {
                Node node2;
                Node node3 = (Node)iterator.next();
                if (node3 instanceof Divider) {
                    this.throwInvalidLayout("expected a Split or Leaf Node", node3);
                }
                if (iterator.hasNext() && !((node2 = (Node)iterator.next()) instanceof Divider)) {
                    this.throwInvalidLayout("expected a Divider Node", node2);
                }
                d2 += node3.getWeight();
                this.checkLayout(node3);
            }
            if (d2 > 1.01) {
                this.throwInvalidLayout("Split children's total weight > 1.0", node);
            }
        }
    }

    @Override
    public void layoutContainer(Container container) {
        this.checkLayout(this.getModel());
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = dimension.height - (insets.top + insets.bottom);
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n2, n3);
        this.layout1(this.getModel(), rectangle);
        this.layout2(this.getModel(), rectangle);
    }

    private Divider dividerAt(Node node, int n2, int n3) {
        if (node instanceof Divider) {
            Divider divider = (Divider)node;
            return divider.getBounds().contains(n2, n3) ? divider : null;
        }
        if (node instanceof Split) {
            Split split = (Split)node;
            for (Node node2 : split.getChildren()) {
                if (!node2.getBounds().contains(n2, n3)) continue;
                return this.dividerAt(node2, n2, n3);
            }
        }
        return null;
    }

    public Divider dividerAt(int n2, int n3) {
        return this.dividerAt(this.getModel(), n2, n3);
    }

    private boolean nodeOverlapsRectangle(Node node, Rectangle rectangle) {
        Rectangle rectangle2 = node.getBounds();
        return rectangle2.x <= rectangle.x + rectangle.width && rectangle2.x + rectangle2.width >= rectangle.x && rectangle2.y <= rectangle.y + rectangle.height && rectangle2.y + rectangle2.height >= rectangle.y;
    }

    private List dividersThatOverlap(Node node, Rectangle rectangle) {
        if (this.nodeOverlapsRectangle(node, rectangle) && node instanceof Split) {
            ArrayList<Divider> arrayList = new ArrayList<Divider>();
            for (Node node2 : ((Split)node).getChildren()) {
                if (node2 instanceof Divider) {
                    if (!this.nodeOverlapsRectangle(node2, rectangle)) continue;
                    arrayList.add((Divider)node2);
                    continue;
                }
                if (!(node2 instanceof Split)) continue;
                arrayList.addAll(this.dividersThatOverlap(node2, rectangle));
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public List dividersThatOverlap(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("null Rectangle");
        }
        return this.dividersThatOverlap(this.getModel(), rectangle);
    }

    private static void throwParseException(StreamTokenizer streamTokenizer, String string) throws Exception {
        throw new Exception("MultiSplitLayout.parseModel Error: " + string);
    }

    private static void parseAttribute(String string, StreamTokenizer streamTokenizer, Node node) throws Exception {
        if (streamTokenizer.nextToken() != 61) {
            MultiSplitLayout.throwParseException(streamTokenizer, "expected '=' after " + string);
        }
        if (string.equalsIgnoreCase("WEIGHT")) {
            if (streamTokenizer.nextToken() == -2) {
                node.setWeight(streamTokenizer.nval);
            } else {
                MultiSplitLayout.throwParseException(streamTokenizer, "invalid weight");
            }
        } else if (string.equalsIgnoreCase("MINPIXEL")) {
            if (streamTokenizer.nextToken() == -2) {
                node.setMinSize(streamTokenizer.nval);
            } else {
                MultiSplitLayout.throwParseException(streamTokenizer, "invalid minimum size");
            }
        } else if (string.equalsIgnoreCase("NAME")) {
            if (streamTokenizer.nextToken() == -3) {
                if (node instanceof Leaf) {
                    ((Leaf)node).setName(streamTokenizer.sval);
                } else {
                    MultiSplitLayout.throwParseException(streamTokenizer, "can't specify name for " + node);
                }
            } else {
                MultiSplitLayout.throwParseException(streamTokenizer, "invalid name");
            }
        } else {
            MultiSplitLayout.throwParseException(streamTokenizer, "unrecognized attribute \"" + string + "\"");
        }
    }

    private static void addSplitChild(Split split, Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>(split.getChildren());
        if (arrayList.size() == 0) {
            arrayList.add(node);
        } else {
            arrayList.add(new Divider());
            arrayList.add(node);
        }
        split.setChildren(arrayList);
    }

    private static void parseLeaf(StreamTokenizer streamTokenizer, Split split) throws Exception {
        int n2;
        Leaf leaf = new Leaf();
        while ((n2 = streamTokenizer.nextToken()) != -1 && n2 != 41) {
            if (n2 == -3) {
                MultiSplitLayout.parseAttribute(streamTokenizer.sval, streamTokenizer, leaf);
                continue;
            }
            MultiSplitLayout.throwParseException(streamTokenizer, "Bad Leaf: " + leaf);
        }
        MultiSplitLayout.addSplitChild(split, leaf);
    }

    private static void parseSplit(StreamTokenizer streamTokenizer, Split split) throws Exception {
        int n2;
        while ((n2 = streamTokenizer.nextToken()) != -1 && n2 != 41) {
            String string;
            if (n2 == -3) {
                if (streamTokenizer.sval.equalsIgnoreCase("WEIGHT") || streamTokenizer.sval.equalsIgnoreCase("MINPIXEL")) {
                    MultiSplitLayout.parseAttribute(streamTokenizer.sval, streamTokenizer, split);
                    continue;
                }
                MultiSplitLayout.addSplitChild(split, new Leaf(streamTokenizer.sval));
                continue;
            }
            if (n2 != 40) continue;
            n2 = streamTokenizer.nextToken();
            if (n2 != -3) {
                MultiSplitLayout.throwParseException(streamTokenizer, "invalid node type");
            }
            if ((string = streamTokenizer.sval.toUpperCase()).equals("LEAF")) {
                MultiSplitLayout.parseLeaf(streamTokenizer, split);
                continue;
            }
            if (string.equals("ROW") || string.equals("COLUMN")) {
                Split split2 = new Split();
                split2.setRowLayout(string.equals("ROW"));
                MultiSplitLayout.addSplitChild(split, split2);
                MultiSplitLayout.parseSplit(streamTokenizer, split2);
                continue;
            }
            MultiSplitLayout.throwParseException(streamTokenizer, "unrecognized node type '" + string + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node parseModel(Reader reader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        try {
            Split split = new Split();
            MultiSplitLayout.parseSplit(streamTokenizer, split);
            Node node = (Node)split.getChildren().get(0);
            return node;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static Node parseModel(String string) {
        return MultiSplitLayout.parseModel(new StringReader(string));
    }

    private static void getModel(StringBuffer stringBuffer, Node node) {
        if (node instanceof Split) {
            Rectangle rectangle;
            Split split = (Split)node;
            boolean bl = split.isRowLayout();
            stringBuffer.append(bl ? "(ROW " : "(COLUMN ");
            double d2 = 0.0;
            for (Node node2 : split.getChildren()) {
                if (node2 instanceof Divider) continue;
                rectangle = node2.getBounds();
                if (bl) {
                    d2 += (double)rectangle.width;
                    continue;
                }
                d2 += (double)rectangle.height;
            }
            for (Node node2 : split.getChildren()) {
                if (d2 > 0.0 && !(node2 instanceof Divider)) {
                    rectangle = node2.getBounds();
                    if (bl) {
                        node2.setWeight((double)rectangle.width / d2);
                    } else {
                        node2.setWeight((double)rectangle.height / d2);
                    }
                }
                MultiSplitLayout.getModel(stringBuffer, node2);
            }
            stringBuffer.append(" weight=");
            stringBuffer.append(Float.toString((float)split.getWeight()));
            if (split.getMinSize() > 0) {
                stringBuffer.append(" minpixel=");
                stringBuffer.append(split.getMinSize());
            }
            stringBuffer.append(")");
        } else if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            stringBuffer.append("(LEAF name=");
            stringBuffer.append(leaf.getName());
            stringBuffer.append(" weight=");
            stringBuffer.append(Float.toString((float)leaf.getWeight()));
            if (leaf.getMinSize() > 0) {
                stringBuffer.append(" minpixel=");
                stringBuffer.append(leaf.getMinSize());
            }
            stringBuffer.append(")");
        }
    }

    public static String getModel(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        MultiSplitLayout.getModel(stringBuffer, node);
        return stringBuffer.toString();
    }

    private static void printModel(String string, Node node) {
        if (node instanceof Split) {
            Split split = (Split)node;
            System.out.println(string + split);
            for (Node node2 : split.getChildren()) {
                MultiSplitLayout.printModel(string + "  ", node2);
            }
        } else {
            System.out.println(string + node);
        }
    }

    public static void printModel(Node node) {
        MultiSplitLayout.printModel("", node);
    }

    public static class Divider
    extends Node {
        public final boolean isVertical() {
            Split split = this.getParent();
            return split != null ? split.isRowLayout() : false;
        }

        @Override
        public void setWeight(double d2) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "MultiSplitLayout.Divider " + this.getBounds().toString();
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            Node node = this.previousSibling();
            Node node2 = this.nextSibling();
            if (this.isVertical()) {
                if (node.getMinSize() > 0 || node2.getMinSize() > 0) {
                    Node node3;
                    Node node4;
                    if (node.getBounds().x < node2.getBounds().x) {
                        node4 = node;
                        node3 = node2;
                    } else {
                        node4 = node2;
                        node3 = node;
                    }
                    if (node4.minSize > 0 && rectangle.x < node4.minSize) {
                        rectangle.x = node4.minSize;
                    }
                    if (node3.minSize > 0 && node3.getBounds().width >= node3.minSize) {
                        int n2 = node3.getBounds().width - (rectangle.x + rectangle.width - node3.getBounds().x);
                        int n3 = node3.minSize - n2;
                        if (n3 > 0) {
                            rectangle.x -= n3;
                        }
                    }
                }
            } else if (node.getMinSize() > 0 || node2.getMinSize() > 0) {
                Node node5;
                Node node6;
                if (node.getBounds().y < node2.getBounds().y) {
                    node6 = node;
                    node5 = node2;
                } else {
                    node6 = node2;
                    node5 = node;
                }
                if (node6.minSize > 0 && rectangle.y < node6.minSize) {
                    rectangle.y = node6.minSize;
                }
                if (node5.minSize > 0 && node5.getBounds().height >= node5.minSize) {
                    int n4 = node5.getBounds().height - (rectangle.y + rectangle.height - node5.getBounds().y);
                    int n5 = node5.minSize - n4;
                    if (n5 > 0) {
                        rectangle.y -= n5;
                    }
                }
            }
            super.setBounds(rectangle);
        }
    }

    public static class Leaf
    extends Node {
        private String name = "";

        public Leaf() {
        }

        public Leaf(String string) {
            if (string == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            if (string == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("MultiSplitLayout.Leaf");
            stringBuffer.append(" \"");
            stringBuffer.append(this.getName());
            stringBuffer.append("\"");
            stringBuffer.append(" weight=");
            stringBuffer.append(this.getWeight());
            stringBuffer.append(" ");
            stringBuffer.append(this.getBounds());
            return stringBuffer.toString();
        }
    }

    public static class Split
    extends Node {
        private List children = Collections.EMPTY_LIST;
        private boolean rowLayout = true;

        public boolean isRowLayout() {
            return this.rowLayout;
        }

        public void setRowLayout(boolean bl) {
            this.rowLayout = bl;
        }

        public List getChildren() {
            return new ArrayList(this.children);
        }

        public void setChildren(List list) {
            if (list == null) {
                throw new IllegalArgumentException("children must be a non-null List");
            }
            for (Node node : this.children) {
                node.setParent(null);
            }
            this.children = new ArrayList(list);
            for (Node node : this.children) {
                node.setParent(this);
            }
        }

        public final Node lastWeightedChild() {
            List list = this.getChildren();
            Node node = null;
            for (Node node2 : list) {
                if (!(node2.getWeight() > 0.0)) continue;
                node = node2;
            }
            return node;
        }

        public String toString() {
            int n2 = this.getChildren().size();
            StringBuffer stringBuffer = new StringBuffer("MultiSplitLayout.Split");
            stringBuffer.append(this.isRowLayout() ? " ROW [" : " COLUMN [");
            stringBuffer.append(n2 + (n2 == 1 ? " child" : " children"));
            stringBuffer.append("] ");
            stringBuffer.append(this.getBounds());
            return stringBuffer.toString();
        }
    }

    public static abstract class Node {
        private Split parent = null;
        private Rectangle bounds = new Rectangle();
        private double weight = 0.0;
        private int minSize = 0;

        public Split getParent() {
            return this.parent;
        }

        public void setParent(Split split) {
            this.parent = split;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.bounds);
        }

        public void setBounds(Rectangle rectangle) {
            if (rectangle == null) {
                throw new IllegalArgumentException("null bounds");
            }
            this.bounds = new Rectangle(rectangle);
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double d2) {
            if (d2 < 0.0 || d2 > 1.0) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = d2;
        }

        public int getMinSize() {
            return this.minSize;
        }

        private void setMinSize(double d2) {
            this.minSize = (int)d2;
        }

        private Node siblingAtOffset(int n2) {
            Split split = this.getParent();
            if (split == null) {
                return null;
            }
            List list = split.getChildren();
            int n3 = list.indexOf(this);
            if (n3 == -1) {
                return null;
            }
            return (n3 += n2) > -1 && n3 < list.size() ? (Node)list.get(n3) : null;
        }

        public Node nextSibling() {
            return this.siblingAtOffset(1);
        }

        public Node previousSibling() {
            return this.siblingAtOffset(-1);
        }
    }

    public static class InvalidLayoutException
    extends RuntimeException {
        private final Node node;

        public InvalidLayoutException(String string, Node node) {
            super(string);
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

