/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.swingx;

import com.iscobol.docking.swingx.MultiSplitLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class MultiSplitPane
extends JPanel {
    private AccessibleContext accessibleContext = null;
    private boolean continuousLayout = true;
    private DividerPainter dividerPainter = new DefaultDividerPainter();
    private boolean dragUnderway = false;
    private MultiSplitLayout.Divider dragDivider = null;
    private Rectangle initialDividerBounds = null;
    private boolean oldFloatingDividers = true;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private int dragMin = -1;
    private int dragMax = -1;

    public MultiSplitPane() {
        super(new MultiSplitLayout());
        InputHandler inputHandler = new InputHandler();
        this.addMouseListener(inputHandler);
        this.addMouseMotionListener(inputHandler);
        this.addKeyListener(inputHandler);
    }

    public final MultiSplitLayout getMultiSplitLayout() {
        return (MultiSplitLayout)this.getLayout();
    }

    public final void setModel(MultiSplitLayout.Node node) {
        this.getMultiSplitLayout().setModel(node);
    }

    public final void setDividerSize(int n2) {
        this.getMultiSplitLayout().setDividerSize(n2);
    }

    public void setContinuousLayout(boolean bl) {
        boolean bl2 = bl;
        this.continuousLayout = bl;
        this.firePropertyChange("continuousLayout", bl2, bl);
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public MultiSplitLayout.Divider activeDivider() {
        return this.dragDivider;
    }

    public DividerPainter getDividerPainter() {
        return this.dividerPainter;
    }

    public void setDividerPainter(DividerPainter dividerPainter) {
        this.dividerPainter = dividerPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        DividerPainter dividerPainter = this.getDividerPainter();
        Rectangle rectangle = graphics.getClipBounds();
        if (dividerPainter != null && rectangle != null) {
            Graphics graphics2 = graphics.create();
            try {
                MultiSplitLayout multiSplitLayout = this.getMultiSplitLayout();
                for (MultiSplitLayout.Divider divider : multiSplitLayout.dividersThatOverlap(rectangle)) {
                    dividerPainter.paint(graphics2, divider);
                }
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    private void startDrag(int n2, int n3) {
        MultiSplitLayout multiSplitLayout = this.getMultiSplitLayout();
        MultiSplitLayout.Divider divider = multiSplitLayout.dividerAt(n2, n3);
        if (divider != null) {
            MultiSplitLayout.Node node = divider.previousSibling();
            MultiSplitLayout.Node node2 = divider.nextSibling();
            if (node == null || node2 == null) {
                this.dragUnderway = false;
            } else {
                this.initialDividerBounds = divider.getBounds();
                this.dragOffsetX = n2 - this.initialDividerBounds.x;
                this.dragOffsetY = n3 - this.initialDividerBounds.y;
                this.dragDivider = divider;
                Rectangle rectangle = node.getBounds();
                Rectangle rectangle2 = node2.getBounds();
                if (this.dragDivider.isVertical()) {
                    this.dragMin = rectangle.x;
                    this.dragMax = rectangle2.x + rectangle2.width;
                    this.dragMax -= this.dragDivider.getBounds().width;
                } else {
                    this.dragMin = rectangle.y;
                    this.dragMax = rectangle2.y + rectangle2.height;
                    this.dragMax -= this.dragDivider.getBounds().height;
                }
                this.oldFloatingDividers = this.getMultiSplitLayout().getFloatingDividers();
                this.getMultiSplitLayout().setFloatingDividers(false);
                this.dragUnderway = true;
            }
        } else {
            this.dragUnderway = false;
        }
    }

    private void repaintDragLimits() {
        Rectangle rectangle = this.dragDivider.getBounds();
        if (this.dragDivider.isVertical()) {
            rectangle.x = this.dragMin;
            rectangle.width = this.dragMax - this.dragMin;
        } else {
            rectangle.y = this.dragMin;
            rectangle.height = this.dragMax - this.dragMin;
        }
        this.repaint(rectangle);
    }

    private void updateDrag(int n2, int n3) {
        if (!this.dragUnderway) {
            return;
        }
        Rectangle rectangle = this.dragDivider.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.dragDivider.isVertical()) {
            rectangle2.x = n2 - this.dragOffsetX;
            rectangle2.x = Math.max(rectangle2.x, this.dragMin);
            rectangle2.x = Math.min(rectangle2.x, this.dragMax);
        } else {
            rectangle2.y = n3 - this.dragOffsetY;
            rectangle2.y = Math.max(rectangle2.y, this.dragMin);
            rectangle2.y = Math.min(rectangle2.y, this.dragMax);
        }
        this.dragDivider.setBounds(rectangle2);
        if (this.isContinuousLayout()) {
            this.revalidate();
            this.repaintDragLimits();
        } else {
            this.repaint(rectangle.union(rectangle2));
        }
    }

    private void clearDragState() {
        this.dragDivider = null;
        this.initialDividerBounds = null;
        this.oldFloatingDividers = true;
        this.dragOffsetY = 0;
        this.dragOffsetX = 0;
        this.dragMax = -1;
        this.dragMin = -1;
        this.dragUnderway = false;
    }

    private void finishDrag(int n2, int n3) {
        if (this.dragUnderway) {
            this.clearDragState();
            if (!this.isContinuousLayout()) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    private void cancelDrag() {
        if (this.dragUnderway) {
            this.dragDivider.setBounds(this.initialDividerBounds);
            this.getMultiSplitLayout().setFloatingDividers(this.oldFloatingDividers);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
            this.revalidate();
            this.clearDragState();
        }
    }

    private void updateCursor(int n2, int n3, boolean bl) {
        MultiSplitLayout.Divider divider;
        if (this.dragUnderway) {
            return;
        }
        int n4 = 0;
        if (bl && (divider = this.getMultiSplitLayout().dividerAt(n2, n3)) != null) {
            n4 = divider.isVertical() ? 11 : 8;
        }
        this.setCursor(Cursor.getPredefinedCursor(n4));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiSplitPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultiSplitPane
    extends JPanel.AccessibleJPanel {
        protected AccessibleMultiSplitPane() {
            super(MultiSplitPane.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }

    private class InputHandler
    extends MouseInputAdapter
    implements KeyListener {
        private InputHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MultiSplitPane.this.updateCursor(mouseEvent.getX(), mouseEvent.getY(), true);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MultiSplitPane.this.updateCursor(mouseEvent.getX(), mouseEvent.getY(), true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MultiSplitPane.this.updateCursor(mouseEvent.getX(), mouseEvent.getY(), false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MultiSplitPane.this.startDrag(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MultiSplitPane.this.finishDrag(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MultiSplitPane.this.updateDrag(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                MultiSplitPane.this.cancelDrag();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class DefaultDividerPainter
    extends DividerPainter {
        private DefaultDividerPainter() {
        }

        @Override
        public void paint(Graphics graphics, MultiSplitLayout.Divider divider) {
            if (divider == MultiSplitPane.this.activeDivider() && !MultiSplitPane.this.isContinuousLayout()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.black);
                graphics2D.fill(divider.getBounds());
            }
        }
    }

    public static abstract class DividerPainter {
        public abstract void paint(Graphics var1, MultiSplitLayout.Divider var2);
    }
}

