/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.easydb.Errors;
import com.iscobol.easydb.ModSql;
import com.iscobol.easydb.ModSqlRel;
import com.iscobol.easydb.ModSqlSeq;
import com.iscobol.easydb.MulSql;
import com.iscobol.easydb.OptionList;
import com.iscobol.easydb.SqlGenerator;
import com.iscobol.easydb.Table;
import com.iscobol.easydb.XmlDocument;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import java.io.File;
import java.util.List;

public class EdbiIs
implements EdbiIsCommon {
    protected OptionList options;
    protected boolean debug = false;
    protected int maxCharLen = 0;
    protected static int returnCode = 0;
    protected static XmlDocument docXml;
    protected static int dbt;
    protected static String suffix;
    protected static String suffixSql;
    protected static String prefix;
    protected static String dbStrType;
    protected static String oidName;
    protected static Table tab;
    protected static String subsC;
    protected static String xmlFile;
    public static String notNull;

    public static void main(String[] stringArray) {
        OptionList optionList;
        System.err.println(EdbiIs.getFullVersionNumber());
        if (stringArray.length < 1) {
            System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
            System.exit(-3);
        }
        if ((optionList = new OptionList(stringArray)).getOption("-help") != null) {
            optionList.help(false);
            System.exit(0);
        } else if (optionList.getOption("-v") != null) {
            System.exit(0);
        } else if (optionList.hasErrors()) {
            System.err.println("" + Errors.errors[new Integer(optionList.getErrorNum())] + " " + optionList.getErrors());
            System.exit(0);
        }
        String string = EdbiIs.loadOutDir(optionList);
        stringArray = optionList.getArgs();
        if (returnCode == 0) {
            if (stringArray[0] == null) {
                System.err.println("Missing xml_file");
                System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
                returnCode = -3;
            } else {
                int n2 = 0;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    xmlFile = stringArray[i2];
                    EdbiIs.run((OptionList)optionList.clone(), string, null);
                    if (returnCode == 0) continue;
                    n2 = returnCode;
                    returnCode = 0;
                }
                returnCode = n2;
            }
        }
        if (returnCode != 0) {
            System.exit(returnCode);
        }
    }

    static String getFullVersionNumber() {
        String string = RuntimeProperties.getFullVersionNumber();
        if (string.startsWith("isCOBOL")) {
            string = "isCOBOL-EdbiIs" + string.substring(7);
        }
        return string;
    }

    public EdbiIs() {
        dbt = 1;
        returnCode = 0;
        subsC = "";
    }

    public static String runComp(String string, String[] stringArray) {
        return EdbiIs.runComp(string, stringArray, null);
    }

    public static String runComp(String string, String[] stringArray, List<String> list) {
        OptionList optionList = new OptionList(stringArray);
        String string2 = EdbiIs.loadOutDir(optionList);
        xmlFile = null;
        EdbiIs.run(optionList, string2, string, list);
        return subsC;
    }

    public static EdbiIs run(OptionList optionList, String string, String string2) {
        return EdbiIs.run(optionList, string, string2, null);
    }

    public static EdbiIs run(OptionList optionList, String string, String string2, List<String> list) {
        if (!EdbiIs.checkLicense()) {
            return null;
        }
        EdbiIs edbiIs = new EdbiIs();
        String string3 = null;
        if (optionList.getOption("-sql") != null) {
            string3 = EdbiIs.loadOutDirScript(optionList);
        }
        if (optionList.getOption("-prefix=") != null) {
            prefix = optionList.getOption("-prefix=");
        }
        if (optionList.getOption("-nn") != null) {
            notNull = " not null";
        }
        returnCode = 0;
        edbiIs.debug = Config.b(".jeasydb.debug", false);
        edbiIs.setOption(optionList);
        optionList.checkOptions(edbiIs);
        if (string2 != null) {
            suffix = ".cbl";
        }
        docXml = new XmlDocument(edbiIs, xmlFile, string2, false, 0);
        if (returnCode == 0) {
            tab = new Table(edbiIs, docXml);
            if (returnCode == 0) {
                if (!(tab.isIndexed() || optionList.getOption("-dmld") == null && optionList.getOption("-dmlu") == null && optionList.getOption("-dsld") == null && optionList.getOption("-dslu") == null && optionList.getOption("-dpld") == null && optionList.getOption("-dplu") == null)) {
                    System.err.println(xmlFile + ": #" + 23 + " " + Errors.errors[23] + ":  table type not INDEXED  not allows LIMIT option (dmld,dmlu,dpld,dplu,dsld,dslu)!, line = 1");
                    return edbiIs;
                }
                if (!EdbiIs.tab.isMasterTable) {
                    String string4;
                    SqlGenerator sqlGenerator = null;
                    if (tab.isIndexed()) {
                        sqlGenerator = new ModSql(edbiIs, tab, string, string3);
                    } else if (tab.isRelative()) {
                        sqlGenerator = new ModSqlRel(edbiIs, tab, string, string3);
                    } else if (tab.isSequential()) {
                        sqlGenerator = new ModSqlSeq(edbiIs, tab, string, string3);
                    }
                    if (sqlGenerator != null && list != null && (string4 = sqlGenerator.getEdbiScriptFileName()) != null) {
                        list.add(string4);
                    }
                } else {
                    new MulSql(edbiIs, tab, string);
                    if (returnCode == 0) {
                        Table table = EdbiIs.tab.multiTables.getFirst();
                        while (table != null) {
                            String string5;
                            ModSql modSql = new ModSql(edbiIs, table, string, string3);
                            if (list != null && (string5 = modSql.getEdbiScriptFileName()) != null) {
                                list.add(string5);
                            }
                            table = EdbiIs.tab.multiTables.getNext();
                        }
                    }
                }
            }
        }
        return edbiIs;
    }

    public static String loadOutDir(OptionList optionList) {
        String string = "";
        string = optionList.getOption("-od=");
        if (string != null) {
            File file;
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            if (!(file = new File(string)).exists() || !file.isDirectory()) {
                System.err.println("Missing out directory:" + string);
                System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
            }
        } else {
            string = "";
        }
        return string;
    }

    public static String loadOutDirScript(OptionList optionList) {
        String string = "";
        string = optionList.getOption("-os=");
        if (string != null) {
            File file;
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            if (!(file = new File(string)).exists() || !file.isDirectory()) {
                System.err.println("Missing out script directory:" + string);
                System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
            }
        } else {
            string = "";
        }
        return string;
    }

    public String getOption(String string) {
        if (this.options == null) {
            return null;
        }
        return this.options.getOption(string);
    }

    public String getAllOptions() {
        return this.options.getAll();
    }

    public void setOption(OptionList optionList) {
        this.options = optionList;
    }

    public boolean hasDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public int getDbt() {
        return dbt;
    }

    public void setMaxCharLen(int n2) {
        this.maxCharLen = n2;
    }

    public int getMaxCharLen() {
        return this.maxCharLen;
    }

    public void setOidName(String string) {
        oidName = string;
    }

    public void addSubs(String string) {
        subsC = string + "!" + subsC;
    }

    public String getOidName() {
        return oidName;
    }

    public void printErr(int n2, String string, int n3) {
        String string2 = xmlFile + ": #" + n2 + " ";
        returnCode = n2;
        string2 = string2 + Errors.errors[n2];
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        if (n3 > 0) {
            string2 = string2 + ", line = " + n3;
        }
        System.err.println(string2);
        returnCode = n2;
    }

    static boolean checkLicense() {
        return EdbiIs.checkLicense(true);
    }

    static boolean checkLicense(boolean bl) {
        byte[] byArray = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 101, 97, 115, 121, 100, 98, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 52};
        byte[] byArray2 = new byte[]{20, 41, -107, 58, 24, 67, 0, -23};
        byte[] byArray3 = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 108, 105, 99, 105, 110, 102, 111};
        if (bl) {
            try {
                Config.a(byArray, byArray2);
                Config.a(RtsUtil.newUTFString(byArray3), null);
                Config.a(7);
            }
            catch (Throwable throwable) {
                System.err.println("DataBase Bridge: " + throwable);
                return false;
            }
        } else {
            Config.a(byArray, byArray2);
            Config.a(RtsUtil.newUTFString(byArray3), null);
            Config.a(7);
        }
        return true;
    }

    public void setReturnCode(int n2) {
        returnCode = n2;
    }

    public int getReturnCode() {
        return returnCode;
    }

    static {
        dbt = 1;
        suffix = ".gen";
        suffixSql = ".sql";
        prefix = "";
        dbStrType = "GEN";
        oidName = "OID";
        subsC = "";
        xmlFile = "";
        notNull = "";
    }
}

