/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.easydb.Condition;
import com.iscobol.easydb.ConditionList;
import com.iscobol.easydb.EdbiIs;
import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.easydb.Field;
import com.iscobol.easydb.FieldList;
import com.iscobol.easydb.Index;
import com.iscobol.easydb.IndexList;
import com.iscobol.easydb.Segment;
import com.iscobol.easydb.StringList;
import com.iscobol.easydb.TableList;
import com.iscobol.easydb.XmlDocument;

public class Table
implements EdbiIsCommon {
    String cobtabname;
    String tabname;
    String dbname;
    int dbtype;
    String viewname;
    boolean haveIndicator;
    boolean haveDups = false;
    boolean haveSameBuffs;
    boolean haveDefaultCond = false;
    String dbpath;
    FieldList fields = new FieldList();
    FieldList fieldsRedefines = new FieldList();
    FieldList sqlfields = new FieldList();
    IndexList indexes = new IndexList();
    String currline;
    int currtype;
    int currnum;
    int recLen;
    int maxRecLen;
    int minRecLen;
    int keyCount;
    EdbiIs edbi;
    String tableSpace;
    String storIni;
    String storNext;
    String storIncr;
    String temporary = "noTemp";
    int fileOrg;
    public int numConditions = 0;
    public int numSimplConditions = 0;
    public boolean isMasterTable;
    public boolean isChildTable;
    public boolean hasRedefines;
    public boolean hasRedefinesOfMulti;
    public boolean hasTime;
    public ConditionList conditions = new ConditionList();
    public TableList multiTables = new TableList();

    public Table(EdbiIs edbiIs, XmlDocument xmlDocument) {
        this.edbi = edbiIs;
        this.dbtype = this.edbi.getDbt();
        this.fileOrg = 0;
        this.tableSpace = this.edbi.getOption("-ott=") != null ? this.edbi.getOption("-ott=") : "";
        this.storIni = this.edbi.getOption("-oit=") != null ? this.edbi.getOption("-oit=") : "";
        this.storNext = this.edbi.getOption("-ont=") != null ? this.edbi.getOption("-ont=") : "";
        this.storIncr = this.edbi.getOption("-opt=") != null ? this.edbi.getOption("-opt=") : "";
        xmlDocument.carTable(this);
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.haveSameBuffs = true;
        this.hasTime = false;
        this.isMasterTable = false;
        this.isChildTable = false;
        this.hasRedefines = false;
        this.hasRedefinesOfMulti = false;
        this.dbname = this.tabname;
        this.recLen = this.maxRecLen;
        xmlDocument.carIndexes(this);
        if (!this.isIndexed()) {
            Index index = null;
            index = new Index(this.edbi, false);
            this.indexes.addItem(index);
            index.isSplit = false;
            index.idxdups = false;
            index.segNum = 1;
            Segment segment = new Segment();
            index.segments.addItem(segment);
            index.idxfields.addItem(new Field(this.edbi, "RELSEQ_DUMMY_KEY", "Numeric", 0, -1, this.maxRecLen, 18, 18, 0, 0, 0, false, 2, false, false, false, 0, 1, false));
        }
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        xmlDocument.carConditions(this);
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        xmlDocument.carFields(this);
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.carIdxFields();
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.manageConditions();
        if (this.edbi.getReturnCode() != 0) {
            return;
        }
        this.currnum = 0;
        if (this.edbi.hasDebug()) {
            System.err.println("This is tabname " + this.tabname);
        }
        if (this.edbi.hasDebug()) {
            System.err.println("Record's length = " + this.recLen);
        }
        if (this.fieldsRedefines.getItemNum() > 0) {
            this.changeRedefinesFieldInCond();
        }
    }

    public Table(EdbiIs edbiIs, Table table, Condition condition) {
        int n2 = 0;
        this.edbi = edbiIs;
        this.currnum = 0;
        this.cobtabname = condition.tabname;
        this.tabname = condition.tabname.replace('-', '_');
        if (this.cobtabname == null) {
            this.edbi.printErr(23, "Invalid tablename in multitable [" + this.tabname + "] unknown!", 1);
            return;
        }
        condition.dbname = this.tabname;
        if (this.edbi.hasDebug()) {
            System.err.println("This is tabname " + this.tabname);
        }
        this.dbname = table.dbname;
        this.recLen = table.recLen;
        this.tableSpace = table.tableSpace;
        this.storIni = table.storIni;
        this.storNext = table.storNext;
        this.storIncr = table.storIncr;
        this.haveIndicator = table.haveIndicator();
        this.haveDefaultCond = table.haveDefaultCond();
        this.haveSameBuffs = table.haveSameBuffs;
        this.haveDups = table.haveDups;
        this.hasTime = table.hasTime;
        this.isMasterTable = false;
        this.isChildTable = true;
        this.hasRedefinesOfMulti = false;
        if (condition.childsCond.getItemNum() > 0) {
            this.hasRedefines = true;
        }
        this.conditions.addItem(condition);
        this.manageConditions();
        this.maxRecLen = table.maxRecLen;
        this.minRecLen = table.minRecLen;
        this.keyCount = table.keyCount;
        this.dbtype = table.dbtype;
        this.temporary = table.temporary;
        Field field = table.fields.getFirst();
        while (field != null) {
            if (this.edbi.hasDebug()) {
                System.err.println("While [" + field.getCobName() + "] found [" + field.xmlcondition + "] for [" + condition.number + "]");
            }
            if (field.satisfy(condition)) {
                if (this.edbi.hasDebug()) {
                    System.err.println("XmlOffs [" + field.xmloffset + "] actOffs [" + n2 + "]");
                }
                if (field.getIntType() != field.getCobType() || field.getFldType() == 4) {
                    this.haveSameBuffs = false;
                }
                this.fields.addItem(field);
                n2 = field.xmloffset + field.xmlsize;
                if (!field.getCobName().equalsIgnoreCase("FILLER")) {
                    this.sqlfields.addItem(field);
                }
                if (this.edbi.hasDebug()) {
                    System.err.println("Add [" + field.getCobName() + "] found [" + field.xmlcondition + "] for [" + condition.number + "]");
                }
            }
            field = table.fields.getNext();
        }
        Index index = table.indexes.getFirst();
        while (index != null) {
            Index index2 = new Index(this.edbi, table.fields, index, condition, this);
            if (this.edbi.getReturnCode() != 0) {
                return;
            }
            if (this.edbi.hasDebug()) {
                System.err.println("Added index on cond [" + condition.number + "]");
            }
            this.indexes.addItem(index2);
            index = table.indexes.getNext();
        }
    }

    Field getByName(String string) {
        Field field = null;
        String string2 = string.replace('_', '-');
        field = this.fields.getFirst();
        while (field != null && !field.getCobName().equalsIgnoreCase(string2)) {
            if (this.edbi.hasDebug() && field != null) {
                System.err.println("Found [" + field.getCobName() + "] search for [" + string2 + "]");
            }
            field = this.fields.getNext();
        }
        return field;
    }

    Field getByOffset(int n2) {
        Field field = null;
        field = this.fields.getFirst();
        while (field != null && field.xmloffset != n2) {
            field = this.fields.getNext();
        }
        return field;
    }

    public String getCobName() {
        return this.cobtabname;
    }

    public void setTabname(String string) {
        this.tabname = string;
    }

    public String getTabName() {
        return this.tabname;
    }

    public String getDbName() {
        return this.dbname;
    }

    public String getViewname() {
        return this.viewname;
    }

    public boolean haveIndicator() {
        return this.haveIndicator;
    }

    public boolean haveDefaultCond() {
        return this.haveDefaultCond;
    }

    public void setDefaultCond(boolean bl) {
        this.haveDefaultCond = bl;
    }

    public int getMaxRecLen() {
        return this.maxRecLen;
    }

    public int getMinRecLen() {
        return this.minRecLen;
    }

    public int getDbType() {
        return this.dbtype;
    }

    public String getDbPath() {
        return this.dbpath;
    }

    public FieldList getField() {
        return this.fields;
    }

    public FieldList getSqlField() {
        return this.sqlfields;
    }

    public IndexList getIndex() {
        return this.indexes;
    }

    public ConditionList getCondition() {
        return this.conditions;
    }

    public Index getPrimaryKey() {
        return this.indexes.getFirst();
    }

    boolean isRedefOfIndex(Field field) {
        Index index = null;
        index = this.indexes.getFirst();
        while (index != null) {
            Segment segment = index.segments.getFirst();
            while (segment != null) {
                if (field.xmloffset >= segment.offset && field.xmloffset < segment.offset + segment.size) {
                    return true;
                }
                segment = index.segments.getNext();
            }
            index = this.indexes.getNext();
        }
        return false;
    }

    void carIdxFields() {
        int n2 = 0;
        Index index = this.indexes.getFirst();
        while (index != null) {
            Field field;
            ++n2;
            if (this.edbi.hasDebug()) {
                System.err.println("Index " + n2 + " of " + this.indexes.getMaxIdx() + " numSeg " + index.segNum + " duplicate " + index.idxdups);
            }
            boolean bl = false;
            String string = "";
            String string2 = index.namePart.getFirst();
            while (string2 != null && !bl) {
                field = this.getByName(string2);
                if (field != null) {
                    index.idxfields.addItem(field);
                    field.isPartKey = true;
                } else {
                    string = string2;
                    bl = true;
                }
                string2 = index.namePart.getNext();
            }
            if (bl) {
                int n3 = 0;
                int n4 = 0;
                index.clearIndex();
                Segment segment = index.segments.getFirst();
                while (segment != null) {
                    n4 = segment.offset + segment.size;
                    for (n3 = segment.offset; n3 < n4; n3 += field.xmlsize) {
                        if (n3 == 36) {
                            field = null;
                        }
                        if ((field = this.getByOffset(n3)) == null || field.getSqlName().equalsIgnoreCase("FILLER")) {
                            if (string.equalsIgnoreCase("FILLER")) {
                                this.edbi.printErr(18, string + " is invalid name in key part tag! ", index.xmlLine);
                            } else {
                                this.edbi.printErr(18, string + " part key not found! ", index.xmlLine);
                            }
                            return;
                        }
                        index.idxfields.addItem(field);
                        if (!this.edbi.hasDebug()) continue;
                        System.err.println("Index " + n2 + " by offset added " + field.getSqlName() + " in part[" + segment.offset + "," + segment.size + "] actOffs " + n3 + " lastOffs " + n4);
                    }
                    segment = index.segments.getNext();
                }
            }
            if (this.dbtype == 0) {
                if (this.edbi.hasDebug()) {
                    System.err.println("Hint Calc Index " + n2);
                }
                if (index.hint != "") {
                    index.hint = "/*+ " + index.hint + " */";
                }
                if (this.edbi.hasDebug()) {
                    System.err.println("Hint Calculated [" + index.hint + "][" + index.hintIdx + "]");
                }
            }
            if ((this.edbi.getOption("-dpld") != null || this.edbi.getOption("-dsld") != null || this.edbi.getOption("-dmld") != null) && index.idxdups) {
                field = new Field(this.edbi, this.edbi.getOidName(), "ALPHANUM", 0, -1, 0, 18, -1, -1, 0, 0, false, 0, false, false, false, 0, 0, false);
                index.idxfields.addItem(field);
            }
            index = this.indexes.getNext();
        }
    }

    void manageConditions() {
        if (this.conditions.getItemNum() > 0) {
            Condition condition = this.conditions.getFirst();
            while (condition != null) {
                if (!condition.tabname.equalsIgnoreCase(this.tabname) && condition.tabname.length() > 0) {
                    this.isMasterTable = true;
                    this.multiTables.addItem(new Table(this.edbi, this, condition));
                    if (this.edbi.getReturnCode() != 0) {
                        return;
                    }
                } else if (!condition.tabname.equalsIgnoreCase(this.tabname) || this.conditions.getItemNum() != 1 || !this.isChildTable) {
                    condition.isRedefines = true;
                    this.hasRedefines = true;
                }
                condition = this.conditions.getNext();
            }
        }
    }

    Table getMulti(String string) {
        Table table = null;
        if (this.multiTables.getItemNum() > 0) {
            table = this.multiTables.getFirst();
            while (table != null) {
                if (table.tabname.equalsIgnoreCase(string)) {
                    return table;
                }
                table = this.multiTables.getNext();
            }
        }
        return table;
    }

    int getFileOrg() {
        return this.fileOrg;
    }

    void setFileOrg(int n2) {
        this.fileOrg = n2;
    }

    public boolean isIndexed() {
        return this.fileOrg == 0;
    }

    boolean isSequential() {
        return this.fileOrg == 2;
    }

    boolean isLineSequential() {
        return this.fileOrg == 3;
    }

    public boolean isRelative() {
        return this.fileOrg == 1;
    }

    public int getFieldNum(Field field) {
        int n2 = 0;
        Field field2 = this.fields.getFirst();
        while (field2 != null) {
            ++n2;
            if (field2 == field) {
                return n2;
            }
            field2 = this.fields.getNext();
        }
        return n2;
    }

    void changeRedefinesFieldInCond() {
        Object object = null;
        Field field = this.fieldsRedefines.getFirst();
        while (field != null) {
            object = null;
            Object object2 = this.fields.getFirst();
            while (object2 != null && object == null) {
                if (field.xmloffset == ((Field)object2).xmloffset && field.xmlsize == ((Field)object2).xmlsize) {
                    object = object2;
                }
                object2 = this.fields.getNext();
            }
            if (object != null) {
                object2 = this.conditions.getFirst();
                while (object2 != null) {
                    if (((Condition)object2).field.equalsIgnoreCase(field.xmlname)) {
                        ((Condition)object2).field = ((Field)object).xmlname;
                        ((Condition)object2).condition = ((Condition)object2).condition.replaceAll(field.xmlname, ((Field)object).xmlname);
                    }
                    StringList stringList = new StringList();
                    Object object3 = ((Condition)object2).fieldCond.getFirst();
                    while (object3 != null) {
                        if (((String)object3).equalsIgnoreCase(field.xmlname)) {
                            stringList.addItem(((Field)object).xmlname);
                            ((Condition)object2).condition = ((Condition)object2).condition.replaceAll(field.xmlname, ((Field)object).xmlname);
                        } else {
                            stringList.addItem((String)object3);
                        }
                        object3 = ((Condition)object2).fieldCond.getNext();
                    }
                    ((Condition)object2).fieldCond = stringList;
                    object3 = ((Condition)object2).childsCond.getFirst();
                    while (object3 != null) {
                        if (((Condition)object3).field.equalsIgnoreCase(field.xmlname)) {
                            ((Condition)object3).field = ((Field)object).xmlname;
                            ((Condition)object3).condition = ((Condition)object3).condition.replaceAll(field.xmlname, ((Field)object).xmlname);
                        }
                        StringList stringList2 = new StringList();
                        String string = ((Condition)object3).fieldCond.getFirst();
                        while (string != null) {
                            if (string.equalsIgnoreCase(field.xmlname)) {
                                stringList2.addItem(((Field)object).xmlname);
                                ((Condition)object3).condition = ((Condition)object3).condition.replaceAll(string, ((Field)object).xmlname);
                            } else {
                                stringList2.addItem(string);
                            }
                            string = ((Condition)object3).fieldCond.getNext();
                        }
                        ((Condition)object3).fieldCond = stringList2;
                        object3 = ((Condition)object2).childsCond.getNext();
                    }
                    object2 = this.conditions.getNext();
                }
            }
            field = this.fieldsRedefines.getNext();
        }
    }
}

