/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.easydb.Condition;
import com.iscobol.easydb.EdbiIs;
import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.easydb.Field;
import com.iscobol.easydb.Index;
import com.iscobol.easydb.IndexList;
import com.iscobol.easydb.Macro;
import com.iscobol.easydb.Segment;
import com.iscobol.easydb.SimpleCondition;
import com.iscobol.easydb.SimpleConditionList;
import com.iscobol.easydb.StringList;
import com.iscobol.easydb.Table;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.io.StringReader;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlDocument
implements EdbiIsCommon {
    public EdbiIs edbi;
    boolean isEfdParser = false;
    boolean efdParserFlagIncludeComments = false;
    boolean efdParserFlagInclude999 = false;
    boolean efdParserFlagExcludeArrays = false;
    boolean efdParserFlagDeepFirst = false;
    public static final Hashtable<String, Integer> hdescfrmt = new Hashtable();
    DocumentBuilderFactory factory = RtsUtil.newDocumentBuilderFactory();
    DocumentBuilder builder = null;
    Document doc = null;

    public XmlDocument(EdbiIs edbiIs, String string, String string2, boolean bl, int n2) {
        this.isEfdParser = bl;
        if (n2 >= 8) {
            this.efdParserFlagDeepFirst = true;
            n2 -= 8;
        }
        if (n2 >= 4) {
            this.efdParserFlagExcludeArrays = true;
            n2 -= 4;
        }
        if (n2 >= 2) {
            this.efdParserFlagInclude999 = true;
            n2 -= 2;
        }
        if (n2 > 0) {
            this.efdParserFlagIncludeComments = true;
        }
        this.edbi = edbiIs;
        try {
            this.builder = this.factory.newDocumentBuilder();
            if (string != null) {
                this.doc = this.builder.parse(new File(string));
            } else {
                StringReader stringReader = new StringReader(string2);
                InputSource inputSource = new InputSource(stringReader);
                this.doc = this.builder.parse(inputSource);
            }
            if (this.edbi.hasDebug()) {
                this.parseStream();
            }
        }
        catch (Exception exception) {
            this.edbi.printErr(2, exception.toString(), 0);
        }
    }

    public void parseStream() throws Exception {
        Element element = this.doc.getDocumentElement();
        this.parseNode(element);
    }

    public void parseNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                System.out.println("Element: " + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap.getLength() > 0) {
                    System.out.println("\tAttributes: ");
                    for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                        Attr attr = (Attr)namedNodeMap.item(i2);
                        System.out.print(attr.getNodeName() + "=" + attr.getNodeValue() + " ");
                    }
                    System.out.println();
                }
                this.parseChilds(node.getChildNodes());
                System.out.println("End element: " + node.getNodeName());
                break;
            }
            case 3: 
            case 4: {
                Text text = (Text)node;
                if (text.getNodeValue().trim().equals("")) break;
                System.out.println("\tText; " + text.getNodeValue());
                break;
            }
            default: {
                System.out.println(" DEFAULT nodeName: " + node.getNodeName());
                System.out.println(" DEFAULT nodeType: " + node.getNodeType());
            }
        }
    }

    public void parseChilds(NodeList nodeList) {
        if (nodeList.getLength() > 0) {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                this.parseNode(nodeList.item(i2));
            }
        }
    }

    public void carTable(Table table) {
        Element element = this.doc.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (!element.getNodeName().equalsIgnoreCase("table")) {
            this.edbi.printErr(23, "Invalid sytntax tag name [" + element.getNodeName() + "] unknown!", 1);
            return;
        }
        if (namedNodeMap.getLength() > 0) {
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                String string = attr.getNodeName();
                if (string.equalsIgnoreCase("name")) {
                    table.tabname = attr.getNodeValue().replace('-', '_');
                    table.cobtabname = attr.getNodeValue().replace('_', '-');
                    continue;
                }
                if (string.equalsIgnoreCase("type")) {
                    if (!(attr.getNodeValue().equalsIgnoreCase("idx") || attr.getNodeValue().equalsIgnoreCase("rel") || attr.getNodeValue().equalsIgnoreCase("seq"))) {
                        this.edbi.printErr(23, "Only IDX REL and SEQ type is required!", 1);
                        return;
                    }
                    if (attr.getNodeValue().equalsIgnoreCase("rel")) {
                        table.setFileOrg(1);
                        continue;
                    }
                    if (!attr.getNodeValue().equalsIgnoreCase("seq")) continue;
                    table.setFileOrg(2);
                    continue;
                }
                if (string.equalsIgnoreCase("maxRecLen")) {
                    table.maxRecLen = Integer.parseInt(attr.getNodeValue());
                    if (table.maxRecLen <= 999999) continue;
                    this.edbi.printErr(23, "Invalid maxRecLen in tag TABLE records longer than 999999 bytes not supported!!", 1);
                    return;
                }
                if (string.equalsIgnoreCase("minRecLen")) {
                    table.minRecLen = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (string.equalsIgnoreCase("temporary")) {
                    table.temporary = attr.getNodeValue();
                    continue;
                }
                if (string.equalsIgnoreCase("keyCount")) {
                    table.keyCount = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                this.edbi.printErr(23, "Invalid sytntax in tag TABLE[" + string + "] unknown attribute!", 1);
                return;
            }
        }
    }

    public void carIndexes(Table table) {
        Element element = this.doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        IndexList indexList = table.indexes;
        Index index = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            Attr attr;
            Node node = nodeList.item(i2);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("key")) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            index = new Index(this.edbi, false);
            indexList.addItem(index);
            if (namedNodeMap.getLength() > 0) {
                for (int i3 = 0; i3 < namedNodeMap.getLength(); ++i3) {
                    attr = (Attr)namedNodeMap.item(i3);
                    string = attr.getNodeName();
                    if (string.equalsIgnoreCase("segCount")) {
                        index.segNum = Integer.parseInt(attr.getNodeValue());
                        if (index.segNum <= 1) continue;
                        index.isSplit = true;
                        continue;
                    }
                    if (string.equalsIgnoreCase("duplicate")) {
                        if (attr.getNodeValue().equalsIgnoreCase("true")) {
                            index.idxdups = true;
                            table.haveDups = true;
                            continue;
                        }
                        index.idxdups = false;
                        continue;
                    }
                    this.edbi.printErr(23, "Invalid sytntax in tag KEY[" + string + "] unknown attribute!", 1);
                    return;
                }
            }
            NodeList nodeList2 = node.getChildNodes();
            for (int i4 = 0; nodeList2 != null && i4 < nodeList2.getLength(); ++i4) {
                int n2;
                node = nodeList2.item(i4);
                if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("segment")) {
                    namedNodeMap = node.getAttributes();
                    Segment segment = new Segment();
                    index.segments.addItem(segment);
                    if (namedNodeMap.getLength() <= 0) continue;
                    for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                        attr = (Attr)namedNodeMap.item(n2);
                        string = attr.getNodeName();
                        if (string.equalsIgnoreCase("offset")) {
                            segment.offset = Integer.parseInt(attr.getNodeValue());
                            continue;
                        }
                        if (string.equalsIgnoreCase("size")) {
                            segment.size = Integer.parseInt(attr.getNodeValue());
                            continue;
                        }
                        this.edbi.printErr(23, "Invalid sytntax in tag SEGMENT[" + string + "] unknown attribute!", 1);
                        return;
                    }
                    continue;
                }
                if (node == null || node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("part") || (namedNodeMap = node.getAttributes()).getLength() <= 0) continue;
                for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                    attr = (Attr)namedNodeMap.item(n2);
                    string = attr.getNodeName();
                    if (!string.equalsIgnoreCase("name")) {
                        this.edbi.printErr(23, "Invalid sytntax in tag PART[" + string + "] unknown attribute!", 1);
                        return;
                    }
                    index.namePart.addItem(new String(attr.getNodeValue()));
                }
            }
        }
    }

    public void carConditions(Table table) {
        Object object;
        Object object2;
        int n2;
        Element element = this.doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        String string = "";
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("conditions")) continue;
            object2 = node.getChildNodes();
            object = "";
            int n3 = -1;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            for (int i2 = 0; i2 < object2.getLength(); ++i2) {
                node = object2.item(i2);
                StringList stringList = new StringList();
                if (node == null || node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("condition")) continue;
                string = "";
                string2 = "";
                string3 = "";
                string4 = "";
                String string5 = "";
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap.getLength() > 0) {
                    for (int i3 = 0; i3 < namedNodeMap.getLength(); ++i3) {
                        Attr attr = (Attr)namedNodeMap.item(i3);
                        String string6 = attr.getNodeName();
                        if (string6.equalsIgnoreCase("number")) {
                            n3 = Integer.parseInt(attr.getNodeValue());
                        } else if (string6.equalsIgnoreCase("table")) {
                            object = attr.getNodeValue().toUpperCase();
                        } else if (string6.equalsIgnoreCase("name")) {
                            string = string + string5 + attr.getNodeValue();
                            stringList.addIfNotExist(attr.getNodeValue());
                            string2 = attr.getNodeValue();
                        } else if (string6.equalsIgnoreCase("op")) {
                            string = string + string5 + this.getOp(attr.getNodeValue());
                            string3 = attr.getNodeValue();
                        } else {
                            this.edbi.printErr(23, "Invalid sytntax in tag CONDITION[" + string6 + "] unknown attribute!", 1);
                            return;
                        }
                        string5 = " ";
                    }
                }
                NodeList nodeList2 = node.getChildNodes();
                SimpleConditionList simpleConditionList = new SimpleConditionList();
                for (int i4 = 0; i4 < nodeList2.getLength(); ++i4) {
                    node = nodeList2.item(i4);
                    if (node == null || node.getNodeType() != 1) continue;
                    string = string + this.carComplexCondition(node, table, stringList, simpleConditionList);
                }
                node = nodeList2.item(0);
                if (node != null && node.getNodeType() == 3) {
                    string = string + " " + node.getNodeValue();
                    string4 = node.getNodeValue();
                }
                Condition condition = new Condition((String)object, n3, string, simpleConditionList);
                condition.fieldCond = stringList;
                if (string2.length() == 0 && simpleConditionList.getItemNum() > 0) {
                    string2 = simpleConditionList.getFirst().field;
                }
                if (string3.length() == 0 && simpleConditionList.getItemNum() > 0) {
                    if (simpleConditionList.getFirst().and) {
                        string3 = "and";
                    } else if (simpleConditionList.getFirst().or) {
                        string3 = "or";
                    }
                }
                condition.field = string2;
                condition.op = string3;
                condition.value = string4.trim();
                if (this.edbi.hasDebug()) {
                    System.err.println("num " + n3 + " name[" + (String)object + "] [" + string + "]" + Macro.eol + "field[" + string2 + "] op[" + string3 + "] value[" + string4 + "]");
                }
                if (((String)object).equalsIgnoreCase(table.getCobName())) {
                    condition.isRedefines = true;
                }
                table.conditions.addItemOrChild(condition);
                table.numConditions = table.numConditions + 1 + simpleConditionList.getItemNum();
                table.numSimplConditions += simpleConditionList.getItemNum();
                if (!condition.condition.equalsIgnoreCase("EDBIDEFAULT")) continue;
                table.setDefaultCond(true);
            }
        }
        n2 = table.numConditions - table.numSimplConditions;
        object2 = null;
        object = null;
        Condition condition = table.getCondition().getFirst();
        while (condition != null) {
            object2 = condition.simpleCond.getFirst();
            if (object2 != null) {
                ((SimpleCondition)object2).number = ++n2;
            }
            while (object2 != null) {
                object2 = condition.simpleCond.getNext();
                if (object2 == null) continue;
                ((SimpleCondition)object2).number = ++n2;
            }
            object = condition.childsCond.getFirst();
            while (object != null) {
                object2 = ((Condition)object).simpleCond.getFirst();
                if (object2 != null) {
                    ((SimpleCondition)object2).number = ++n2;
                }
                while (object2 != null) {
                    object2 = ((Condition)object).simpleCond.getNext();
                    if (object2 == null) continue;
                    ((SimpleCondition)object2).number = ++n2;
                }
                object = condition.childsCond.getNext();
            }
            condition = table.getCondition().getNext();
        }
    }

    String getOp(String string) {
        String string2 = "";
        if (string.equalsIgnoreCase("EQ")) {
            string2 = "=";
        } else if (string.equalsIgnoreCase("GT")) {
            string2 = ">";
        } else if (string.equalsIgnoreCase("LT")) {
            string2 = "<";
        } else if (string.equalsIgnoreCase("GE")) {
            string2 = "not <";
        } else if (string.equalsIgnoreCase("LE")) {
            string2 = "not >";
        } else if (string.equalsIgnoreCase("NE")) {
            string2 = "not =";
        } else if (string.equalsIgnoreCase("DEFAULT")) {
            string2 = "EDBIDEFAULT";
        } else {
            this.edbi.printErr(23, "Invalid value in attribute op [" + string + "]!", 1);
            return "";
        }
        return string2;
    }

    String carComplexCondition(Node node, Table table, StringList stringList, SimpleConditionList simpleConditionList) {
        String string = "";
        String string2 = "";
        if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("paren")) {
            string2 = string2 + " (";
            NodeList nodeList = node.getChildNodes();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                node = nodeList.item(i2);
                string2 = string2 + this.carComplexCondition(node, table, stringList, simpleConditionList);
            }
            string2 = string2 + " )";
        } else if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("and")) {
            string2 = string2 + Macro.eol + "                  and";
            if (simpleConditionList.getLast() != null) {
                simpleConditionList.getLast().and = true;
            }
        } else if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("or")) {
            string2 = string2 + Macro.eol + "                  or";
            if (simpleConditionList.getLast() != null) {
                simpleConditionList.getLast().or = true;
            }
        } else if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("simple_condition")) {
            NodeList nodeList;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap.getLength() > 0) {
                for (int i3 = 0; i3 < namedNodeMap.getLength(); ++i3) {
                    Attr attr = (Attr)namedNodeMap.item(i3);
                    string = attr.getNodeName();
                    if (string.equalsIgnoreCase("name")) {
                        string3 = attr.getNodeValue();
                        string2 = string2 + " " + string3;
                        stringList.addIfNotExist(string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("op")) {
                        string4 = attr.getNodeValue();
                        string2 = string2 + " " + this.getOp(string4);
                        continue;
                    }
                    this.edbi.printErr(23, "Invalid sytntax in tag SIMPLE_CONDITION[" + string + "] unknown attribute!", 1);
                    return "";
                }
            }
            if ((node = (nodeList = node.getChildNodes()).item(0)) != null && node.getNodeType() == 3) {
                string2 = string2 + " " + node.getNodeValue();
            }
            string5 = node.getNodeValue();
            simpleConditionList.addItem(new SimpleCondition(string3, string4, string5));
        }
        return string2;
    }

    public void carFields(Table table) {
        Element element = this.doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("field")) {
                this.carField(table, node, -1, "", "", 0);
                continue;
            }
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("occurs")) continue;
            this.carOccurs(table, node, -1, "", "", 0);
        }
    }

    void carField(Table table, Node node, int n2, String string, String string2, int n3) {
        Object object;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n11 = 0;
        int n12 = -1;
        int n13 = 8;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                String string6 = attr.getNodeName();
                if (string6.equalsIgnoreCase("name")) {
                    string3 = attr.getNodeValue() + string;
                    continue;
                }
                if (string6.equalsIgnoreCase("offset")) {
                    n4 = Integer.parseInt(attr.getNodeValue()) + n3;
                    continue;
                }
                if (string6.equalsIgnoreCase("size")) {
                    n5 = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (string6.equalsIgnoreCase("condition")) {
                    n6 = n2 = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (string6.equalsIgnoreCase("digits")) {
                    n10 = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (string6.equalsIgnoreCase("scale")) {
                    n9 = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (string6.equalsIgnoreCase("hidden")) {
                    if (attr.getNodeValue().equalsIgnoreCase("true")) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (string6.equalsIgnoreCase("format")) {
                    int n14;
                    object = attr.getNodeValue();
                    Integer n15 = hdescfrmt.get(object);
                    if (n15 != null) {
                        n7 = n15;
                        continue;
                    }
                    for (n14 = EdbiIs.timefrmt.length - 1; n14 >= 0 && !((String)object).startsWith(EdbiIs.timefrmt[n14]) && !((String)object).endsWith(EdbiIs.timefrmt[n14]); --n14) {
                    }
                    if (n14 <= 0) {
                        this.edbi.printErr(23, "Invalid sytntax in tag FIELD unknown attribute type value[" + attr.getNodeValue() + "]!", 1);
                        return;
                    }
                    if (((String)object).startsWith(EdbiIs.timefrmt[n14])) {
                        n7 = hdescfrmt.get(((String)object).substring(EdbiIs.timefrmt[n14].length()));
                        bl5 = true;
                    } else {
                        n7 = hdescfrmt.get(((String)object).substring(0, ((String)object).indexOf(EdbiIs.timefrmt[n14])));
                    }
                    n8 = hdescfrmt.get(EdbiIs.timefrmt[n14]);
                    continue;
                }
                if (string6.equalsIgnoreCase("dbtype")) {
                    string5 = attr.getNodeValue();
                    if (string5.equalsIgnoreCase("DATE")) {
                        n13 = 4;
                        continue;
                    }
                    if (string5.equalsIgnoreCase("BINARY")) {
                        n13 = 7;
                        continue;
                    }
                    if (string5.equalsIgnoreCase("LONGCHAR")) {
                        n13 = 1;
                        continue;
                    }
                    if (string5.equalsIgnoreCase("CHAR")) {
                        n13 = 0;
                        continue;
                    }
                    if (string5.equalsIgnoreCase("LONGBINARY") || string5.equalsIgnoreCase("SERIAL")) continue;
                    this.edbi.printErr(23, "Invalid sytntax in tag FIELD unknown attribute dbtype value[" + attr.getNodeValue() + "]!", 1);
                    return;
                }
                if (string6.equalsIgnoreCase("type")) {
                    string4 = attr.getNodeValue();
                    if (string4.equalsIgnoreCase("NUMSIGNED")) {
                        n12 = 3;
                        n11 = 0;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("NUMUNSIGNED")) {
                        n12 = 2;
                        n11 = 0;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("NUMSIGNSEP")) {
                        n12 = 3;
                        n11 = 0;
                        bl2 = true;
                        bl3 = true;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("NUMSEPLEAD")) {
                        n12 = 3;
                        n11 = 0;
                        bl3 = true;
                        bl4 = true;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("NUMLEADING")) {
                        n12 = 3;
                        n11 = 0;
                        bl4 = true;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("COMPSIGNED")) {
                        n11 = 3;
                        n12 = 3;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("COMPUNSIGNED")) {
                        n11 = 3;
                        n12 = 3;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("PACKEDPOSITIVE")) {
                        n11 = 4;
                        n12 = 2;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("PACKEDSIGNED")) {
                        n11 = 4;
                        n12 = 3;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("PACKEDUNSIGNED")) {
                        n11 = 5;
                        n12 = 2;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("BINARYSIGNED")) {
                        n11 = 1;
                        n12 = 3;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("BINARYUNSIGNED")) {
                        n11 = 1;
                        n12 = 2;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("NATIVESIGNED")) {
                        n11 = 2;
                        n12 = 3;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("NATIVEUNSIGNED")) {
                        n11 = 2;
                        n12 = 2;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("FLOAT")) {
                        n11 = 0;
                        n12 = 3;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("ALPHANUM") || string4.equalsIgnoreCase("NATIONAL")) {
                        n11 = 0;
                        n12 = 0;
                        continue;
                    }
                    this.edbi.printErr(23, "Invalid sytntax in tag FIELD unknown attribute type value[" + attr.getNodeValue() + "]!", 1);
                    return;
                }
                this.edbi.printErr(23, "Invalid sytntax in tag FIELD[" + string6 + "] unknown attribute!", 1);
                return;
            }
        }
        NodeList nodeList = node.getChildNodes();
        if (!bl || this.isInCond(table, string3) || this.isEfdParser && bl && nodeList.getLength() == 0 || this.efdParserFlagInclude999) {
            if (string5.equalsIgnoreCase("DATE")) {
                n12 = 4;
            }
            if (string5.equalsIgnoreCase("BINARY") && EdbiIs.dbt == 0) {
                n12 = 0;
                string4 = "ALPHANUM";
            }
            object = new Field(this.edbi, string3, string4, n7, n8, n4, n5, n10, n9, n2, n6, bl, n12, bl4, bl2, bl3, n13, n11, bl5);
            ((Field)object).xmldbtypeS = string5;
            if (bl && this.isInCond(table, string3)) {
                table.fieldsRedefines.addItem((Field)object);
            } else {
                table.fields.addItem((Field)object);
            }
            if (this.isEfdParser && string.length() > 0) {
                ((Field)object).suffix = string.substring(1);
                ((Field)object).efdParseOccs = string2.substring(1);
            }
            if (!((Field)object).getIntType().equalsIgnoreCase(((Field)object).getCobType()) || n12 == 4) {
                table.haveSameBuffs = false;
            }
            if (((Field)object).getTimeType().length() > 0) {
                table.hasTime = true;
            }
            if (!string3.equalsIgnoreCase("FILLER")) {
                table.sqlfields.addItem((Field)object);
            }
            if (this.edbi.hasDebug()) {
                System.out.println("Created field [" + string3 + "," + string4 + "," + n4 + "," + n5 + "," + n10 + "," + n9 + "," + n2 + "," + n6 + "," + bl + "," + n12 + "," + bl4 + "," + bl2 + "," + bl3 + "," + n13 + "," + n11 + "]" + string);
            }
        }
        for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
            node = nodeList.item(i3);
            if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("field")) {
                if (this.edbi.hasDebug()) {
                    System.out.println("   ADD a child at[" + string3 + "]");
                }
                this.carField(table, node, n2, string, string2, n3);
                continue;
            }
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("occurs")) continue;
            if (this.edbi.hasDebug()) {
                System.out.println("   Found OCCURS[" + string3 + "]");
            }
            this.carOccurs(table, node, n2, string, string2, n3);
        }
    }

    void carOccurs(Table table, Node node, int n2, String string, String string2, int n3) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n4 = 1;
        int n5 = 1;
        if (namedNodeMap.getLength() > 0) {
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                String string3 = attr.getNodeName();
                if (string3.equalsIgnoreCase("number")) {
                    n4 = Integer.parseInt(attr.getNodeValue());
                    continue;
                }
                if (!string3.equalsIgnoreCase("size")) continue;
                n5 = Integer.parseInt(attr.getNodeValue());
            }
        }
        String string4 = "" + n4;
        int n6 = string4.length();
        NodeList nodeList = node.getChildNodes();
        boolean bl = false;
        if (this.edbi.getOption("-no") != null) {
            bl = true;
        }
        for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
            node = nodeList.item(i3);
            for (int i4 = 1; i4 <= n4; ++i4) {
                String string5;
                String string6;
                if (bl) {
                    string4 = "00000000000000000" + i4;
                    string6 = string + "_" + string4.substring(string4.length() - n6);
                    string5 = string2 + "_" + n4;
                } else {
                    string6 = string + "_" + i4;
                    string5 = string2 + "_" + n4;
                }
                int n7 = n3 + n5 * (i4 - 1);
                if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("field")) {
                    this.carField(table, node, n2, string6, string5, n7);
                    continue;
                }
                if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("occurs")) continue;
                this.carOccurs(table, node, n2, string6, string5, n7);
            }
        }
    }

    boolean isInCond(Table table, String string) {
        Condition condition = table.conditions.getFirst();
        while (condition != null) {
            if (string.equalsIgnoreCase(condition.field)) {
                return true;
            }
            Condition condition2 = condition.childsCond.getFirst();
            while (condition2 != null) {
                if (string.equalsIgnoreCase(condition2.field)) {
                    return true;
                }
                condition2 = condition.childsCond.getNext();
            }
            condition = table.conditions.getNext();
        }
        return false;
    }

    static {
        hdescfrmt.put("NOFRMT", new Integer(0));
        hdescfrmt.put("BINARYFRMT", new Integer(1));
        hdescfrmt.put("NATIVEFRMT", new Integer(2));
        hdescfrmt.put("COMPFRMT", new Integer(3));
        hdescfrmt.put("PACKEDFRMT", new Integer(4));
        hdescfrmt.put("PACKEDUFRMT", new Integer(5));
        hdescfrmt.put("DDMMYY", new Integer(6));
        hdescfrmt.put("YYMMDD", new Integer(7));
        hdescfrmt.put("DDMMYYYY", new Integer(8));
        hdescfrmt.put("YYYYMMDD", new Integer(9));
        hdescfrmt.put("MMDDYY", new Integer(10));
        hdescfrmt.put("MMDDYYYY", new Integer(11));
        hdescfrmt.put("YY", new Integer(12));
        hdescfrmt.put("YYY", new Integer(13));
        hdescfrmt.put("MMYY", new Integer(14));
        hdescfrmt.put("YYMM", new Integer(15));
        hdescfrmt.put("HH", new Integer(16));
        hdescfrmt.put("HHNN", new Integer(17));
        hdescfrmt.put("HHNNSS", new Integer(18));
        hdescfrmt.put("HHNNSSTT", new Integer(19));
        hdescfrmt.put("JJJ", new Integer(20));
        hdescfrmt.put("JJJJ", new Integer(21));
        hdescfrmt.put("JJJJJ", new Integer(22));
        hdescfrmt.put("JJJJJJ", new Integer(23));
        hdescfrmt.put("JJJJJJJ", new Integer(24));
        hdescfrmt.put("JJJJJJJJ", new Integer(25));
        hdescfrmt.put("YYYYEEE", new Integer(27));
        hdescfrmt.put("EEEYYYY", new Integer(28));
        hdescfrmt.put("YYEEE", new Integer(29));
        hdescfrmt.put("EEEYY", new Integer(30));
    }
}

