/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.extfh;

import com.iscobol.rts.Factory;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.LiteralAll;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;

public abstract class ExtfhBase
implements RuntimeErrorsNumbers,
Cloneable {
    public static final NumericVar ZERO = Factory.getNumLiteral(0L, 1, 0, false);
    public static final LiteralAll LOWVALUE = Factory.getAllLiteral(new byte[]{0});
    public static final NumericVar N128 = Factory.getNumLiteral(128L, 3, 0, false);
    private static final int FCD_VERSION_2 = 0;
    protected int openMode = 0;
    protected int lockType;
    protected int lastKeyNum;
    protected KeyDescription[] keys;
    protected int maxRecordSize;
    protected int minRecordSize;
    protected byte[] wsMem;
    protected PicX XFHFCD;
    protected PicX FCD_FILE_STATUS;
    protected PicX FCD_STATUS_KEY_1;
    protected PicX FCD_STATUS_KEY_2;
    protected NumericVar FCD_VERSION;
    protected NumericVar FCD_BINARY;
    protected NumericVar FCD_ORGANIZATION;
    protected NumericVar FCD_ACCESS_MODE;
    protected NumericVar FCD_OPEN_MODE;
    protected NumericVar FCD_NAME_LENGTH;
    protected NumericVar FCD_TRANS_LOG;
    protected NumericVar FCD_LOCK_MODE;
    protected NumericVar FCD_OTHER_FLAGS;
    protected NumericVar FCD_HANDLE;
    protected NumericVar FCD_STATUS_TYPE;
    protected NumericVar FCD_FILE_FORMAT;
    protected NumericVar FCD_MAX_REC_LENGTH;
    protected NumericVar FCD_RELATIVE_KEY;
    protected NumericVar FCD_RECORDING_MODE;
    protected NumericVar FCD_CURRENT_REC_LEN;
    protected NumericVar FCD_MIN_REC_LENGTH;
    protected NumericVar FCD_KEY_ID;
    protected NumericVar FCD_LINE_COUNT;
    protected NumericVar FCD_KEY_LENGTH;
    protected NumericVar FCD_RECORD_ADDRESS;
    protected NumericVar FCD_FILENAME_ADDRESS;
    protected NumericVar FCD_KEY_DEF_ADDRESS;
    protected NumericVar FCD_RELADDR_OFFSET;
    protected NumericVar FCD_DATA_COMPRESS;
    protected NumericVar FCD_SESSION_ID;
    protected NumericVar FCD_FS_FILE_ID;
    protected NumericVar FCD_MAX_REL_KEY;
    protected NumericVar FCD_FLAGS_1;
    protected NumericVar FCD_BLOCKING;
    protected NumericVar FCD_LOCKTYPES;
    protected NumericVar FCD_FS_FLAGS;
    protected NumericVar FCD_CONFIG_FLAGS;
    protected NumericVar FCD_CONFIG_FLAGS2;
    protected NumericVar FCD_IDXCACHE_SIZE;
    protected NumericVar FCD_IDXCACHE_BUFFS;
    protected PicX GLOBAL_INFORMATION_AREA;
    protected NumericVar KEY_DEFINITION_BLOCK_LENGTH;
    protected NumericVar NUMBER_OF_KEY;
    protected PicX KEY_DEFINITION_BLOCK;
    protected NumericVar COMPONENT_COUNT;
    protected NumericVar FIRST_COMPONENT_OFFSET;
    protected NumericVar KEY_FLAGS;
    protected NumericVar COMPRESSIONS_FLAGS;
    protected NumericVar SPARSE_CHARACTER;
    protected PicX COMPONENTS;
    protected NumericVar COMPONENT_BYTE0;
    protected NumericVar COMPONENT_BYTE1;
    protected NumericVar COMPONENT_OFFSET;
    protected NumericVar COMPONENT_LENGTH;
    protected final byte[] path = new byte[256];
    protected int pathLen;
    protected byte fs1;
    protected byte fs2;
    protected String sysError;
    protected String errMsg;

    protected ExtfhBase(byte[] byArray) {
        this.XFHFCD = Factory.getVarAlphanum(byArray, 0, 100, false, null, null, null, "XFHFCD", false, false);
        this.FCD_FILE_STATUS = Factory.getVarAlphanum(this.XFHFCD, 0, 2, false, null, null, null, "FCD-FILE-STATUS", false, false);
        this.FCD_STATUS_KEY_1 = Factory.getVarAlphanum(this.FCD_FILE_STATUS, 0, 1, false, null, null, null, "FCD-STATUS-KEY-1", false, false);
        this.FCD_STATUS_KEY_2 = Factory.getVarAlphanum(this.FCD_FILE_STATUS, 1, 1, false, null, null, null, "FCD-STATUS-KEY-2", false, false);
        this.FCD_BINARY = Factory.getVarCompX(this.FCD_STATUS_KEY_2, 1, 1, false, null, null, null, "FCD-BINARY", false, 2, 0, false, false, false);
        this.FCD_BINARY.setAsRedefines();
        this.FCD_VERSION = Factory.getVarCompX(this.XFHFCD, 4, 1, false, null, null, null, "FCD-VERSION", false, 2, 0, false, false, false);
        this.FCD_ORGANIZATION = Factory.getVarCompX(this.XFHFCD, 5, 1, false, null, null, null, "FCD-ORGANIZATION", false, 2, 0, false, false, false);
        this.FCD_ACCESS_MODE = Factory.getVarCompX(this.XFHFCD, 6, 1, false, null, null, null, "FCD-ACCESS-MODE", false, 2, 0, false, false, false);
        this.FCD_OPEN_MODE = Factory.getVarCompX(this.XFHFCD, 7, 1, false, null, null, null, "FCD-OPEN-MODE", false, 2, 0, false, false, false);
        this.FCD_NAME_LENGTH = Factory.getVarCompX(this.XFHFCD, 11, 2, false, null, null, null, "FCD-NAME-LENGTH", false, 4, 0, false, false, false);
        this.FCD_TRANS_LOG = Factory.getVarCompX(this.XFHFCD, 22, 1, false, null, null, null, "FCD-TRANS-LOG", false, 2, 0, false, false, false);
        this.FCD_LOCK_MODE = Factory.getVarCompX(this.XFHFCD, 24, 1, false, null, null, null, "FCD-LOCK-MODE", false, 2, 0, false, false, false);
        this.FCD_OTHER_FLAGS = Factory.getVarCompX(this.XFHFCD, 25, 1, false, null, null, null, "FCD-OTHER-FLAGS", false, 2, 0, false, false, false);
        this.FCD_HANDLE = Factory.getVarObject(this.XFHFCD, 28, 4, false, null, null, null, "FCD-HANDLE", false, 0, 0, false, false, false);
        this.FCD_STATUS_TYPE = Factory.getVarCompX(this.XFHFCD, 33, 1, false, N128, null, null, "FCD-STATUS-TYPE", false, 2, 0, false, false, false);
        this.FCD_FILE_FORMAT = Factory.getVarCompX(this.XFHFCD, 34, 1, false, null, null, null, "FCD-FILE-FORMAT", false, 2, 0, false, false, false);
        this.FCD_MAX_REC_LENGTH = Factory.getVarCompX(this.XFHFCD, 38, 2, false, null, null, null, "FCD-MAX-REC-LENGTH", false, 4, 0, false, false, false);
        this.FCD_RELATIVE_KEY = Factory.getVarCompX(this.XFHFCD, 43, 4, false, null, null, null, "FCD-RELATIVE-KEY", false, 9, 0, false, false, false);
        this.FCD_RECORDING_MODE = Factory.getVarCompX(this.XFHFCD, 47, 1, false, null, null, null, "FCD-RECORDING-MODE", false, 2, 0, false, false, false);
        this.FCD_CURRENT_REC_LEN = Factory.getVarCompX(this.XFHFCD, 48, 2, false, null, null, null, "FCD-CURRENT-REC-LEN", false, 4, 0, false, false, false);
        this.FCD_MIN_REC_LENGTH = Factory.getVarCompX(this.XFHFCD, 50, 2, false, null, null, null, "FCD-MIN-REC-LENGTH", false, 4, 0, false, false, false);
        this.FCD_KEY_ID = Factory.getVarCompX(this.XFHFCD, 52, 2, false, null, null, null, "FCD-KEY-ID", false, 4, 0, false, false, false);
        this.FCD_LINE_COUNT = Factory.getVarCompX(this.FCD_KEY_ID, 52, 2, false, null, null, null, "FCD-LINE-COUNT", false, 4, 0, false, false, false);
        this.FCD_LINE_COUNT.setAsRedefines();
        this.FCD_KEY_LENGTH = Factory.getVarCompX(this.XFHFCD, 54, 2, false, null, null, null, "FCD-KEY-LENGTH", false, 4, 0, false, false, false);
        this.FCD_RECORD_ADDRESS = Factory.getVarObject(this.XFHFCD, 56, 4, false, null, null, null, "FCD-RECORD-ADDRESS", false, 0, 0, false, false, false);
        this.FCD_FILENAME_ADDRESS = Factory.getVarObject(this.XFHFCD, 60, 4, false, null, null, null, "FCD-FILENAME-ADDRESS", false, 0, 0, false, false, false);
        this.FCD_KEY_DEF_ADDRESS = Factory.getVarObject(this.XFHFCD, 64, 4, false, null, null, null, "FCD-KEY-DEF-ADDRESS", false, 0, 0, false, false, false);
        this.FCD_RELADDR_OFFSET = Factory.getVarCompX(this.XFHFCD, 72, 4, false, null, null, null, "FCD-RELADDR-OFFSET", false, 9, 0, false, false, false);
        this.FCD_DATA_COMPRESS = Factory.getVarCompX(this.XFHFCD, 78, 1, false, null, null, null, "FCD-DATA-COMPRESS", false, 2, 0, false, false, false);
        this.FCD_SESSION_ID = Factory.getVarCompX(this.XFHFCD, 79, 4, false, null, null, null, "FCD-SESSION-ID", false, 9, 0, false, false, false);
        this.FCD_FS_FILE_ID = Factory.getVarCompX(this.XFHFCD, 83, 2, false, null, null, null, "FCD-FS-FILE-ID", false, 4, 0, false, false, false);
        this.FCD_MAX_REL_KEY = Factory.getVarCompX(this.XFHFCD, 85, 4, false, null, null, null, "FCD-MAX-REL-KEY", false, 9, 0, false, false, false);
        this.FCD_FLAGS_1 = Factory.getVarCompX(this.XFHFCD, 89, 1, false, null, null, null, "FCD-FLAGS-1", false, 2, 0, false, false, false);
        this.FCD_BLOCKING = Factory.getVarCompX(this.XFHFCD, 90, 1, false, null, null, null, "FCD-BLOCKING", false, 2, 0, false, false, false);
        this.FCD_LOCKTYPES = Factory.getVarCompX(this.XFHFCD, 91, 1, false, null, null, null, "FCD-LOCKTYPES", false, 2, 0, false, false, false);
        this.FCD_FS_FLAGS = Factory.getVarCompX(this.XFHFCD, 92, 1, false, null, null, null, "FCD-FS-FLAGS", false, 2, 0, false, false, false);
        this.FCD_CONFIG_FLAGS = Factory.getVarCompX(this.XFHFCD, 93, 1, false, null, null, null, "FCD-CONFIG-FLAGS", false, 2, 0, false, false, false);
        this.FCD_CONFIG_FLAGS2 = Factory.getVarCompX(this.XFHFCD, 95, 1, false, null, null, null, "FCD-CONFIG-FLAGS2", false, 2, 0, false, false, false);
        this.FCD_IDXCACHE_SIZE = Factory.getVarCompX(this.XFHFCD, 96, 1, false, null, null, null, "FCD-IDXCACHE-SIZE", false, 2, 0, false, false, false);
        this.FCD_IDXCACHE_BUFFS = Factory.getVarCompX(this.XFHFCD, 97, 1, false, null, null, null, "FCD-IDXCACHE-BUFFS", false, 2, 0, false, false, false);
        this.FCD_VERSION.set(0);
    }

    public String getSysErrno() {
        return this.sysError;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getCobErrno() {
        switch (this.fs1) {
            case 48: {
                switch (this.fs2) {
                    case 48: {
                        return 0;
                    }
                    case 50: {
                        return 200;
                    }
                    case 52: {
                        return 201;
                    }
                    case 53: {
                        return 203;
                    }
                }
                return this.encodeFs();
            }
            case 49: {
                switch (this.fs2) {
                    case 48: {
                        return 110;
                    }
                }
                return this.encodeFs();
            }
            case 50: {
                switch (this.fs2) {
                    case 50: {
                        return 100;
                    }
                    case 51: {
                        return 111;
                    }
                    case 52: {
                        return 139;
                    }
                }
                return this.encodeFs();
            }
            case 51: {
                switch (this.fs2) {
                    case 48: {
                        return 133;
                    }
                    case 53: {
                        return 130;
                    }
                    case 55: {
                        return 142;
                    }
                    case 56: {
                        return 141;
                    }
                }
                return this.encodeFs();
            }
            case 52: {
                switch (this.fs2) {
                    case 49: {
                        return 135;
                    }
                    case 50: {
                        return 101;
                    }
                    case 51: {
                        return 143;
                    }
                    case 54: {
                        return 112;
                    }
                    case 55: {
                        return 136;
                    }
                    case 56: {
                        return 137;
                    }
                    case 57: {
                        return 138;
                    }
                }
                return this.encodeFs();
            }
            case 57: {
                switch (this.fs2) {
                    case 65: {
                        return 113;
                    }
                    case 68: {
                        return 107;
                    }
                    case 7: {
                        return 127;
                    }
                    case 14: {
                        return 104;
                    }
                    case 31: {
                        return 131;
                    }
                    case -43: {
                        return 129;
                    }
                }
                return this.encodeFs();
            }
        }
        return this.encodeFs();
    }

    private int encodeFs() {
        return 0x7FFF0000 | this.fs1 << 8 | this.fs2;
    }

    protected int mapError() {
        this.fs1 = this.FCD_STATUS_KEY_1.tobyte();
        this.fs2 = this.FCD_STATUS_KEY_2.tobyte();
        this.sysError = "FS=" + (char)this.fs1 + "," + (char)this.fs2 + " (" + (this.fs2 & 0xFF) + ")";
        this.errMsg = "";
        if (this.fs1 == 48 && this.fs2 == 48) {
            return 1;
        }
        return 0;
    }

    protected void setLock(int n2) {
        short s2;
        this.lockType = n2;
        switch (this.lockType & 0xF) {
            default: {
                s2 = 0;
                break;
            }
            case 1: 
            case 6: {
                s2 = 1;
                break;
            }
            case 4: {
                s2 = 4;
                break;
            }
            case 3: 
            case 5: {
                s2 = 4;
            }
        }
        if ((this.lockType & 0x100) != 0) {
            s2 = (short)(s2 | 0x80);
        }
        this.FCD_LOCK_MODE.set(s2);
    }

    protected void setPath(byte[] byArray) {
        this.pathLen = byArray.length;
        System.arraycopy(byArray, 0, this.path, 0, this.pathLen);
        for (int i2 = this.pathLen; i2 < this.path.length; ++i2) {
            this.path[i2] = 0;
        }
    }
}

