/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.extfh;

import com.iscobol.extfh.ExtfhBase;
import com.iscobol.extfh.ExtfhConstants;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.IndexFile;
import com.iscobol.io.LineSeqFile;
import com.iscobol.io.LineSequentialDFile;
import com.iscobol.io.RelativeDFile;
import com.iscobol.io.SequentialDFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.KeyDescription;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicX;

public class InExtfh
extends ExtfhBase
implements ExtfhConstants {
    private static HandlesManager handles = new HandlesManager(100);
    private static Logger log = LoggerFactory.get(8);
    private static byte[] dummyRecord = new byte[0];
    private final String fileName;
    private CobolFile file;
    private byte[] recMem;
    private CobolVar record;
    private int lockType;
    private CobolVar[][] keys;
    private static final byte[] dummyKdb = new byte[40];

    private static int getHandle(byte[] byArray) {
        int n2 = (byArray[28] & 0xFF) << 24;
        n2 |= (byArray[29] & 0xFF) << 16;
        n2 |= (byArray[30] & 0xFF) << 8;
        return n2 |= byArray[31] & 0xFF;
    }

    private static InExtfh newInExtfh(byte[] byArray, String string, byte[] byArray2) {
        InExtfh inExtfh = new InExtfh(byArray, string, byArray2);
        int n2 = handles.newHandle(inExtfh);
        byArray[28] = (byte)(n2 >>> 24 & 0xFF);
        byArray[29] = (byte)(n2 >>> 16 & 0xFF);
        byArray[30] = (byte)(n2 >>> 8 & 0xFF);
        byArray[31] = (byte)(n2 & 0xFF);
        return inExtfh;
    }

    public static void setFileStatus(byte[] byArray, String string) {
        char[] cArray = string.toCharArray();
        byArray[0] = (byte)string.charAt(0);
        byArray[1] = (byte)string.charAt(1);
    }

    public static void setFileStatus(byte[] byArray, int n2) {
        if ((byArray[33] & 0x80) != 0) {
            byArray[0] = ansi85fs[n2][0];
            byArray[1] = ansi85fs[n2][1];
        } else {
            byArray[0] = ansi74fs[n2][0];
            byArray[1] = ansi74fs[n2][1];
        }
    }

    public static void extfh(char c2, byte[] byArray, byte[] byArray2, int n2, int n3, String string, byte[] byArray3) {
        block35: {
            if (log != null) {
                log.info("EXTFH:" + string + ", OP=" + Integer.toHexString(c2) + ", REC-LEN=" + n2 + ", REC-OFFSET=" + n3 + ", BUF-LEN=" + (byArray2 != null ? byArray2.length : -1) + ", OTH-FLG=0x" + Integer.toHexString(byArray[25] & 0xFF));
            }
            if (byArray2 == null) {
                byArray2 = dummyRecord;
            }
            try {
                switch (c2) {
                    case '\ufa00': 
                    case '\ufa01': 
                    case '\ufa02': 
                    case '\ufa03': 
                    case '\ufa04': 
                    case '\ufa05': 
                    case '\ufa08': {
                        InExtfh inExtfh = InExtfh.newInExtfh(byArray, string, byArray3);
                        inExtfh.open(byArray, c2);
                        break;
                    }
                    case '\ufa80': 
                    case '\ufa81': 
                    case '\ufa82': 
                    case '\ufa84': 
                    case '\ufa85': 
                    case '\ufa86': {
                        int n4 = InExtfh.getHandle(byArray);
                        InExtfh inExtfh = (InExtfh)handles.getObject(n4);
                        if (inExtfh != null) {
                            inExtfh.close(byArray, c2);
                            handles.removeHandle(n4);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufa8d': 
                    case '\ufad8': 
                    case '\ufad9': 
                    case '\ufaf5': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.next(byArray, c2, byArray2);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufa8c': 
                    case '\ufade': 
                    case '\ufadf': 
                    case '\ufaf9': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.prev(byArray, c2, byArray2);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufa8e': 
                    case '\ufa8f': 
                    case '\ufac9': 
                    case '\ufad6': 
                    case '\ufad7': 
                    case '\ufada': 
                    case '\ufadb': 
                    case '\ufaf6': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.read(byArray, c2, byArray2);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufaf1': {
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufae3': 
                    case '\ufae4': 
                    case '\ufaec': 
                    case '\ufaed': {
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufae1': 
                    case '\ufae2': 
                    case '\ufae5': 
                    case '\ufae6': 
                    case '\ufaf3': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.write(byArray, c2, byArray2);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufaf4': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.rewrite(byArray, c2, byArray2);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufae8': 
                    case '\ufae9': 
                    case '\ufaea': 
                    case '\ufaeb': 
                    case '\ufafe': 
                    case '\ufaff': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.start(byArray, c2, byArray2);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufa90': 
                    case '\ufa92': 
                    case '\ufaca': 
                    case '\ufacc': 
                    case '\ufad0': 
                    case '\ufad1': 
                    case '\ufad4': 
                    case '\ufad5': {
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufaf7': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.delete(byArray, byArray2);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufaf8': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.deleteFile(byArray, string);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufa0e': {
                        InExtfh inExtfh = (InExtfh)handles.getObject(InExtfh.getHandle(byArray));
                        if (inExtfh != null) {
                            inExtfh.unlock(byArray);
                            break;
                        }
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                    case '\ufadc': {
                        IndexFile.commit(0);
                        InExtfh.setFileStatus(byArray, 0);
                        break;
                    }
                    case '\ufadd': {
                        IndexFile.rollback();
                        InExtfh.setFileStatus(byArray, 0);
                        break;
                    }
                    case '\u0006': {
                        InExtfh inExtfh = InExtfh.newInExtfh(byArray, string, byArray3);
                        inExtfh.info(byArray);
                        int n5 = InExtfh.getHandle(byArray);
                        if (n5 != 0) {
                            handles.removeHandle(n5);
                        }
                        break;
                    }
                    default: {
                        InExtfh.setFileStatus(byArray, 35);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                InExtfh.setFileStatus(byArray, 35);
                if (log == null) break block35;
                log.info("EXTFH Exception caught! " + exception);
            }
        }
        if (log != null) {
            log.info("EXTFH exit FS=[" + (char)byArray[0] + "," + (char)byArray[1] + "]");
        }
    }

    public InExtfh(byte[] byArray, String string, byte[] byArray2) {
        super(byArray);
        this.fileName = string;
        this.recMem = new byte[this.FCD_MAX_REC_LENGTH.toint()];
        this.record = new PicX(this.recMem, 0, this.recMem.length, null, null, "", false, false);
        if (byArray2 != null && byArray2.length >= 40) {
            this.buildKey(byArray2);
        } else {
            this.buildKey(dummyKdb);
        }
    }

    private void buildKey(byte[] byArray) {
        this.GLOBAL_INFORMATION_AREA = Factory.getVarAlphanum(byArray, 0, byArray.length, false, null, null, null, "GLOBAL-INFORMATION-AREA", false, false);
        this.KEY_DEFINITION_BLOCK_LENGTH = Factory.getVarCompX(this.GLOBAL_INFORMATION_AREA, 0, 2, false, null, null, null, "KEY-DEFINITION-BLOCK-LENGTH", false, 2, 0, false, false, false);
        this.NUMBER_OF_KEY = Factory.getVarCompX(this.GLOBAL_INFORMATION_AREA, 6, 2, false, null, null, null, "NUMBER-OF-KEY", false, 2, 0, false, false, false);
        int n2 = this.NUMBER_OF_KEY.toint();
        this.KEY_DEFINITION_BLOCK = Factory.getVarAlphanum(this.GLOBAL_INFORMATION_AREA, 14, 16, false, null, new int[]{16}, new int[]{n2}, "KEY-DEFINITION-BLOCK", false, false);
        this.COMPONENT_COUNT = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 14, 2, false, null, new int[]{16}, new int[]{n2}, "COMPONENT-COUNT", false, 2, 0, false, false, false);
        this.FIRST_COMPONENT_OFFSET = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 16, 2, false, null, new int[]{16}, new int[]{n2}, "FIRST-COMPONENT-OFFSET", false, 2, 0, false, false, false);
        this.KEY_FLAGS = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 18, 1, false, null, new int[]{16}, new int[]{n2}, "KEY-FLAGS", false, 1, 0, false, false, false);
        this.COMPRESSIONS_FLAGS = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 19, 1, false, null, new int[]{16}, new int[]{n2}, "COMPRESSIONS-FLAGS", false, 1, 0, false, false, false);
        this.SPARSE_CHARACTER = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 20, 1, false, null, new int[]{16}, new int[]{n2}, "SPARSE-CHARACTER", false, 1, 0, false, false, false);
        int n3 = 14 + 16 * n2;
        int n4 = (byArray.length - n3) / 10;
        this.COMPONENTS = Factory.getVarAlphanum(this.GLOBAL_INFORMATION_AREA, n3, 10, false, null, new int[]{10}, new int[]{n4}, "COMPONENTS", false, false);
        this.COMPONENT_OFFSET = Factory.getVarCompX(this.COMPONENTS, n3 + 2, 4, false, null, new int[]{10}, new int[]{n4}, "COMPONENT-OFFSET", false, 4, 0, false, false, false);
        this.COMPONENT_LENGTH = Factory.getVarCompX(this.COMPONENTS, n3 + 6, 4, false, null, new int[]{10}, new int[]{n4}, "COMPONENT-LENGTH", false, 4, 0, false, false, false);
    }

    private void open(byte[] byArray, char c2) {
        int n2;
        boolean bl = c2 == '\ufa00' || c2 == '\ufa04' || c2 == '\ufa08' ? (this.FCD_OTHER_FLAGS.toint() & 0x80) != 0 : (this.FCD_OTHER_FLAGS.toint() & 0x20) == 0;
        switch (this.FCD_ACCESS_MODE.toint() & 0xFFFFFF) {
            default: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
            }
        }
        this.lockType = 0;
        if ((this.FCD_LOCK_MODE.toint() & 1) != 0) {
            this.lockType = 1;
        }
        if ((this.FCD_LOCK_MODE.toint() & 2) != 0) {
            this.lockType |= 0x80;
        }
        if ((this.FCD_LOCK_MODE.toint() & 0x80) != 0) {
            this.lockType |= 0x100;
        }
        boolean bl2 = Config.b(".extfh.intrinsic_file_manager", true);
        int n3 = this.FCD_MIN_REC_LENGTH.toint();
        int n4 = this.FCD_MAX_REC_LENGTH.toint();
        switch (this.FCD_ORGANIZATION.toint()) {
            case 0: {
                Class clazz;
                if (!bl2 && (clazz = FileTypeManager.getLineSequentialIn()) != FileTypeManager.DEF_LineSequential) {
                    this.file = new LineSequentialDFile(this.fileName, n4, (ICobolVar)this.record, n3, bl, 1, clazz);
                    break;
                }
                if (c2 == '\ufa00') {
                    clazz = bl2 ? FileTypeManager.DEF_Input : FileTypeManager.getInputIn();
                    this.file = new LineSeqFile(this.fileName, n4, (ICobolVar)this.record, n3, bl, clazz);
                    break;
                }
                if (c2 == '\ufa01' || c2 == '\ufa03') {
                    clazz = bl2 ? FileTypeManager.DEF_Output : FileTypeManager.getOutputIn();
                    this.file = new LineSeqFile(this.fileName, n4, (ICobolVar)this.record, n3, bl, clazz);
                    break;
                }
                if (c2 == '\ufa02') {
                    clazz = bl2 ? FileTypeManager.DEF_LineSequential : FileTypeManager.getLineSequentialIn();
                    this.file = new LineSequentialDFile(this.fileName, n4, (ICobolVar)this.record, n3, bl, 1, clazz);
                    break;
                }
                InExtfh.setFileStatus(byArray, 35);
                return;
            }
            case 1: {
                Class clazz = n3 != 0 && n3 != n4 ? (bl2 ? FileTypeManager.DEF_VarSeq : FileTypeManager.getSequentialIn(true)) : (bl2 ? FileTypeManager.DEF_Sequential : FileTypeManager.getSequentialIn(false));
                this.file = new SequentialDFile(this.fileName, n4, (ICobolVar)this.record, n3, bl, 1, clazz);
                break;
            }
            case 2: {
                Class clazz = bl2 ? FileTypeManager.DEF_Index : FileTypeManager.getIndexIn();
                this.file = new IndexFile(this.fileName, n4, (ICobolVar)this.record, n3, bl, n2, clazz);
                int n5 = this.NUMBER_OF_KEY.toint();
                this.keys = new CobolVar[n5][];
                int n6 = 1;
                for (int i2 = 1; i2 <= n5; ++i2) {
                    int n7 = this.COMPONENT_COUNT.at(i2).toint();
                    CobolVar[] cobolVarArray = new CobolVar[n7];
                    int n8 = 0;
                    while (n8 < n7) {
                        cobolVarArray[n8] = new PicX(this.record, this.COMPONENT_OFFSET.at(n6).toint(), this.COMPONENT_LENGTH.at(n6).toint(), null, null, "", false, false);
                        ++n8;
                        ++n6;
                    }
                    this.keys[i2 - 1] = cobolVarArray;
                    this.file.key(cobolVarArray, (this.KEY_FLAGS.at(i2).toint() & 0x40) != 0);
                }
                break;
            }
            case 3: {
                Class clazz = bl2 ? FileTypeManager.DEF_Relative : FileTypeManager.getRelativeIn();
                this.file = new RelativeDFile(this.fileName, n4, (ICobolVar)this.record, n3, bl, n2, clazz);
                break;
            }
            default: {
                InExtfh.setFileStatus(byArray, 35);
                return;
            }
        }
        this.file.setAssignExt((this.FCD_OTHER_FLAGS.toint() & 0x10) != 0);
        try {
            switch (c2) {
                case '\ufa00': {
                    this.file.open(new PicX(this.fileName), 1, this.lockType);
                    this.FCD_OPEN_MODE.set(0);
                    break;
                }
                case '\ufa01': {
                    this.file.open(new PicX(this.fileName), 2, this.lockType);
                    this.FCD_OPEN_MODE.set(1);
                    break;
                }
                case '\ufa02': {
                    this.file.open(new PicX(this.fileName), 3, this.lockType);
                    this.FCD_OPEN_MODE.set(2);
                    break;
                }
                case '\ufa03': {
                    this.file.open(new PicX(this.fileName), 6, this.lockType);
                    this.FCD_OPEN_MODE.set(3);
                    break;
                }
                case '\ufa04': 
                case '\ufa05': 
                case '\ufa08': {
                    InExtfh.setFileStatus(byArray, 35);
                    return;
                }
            }
            this.FCD_OPEN_MODE.getMemory();
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void close(byte[] byArray, char c2) {
        try {
            this.file.close();
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void write(byte[] byArray, char c2, byte[] byArray2) {
        this.record.set(byArray2);
        this.XFHFCD.set(byArray);
        try {
            int n2 = 0;
            switch (this.FCD_ORGANIZATION.toint()) {
                case 0: 
                case 1: {
                    int n3;
                    switch (c2) {
                        case '\ufae1': {
                            n3 = 2;
                            break;
                        }
                        case '\ufae2': {
                            n3 = 1;
                            break;
                        }
                        case '\ufae5': {
                            n3 = 4;
                            break;
                        }
                        case '\ufae6': {
                            n3 = 3;
                            break;
                        }
                        default: {
                            n3 = 0;
                            n2 = 3;
                        }
                    }
                    this.file.writeAdvancing(n3, this.FCD_LINE_COUNT.toint(), false, this.FCD_CURRENT_REC_LEN.toint(), n2);
                    InExtfh.setFileStatus(byArray, 0);
                    break;
                }
                case 2: {
                    this.file.write(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(byArray, 0);
                    break;
                }
                case 3: {
                    this.file.relativeKey(this.FCD_RELATIVE_KEY);
                    this.file.write(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(byArray, 0);
                    break;
                }
                default: {
                    InExtfh.setFileStatus(byArray, 35);
                    return;
                }
            }
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void rewrite(byte[] byArray, char c2, byte[] byArray2) {
        this.record.set(byArray2);
        this.XFHFCD.set(byArray);
        try {
            switch (this.FCD_ORGANIZATION.toint()) {
                case 0: 
                case 1: 
                case 2: {
                    this.file.rewrite(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(byArray, 0);
                    break;
                }
                case 3: {
                    this.file.relativeKey(this.FCD_RELATIVE_KEY);
                    this.file.rewrite(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(byArray, 0);
                    break;
                }
                default: {
                    InExtfh.setFileStatus(byArray, 35);
                    return;
                }
            }
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void next(byte[] byArray, char c2, byte[] byArray2) {
        int n2 = byArray2.length < this.recMem.length ? byArray2.length : this.recMem.length;
        this.record.set(byArray2);
        this.XFHFCD.set(byArray);
        boolean bl = c2 == '\ufaf5' ? (this.lockType & 0x80) != 0 : c2 != '\ufa8d';
        try {
            int n3 = this.file.readNext(bl, null);
            this.FCD_CURRENT_REC_LEN.link(byArray);
            this.FCD_CURRENT_REC_LEN.set(n3);
            this.FCD_CURRENT_REC_LEN.getMemory();
            System.arraycopy(this.recMem, 0, byArray2, 0, n2);
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void prev(byte[] byArray, char c2, byte[] byArray2) {
        int n2 = byArray2.length < this.recMem.length ? byArray2.length : this.recMem.length;
        this.record.set(byArray2);
        this.XFHFCD.set(byArray);
        boolean bl = c2 == '\ufaf9' ? (this.lockType & 0x80) != 0 : c2 != '\ufa8c';
        try {
            int n3 = this.file.readPrev(bl, null);
            this.FCD_CURRENT_REC_LEN.link(byArray);
            this.FCD_CURRENT_REC_LEN.set(n3);
            this.FCD_CURRENT_REC_LEN.getMemory();
            System.arraycopy(this.recMem, 0, byArray2, 0, n2);
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void read(byte[] byArray, char c2, byte[] byArray2) {
        int n2 = byArray2.length < this.recMem.length ? byArray2.length : this.recMem.length;
        this.record.set(byArray2);
        this.XFHFCD.set(byArray);
        boolean bl = c2 == '\ufaf6' || c2 == '\ufac9' ? (this.lockType & 0x80) != 0 : c2 != '\ufa8e' && c2 != '\ufa8f';
        try {
            int n3;
            int n4 = 0;
            if (this.FCD_ORGANIZATION.toint() == 3) {
                this.file.relativeKey(this.FCD_RELATIVE_KEY);
                n3 = this.file.readKey(null, bl, null);
                System.arraycopy(this.recMem, 0, byArray2, 0, n2);
                InExtfh.setFileStatus(byArray, 0);
            } else {
                n4 = this.FCD_KEY_ID.toint();
                if (n4 >= 0 && n4 < this.keys.length) {
                    n3 = this.file.readKey(this.keys[n4], bl, null);
                    System.arraycopy(this.recMem, 0, byArray2, 0, n2);
                    InExtfh.setFileStatus(byArray, 0);
                } else {
                    n3 = 0;
                    InExtfh.setFileStatus(byArray, 35);
                }
            }
            this.FCD_CURRENT_REC_LEN.link(byArray);
            this.FCD_CURRENT_REC_LEN.set(n3);
            this.FCD_CURRENT_REC_LEN.getMemory();
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void start(byte[] byArray, char c2, byte[] byArray2) {
        int n2;
        int n3 = this.FCD_KEY_ID.toint();
        int n4 = this.FCD_KEY_LENGTH.toint();
        this.record.set(byArray2);
        this.XFHFCD.set(byArray);
        switch (c2) {
            default: {
                n3 = 0;
                n4 = this.recMem.length;
            }
            case '\ufae9': {
                n2 = 5;
                break;
            }
            case '\ufaea': {
                n2 = 6;
                break;
            }
            case '\ufaeb': {
                n2 = 7;
                break;
            }
            case '\ufafe': {
                n2 = 8;
                break;
            }
            case '\ufaff': {
                n2 = 9;
            }
        }
        try {
            if (this.FCD_ORGANIZATION.toint() == 3) {
                this.file.relativeKey(this.FCD_RELATIVE_KEY);
                this.file.start((CobolVar[])null, n2, n4);
                InExtfh.setFileStatus(byArray, 0);
            } else {
                n3 = this.FCD_KEY_ID.toint();
                if (n3 >= 0 && n3 < this.keys.length) {
                    this.file.start(this.keys[n3], n2, n4);
                    InExtfh.setFileStatus(byArray, 0);
                } else {
                    InExtfh.setFileStatus(byArray, 35);
                }
            }
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void delete(byte[] byArray, byte[] byArray2) {
        this.record.set(byArray2);
        this.XFHFCD.set(byArray);
        try {
            if (this.FCD_ORGANIZATION.toint() == 3) {
                this.file.relativeKey(this.FCD_RELATIVE_KEY);
            }
            this.file.delete();
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void deleteFile(byte[] byArray, String string) {
        this.XFHFCD.set(byArray);
        try {
            this.file.deleteFile(new PicX(string));
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void unlock(byte[] byArray) {
        this.XFHFCD.set(byArray);
        try {
            this.file.unlock();
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, this.file.getFileStatus());
        }
    }

    private void info(byte[] byArray) {
        this.XFHFCD.set(byArray);
        DummyDataStream dummyDataStream = new DummyDataStream();
        try {
            DynamicFile dynamicFile = IndexFile.isIdxInConfig(this.fileName);
            if (dynamicFile == null) {
                dynamicFile = IndexFile.getDefaultDynamicFile(this.fileName);
            }
            if (dynamicFile.open(this.fileName, 1, 0, null, 0, 0, 0, 3, false, false) != 0) {
                int n2 = dynamicFile.getMaxRecordSize();
                int n3 = dynamicFile.getMinRecordSize();
                this.FCD_ORGANIZATION.set(2);
                this.FCD_FILE_FORMAT.set(0);
                this.FCD_MAX_REC_LENGTH.set(n2);
                this.FCD_MIN_REC_LENGTH.set(n3);
                if (n2 == n3) {
                    this.FCD_RECORDING_MODE.set(0);
                } else {
                    this.FCD_RECORDING_MODE.set(1);
                }
                this.FCD_RELADDR_OFFSET.set((long)n2 * dynamicFile.getNumRecords());
                this.FCD_DATA_COMPRESS.set(0);
                int n4 = dynamicFile.getNumKeys();
                this.NUMBER_OF_KEY.set(n4);
                this.buildKey(this.GLOBAL_INFORMATION_AREA.getMemory());
                int n5 = 1;
                for (int i2 = 1; i2 <= n4; ++i2) {
                    KeyDescription keyDescription = dynamicFile.getKey(i2 - 1);
                    int n6 = keyDescription.getNumSegments();
                    this.COMPONENT_COUNT.at(i2).set(n6);
                    if (i2 == 1) {
                        this.KEY_FLAGS.at(i2).set(16);
                    } else {
                        this.KEY_FLAGS.at(i2).set(keyDescription.isDup() ? 64 : 0);
                    }
                    this.FIRST_COMPONENT_OFFSET.at(i2).set(this.COMPONENTS.at(n5).getOffset());
                    int n7 = 0;
                    while (n7 < n6) {
                        KeyDescription.Segs segs = keyDescription.getSegment(n7);
                        this.COMPONENT_OFFSET.at(n5).set(segs.offset);
                        this.COMPONENT_LENGTH.at(n5).set(segs.size);
                        ++n7;
                        ++n5;
                    }
                }
                if (dynamicFile.close() == 0) {
                    CobolIOException.get(dynamicFile.getCobErrno(), "", dummyDataStream, 2);
                }
            } else {
                CobolIOException.get(dynamicFile.getCobErrno(), "", dummyDataStream, 1);
            }
            this.GLOBAL_INFORMATION_AREA.getMemory();
            InExtfh.setFileStatus(byArray, 0);
        }
        catch (CobolIOException cobolIOException) {
            InExtfh.setFileStatus(byArray, dummyDataStream.getFileStatus());
        }
    }

    private static class DummyDataStream
    implements DataStream {
        private String fs = "00";
        private String extFs = "00";
        private String statusMsg = "";

        private DummyDataStream() {
        }

        @Override
        public void setFileStatus(String string) {
            this.fs = string;
        }

        @Override
        public String getFileStatus() {
            return this.fs;
        }

        @Override
        public void setExtendedStatus(String string) {
            this.extFs = string;
        }

        @Override
        public String getExtendedStatus() {
            return this.extFs;
        }

        @Override
        public void setStatusMessage(String string) {
            this.statusMsg = string;
        }

        @Override
        public String getStatusMessage() {
            return this.statusMsg;
        }

        @Override
        public void setLastException(CobolIOException cobolIOException) {
        }

        @Override
        public CobolIOException getLastException() {
            return null;
        }

        @Override
        public String getLogicName() {
            return "";
        }

        @Override
        public String getOsPath() {
            return "";
        }

        @Override
        public Logger getLogger() {
            return null;
        }

        @Override
        public void finalize() {
        }
    }
}

