/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.rts.Config;
import java.awt.Color;

public class ColorCmp
implements Cloneable {
    public static final int BLACK = 0;
    public static final int BLUE = 1;
    public static final int GREEN = 2;
    public static final int CYAN = 3;
    public static final int RED = 4;
    public static final int MAGENTA = 5;
    public static final int BROWN = 6;
    public static final int WHITE = 7;
    private int foreground = -1;
    private int background = -1;
    private boolean reverse;
    private boolean underline;
    private boolean backHighIntensity;
    private boolean foreHighIntensity;
    private boolean protectedAttribute;
    private boolean blink;
    private boolean foregroundSet;
    private boolean backgroundSet;
    private boolean foreIntensitySet;
    private boolean backIntensitySet;

    public ColorCmp() {
        this(true);
    }

    public ColorCmp(boolean bl) {
        this.setStandard(bl);
    }

    public ColorCmp(ColorCmp colorCmp) {
        this.copyColor(colorCmp);
    }

    public ColorCmp(int n2) {
        if (n2 == 0) {
            n2 = 1;
        }
        this.setColor(n2, (n2 & 0x3E0) > 0);
    }

    public void setStandard(boolean bl) {
        if (bl) {
            this.foreground = 0;
            this.background = 7;
        } else {
            this.foreground = 7;
            this.background = 0;
            this.backHighIntensity = false;
        }
    }

    public void setColor(int n2) {
        this.setColor(n2, (n2 & 0x3E0) > 0);
    }

    public void setColor(int n2, boolean bl) {
        if (n2 >= 131072) {
            n2 %= 131072;
            this.backHighIntensity = true;
            this.backIntensitySet = true;
        }
        if (n2 >= 65536 && n2 < 131072) {
            n2 -= 65536;
            this.backHighIntensity = false;
            this.backIntensitySet = true;
        }
        if (n2 >= 32768 && n2 < 65536) {
            n2 -= 32768;
            this.protectedAttribute = true;
        }
        if (n2 >= 16384 && n2 < 32768) {
            this.blink = true;
            n2 -= 16384;
        }
        if (n2 >= 8192 && n2 < 16384) {
            this.underline = true;
            n2 -= 8192;
        }
        if (n2 >= 4096 && n2 < 8192) {
            n2 -= 4096;
            this.foreHighIntensity = true;
            this.foreIntensitySet = true;
        }
        if (n2 >= 2048 && n2 < 4096) {
            this.foreHighIntensity = false;
            this.foreIntensitySet = true;
            n2 -= 2048;
        }
        if (n2 >= 1024 && n2 < 2048) {
            this.reverse = true;
            n2 -= 1024;
        }
        if (n2 >= 544 && n2 < 1024) {
            n2 -= 512;
        }
        if (bl) {
            if (n2 <= 543) {
                if (n2 < 32) {
                    this.setForeNoRGB(n2 - 1);
                } else if (n2 < 64) {
                    this.setBackground(0);
                    this.setForeNoRGB(n2 - 32 - 1);
                } else if (n2 < 96) {
                    this.setBackground(1);
                    this.setForeNoRGB(n2 - 64 - 1);
                } else if (n2 < 128) {
                    this.setBackground(2);
                    this.setForeNoRGB(n2 - 96 - 1);
                } else if (n2 < 160) {
                    this.setBackground(3);
                    this.setForeNoRGB(n2 - 128 - 1);
                } else if (n2 < 192) {
                    this.setBackground(4);
                    this.setForeNoRGB(n2 - 160 - 1);
                } else if (n2 < 224) {
                    this.setBackground(5);
                    this.setForeNoRGB(n2 - 192 - 1);
                } else if (n2 < 256) {
                    this.setBackground(6);
                    this.setForeNoRGB(n2 - 224 - 1);
                } else if (n2 <= 287) {
                    this.setBackground(7);
                    if (n2 > 256) {
                        if (n2 <= 272) {
                            this.setForeNoRGB(n2 - 256 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 319) {
                    this.setBackground(8);
                    if (n2 > 288) {
                        if (n2 <= 304) {
                            this.setForeNoRGB(n2 - 288 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 351) {
                    this.setBackground(9);
                    if (n2 > 320) {
                        if (n2 <= 336) {
                            this.setForeNoRGB(n2 - 320 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 383) {
                    this.setBackground(10);
                    if (n2 > 352) {
                        if (n2 <= 368) {
                            this.setForeNoRGB(n2 - 352 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 415) {
                    this.setBackground(11);
                    if (n2 > 384) {
                        if (n2 <= 400) {
                            this.setForeNoRGB(n2 - 384 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 447) {
                    this.setBackground(12);
                    if (n2 > 416) {
                        if (n2 <= 432) {
                            this.setForeNoRGB(n2 - 416 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 479) {
                    this.setBackground(13);
                    if (n2 > 448) {
                        if (n2 <= 464) {
                            this.setForeNoRGB(n2 - 448 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 511) {
                    this.setBackground(14);
                    if (n2 > 480) {
                        if (n2 <= 496) {
                            this.setForeNoRGB(n2 - 480 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (n2 <= 543) {
                    this.setBackground(15);
                    if (n2 > 512) {
                        if (n2 <= 528) {
                            this.setForeNoRGB(n2 - 512 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                }
            }
        } else if (n2 != 0) {
            this.setForeground(n2 - 1);
        }
    }

    private static int encodeAlpha(int n2) {
        int n3 = n2 & 0x7F000000;
        return n3;
    }

    private static int decodeAlpha(int n2) {
        int n3 = n2 & 0x7F000000;
        if ((n3 <<= 1) == 0 || n3 == -33554432) {
            n3 = -16777216;
        } else if (n3 == 0x2000000) {
            n3 = 0;
        }
        return n3;
    }

    public static int encodeRGBColor(int n2) {
        return -(n2 & 0xFFFFFF | ColorCmp.encodeAlpha(n2));
    }

    public static int decodeRGBColor(int n2) {
        n2 = -n2;
        return n2 & 0xFFFFFF | ColorCmp.decodeAlpha(n2);
    }

    public int getForeground() {
        return this.foreground;
    }

    public int getBackground() {
        return this.background;
    }

    public static boolean isRGB(int n2) {
        return n2 < 0;
    }

    public static int getRealColor(int n2, boolean bl) {
        if (ColorCmp.isRGB(n2)) {
            return n2;
        }
        if (n2 > 15) {
            n2 %= 16;
        }
        if (bl && n2 < 8) {
            n2 += 8;
        }
        return n2;
    }

    public static int getRealColorBack(int n2, boolean bl) {
        if (n2 == 0 && bl) {
            return n2;
        }
        return ColorCmp.getRealColor(n2, bl);
    }

    public static Color getRGBColor(int n2) {
        Color color = new Color(ColorCmp.decodeRGBColor(n2), true);
        return color;
    }

    private void setForeNoRGB(int n2) {
        if (n2 >= 0) {
            this.setForeground(n2);
        }
    }

    public void setForeground(int n2) {
        if (ColorCmp.isRGB(n2)) {
            this.foreground = n2;
            this.foregroundSet = true;
        } else if (n2 >= 0) {
            this.foreground = n2 % 16;
            this.foregroundSet = true;
        }
    }

    public void setForeRGB(int n2) {
        this.foreground = ColorCmp.isRGB(n2) ? n2 : ColorCmp.encodeRGBColor(n2);
        this.foregroundSet = true;
    }

    public void setBackground(int n2) {
        if (ColorCmp.isRGB(n2)) {
            this.background = n2;
            this.backgroundSet = true;
        } else if (n2 >= 0) {
            this.background = n2 % 16;
            this.backgroundSet = true;
        }
    }

    public void setBackRGB(int n2) {
        this.background = ColorCmp.isRGB(n2) ? n2 : ColorCmp.encodeRGBColor(n2);
        this.backgroundSet = true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public void copyColor(ColorCmp colorCmp) {
        this.foreground = colorCmp.foreground;
        this.background = colorCmp.background;
        this.foreHighIntensity = colorCmp.foreHighIntensity;
        this.foreIntensitySet = colorCmp.foreIntensitySet;
        this.backHighIntensity = colorCmp.backHighIntensity;
        this.backIntensitySet = colorCmp.backIntensitySet;
        this.reverse = false;
        this.underline = false;
        this.blink = false;
        this.protectedAttribute = colorCmp.protectedAttribute;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public void setUnderline(boolean bl) {
        this.underline = bl;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public void setBackHighIntensity(boolean bl) {
        this.backHighIntensity = bl;
        this.backIntensitySet = true;
    }

    public void setForeHighIntensity(boolean bl) {
        this.foreHighIntensity = bl;
        this.foreIntensitySet = true;
    }

    private void colormapSet(int n2, ColorCmp colorCmp, boolean bl) {
        int n3 = -1;
        if (bl && colorCmp != null) {
            n3 = n2 & 0xF;
            if (n3 != 0) {
                this.setForeground(n3 - 1);
            } else if (n3 == 0) {
                this.setForeground(15);
            }
            n3 = (n2 & 0x1E0) >>> 5;
            if (n3 != 0) {
                this.setBackground(n3 - 1);
            }
        } else if (colorCmp == null) {
            if (!this.isForegroundSet() && (n3 = n2 & 0xF) != 0) {
                this.setForeground(n3 - 1);
            } else if (n3 == 0) {
                this.setForeground(15);
            }
            if (!this.isBackgroundSet() && (n3 = (n2 & 0x1E0) >>> 5) != 0) {
                this.setBackground(n3 - 1);
            }
        } else {
            if (!this.isForegroundSet() && !colorCmp.isForegroundSet() && (n3 = n2 & 0xF) != 0) {
                this.setForeground(n3 - 1);
            } else if (n3 == 0) {
                this.setForeground(15);
            }
            if (!this.isBackgroundSet() && !colorCmp.isBackgroundSet() && (n3 = (n2 & 0x1E0) >>> 5) != 0) {
                this.setBackground(n3 - 1);
            }
        }
    }

    public void evalColorMap(ColorCmp colorCmp) {
        if (this.foreIntensitySet) {
            if (this.foreHighIntensity) {
                int n2 = Config.a("iscobol.colormap.high", 0);
                if (n2 != 0) {
                    this.colormapSet(n2, colorCmp, true);
                    this.foreIntensitySet = false;
                }
            } else {
                int n3 = Config.a("iscobol.colormap.low", 0);
                if (n3 != 0) {
                    this.colormapSet(n3, colorCmp, true);
                    this.foreIntensitySet = false;
                }
            }
        } else {
            int n4 = Config.a("iscobol.colormap.default", 0);
            if (n4 != 0) {
                this.colormapSet(n4, colorCmp, false);
            }
        }
    }

    public boolean getProtectedAttribute() {
        return this.protectedAttribute;
    }

    public void setProtectedAttribute(boolean bl) {
        this.protectedAttribute = bl;
    }

    public boolean getForeHighIntensity() {
        return this.foreHighIntensity;
    }

    public boolean getBackHighIntensity() {
        return this.backHighIntensity;
    }

    public void setBlink(boolean bl) {
        this.blink = bl;
    }

    public boolean getBlink() {
        return this.blink;
    }

    public boolean isForegroundSet() {
        return this.foregroundSet;
    }

    public boolean isBackgroundSet() {
        return this.backgroundSet;
    }

    public boolean isForeIntensitySet() {
        return this.foreIntensitySet;
    }

    public boolean isBackIntensitySet() {
        return this.backIntensitySet;
    }

    public String toString() {
        String string = ColorCmp.isRGB(this.foreground) ? "[fg=" + Integer.toHexString(ColorCmp.decodeRGBColor(this.foreground)) + "]" : "fg=" + this.foreground + ",fs=" + this.foregroundSet + ",fh=" + this.foreHighIntensity + ",fi=" + this.foreIntensitySet + "]";
        string = ColorCmp.isRGB(this.background) ? string + " [bg=" + Integer.toHexString(ColorCmp.decodeRGBColor(this.background)) + "]" : string + " [bg=" + this.background + ",bs=" + this.backgroundSet + ",bh=" + this.backHighIntensity + ",bi=" + this.backIntensitySet + "]";
        string = string + ",pr=" + this.protectedAttribute + ",ul=" + this.underline + ",rv=" + this.reverse + ",bl=" + this.blink;
        return string;
    }
}

