/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class FontAttribute
implements Serializable {
    public static final int FAMILY_N = 1;
    public static final int SIZE_N = 2;
    public static final int WEIGHT_N = 3;
    public static final int POSTURE_N = 4;
    public static final int UNDERLINE_N = 5;
    public static final int STRIKETHROUGH_N = 6;
    public static final int TRANSFORM_N = 7;
    public static final int PITCHFIXED_N = 8;
    public static final int ASCENT_N = 9;
    public static final int DESCENT_N = 10;
    public static final int LEADING_N = 11;
    public static final int AVEWIDTH_N = 12;
    public static final int MAXWIDTH_N = 13;
    public static final int FIRST_N = 1;
    public static final int LAST_N = 13;
    public static final Float WEIGHT_EXTRA_LIGHT = new Float(0.5);
    public static final Float WEIGHT_LIGHT = new Float(0.75);
    public static final Float WEIGHT_DEMILIGHT = new Float(0.875);
    public static final Float WEIGHT_REGULAR = new Float(1.0);
    public static final Float WEIGHT_SEMIBOLD = new Float(1.25);
    public static final Float WEIGHT_MEDIUM = new Float(1.5);
    public static final Float WEIGHT_DEMIBOLD = new Float(1.75);
    public static final Float WEIGHT_BOLD = new Float(2.0);
    public static final Float WEIGHT_HEAVY = new Float(2.25);
    public static final Float WEIGHT_EXTRABOLD = new Float(2.5);
    public static final Float WEIGHT_ULTRABOLD = new Float(2.75);
    public static final Float POSTURE_REGULAR = new Float(0.0f);
    public static final Float POSTURE_OBLIQUE = new Float(0.2f);
    public static final Integer UNDERLINE_ON = new Integer(0);
    public static final Boolean STRIKETHROUGH_ON = new Boolean(true);
    public static final Boolean PITCHFIXED_ON = new Boolean(true);
    private int type;
    public static final FontAttribute FAMILY = new FontAttribute(1);
    public static final FontAttribute SIZE = new FontAttribute(2);
    public static final FontAttribute WEIGHT = new FontAttribute(3);
    public static final FontAttribute POSTURE = new FontAttribute(4);
    public static final FontAttribute UNDERLINE = new FontAttribute(5);
    public static final FontAttribute STRIKETHROUGH = new FontAttribute(6);
    public static final FontAttribute TRANSFORM = new FontAttribute(7);
    public static final FontAttribute PITCHFIXED = new FontAttribute(8);
    public static final FontAttribute ASCENT = new FontAttribute(9);
    public static final FontAttribute DESCENT = new FontAttribute(10);
    public static final FontAttribute LEADING = new FontAttribute(11);
    public static final FontAttribute AVEWIDTH = new FontAttribute(12);
    public static final FontAttribute MAXWIDTH = new FontAttribute(13);

    private FontAttribute(int n2) {
        this.type = n2;
    }

    public int getId() {
        return this.type;
    }

    public boolean equals(Object object) {
        return object instanceof FontAttribute && ((FontAttribute)object).type == this.type;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "FAMILY";
            }
            case 2: {
                return "SIZE";
            }
            case 3: {
                return "WEIGHT";
            }
            case 4: {
                return "POSTURE";
            }
            case 5: {
                return "UNDERLINE";
            }
            case 6: {
                return "STRIKETHROUGH";
            }
            case 7: {
                return "TRANSFORM";
            }
            case 8: {
                return "PITCHFIXED";
            }
            case 9: {
                return "ASCENT";
            }
            case 10: {
                return "DESCENT";
            }
            case 11: {
                return "LEADING";
            }
            case 12: {
                return "AVEWIDTH";
            }
            case 13: {
                return "MAXWIDTH";
            }
        }
        return "Unknown " + this.type;
    }

    public static Map convertToTextAttributes(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        block9: while (enumeration.hasMoreElements()) {
            FontAttribute fontAttribute = (FontAttribute)enumeration.nextElement();
            switch (fontAttribute.getId()) {
                case 1: {
                    hashtable2.put(TextAttribute.FAMILY, hashtable.get(fontAttribute));
                    continue block9;
                }
                case 2: {
                    hashtable2.put(TextAttribute.SIZE, hashtable.get(fontAttribute));
                    continue block9;
                }
                case 3: {
                    hashtable2.put(TextAttribute.WEIGHT, hashtable.get(fontAttribute));
                    continue block9;
                }
                case 4: {
                    hashtable2.put(TextAttribute.POSTURE, hashtable.get(fontAttribute));
                    continue block9;
                }
                case 5: {
                    hashtable2.put(TextAttribute.UNDERLINE, hashtable.get(fontAttribute));
                    continue block9;
                }
                case 6: {
                    hashtable2.put(TextAttribute.STRIKETHROUGH, hashtable.get(fontAttribute));
                    continue block9;
                }
                case 7: {
                    hashtable2.put(TextAttribute.TRANSFORM, hashtable.get(fontAttribute));
                    continue block9;
                }
            }
        }
        return hashtable2;
    }

    public static Hashtable convertFromTextAttributes(Map map) {
        Hashtable hashtable = new Hashtable();
        Object v2 = map.get(TextAttribute.SIZE);
        if (v2 != null) {
            hashtable.put(SIZE, v2);
        }
        if ((v2 = map.get(TextAttribute.WEIGHT)) != null) {
            hashtable.put(WEIGHT, v2);
        }
        if ((v2 = map.get(TextAttribute.POSTURE)) != null) {
            hashtable.put(POSTURE, v2);
        }
        if ((v2 = map.get(TextAttribute.UNDERLINE)) != null) {
            hashtable.put(UNDERLINE, v2);
        }
        if ((v2 = map.get(TextAttribute.STRIKETHROUGH)) != null) {
            hashtable.put(STRIKETHROUGH, v2);
        }
        if ((v2 = map.get(TextAttribute.TRANSFORM)) != null) {
            if (v2 instanceof TransformAttribute) {
                hashtable.put(TRANSFORM, ((TransformAttribute)v2).getTransform());
            } else {
                hashtable.put(TRANSFORM, v2);
            }
        }
        return hashtable;
    }
}

