/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.ImageLoader;
import com.iscobol.rts.BMPImage;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class IsguiUtility
implements ImageObserver {
    public static final int IMG_TYPE_UNKNOWN = 0;
    public static final int IMG_TYPE_BMP = 1;
    public static final int IMG_TYPE_JAVA = 2;
    public static final int S_FIT_FULL = 0;
    public static final int S_FIT_ASPECT = 1;
    public static final int S_FIT_WIDTH = 2;
    public static final int S_FIT_HEIGHT = 3;
    public static final int S_NO_FIT = 4;
    public static final int A_LEFT_BOTTOM = 1;
    public static final int A_CENTER_BOTTOM = 2;
    public static final int A_RIGHT_BOTTOM = 3;
    public static final int A_LEFT = 4;
    public static final int A_CENTER = 5;
    public static final int A_RIGHT = 6;
    public static final int A_LEFT_TOP = 7;
    public static final int A_CENTER_TOP = 8;
    public static final int A_RIGHT_TOP = 9;
    private transient boolean fullLoad;
    private transient boolean wrongFormat;
    private static final ImageLoader externalLoader;
    private static final int defaultFontSize = 12;

    public static Image createImage(byte[] byArray, int[] nArray, boolean bl) {
        return IsguiUtility.createImage(byArray, nArray, bl, true, 1);
    }

    public static Image createImage(byte[] byArray, int[] nArray, boolean bl, boolean bl2) {
        return IsguiUtility.createImage(byArray, nArray, bl, bl2, 1);
    }

    public static Image createImage(byte[] byArray, int[] nArray, boolean bl, boolean bl2, int n2) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = null;
            switch (nArray[0]) {
                case 0: {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    image = BMPImage.createImage(byteArrayInputStream, bl2);
                    if (image == null) {
                        nArray[0] = 2;
                        image = toolkit.createImage(byArray);
                        break;
                    }
                    nArray[0] = 1;
                    break;
                }
                case 1: {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    image = BMPImage.createImage(byteArrayInputStream, bl2);
                    break;
                }
                case 2: {
                    image = toolkit.createImage(byArray);
                }
            }
            if (image != null && bl) {
                boolean bl3 = IsguiUtility.prepareImage(image);
                if (bl3) {
                    if (n2 == 2) {
                        if (byteArrayInputStream == null) {
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                        } else {
                            byteArrayInputStream.reset();
                        }
                        try {
                            image = BMPDecoder.readImage(byteArrayInputStream);
                        }
                        catch (IOException iOException) {
                            image = null;
                        }
                        if (image != null) {
                            bl3 = IsguiUtility.prepareImage(image);
                        }
                    }
                    if (bl3 && externalLoader != null) {
                        if (byteArrayInputStream == null) {
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                        } else {
                            byteArrayInputStream.reset();
                        }
                        try {
                            image = externalLoader.loadImage(byteArrayInputStream);
                        }
                        catch (Exception exception) {
                            image = null;
                        }
                        if (image == null) {
                            List list;
                            byteArrayInputStream.reset();
                            try {
                                list = externalLoader.loadIcons(byteArrayInputStream);
                            }
                            catch (Exception exception) {
                                list = null;
                            }
                            if (list != null && !list.isEmpty()) {
                                image = (Image)list.get(0);
                            }
                        }
                        if (image != null) {
                            bl3 = IsguiUtility.prepareImage(image);
                        }
                    }
                }
                if (bl3) {
                    image = null;
                }
            }
        }
        return image;
    }

    public static Image getImage(int n2, int n3, Image image, int n4) {
        Image image2;
        if (image != null) {
            int n5 = image.getWidth(null);
            int n6 = image.getHeight(null);
            if (n2 <= 0 || n2 > n5) {
                n2 = n5;
            }
            if (n3 <= 0 || n3 > n6) {
                n3 = n6;
            }
            if (n2 != n5 || n3 != n6) {
                boolean bl;
                int n7 = (n4 - 1) * n2;
                if (n7 >= n5) {
                    return null;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                CropImageFilter cropImageFilter = new CropImageFilter(n7, 0, n2, n3);
                image2 = toolkit.createImage(new FilteredImageSource(image.getSource(), cropImageFilter));
                if (image2 != null && (bl = IsguiUtility.prepareImage(image2))) {
                    image2 = null;
                }
            } else {
                image2 = image;
            }
        } else {
            image2 = null;
        }
        return image2;
    }

    public static Image makeColorTransparent(Image image, final int n2) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            final boolean colorAt00;
            public int markerRGB;
            {
                this.colorAt00 = n2 == 0x1000000;
                this.markerRGB = n2 | 0xFF000000;
            }

            @Override
            public final int filterRGB(int n22, int n3, int n4) {
                if (n22 == 0 && n3 == 0 && this.colorAt00) {
                    this.markerRGB = n4;
                }
                if ((n4 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n4;
                }
                return n4;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareImage(Image image) {
        IsguiUtility isguiUtility;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        IsguiUtility isguiUtility2 = isguiUtility = new IsguiUtility();
        synchronized (isguiUtility2) {
            while (!toolkit.prepareImage(image, -1, -1, isguiUtility) && !isguiUtility.fullLoad) {
                try {
                    isguiUtility.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return isguiUtility.wrongFormat;
    }

    public static BufferedImage rotate(Image image, double d2) {
        float f2;
        float f3;
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d2);
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        affineTransform.transform(float_, float_);
        float f4 = f3 = float_.x;
        float f5 = f2 = float_.x;
        float_.setLocation(n2, 0.0f);
        affineTransform.transform(float_, float_);
        if (float_.x < f4) {
            f4 = float_.x;
        }
        if (float_.y < f5) {
            f5 = float_.y;
        }
        if (float_.x > f3) {
            f3 = float_.x;
        }
        if (float_.y > f2) {
            f2 = float_.y;
        }
        float_.setLocation(0.0f, n3);
        affineTransform.transform(float_, float_);
        if (float_.x < f4) {
            f4 = float_.x;
        }
        if (float_.y < f5) {
            f5 = float_.y;
        }
        if (float_.x > f3) {
            f3 = float_.x;
        }
        if (float_.y > f2) {
            f2 = float_.y;
        }
        float_.setLocation(n2, n3);
        affineTransform.transform(float_, float_);
        if (float_.x < f4) {
            f4 = float_.x;
        }
        if (float_.y < f5) {
            f5 = float_.y;
        }
        if (float_.x > f3) {
            f3 = float_.x;
        }
        if (float_.y > f2) {
            f2 = float_.y;
        }
        n2 = (int)(f3 - f4 + 1.0f);
        n3 = (int)(f2 - f5 + 1.0f);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(-f4, -f5);
        graphics2D.rotate(d2);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage scale(Image image, double d2, double d3, int n2, int n3) {
        return IsguiUtility.scale(image, d2, d3, n2, n3, false);
    }

    public static BufferedImage scale(Image image, double d2, double d3, int n2, int n3, boolean bl) {
        double d4 = 0.5;
        if (bl) {
            double d5 = image.getWidth(null);
            double d6 = image.getHeight(null);
            Image image2 = image;
            do {
                if (d5 > d2) {
                    if ((d5 *= d4) < d2) {
                        d5 = d2;
                    }
                } else {
                    d5 = d2;
                }
                if (d6 > d3) {
                    if ((d6 *= d4) < d3) {
                        d6 = d3;
                    }
                } else {
                    d6 = d3;
                }
                image2 = IsguiUtility.scaleImpl(image2, d5, d6, n2, n3);
            } while (d5 != d2 || d6 != d3);
            return (BufferedImage)image2;
        }
        return IsguiUtility.scaleImpl(image, d2, d3, n2, n3);
    }

    private static BufferedImage scaleImpl(Image image, double d2, double d3, int n2, int n3) {
        int n4;
        int n5;
        double d4 = image.getWidth(null);
        double d5 = image.getHeight(null);
        double d6 = 1.0;
        double d7 = 1.0;
        switch (n2) {
            default: {
                d6 = d2 / d4;
                d7 = d3 / d5;
                break;
            }
            case 1: {
                d6 = d2 / d4;
                d7 = d3 / d5;
                if (d6 < d7) {
                    d7 = d6;
                    break;
                }
                d6 = d7;
                break;
            }
            case 2: {
                d7 = d6 = d2 / d4;
                break;
            }
            case 3: {
                d7 = d6 = d3 / d5;
            }
            case 4: 
        }
        int n6 = d6 != 1.0 ? (int)(d6 * d4) : (int)d4;
        int n7 = d7 != 1.0 ? (int)(d7 * d5) : (int)d5;
        if (n6 < 1) {
            n6 = 1;
        }
        if (n7 < 1) {
            n7 = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (d6 != 1.0 || d7 != 1.0) {
            graphics2D.scale(d6, d7);
        }
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHints(hashMap);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        d4 = bufferedImage.getWidth(null);
        d5 = bufferedImage.getHeight(null);
        switch (n3) {
            case 1: {
                n5 = 0;
                n4 = (int)(d3 - d5);
                break;
            }
            case 2: {
                n5 = (int)(d2 - d4) / 2;
                n4 = (int)(d3 - d5);
                break;
            }
            case 3: {
                n5 = (int)(d2 - d4);
                n4 = (int)(d3 - d5);
                break;
            }
            case 4: {
                n5 = 0;
                n4 = (int)(d3 - d5) / 2;
                break;
            }
            case 5: {
                n5 = (int)(d2 - d4) / 2;
                n4 = (int)(d3 - d5) / 2;
                break;
            }
            case 6: {
                n5 = (int)(d2 - d4);
                n4 = (int)(d3 - d5) / 2;
                break;
            }
            default: {
                n5 = 0;
                n4 = 0;
                break;
            }
            case 8: {
                n5 = (int)(d2 - d4) / 2;
                n4 = 0;
                break;
            }
            case 9: {
                n5 = (int)(d2 - d4);
                n4 = 0;
            }
        }
        BufferedImage bufferedImage2 = new BufferedImage((int)d2, (int)d3, 2);
        graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, n5, n4, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage align(Image image, double d2, double d3, int n2) {
        int n3;
        int n4;
        double d4 = image.getWidth(null);
        double d5 = image.getHeight(null);
        switch (n2) {
            case 1: {
                n4 = 0;
                n3 = (int)(d3 - d5);
                break;
            }
            case 2: {
                n4 = (int)(d2 - d4) / 2;
                n3 = (int)(d3 - d5);
                break;
            }
            case 3: {
                n4 = (int)(d2 - d4);
                n3 = (int)(d3 - d5);
                break;
            }
            case 4: {
                n4 = 0;
                n3 = (int)(d3 - d5) / 2;
                break;
            }
            case 5: {
                n4 = (int)(d2 - d4) / 2;
                n3 = (int)(d3 - d5) / 2;
                break;
            }
            case 6: {
                n4 = (int)(d2 - d4);
                n3 = (int)(d3 - d5) / 2;
                break;
            }
            default: {
                n4 = 0;
                n3 = 0;
                break;
            }
            case 8: {
                n4 = (int)(d2 - d4) / 2;
                n3 = 0;
                break;
            }
            case 9: {
                n4 = (int)(d2 - d4);
                n3 = 0;
            }
        }
        BufferedImage bufferedImage = new BufferedImage((int)d2, (int)d3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, n4, n3, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 & 0xF0;
        if (n7 != 0) {
            if (n7 != 32 && n7 != 16) {
                this.wrongFormat = true;
            }
            IsguiUtility isguiUtility = this;
            synchronized (isguiUtility) {
                this.fullLoad = true;
                this.notifyAll();
            }
        }
        return n7 == 0;
    }

    public static String createMaskFromDatePattern(String string, char c2, boolean bl) {
        String string2 = "GyMdkHmsSEDFwWahKzZ";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            boolean bl2 = false;
            for (int i3 = 0; i3 < string2.length(); ++i3) {
                if (string2.charAt(i3) != c3) continue;
                stringBuffer.append(c2);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (bl) {
                stringBuffer.append('\'');
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static String getDefaultShortDateFormat() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        return "dd/MM/yyyy";
    }

    public static String getDefaultLongDateFormat() {
        DateFormat dateFormat = DateFormat.getDateInstance(0);
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        return "EEEE dd MMMM yyyy";
    }

    public static String getDefaultCenturyDateFormat() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        if (dateFormat instanceof SimpleDateFormat) {
            String string = ((SimpleDateFormat)dateFormat).toPattern();
            return string.replaceAll("\\byy\\b", "yyyy").replaceAll("\\by\\b", "yyyy");
        }
        return "dd/MM/yyyy";
    }

    public static String getDefaultTimeDateFormat() {
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        return "HH:mm:ss";
    }

    public static Object[] parseFontString(String string) {
        String string2 = string;
        int n2 = 0;
        float f2 = 12.0f;
        int n3 = string.indexOf(45);
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
            if (n3 < string.length()) {
                if ((string = string.substring(n3 + 1).toLowerCase()).startsWith("bolditalic")) {
                    n2 = 3;
                    if (string.length() > 11) {
                        string = string.substring(11);
                    }
                } else if (string.startsWith("bold")) {
                    n2 = 1;
                    if (string.length() > 5) {
                        string = string.substring(5);
                    }
                } else if (string.startsWith("italic")) {
                    n2 = 2;
                    if (string.length() > 7) {
                        string = string.substring(7);
                    }
                }
                if (string.length() > 0) {
                    try {
                        f2 = Float.valueOf(string).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (f2 == 0.0f) {
                    f2 = 12.0f;
                }
            }
        }
        return new Object[]{string2, n2, Float.valueOf(f2)};
    }

    public static KeyListener keyPressedAdapter(final Consumer<KeyEvent> consumer) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                consumer.accept(keyEvent);
            }
        };
    }

    public static MouseListener mouseClickedAdapter(final Consumer<MouseEvent> consumer) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                consumer.accept(mouseEvent);
            }
        };
    }

    public static MouseListener mousePressedAdapter(final Consumer<MouseEvent> consumer) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                consumer.accept(mouseEvent);
            }
        };
    }

    public static MouseListener mouseAdapter(Consumer<MouseEvent> consumer, Consumer<MouseEvent> consumer2, Consumer<MouseEvent> consumer3) {
        return IsguiUtility.mouseAdapter(null, null, consumer, consumer2, consumer3);
    }

    public static MouseListener mouseAdapter(final Consumer<MouseEvent> consumer, final Consumer<MouseEvent> consumer2, final Consumer<MouseEvent> consumer3, final Consumer<MouseEvent> consumer4, final Consumer<MouseEvent> consumer5) {
        return new MouseListener(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (consumer3 != null) {
                    consumer3.accept(mouseEvent);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (consumer5 != null) {
                    consumer5.accept(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (consumer4 != null) {
                    consumer4.accept(mouseEvent);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (consumer != null) {
                    consumer.accept(mouseEvent);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (consumer2 != null) {
                    consumer2.accept(mouseEvent);
                }
            }
        };
    }

    public static ComponentListener componentResizedAdapter(final Consumer<ComponentEvent> consumer) {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                consumer.accept(componentEvent);
            }
        };
    }

    public static ComponentListener componentMovedAdapter(final Consumer<ComponentEvent> consumer) {
        return new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                consumer.accept(componentEvent);
            }
        };
    }

    public static WindowListener windowClosedAdapter(final Consumer<WindowEvent> consumer) {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                consumer.accept(windowEvent);
            }
        };
    }

    public static WindowListener windowClosingAdapter(final Consumer<WindowEvent> consumer) {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                consumer.accept(windowEvent);
            }
        };
    }

    public static FocusListener focusGainedAdapter(final Consumer<FocusEvent> consumer) {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                consumer.accept(focusEvent);
            }
        };
    }

    public static FocusListener focusLostAdapter(final Consumer<FocusEvent> consumer) {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                consumer.accept(focusEvent);
            }
        };
    }

    public static FocusListener focusAdapter(final Consumer<FocusEvent> consumer, final Consumer<FocusEvent> consumer2) {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (consumer2 != null) {
                    consumer2.accept(focusEvent);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (consumer != null) {
                    consumer.accept(focusEvent);
                }
            }
        };
    }

    public static BufferedImage takeScreenshot(JComponent jComponent) {
        return IsguiUtility.takeScreenshot(jComponent, false);
    }

    public static BufferedImage takeScreenshot(final JComponent jComponent, boolean bl) {
        JFrame jFrame = new JFrame();
        jFrame.setLayout(null);
        jFrame.enableInputMethods(false);
        boolean bl2 = jComponent.isOpaque();
        jComponent.setOpaque(!bl);
        Canvas canvas = new Canvas(){

            @Override
            public void paint(Graphics graphics) {
                jComponent.paint(graphics);
            }
        };
        canvas.setSize(jComponent.getSize());
        jFrame.getContentPane().add(canvas);
        jFrame.pack();
        BufferedImage bufferedImage = new BufferedImage(canvas.getWidth(), canvas.getHeight(), bl ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(canvas.getBounds());
        canvas.paint(graphics2D);
        graphics2D.dispose();
        jComponent.setOpaque(bl2);
        jFrame.dispose();
        return bufferedImage;
    }

    static {
        ImageLoader imageLoader;
        try {
            imageLoader = (ImageLoader)Class.forName("com.iscobol.misc.image.Image4JLoader").newInstance();
        }
        catch (Throwable throwable) {
            imageLoader = null;
        }
        externalLoader = imageLoader;
    }

    private static class BMPDecoder {
        private InputStream is;
        private int curPos;
        private int bitmapOffset;
        private int width;
        private int height;
        private short bitsPerPixel;
        private int compression;
        private int actualSizeOfBitmap;
        private int scanLineSize;
        private int actualColorsUsed;
        private byte[] r;
        private byte[] g;
        private byte[] b;
        private int noOfEntries;
        private byte[] byteData;
        private int[] intData;
        private boolean topDown;

        private BMPDecoder() {
        }

        private int readInt() throws IOException {
            int n2 = this.is.read();
            int n3 = this.is.read();
            int n4 = this.is.read();
            int n5 = this.is.read();
            this.curPos += 4;
            return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
        }

        private short readShort() throws IOException {
            int n2 = this.is.read();
            int n3 = this.is.read();
            this.curPos += 2;
            return (short)((n3 << 8) + n2);
        }

        private void getFileHeader() throws IOException {
            int n2 = 19778;
            n2 = this.readShort();
            if (n2 != 19778) {
                throw new IOException("Not a BMP file");
            }
            this.readInt();
            this.readShort();
            this.readShort();
            this.bitmapOffset = this.readInt();
        }

        private void getBitmapHeader() throws IOException {
            this.readInt();
            this.width = this.readInt();
            this.height = this.readInt();
            this.readShort();
            this.bitsPerPixel = this.readShort();
            this.compression = this.readInt();
            this.readInt();
            this.readInt();
            this.readInt();
            int n2 = this.readInt();
            this.readInt();
            if (this.bitsPerPixel == 24) {
                n2 = 0;
            }
            boolean bl = this.topDown = this.height < 0;
            if (this.topDown) {
                this.height = -this.height;
            }
            this.scanLineSize = (this.width * this.bitsPerPixel + 31) / 32 * 4;
            this.actualSizeOfBitmap = this.scanLineSize * this.height;
            this.actualColorsUsed = n2 != 0 ? n2 : (this.bitsPerPixel < 16 ? 1 << this.bitsPerPixel : 0);
        }

        private void getPalette() throws IOException {
            this.noOfEntries = this.actualColorsUsed;
            if (this.noOfEntries > 0) {
                this.r = new byte[this.noOfEntries];
                this.g = new byte[this.noOfEntries];
                this.b = new byte[this.noOfEntries];
                for (int i2 = 0; i2 < this.noOfEntries; ++i2) {
                    this.b[i2] = (byte)this.is.read();
                    this.g[i2] = (byte)this.is.read();
                    this.r[i2] = (byte)this.is.read();
                    this.is.read();
                    this.curPos += 4;
                }
            }
        }

        private void unpack(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws IOException {
            int n6;
            int n7;
            int n8 = n4;
            int n9 = n2;
            switch (n3) {
                case 1: {
                    n7 = 1;
                    n6 = 8;
                    break;
                }
                case 4: {
                    n7 = 15;
                    n6 = 2;
                    break;
                }
                case 8: {
                    n7 = -1;
                    n6 = 1;
                    break;
                }
                default: {
                    throw new IOException("Unsupported bits-per-pixel value: " + n3);
                }
            }
            int n10 = 0;
            while (true) {
                int n11 = 8 - n3;
                for (int i2 = 0; i2 < n6; ++i2) {
                    byte by = byArray[n9];
                    by = (byte)(by >> n11);
                    byArray2[n8] = (byte)(by & n7);
                    ++n8;
                    if (++n10 == n5) {
                        return;
                    }
                    n11 -= n3;
                }
                ++n9;
            }
        }

        private void unpack24(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
            int n5 = n3;
            int n6 = n2;
            int n7 = 255;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n8 = byArray[n6++] & n7;
                int n9 = (byArray[n6++] & n7) << 8;
                int n10 = (byArray[n6++] & n7) << 16;
                nArray[n5] = 0xFF000000 | n8 | n9 | n10;
                ++n5;
            }
        }

        private void unpack32(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
            int n5 = n3;
            int n6 = n2;
            int n7 = 255;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n8 = byArray[n6++] & n7;
                int n9 = (byArray[n6++] & n7) << 8;
                int n10 = (byArray[n6++] & n7) << 16;
                ++n6;
                nArray[n5] = 0xFF000000 | n8 | n9 | n10;
                ++n5;
            }
        }

        private void getPixelData() throws IOException {
            long l2 = this.bitmapOffset - this.curPos;
            if (l2 > 0L) {
                this.is.skip(l2);
                this.curPos = (int)((long)this.curPos + l2);
            }
            int n2 = this.scanLineSize;
            if (this.bitsPerPixel > 8) {
                this.intData = new int[this.width * this.height];
            } else {
                this.byteData = new byte[this.width * this.height];
            }
            byte[] byArray = new byte[this.actualSizeOfBitmap];
            int n3 = 0;
            int n4 = (this.height - 1) * this.width;
            for (int i2 = this.height - 1; i2 >= 0; --i2) {
                int n5 = this.is.read(byArray, n3, n2);
                if (n5 < n2) {
                    throw new IOException("Scan line ended prematurely after " + n5 + " bytes");
                }
                if (this.bitsPerPixel == 24) {
                    this.unpack24(byArray, n3, this.intData, n4, this.width);
                } else if (this.bitsPerPixel == 32) {
                    this.unpack32(byArray, n3, this.intData, n4, this.width);
                } else {
                    this.unpack(byArray, n3, this.bitsPerPixel, this.byteData, n4, this.width);
                }
                n3 += n2;
                n4 -= this.width;
            }
        }

        void read(InputStream inputStream) throws IOException {
            this.is = inputStream;
            this.getFileHeader();
            this.getBitmapHeader();
            if (this.compression != 0) {
                throw new IOException("Compression not supported");
            }
            this.getPalette();
            this.getPixelData();
        }

        MemoryImageSource makeImageSource() {
            ColorModel colorModel = this.noOfEntries > 0 && this.bitsPerPixel != 24 ? new IndexColorModel((int)this.bitsPerPixel, this.noOfEntries, this.r, this.g, this.b) : ColorModel.getRGBdefault();
            MemoryImageSource memoryImageSource = this.bitsPerPixel > 8 ? new MemoryImageSource(this.width, this.height, colorModel, this.intData, 0, this.width) : new MemoryImageSource(this.width, this.height, colorModel, this.byteData, 0, this.width);
            return memoryImageSource;
        }

        static Image readImage(InputStream inputStream) throws IOException {
            BMPDecoder bMPDecoder = new BMPDecoder();
            bMPDecoder.read(inputStream);
            MemoryImageSource memoryImageSource = bMPDecoder.makeImageSource();
            return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        }
    }
}

