/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import java.util.Vector;

public class JavaBeanUtilities {
    public static final int INIT_PARAM_ALPHANUMERIC = 1001;
    public static final int INIT_PARAM_NUMERIC = 1002;

    public static Method getMethod(Class clazz, boolean bl, Method[] methodArray, String string, String string2, Object[] objectArray) throws Throwable {
        Method method;
        if (string2 != null) {
            Class[] classArray = JavaBeanUtilities.signatureToTypes(string2);
            method = clazz.getMethod(string, classArray);
            if (bl && !JavaBeanUtilities.isStatic(method)) {
                throw new NoSuchMethodException();
            }
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    objectArray[i2] = JavaBeanUtilities.checkType(classArray[i2], objectArray[i2]);
                }
            }
        } else {
            Method[] methodArray2 = JavaBeanUtilities.getMethods(string, objectArray, methodArray, bl);
            if (methodArray2.length == 0) {
                throw new NoSuchMethodException();
            }
            if (methodArray2.length > 1) {
                StringBuffer stringBuffer = new StringBuffer("Ambiguous method invokation:\n");
                for (int i3 = 0; i3 < methodArray2.length; ++i3) {
                    stringBuffer.append("   " + JavaBeanUtilities.getMethodSignature(methodArray2[i3]) + "\n");
                }
                throw new NoSuchMethodException(stringBuffer.toString());
            }
            if (objectArray != null) {
                Class<?>[] classArray = methodArray2[0].getParameterTypes();
                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                    objectArray[i4] = JavaBeanUtilities.checkType(classArray[i4], objectArray[i4]);
                }
            }
            method = methodArray2[0];
        }
        return method;
    }

    public static Object callMethod(Class clazz, Object object, Method[] methodArray, String string, String string2, Object[] objectArray) throws Throwable {
        Method method = JavaBeanUtilities.getMethod(clazz, object == null, methodArray, string, string2, objectArray);
        return method.invoke(object, objectArray);
    }

    private static String getMethodSignature(Method method) throws Exception {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = method.getReturnType();
        if (clazz.isArray()) {
            int n3 = 0;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++n3;
            }
            stringBuffer.append(clazz.getName());
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append("[]");
            }
        } else {
            stringBuffer.append(clazz.getName());
        }
        stringBuffer.append(" " + method.getName());
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (n2 = 0; n2 < classArray.length; ++n2) {
            Class<?> clazz2;
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            if ((clazz2 = classArray[n2]).isArray()) {
                int n4 = 0;
                while (clazz2.isArray()) {
                    clazz2 = clazz2.getComponentType();
                    ++n4;
                }
                stringBuffer.append(clazz2.getName());
                for (int i2 = 0; i2 < n4; ++i2) {
                    stringBuffer.append("[]");
                }
                continue;
            }
            stringBuffer.append(clazz2.getName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static Object checkType(Class clazz, Object object) {
        if (object instanceof INumericVar) {
            if (clazz.isAssignableFrom(INumericVar.class)) {
                return object;
            }
            INumericVar iNumericVar = (INumericVar)object;
            if (!iNumericVar.isInteger()) {
                if (clazz == Float.TYPE) {
                    return new Float(iNumericVar.tofloat());
                }
                if (clazz == Double.TYPE) {
                    return new Double(iNumericVar.todouble());
                }
            } else {
                if (clazz == Byte.TYPE) {
                    return new Byte(iNumericVar.tobyte());
                }
                if (clazz == Short.TYPE) {
                    return new Short(iNumericVar.toshort());
                }
                if (clazz == Integer.TYPE) {
                    return new Integer(iNumericVar.toint());
                }
                if (clazz == Long.TYPE) {
                    return new Long(iNumericVar.tolong());
                }
                if (clazz == Float.TYPE) {
                    return new Float(iNumericVar.tofloat());
                }
                if (clazz == Double.TYPE) {
                    return new Double(iNumericVar.todouble());
                }
                if (clazz == Boolean.TYPE) {
                    return new Boolean(iNumericVar.toint() != 0);
                }
            }
        } else if (object instanceof ICobolVar) {
            String string;
            if (clazz.isAssignableFrom(ICobolVar.class)) {
                return object;
            }
            if (clazz == String.class) {
                return ScreenUtility.rightTrim(object.toString());
            }
            if (clazz == Character.TYPE && (string = object.toString()).length() > 0) {
                return new Character(string.charAt(0));
            }
        } else if (object instanceof String) {
            String string = (String)object;
            if (clazz == String.class) {
                return object;
            }
            if (clazz == Character.TYPE && string.length() == 1) {
                return new Character(string.charAt(0));
            }
        }
        return object;
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    private static Method[] getMethods(String string, Object[] objectArray, Method[] methodArray, boolean bl) throws Exception {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Vector<Method> vector = new Vector<Method>();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Class<?>[] classArray;
            if (bl && !JavaBeanUtilities.isStatic(methodArray[i2]) || !methodArray[i2].getName().equals(string) || (classArray = methodArray[i2].getParameterTypes()).length != objectArray.length) continue;
            boolean bl2 = true;
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                if (JavaBeanUtilities.isAssignableFrom(classArray[i3], objectArray[i3])) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            vector.addElement(methodArray[i2]);
        }
        Method[] methodArray2 = new Method[vector.size()];
        vector.toArray(methodArray2);
        return methodArray2;
    }

    public static boolean isAssignableFrom(Class clazz, Object object) {
        if (object == null) {
            return !clazz.isPrimitive();
        }
        if (object instanceof INumericVar) {
            if (clazz.isAssignableFrom(INumericVar.class)) {
                return true;
            }
            INumericVar iNumericVar = (INumericVar)object;
            if (!iNumericVar.isInteger()) {
                return clazz == Float.TYPE || clazz == Double.TYPE;
            }
            return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Boolean.TYPE;
        }
        if (object instanceof ICobolVar) {
            return clazz.isAssignableFrom(ICobolVar.class) || clazz.isAssignableFrom(String.class) || clazz == Character.TYPE && object.toString().length() == 1;
        }
        if (object instanceof String) {
            return clazz.isAssignableFrom(String.class) || clazz == Character.TYPE && object.toString().length() == 1;
        }
        if (object instanceof Character) {
            return clazz.isAssignableFrom(Character.class) || clazz == Character.TYPE;
        }
        if (object instanceof Byte) {
            return clazz.isAssignableFrom(Byte.class) || clazz == Byte.TYPE;
        }
        if (object instanceof Short) {
            return clazz.isAssignableFrom(Short.class) || clazz == Short.TYPE;
        }
        if (object instanceof Integer) {
            return clazz.isAssignableFrom(Integer.class) || clazz == Integer.TYPE;
        }
        if (object instanceof Long) {
            return clazz.isAssignableFrom(Long.class) || clazz == Long.TYPE;
        }
        if (object instanceof Float) {
            return clazz.isAssignableFrom(Float.class) || clazz == Float.TYPE;
        }
        if (object instanceof Double) {
            return clazz.isAssignableFrom(Double.class) || clazz == Double.TYPE;
        }
        if (object instanceof Boolean) {
            return clazz.isAssignableFrom(Boolean.class) || clazz == Boolean.TYPE;
        }
        return clazz.isInstance(object);
    }

    public static Class[] signatureToTypes(String string) throws Exception {
        Class[] classArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string.replaceAll(" ", ""), ",");
        Vector vector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            classArray = stringTokenizer.nextToken();
            int n2 = 0;
            int n3 = classArray.indexOf("[]");
            if (n3 >= 0) {
                object = classArray.substring(0, n3);
                n2 = 1;
                while ((n3 = classArray.indexOf("[]", n3 + 2)) >= 0) {
                    ++n2;
                }
            } else {
                object = classArray;
            }
            if (((String)object).equals("char")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "C"));
                    continue;
                }
                vector.addElement(Character.TYPE);
                continue;
            }
            if (((String)object).equals("boolean")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "Z"));
                    continue;
                }
                vector.addElement(Boolean.TYPE);
                continue;
            }
            if (((String)object).equals("byte")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "B"));
                    continue;
                }
                vector.addElement(Byte.TYPE);
                continue;
            }
            if (((String)object).equals("short")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "S"));
                    continue;
                }
                vector.addElement(Short.TYPE);
                continue;
            }
            if (((String)object).equals("int")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "I"));
                    continue;
                }
                vector.addElement(Integer.TYPE);
                continue;
            }
            if (((String)object).equals("long")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "J"));
                    continue;
                }
                vector.addElement(Long.TYPE);
                continue;
            }
            if (((String)object).equals("float")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "F"));
                    continue;
                }
                vector.addElement(Float.TYPE);
                continue;
            }
            if (((String)object).equals("double")) {
                if (n2 > 0) {
                    vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "D"));
                    continue;
                }
                vector.addElement(Double.TYPE);
                continue;
            }
            if (n2 > 0) {
                vector.addElement(Class.forName(JavaBeanUtilities.addBrackets(n2) + "L" + (String)object + ";"));
                continue;
            }
            vector.addElement(Class.forName((String)object));
        }
        classArray = new Class[vector.size()];
        vector.toArray(classArray);
        return classArray;
    }

    private static String addBrackets(int n2) {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "[";
        }
        return string;
    }
}

