/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.Constants;
import java.awt.Color;
import java.awt.SystemColor;

public class Palette
implements Constants {
    static final Color[] defaultColors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 128), new Color(0, 128, 0), new Color(0, 128, 128), new Color(128, 0, 0), new Color(128, 0, 128), new Color(128, 128, 0), new Color(192, 192, 192), new Color(128, 128, 128), new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255)};
    public static final int USER_GRAY_NUM = 7;
    public static final int USER_WHITE_NUM = 15;
    private static boolean userGray;
    private static boolean userWhite;
    public static final Color windowColor;
    public static final Color controlColor;
    public static final Color controlHighlightColor;
    private Color[] colors = new Color[16];

    public Palette(Palette palette) {
        if (palette == null) {
            for (int i2 = 0; i2 < 16; ++i2) {
                this.colors[i2] = defaultColors[i2];
            }
        } else {
            for (int i3 = 0; i3 < 16; ++i3) {
                this.colors[i3] = palette.colors[i3];
            }
        }
    }

    public boolean setUserColor(int n2, int n3) {
        if (n3 < 0 || n3 >= 16) {
            return false;
        }
        switch (n2) {
            case 1: {
                this.colors[n3] = controlColor;
                break;
            }
            case 2: {
                this.colors[n3] = windowColor;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void setUserGray(boolean bl) {
        userGray = bl;
    }

    public static void setUserWhite(boolean bl) {
        userWhite = bl;
    }

    public static Color getDefaultColor(int n2) {
        switch (n2) {
            case 7: {
                if (userGray) {
                    return controlColor;
                }
                return defaultColors[n2];
            }
            case 15: {
                if (userWhite) {
                    return windowColor;
                }
                return defaultColors[n2];
            }
            case 16: {
                return windowColor;
            }
        }
        if (n2 < 0 || n2 >= defaultColors.length) {
            return null;
        }
        return defaultColors[n2];
    }

    public Color getColor(int n2) {
        if (n2 < 0) {
            return null;
        }
        if (n2 == 16) {
            return windowColor;
        }
        return this.colors[n2];
    }

    static {
        windowColor = SystemColor.window;
        controlColor = SystemColor.control;
        controlHighlightColor = SystemColor.controlHighlight;
    }
}

