/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.ParamVElement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ParamElementWindowLocation
extends ParamVElement
implements Externalizable {
    private static final long serialVersionUID = 6735473647364738L;
    private static final int FIRSTDISPLAY_TRUE = 1;
    private static final int CHANGESCREENLC_TRUE = 2;
    private static final int SCREEN_LINE_INVALID = 8;
    private static final int SCREEN_COLUMN_INVALID = 16;
    private static final int GETATLINE_EQ_SCREEN_LINE = 32;
    private static final int GETATCOL_EQ_SCREEN_COL = 64;
    private static final int HAVE_ADD_SUB_LINE = 128;
    private static final int HAVE_ADD_SUB_COL = 256;
    private static final int HAVE_SCREEN_LINE = 512;
    private static final int HAVE_SCREEN_COL = 1024;
    private static final int HAVE_GET_AT_LINE = 2048;
    private static final int HAVE_GET_AT_COL = 4096;
    private static final int HAVE_PARENT_ID = 8192;
    private static final int HAVE_TOOLBARSHEIGHT = 16384;
    public boolean firstdisplay;
    public boolean changescreenlc;
    public float screenline;
    public float screencolumn;
    public float getatline;
    public float getatcolumn;
    public float add_sub_lines;
    public float add_sub_columns;
    public int parentid;
    public float toolbarsheight;

    public ParamElementWindowLocation() {
    }

    public ParamElementWindowLocation(short s2) {
        super(s2);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        short s2 = objectInput.readShort();
        this.firstdisplay = false;
        this.changescreenlc = false;
        this.parentid = -1;
        if (s2 > 0) {
            if ((s2 & 1) == 1) {
                this.firstdisplay = true;
            }
            if ((s2 & 2) == 2) {
                this.changescreenlc = true;
            }
            if ((s2 & 8) == 8) {
                this.screenline = -99999.0f;
            } else if ((s2 & 0x200) == 512) {
                this.screenline = objectInput.readFloat();
            }
            if ((s2 & 0x10) == 16) {
                this.screencolumn = -99999.0f;
            } else if ((s2 & 0x400) == 1024) {
                this.screencolumn = objectInput.readFloat();
            }
            if ((s2 & 0x20) == 32) {
                this.getatline = this.screenline;
            } else if ((s2 & 0x800) == 2048) {
                this.getatline = objectInput.readFloat();
            }
            if ((s2 & 0x40) == 64) {
                this.getatcolumn = this.screencolumn;
            } else if ((s2 & 0x1000) == 4096) {
                this.getatcolumn = objectInput.readFloat();
            }
            if ((s2 & 0x80) == 128) {
                this.add_sub_lines = objectInput.readFloat();
            }
            if ((s2 & 0x100) == 256) {
                this.add_sub_columns = objectInput.readFloat();
            }
            if ((s2 & 0x2000) == 8192) {
                this.parentid = objectInput.readInt();
            }
            if ((s2 & 0x4000) == 16384) {
                this.toolbarsheight = objectInput.readFloat();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        short s2 = 0;
        if (this.firstdisplay) {
            s2 = (short)(s2 | 1);
        }
        if (this.changescreenlc) {
            s2 = (short)(s2 | 2);
        }
        s2 = this.screenline <= -99999.0f ? (short)(s2 | 8) : (short)(s2 | 0x200);
        s2 = this.screencolumn <= -99999.0f ? (short)(s2 | 0x10) : (short)(s2 | 0x400);
        if (this.getatline > 0.0f) {
            s2 = this.getatline == this.screenline ? (short)(s2 | 0x20) : (short)(s2 | 0x800);
        } else if (this.getatline == this.screenline && this.getatline == -99999.0f) {
            s2 = (short)(s2 | 0x20);
        } else if (this.getatline < 0.0f && this.getatline != -99999.0f) {
            s2 = (short)(s2 | 0x800);
        }
        if (this.getatcolumn > 0.0f) {
            s2 = this.getatcolumn == this.screencolumn ? (short)(s2 | 0x40) : (short)(s2 | 0x1000);
        } else if (this.getatcolumn == this.screencolumn && this.getatcolumn == -99999.0f) {
            s2 = (short)(s2 | 0x40);
        } else if (this.getatcolumn < 0.0f && this.getatcolumn != -99999.0f) {
            s2 = (short)(s2 | 0x1000);
        }
        if (this.add_sub_lines != 0.0f) {
            s2 = (short)(s2 | 0x80);
        }
        if (this.add_sub_columns != 0.0f) {
            s2 = (short)(s2 | 0x100);
        }
        if (this.parentid >= 0) {
            s2 = (short)(s2 | 0x2000);
        }
        if (this.toolbarsheight > 0.0f) {
            s2 = (short)(s2 | 0x4000);
        }
        objectOutput.writeShort(s2);
        if (this.screenline > -99999.0f) {
            objectOutput.writeFloat(this.screenline);
        }
        if (this.screencolumn > -99999.0f) {
            objectOutput.writeFloat(this.screencolumn);
        }
        if (this.getatline > 0.0f && this.getatline != this.screenline || this.getatline < 0.0f && this.getatline != -99999.0f) {
            objectOutput.writeFloat(this.getatline);
        }
        if (this.getatcolumn > 0.0f && this.getatcolumn != this.screencolumn || this.getatcolumn < 0.0f && this.getatcolumn != -99999.0f) {
            objectOutput.writeFloat(this.getatcolumn);
        }
        if (this.add_sub_lines != 0.0f) {
            objectOutput.writeFloat(this.add_sub_lines);
        }
        if (this.add_sub_columns != 0.0f) {
            objectOutput.writeFloat(this.add_sub_columns);
        }
        if (this.parentid >= 0) {
            objectOutput.writeInt(this.parentid);
        }
        if (this.toolbarsheight > 0.0f) {
            objectOutput.writeFloat(this.toolbarsheight);
        }
    }
}

