/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.AppFactory;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.LocLinkedList;
import com.iscobol.gui.Navigable;
import com.iscobol.gui.client.AppFactoryImpl;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.CommunicationException;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeEnvironmentType;
import com.iscobol.rts.RuntimeInfo;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScreenUtility
extends IsguiUtility {
    public static final char LOW_VALUE = '\u0000';
    private static Hashtable serverFonts;

    public static boolean canPaste(Object object) {
        return Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
    }

    public static String getAll(char c2, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String rightTrim(String string) {
        return Factory.rightTrim(string);
    }

    public static void disableFocusTraversalKeys(Container container) {
        if (container != null) {
            try {
                container.setFocusTraversalKeys(1, Collections.EMPTY_SET);
                container.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String allSpaces(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static GuiFactory setGuiFactory() {
        Object object;
        AppFactory appFactory = (AppFactory)IscobolSystem.get(AppFactory.class);
        if (appFactory == null) {
            KeyboardBuffer.clinit();
            appFactory = new AppFactoryImpl();
            IscobolSystem.set(AppFactory.class, appFactory);
            object = Config.a(".guifactory.class", "com.iscobol.gui.client.swing.GuiFactoryImpl");
            if ("com.iscobol.gui.client.zk.GuiFactoryImpl".equals(object)) {
                RuntimeInfo.set(RuntimeEnvironmentType.WD2);
            } else if ("com.iscobol.gui.client.charva.GuiFactoryImpl".equals(object)) {
                RuntimeInfo.set(RuntimeEnvironmentType.STANDALONE_CHARVA);
            } else {
                RuntimeInfo.set(RuntimeEnvironmentType.STANDALONE);
            }
        }
        object = null;
        try {
            object = appFactory.newGuiFactory();
            IscobolSystem.set(GuiFactory.class, object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public static GuiFactory getGuiFactory() {
        GuiFactory guiFactory = (GuiFactory)IscobolSystem.get(GuiFactory.class);
        if (guiFactory == null) {
            guiFactory = ScreenUtility.setGuiFactory();
        }
        return guiFactory;
    }

    public static boolean isWD2() {
        return !IscobolSystem.isAS() && "com.iscobol.gui.client.zk.GuiFactoryImpl".equals(Config.a("iscobol.guifactory.class", "com.iscobol.gui.client.swing.GuiFactoryImpl"));
    }

    public static void handleIOException(IOException iOException) {
        throw new CommunicationException(iOException);
    }

    public static String removeLowValues(String string) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n2 = stringBuffer.toString().indexOf(0)) >= 0) {
            stringBuffer.deleteCharAt(n2);
        }
        return stringBuffer.toString();
    }

    public static String truncAtFirstLowValue(String string) {
        int n2 = string.indexOf(0);
        if (n2 >= 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static boolean isPrintableChar(char c2) {
        int n2 = new Character(c2).hashCode();
        return n2 >= 32 && n2 <= 126 || n2 >= 160 && n2 <= 255 || c2 == '\b' || n2 == 127;
    }

    public static int getMnemonicChar(StringBuffer stringBuffer) {
        int n2 = ScreenUtility.getMnemonicIdx(stringBuffer);
        return n2 >= 0 ? (int)stringBuffer.charAt(n2) : -1;
    }

    public static int getMnemonicIdx(StringBuffer stringBuffer) {
        int n2;
        block4: {
            int n3;
            block5: {
                n2 = -1;
                n3 = 0;
                if (stringBuffer == null || stringBuffer.toString() == null) break block4;
                if (!stringBuffer.toString().toUpperCase().startsWith("<HTML")) break block5;
                n3 = stringBuffer.indexOf("<u");
                if (n3 == -1) {
                    n3 = stringBuffer.indexOf("<U");
                }
                if (n3 < 0) break block4;
                n3 += 2;
                while (n3 < stringBuffer.length() && stringBuffer.charAt(n3) == ' ') {
                    ++n3;
                }
                if (n3 >= stringBuffer.length() || n3 + 1 >= stringBuffer.length() || stringBuffer.charAt(n3) != '>' || n2 >= 0) break block4;
                n2 = n3 + 1;
                break block4;
            }
            while ((n3 = ScreenUtility.indexOf(stringBuffer, '&', n3)) >= 0) {
                char c2;
                if (n3 + 1 < stringBuffer.length() && (c2 = stringBuffer.charAt(n3 + 1)) != '&' && n2 < 0) {
                    n2 = n3;
                }
                stringBuffer.deleteCharAt(n3);
                ++n3;
            }
        }
        return n2;
    }

    private static int calcDistance(int n2, int n3, Navigable navigable, boolean bl) {
        int n4 = -1;
        int n5 = -1;
        if (bl && navigable.getY() >= n3 || !bl && navigable.getY() <= n3 || !navigable.isValidRemoteControl() || !navigable.isInputField() || !navigable.controlPeerisEnabled() || !navigable.controlPeerisVisible() || !navigable.getActiveAccept() || navigable.isProtectedField()) {
            n5 = Integer.MAX_VALUE;
        } else {
            int n6 = navigable.getX() - n2;
            n5 = navigable.getY() - n3;
            if (n6 < 0) {
                n6 *= -1;
            }
            if (n5 < 0) {
                n5 *= -1;
            }
            n4 = (int)Math.sqrt(n6 * n6 + n5 * n5);
        }
        navigable.setDistance(n4, n5);
        return n5;
    }

    public static Navigable getUp(ArrayList arrayList, Navigable navigable, int n2, int n3) {
        Navigable navigable2 = null;
        Collections.sort(arrayList, new NavigableComparator(navigable, n2, n3, true));
        navigable2 = ScreenUtility.getClosest(arrayList);
        if (arrayList != null && arrayList.size() == 1 && (Navigable)arrayList.get(0) == navigable && navigable2 == navigable) {
            navigable2 = null;
        }
        return navigable2;
    }

    public static Navigable getDown(ArrayList arrayList, Navigable navigable, int n2, int n3) {
        Navigable navigable2 = null;
        Collections.sort(arrayList, new NavigableComparator(navigable, n2, n3, false));
        navigable2 = ScreenUtility.getClosest(arrayList);
        if (arrayList != null && arrayList.size() == 1 && (Navigable)arrayList.get(0) == navigable && navigable2 == navigable) {
            navigable2 = null;
        }
        return navigable2;
    }

    private static Navigable getClosest(ArrayList arrayList) {
        Navigable navigable = null;
        Navigable navigable2 = (Navigable)arrayList.get(0);
        if (navigable2 != null && navigable2.getDistanceY() < Integer.MAX_VALUE) {
            Navigable navigable3 = null;
            for (int i2 = 1; i2 < arrayList.size() && (navigable3 = (Navigable)arrayList.get(i2)) != null && navigable3.getY() == navigable2.getY(); ++i2) {
                if (navigable3.getDistance() >= navigable2.getDistance()) continue;
                navigable2 = navigable3;
            }
            navigable = navigable3 != null && navigable3.getY() == navigable2.getY() ? navigable3 : navigable2;
        }
        return navigable;
    }

    private static int indexOf(StringBuffer stringBuffer, char c2, int n2) {
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static Navigable stgetTransferFocusForward(Navigable navigable, boolean bl, boolean bl2, boolean bl3) {
        return ScreenUtility.stgetTransferFocusForward(navigable, null, null, bl, false, bl2, bl3);
    }

    public static Navigable stgetTransferFocusForward(Navigable navigable, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return ScreenUtility.stgetTransferFocusForward(navigable, null, null, bl, bl2, bl3, bl4);
    }

    public static Navigable stgetTransferFocusForward(Navigable navigable, Navigable navigable2, Navigable navigable3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Navigable navigable4;
        Navigable navigable5 = null;
        Navigable navigable6 = null;
        int n2 = 0;
        if (bl3 && navigable.getParentControlNV() != null && (navigable4 = ScreenUtility.getNextInGroupNV(navigable, navigable.getParentControlNV().getChildGraphics(), !bl4, bl3)) != navigable) {
            return navigable4;
        }
        if (!bl && navigable.isValidRemoteControl()) {
            if (navigable.isInputField() && navigable.controlPeerisEnabled() && navigable.controlPeerisVisible() && (bl4 || navigable.getActiveAccept()) && !navigable.isProtectedField() && (!bl3 || !navigable.getNoTab())) {
                navigable5 = navigable;
            }
        } else if (navigable.getChildGraphics() != null && navigable.getChildGraphics().size() > 0) {
            if (navigable2 != null) {
                for (n2 = 1; navigable2 != navigable6 && n2 <= navigable.getChildGraphics().size(); ++n2) {
                    navigable6 = (Navigable)navigable.getChildGraphics().getIdxElement(n2);
                }
            }
            while (navigable5 == null && n2 <= navigable.getChildGraphics().size()) {
                if (bl3 && navigable6 != null) {
                    n2 = ScreenUtility.getNextChildNV(navigable6, navigable.getChildGraphics(), n2);
                }
                if (n2 <= navigable.getChildGraphics().size() && (navigable6 = (Navigable)navigable.getChildGraphics().getIdxElement(n2)) != null && (navigable6.getControlPeerType() > 0 || navigable6.getControlPeerType() == 0 && navigable6.controlPeerisEnabledAttr() && navigable6.getChildGraphics() != null && navigable6.getChildGraphics().size() > 0 && (!navigable.getContainsChildCTRL() || navigable6.controlPeerisVisibleAttr()))) {
                    navigable5 = ScreenUtility.stgetTransferFocusForward(navigable6, false, bl3, bl4);
                }
                ++n2;
            }
            if (n2 >= navigable.getChildGraphics().size() + 1 && navigable5 == null) {
                if (navigable.getParentControlNV() != null) {
                    if (navigable3 != null && navigable.getParentControlNV() != navigable3) {
                        navigable5 = ScreenUtility.stgetTransferFocusForward(navigable.getParentControlNV(), navigable, navigable.getParentControlNV(), false, bl2, bl3, bl4);
                    }
                } else if (bl2 && navigable2 != null) {
                    navigable5 = ScreenUtility.stgetTransferFocusForward(navigable, false, bl2, bl3, bl4);
                } else if (bl2) {
                    // empty if block
                }
            }
        } else if (bl) {
            if (navigable.getParentControlNV() != null) {
                navigable5 = ScreenUtility.stgetTransferFocusForward(navigable.getParentControlNV(), navigable, navigable.getParentControlNV(), false, bl2, bl3, bl4);
            } else if (bl2) {
                navigable5 = ScreenUtility.stgetTransferFocusForward(navigable, false, bl3, bl4);
            }
        }
        return navigable5;
    }

    public static Navigable stgetTransferFocusBackward(Navigable navigable, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return ScreenUtility.stgetTransferFocusBackward(navigable, null, null, bl, bl2, bl3, bl4);
    }

    public static Navigable stgetTransferFocusBackward(Navigable navigable, boolean bl, boolean bl2, boolean bl3) {
        return ScreenUtility.stgetTransferFocusBackward(navigable, null, null, bl, false, bl2, bl3);
    }

    public static Navigable stgetTransferFocusBackward(Navigable navigable, Navigable navigable2, Navigable navigable3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Navigable navigable4;
        Navigable navigable5 = null;
        Navigable navigable6 = null;
        int n2 = 0;
        if (bl3 && navigable.getParentControlNV() != null && (navigable4 = ScreenUtility.getPrevInGroupNV(navigable, navigable.getParentControlNV().getChildGraphics(), !bl4, bl3)) != navigable) {
            return navigable4;
        }
        if (!bl && navigable.isValidRemoteControl()) {
            if (navigable.isInputField() && navigable.controlPeerisEnabled() && navigable.controlPeerisVisible() && (bl4 || navigable.getActiveAccept()) && !navigable.isProtectedField() && (!bl3 || !navigable.getNoTab())) {
                navigable5 = navigable;
            }
        } else if (navigable.getChildGraphics() != null && navigable.getChildGraphics().size() > 0) {
            if (navigable2 != null) {
                for (n2 = navigable.getChildGraphics().size(); navigable2 != navigable6 && n2 > 0; --n2) {
                    navigable6 = (Navigable)navigable.getChildGraphics().getIdxElement(n2);
                }
            }
            while (navigable5 == null && n2 > 0) {
                if (bl3 && navigable6 != null) {
                    n2 = ScreenUtility.getPrevChildNV(navigable6, navigable.getChildGraphics(), n2);
                }
                if (n2 > 0 && (navigable6 = (Navigable)navigable.getChildGraphics().getIdxElement(n2)) != null && (navigable6.getControlPeerType() > 0 || navigable6.getControlPeerType() == 0 && navigable6.controlPeerisEnabledAttr() && (!navigable.getContainsChildCTRL() || navigable6.controlPeerisVisibleAttr()))) {
                    navigable5 = ScreenUtility.stgetTransferFocusBackward(navigable6, false, bl2, bl3, bl4);
                }
                --n2;
            }
            if (n2 <= 0 && navigable5 == null) {
                if (navigable.getParentControlNV() != null) {
                    if (navigable3 != null && navigable.getParentControlNV() != navigable3) {
                        navigable5 = ScreenUtility.stgetTransferFocusBackward(navigable.getParentControlNV(), navigable, navigable.getParentControlNV(), false, bl2, bl3, bl4);
                    }
                } else if (bl2 && navigable2 != null) {
                    navigable5 = ScreenUtility.stgetTransferFocusBackward(navigable, false, bl2, bl3, bl4);
                } else if (bl2) {
                    // empty if block
                }
            }
        } else if (bl) {
            if (navigable.getParentControlNV() != null) {
                navigable5 = ScreenUtility.stgetTransferFocusBackward(navigable.getParentControlNV(), navigable, navigable.getParentControlNV(), false, bl2, bl3, bl4);
            } else if (bl2) {
                navigable5 = ScreenUtility.stgetTransferFocusBackward(navigable, false, bl2, bl3, bl4);
            }
        }
        return navigable5;
    }

    public static Navigable getNextInGroupNV(Navigable navigable, LocLinkedList locLinkedList, boolean bl, boolean bl2) {
        if (!navigable.hasNextInGroupNV()) {
            return navigable;
        }
        Navigable[] navigableArray = new Navigable[locLinkedList.size()];
        locLinkedList.toArray(navigableArray);
        int n2 = Integer.parseInt(navigable.getPropNV(103));
        int n3 = locLinkedList.indexOf(navigable);
        String string = null;
        for (int i2 = 0; navigableArray != null && i2 < navigableArray.length; ++i2) {
            if (!navigableArray[i2].hasNextInGroupNV() || !navigableArray[i2].controlPeerisEnabled() || !navigableArray[i2].controlPeerisVisible() || bl && !navigableArray[i2].getActiveAccept() || navigableArray[i2].getNoGroupTab() || navigableArray[i2].getNoTab() || Integer.parseInt(navigableArray[i2].getPropNV(103)) != n2 || (string = navigableArray[i2].getValueNV()) == null || !navigableArray[i2].haveSameGroupValue(string, navigableArray[i2].getControlValue())) continue;
            if (n3 >= 0 && i2 < n3) {
                return null;
            }
            return navigableArray[i2];
        }
        return navigable;
    }

    public static Navigable getPrevInGroupNV(Navigable navigable, LocLinkedList locLinkedList, boolean bl, boolean bl2) {
        if (!navigable.hasNextInGroupNV()) {
            return navigable;
        }
        if (!bl2) {
            return ScreenUtility.getNextInGroupNV(navigable, locLinkedList, bl, bl2);
        }
        Navigable[] navigableArray = new Navigable[locLinkedList.size()];
        locLinkedList.toArray(navigableArray);
        int n2 = Integer.parseInt(navigable.getPropNV(103));
        int n3 = locLinkedList.indexOf(navigable);
        String string = null;
        for (int i2 = navigableArray.length - 1; navigableArray != null && i2 >= 0; --i2) {
            if (!navigableArray[i2].hasNextInGroupNV() || !navigableArray[i2].controlPeerisEnabled() || !navigableArray[i2].controlPeerisVisible() || bl && !navigableArray[i2].getActiveAccept() || navigableArray[i2].getNoGroupTab() || navigableArray[i2].getNoTab() || Integer.parseInt(navigableArray[i2].getPropNV(103)) != n2 || (string = navigableArray[i2].getValueNV()) == null || !navigableArray[i2].haveSameGroupValue(string, navigableArray[i2].getControlValue())) continue;
            if (n3 >= 0 && n3 < i2) {
                return null;
            }
            return navigableArray[i2];
        }
        return navigable;
    }

    public static int getNextChildNV(Navigable navigable, LocLinkedList locLinkedList, int n2) {
        int n3;
        if (!navigable.hasNextInGroupNV()) {
            return n2;
        }
        if (navigable.getNoGroupTab()) {
            return n2;
        }
        Navigable navigable2 = null;
        int n4 = Integer.parseInt(navigable.getPropNV(103));
        int n5 = 1;
        for (n3 = n2; n3 <= locLinkedList.size() && (navigable2 = (Navigable)locLinkedList.getIdxElement(n3)) != null && navigable2.hasNextInGroupNV() && (n5 = Integer.parseInt(navigable2.getPropNV(103))) == n4; ++n3) {
        }
        return n3;
    }

    public static int getPrevChildNV(Navigable navigable, LocLinkedList locLinkedList, int n2) {
        int n3;
        if (!navigable.hasNextInGroupNV()) {
            return n2;
        }
        if (navigable.getNoGroupTab()) {
            return n2;
        }
        Navigable navigable2 = null;
        int n4 = Integer.parseInt(navigable.getPropNV(103));
        int n5 = 1;
        for (n3 = n2; n3 > 0 && (navigable2 = (Navigable)locLinkedList.getIdxElement(n3)) != null && navigable2.hasNextInGroupNV() && (n5 = Integer.parseInt(navigable2.getPropNV(103))) == n4; --n3) {
        }
        return n3;
    }

    public static String strreplaceAll(String string, String string2, String string3) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 != -1) {
            object = new StringBuffer(string);
            ((StringBuffer)object).replace(n2, n2 + string2.length(), string3);
            while ((n2 = string.lastIndexOf(string2, n2 - 1)) != -1) {
                ((StringBuffer)object).replace(n2, n2 + string2.length(), string3);
            }
            string = ((StringBuffer)object).toString();
        }
        if ((object = new StringTokenizer(string2, string2, true)) != null) {
            n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                if (!string4.equals("\n") && string.lastIndexOf(string4) > 0) {
                    string = ScreenUtility.strreplaceAll(string, string4, "");
                }
                ++n2;
            }
        }
        return string;
    }

    public static String createServerFont(int n2, InputStream inputStream) throws IOException {
        try {
            String string;
            Font font = Font.createFont(n2, inputStream);
            if (serverFonts == null) {
                serverFonts = new Hashtable();
            }
            if ((string = font.getFamily()) != null) {
                serverFonts.put(string, font);
            }
            return string;
        }
        catch (IOException iOException) {}
        catch (IllegalArgumentException illegalArgumentException) {}
        catch (Exception exception) {}
        finally {
            return null;
        }
    }

    public static Font getServerFont(Map map) {
        Font font;
        Font font2;
        String string;
        if (map == null) {
            map = Font.decode(null).getAttributes();
        }
        if ((string = (String)map.get(TextAttribute.FAMILY)) == null) {
            string = "";
        }
        if (!(font2 = Font.getFont(map)).getFamily().equalsIgnoreCase(string) && serverFonts != null && (font = (Font)serverFonts.get(string)) != null) {
            map.remove(TextAttribute.FAMILY);
            font2 = font.deriveFont(map);
        }
        return font2;
    }

    public static <T> int getInsertionIndex(Vector<T> vector, T t2, Comparator<T> comparator) {
        int n2 = 0;
        int n3 = vector.size() - 1;
        int n4 = n2 + (n3 - n2) / 2;
        while (n2 <= n3) {
            int n5 = comparator.compare(vector.elementAt(n4), t2);
            if (n5 == 0) {
                return n4;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
            } else {
                n2 = n4 + 1;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return n4;
    }

    public static Navigable stgetFirstInputField(Navigable navigable) {
        Navigable navigable2 = null;
        Navigable navigable3 = null;
        Enumeration enumeration = navigable.getParentControlNV().getChildGraphics().elements();
        while (navigable3 == null && enumeration.hasMoreElements()) {
            navigable2 = (Navigable)enumeration.nextElement();
            if (navigable2 == null || !navigable2.getActiveAccept() || !navigable2.isInputField()) continue;
            navigable3 = navigable2;
        }
        if (navigable3 == null) {
            navigable3 = navigable;
        }
        return navigable3;
    }

    public static Navigable stgetLastInputField(Navigable navigable) {
        int n2;
        Navigable navigable2 = null;
        Navigable navigable3 = null;
        for (int i2 = n2 = navigable.getParentControlNV().getChildGraphics().size(); navigable3 == null && i2 > 0; --i2) {
            navigable2 = (Navigable)navigable.getParentControlNV().getChildGraphics().getIdxElement(i2);
            if (navigable2 == null || !navigable2.getActiveAccept() || !navigable2.isInputField()) continue;
            navigable3 = navigable2;
        }
        if (navigable3 == null) {
            navigable3 = navigable;
        }
        return navigable3;
    }

    public static int desktop(String string, String string2) {
        Desktop.Action action;
        Desktop desktop;
        Logger logger = LoggerFactory.get(8);
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(action = Desktop.Action.valueOf(string))) {
            try {
                switch (action) {
                    case BROWSE: {
                        desktop.browse(new URI(string2));
                        break;
                    }
                    case EDIT: {
                        desktop.edit(new File(string2));
                        break;
                    }
                    case MAIL: {
                        desktop.mail(new URI(string2));
                        break;
                    }
                    case OPEN: {
                        desktop.open(new File(string2));
                        break;
                    }
                    case PRINT: {
                        desktop.print(new File(string2));
                        break;
                    }
                    default: {
                        if (logger == null) break;
                        logger.info("C$DESKTOP: errmsg=invalid operation!");
                    }
                }
                return 0;
            }
            catch (SecurityException securityException) {
                if (logger != null) {
                    logger.info("C$DESKTOP: errmsg=" + securityException.getMessage());
                }
                return -4;
            }
            catch (Exception exception) {
                if (logger != null) {
                    logger.info("C$DESKTOP: errmsg=" + exception.getMessage());
                }
                return -3;
            }
        }
        if (logger != null) {
            logger.info("C$DESKTOP: errmsg=desktop not supperted!");
        }
        return -1;
    }

    public static class NavigableComparator
    implements Comparator {
        Navigable current;
        boolean isup;
        int x;
        int y;

        public NavigableComparator(Navigable navigable, boolean bl) {
            this.current = navigable;
            this.isup = bl;
            if (navigable != null) {
                this.x = navigable.getX();
                this.y = navigable.getY();
            }
        }

        public NavigableComparator(Navigable navigable, int n2, int n3, boolean bl) {
            this.current = navigable;
            this.isup = bl;
            this.x = n2;
            this.y = n3;
        }

        public int compare(Object object, Object object2) {
            Navigable navigable = (Navigable)object;
            Navigable navigable2 = (Navigable)object2;
            int n2 = -1;
            int n3 = -1;
            n2 = ScreenUtility.calcDistance(this.x, this.y, navigable, this.isup);
            n3 = ScreenUtility.calcDistance(this.x, this.y, navigable2, this.isup);
            return n2 - n3;
        }
    }
}

