/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.ScreenUtility;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableImage
implements Serializable {
    private transient Image image;
    private static final long serialVersionUID = 11421251452614251L;

    public SerializableImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        ScreenUtility screenUtility = new ScreenUtility();
        Object object = pixelGrabber.getPixels();
        Dimension dimension = new Dimension(this.image.getWidth(screenUtility), this.image.getHeight(screenUtility));
        objectOutputStream.writeObject(dimension);
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            Dimension dimension = (Dimension)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            int[] nArray = (int[])object;
            this.image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(dimension.width, dimension.height, nArray, 0, dimension.width));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException();
        }
    }
}

