/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.client.ClientCallImpl;
import com.iscobol.gui.client.ClientHandler;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.RedirectException;
import com.iscobol.gui.client.UpdateException;
import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.interfaces.debugger.Appender;
import com.iscobol.interfaces.debugger.IDebuggerExtension2;
import com.iscobol.rts.ArrayTable;
import com.iscobol.rts.Config;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.Version;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.UIManager;

public class Client {
    private static final byte[] a = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 52};
    private static final byte[] b = new byte[]{72, 75, 74, 69, 67, 77, 71, 72, 67, 68, 70, 69, 66, 76, 65, 66, 77, 79, 65, 75, 68, 77, 67, 78, 74, 72, 67, 69, 78, 67, 75, 65, 66, 66, 67, 77, 80, 78, 77, 67, 72, 66, 66, 77, 79, 67, 69, 72, 72, 72, 70, 71, 68, 69, 70, 68, 79, 78, 74, 67, 73, 69, 75, 80, 66, 65, 73, 69, 70, 70};
    private static String u;
    private static String p;
    private static String webClient;
    private ArrayTable objectIds = new ArrayTable();
    private static final String eol;
    private static final String usage;
    private boolean noexit = false;
    private String[][] isconfig;
    private GuiFactory gf;
    private static boolean exiting;

    public static String[] login() {
        return new String[]{u, p};
    }

    public Client() {
    }

    public synchronized int setId(Object object) {
        return this.objectIds.put(object);
    }

    public Object getId(int n2) {
        try {
            return this.objectIds.get(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void delId(int n2) {
        try {
            this.objectIds.remove(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Vector getObjectsId() {
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = this.objectIds.length() - 1; i2 > 0; --i2) {
            Object object = this.objectIds.getObject(i2);
            if (object == null) continue;
            vector.add(object);
        }
        return vector;
    }

    public int getUniqueHandle(Object object) {
        return this.objectIds.getUniqueHandle(object);
    }

    public int getHandle(Object object) {
        return this.objectIds.getHandle(object);
    }

    public void debug() {
        System.out.println("<Client> debug start ---length [" + this.objectIds.length() + "]-----");
        for (int i2 = this.objectIds.length() - 1; i2 > 0; --i2) {
            Object object = this.objectIds.getObject(i2);
            if (object == null) continue;
            System.out.println("[" + i2 + "]=" + object);
        }
        System.out.println("<Client> debug end   ---length [" + this.objectIds.length() + "]-----");
    }

    public static void main(String[] stringArray) {
        ClientCallImpl.mainThread = Thread.currentThread();
        Client.clinit();
        new Client(stringArray);
    }

    public Client(String[][] stringArray, GuiFactory guiFactory) {
        this.gf = guiFactory;
        this.noexit = true;
        this.isconfig = stringArray;
    }

    public Client(String[] stringArray) {
        this.init(stringArray);
    }

    public static void clinit() {
        try {
            Properties properties = new Properties();
            properties.setProperty(RtsUtil.newUTFString(a), RtsUtil.newUTFString(b));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, "Client Static Configurations");
            byteArrayOutputStream.close();
            Config.a(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(String[] stringArray) {
        String[] stringArray2;
        Object object;
        Config.c();
        String string = null;
        String string2 = null;
        String string3 = null;
        Object object2 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = !GraphicsEnvironment.isHeadless();
        boolean bl5 = false;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        int n2 = 0;
        String string10 = null;
        if (bl4) {
            string10 = UIManager.getSystemLookAndFeelClassName();
        }
        String[] stringArray3 = new String[2];
        String[] stringArray4 = Config.a(new String[]{"iscobol.default_program", "iscobol.default_options"}, stringArray3);
        String string11 = stringArray4[0];
        String string12 = stringArray4[1];
        if (string12 != null) {
            object = RtsUtil.parseArguments(string12);
            String[] stringArray5 = new String[((String[])object).length + stringArray.length];
            System.arraycopy(object, 0, stringArray5, 0, ((String[])object).length);
            System.arraycopy(stringArray, 0, stringArray5, ((String[])object).length, stringArray.length);
            stringArray = stringArray5;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equalsIgnoreCase("-lc")) continue;
            if (!(((File)(object = new File(string4 = stringArray[++n2]))).exists() && ((File)object).isFile() && ((File)object).canRead())) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException(string4);
                ErrorBox.show(fileNotFoundException);
                System.exit(1);
            }
            System.setProperty("iscobol.conf", string4);
            boolean[] blArray = new boolean[]{string11 == null, string12 == null};
            if (!blArray[0] && !blArray[1]) break;
            String[] stringArray6 = new String[2];
            if (blArray[0]) {
                stringArray6[0] = "iscobol.default_program";
            }
            if (blArray[1]) {
                stringArray6[1] = "iscobol.default_options";
            }
            stringArray4 = Config.a(stringArray6, stringArray3);
            if (blArray[0]) {
                string11 = stringArray4[0];
            }
            if (!blArray[1] || (string12 = stringArray4[1]) == null) break;
            String[] stringArray7 = RtsUtil.parseArguments(string12);
            String[] stringArray8 = new String[stringArray7.length + stringArray.length];
            System.arraycopy(stringArray7, 0, stringArray8, 0, stringArray7.length);
            System.arraycopy(stringArray, 0, stringArray8, stringArray7.length, stringArray.length);
            stringArray = stringArray8;
            break;
        }
        KeyboardBuffer.clinit();
        try {
            block12: for (n2 = 0; n2 < stringArray.length && stringArray[n2].startsWith("-"); ++n2) {
                void var25_35;
                if (stringArray[n2].equalsIgnoreCase("-port")) {
                    string2 = stringArray[++n2];
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-hostname")) {
                    string = stringArray[++n2];
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-user")) {
                    string6 = stringArray[++n2];
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-password")) {
                    string7 = stringArray[++n2];
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-help")) {
                    SwingErrorBox.message("Help", usage, true);
                    System.exit(0);
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-v")) {
                    object = RuntimeProperties.getFullVersionNumber();
                    if (((String)object).startsWith("isCOBOL")) {
                        object = "isCOBOL-Client" + ((String)object).substring(7);
                    }
                    SwingErrorBox.message((String)object, Client.copyright(), true);
                    System.exit(0);
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-admin")) {
                    bl5 = true;
                    object2 = "ASA$GADMIN";
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-panel")) {
                    bl5 = true;
                    object2 = "ASA$GPANEL";
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-info")) {
                    bl4 = false;
                    object2 = "ASA$INFO";
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-kill")) {
                    bl4 = false;
                    bl2 = true;
                    object2 = "ASA$KILL";
                    string8 = stringArray[++n2];
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-c")) {
                    string3 = stringArray[++n2];
                    System.setProperty("iscobol.remote_conf", string3);
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-lc")) {
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-uc")) {
                    if (((File)(object = new File(string5 = stringArray[++n2]))).exists() && ((File)object).isFile() && ((File)object).canRead()) continue;
                    FileNotFoundException fileNotFoundException = new FileNotFoundException(string5);
                    ErrorBox.show(fileNotFoundException);
                    System.exit(1);
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-d")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-utility")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-web")) {
                    webClient = "true";
                    continue;
                }
                if (stringArray[n2].length() > 5 && stringArray[n2].toLowerCase().startsWith("-web=")) {
                    webClient = stringArray[n2].substring(5).toLowerCase();
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-nodisconnecterr")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-noupdate")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("--system")) {
                    if (!bl4) continue;
                    string10 = UIManager.getSystemLookAndFeelClassName();
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("--metal")) {
                    if (!bl4) continue;
                    string10 = UIManager.getCrossPlatformLookAndFeelClassName();
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("--nimbus")) {
                    if (!bl4) continue;
                    string10 = UIManager.getSystemLookAndFeelClassName();
                    object = UIManager.getInstalledLookAndFeels();
                    boolean bl6 = false;
                } else {
                    if (stringArray[n2].equalsIgnoreCase("--motif")) {
                        if (!bl4) continue;
                        string10 = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                        continue;
                    }
                    if (stringArray[n2].equalsIgnoreCase("--GTK")) {
                        if (!bl4) continue;
                        string10 = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                        continue;
                    }
                    if (stringArray[n2].equalsIgnoreCase("-debugport")) {
                        string9 = stringArray[++n2];
                        continue;
                    }
                    if (stringArray[n2].equalsIgnoreCase("--nolaf")) {
                        bl4 = false;
                        continue;
                    }
                    SwingErrorBox.message("Command line error: " + stringArray[n2], usage, false);
                    System.exit(0);
                    continue;
                }
                while (var25_35 < ((Object)object).length) {
                    if ("Nimbus".equals(((UIManager.LookAndFeelInfo)object[var25_35]).getName())) {
                        string10 = ((UIManager.LookAndFeelInfo)object[var25_35]).getClassName();
                        continue block12;
                    }
                    ++var25_35;
                }
            }
        }
        catch (Exception exception) {
            SwingErrorBox.message("Command line error: " + exception.getMessage(), exception);
            System.exit(0);
        }
        if (string3 == null) {
            string3 = Config.a("iscobol.remote_conf", null);
        }
        if (string == null) {
            string = Config.a("iscobol.hostname", "localhost");
        }
        if (string2 == null) {
            string2 = Config.a("iscobol.port", ClientHandler.getDefaultPort());
        }
        if (string9 == null) {
            string9 = Config.a("iscobol.debug.port", null);
        }
        if (string9 == null) {
            string9 = "0";
        }
        if (bl4 && System.getProperty("swing.defaultlaf") == null) {
            try {
                UIManager.setLookAndFeel(string10);
            }
            catch (Exception exception) {
                string10 = UIManager.getSystemLookAndFeelClassName();
                try {
                    UIManager.setLookAndFeel(string10);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        UIManager.getDefaults().put("Button.showMnemonics", Boolean.TRUE);
        if (object2 == null && n2 < stringArray.length) {
            object2 = stringArray[n2];
        }
        if (stringArray.length > ++n2) {
            stringArray2 = new String[stringArray.length - n2];
            System.arraycopy(stringArray, n2, stringArray2, 0, stringArray2.length);
        } else {
            stringArray2 = string8 != null ? new String[]{string8} : new String[]{};
        }
        if (object2 == null && string11 != null) {
            void var25_38;
            object = RtsUtil.parseArguments(string11);
            stringArray2 = new String[((Object)object).length - 1];
            object2 = object[0];
            boolean bl7 = false;
            while (var25_38 < stringArray2.length) {
                stringArray2[var25_38] = object[var25_38 + true];
                ++var25_38;
            }
        }
        if (object2 != null) {
            object2 = Factory.prepareCallName((String)object2);
        }
        if (string6 == null) {
            string6 = Config.a(".user.name", null);
        }
        if (string7 == null) {
            string7 = Config.a(".user.password", ".user.passwd", null);
        }
        u = string6;
        p = string7;
        if (bl3) {
            string5 = null;
        } else if (string5 == null) {
            string5 = "";
        }
        while (true) {
            try {
                new ClientHandler().init(string, string2, (String)object2, stringArray2, string3, this.noexit, string5, this.isconfig, bl2, new String[]{String.valueOf(bl), string9}, bl5, webClient, null, this.gf);
                return;
            }
            catch (RedirectException redirectException) {
                string = redirectException.host;
                string2 = redirectException.port;
                continue;
            }
            catch (UpdateException updateException) {
                try {
                    Factory.launchSoftwareUpdater(updateException.sw, updateException.propFileName, updateException.props, updateException.site, Client.class.getName(), stringArray, true);
                    return;
                }
                catch (Exception exception) {
                    SwingErrorBox.message(exception.getMessage(), exception);
                    if (this.noexit) return;
                    System.exit(4);
                    return;
                }
            }
            break;
        }
    }

    private static void addJavaArgs(Vector vector, boolean bl) {
        String string = System.getProperty("java.home");
        vector.addElement(string != null ? string + "/bin/java" : "java");
        String string2 = System.getProperty("java.class.path", "");
        if (string2.length() > 0) {
            vector.addElement("-classpath");
            vector.addElement(string2);
        }
        if (bl) {
            for (String string3 : new String[]{"iscobol.net.ssl.trust_store", "iscobol.net.ssl.trust_store_password"}) {
                String string4 = Config.a(string3, null);
                if (string4 == null || string4.length() <= 0) continue;
                vector.addElement("-D" + string3 + "=" + string4);
            }
        }
    }

    static int startDebugListener(String string, String string2, String string3) throws IOException {
        Vector<String> vector = new Vector<String>();
        Client.addJavaArgs(vector, true);
        vector.addElement("-Discobol.display_message=2");
        vector.addElement(Client.class.getName());
        vector.addElement("-noupdate");
        vector.addElement("-port");
        vector.addElement(string2);
        vector.addElement("-hostname");
        vector.addElement(string);
        vector.addElement("ASA$DEBUG_AUTO");
        vector.addElement("start");
        vector.addElement("1");
        vector.addElement(string3);
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        Process process = Runtime.getRuntime().exec(stringArray);
        final InputStream inputStream = process.getErrorStream();
        new Thread(){

            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        System.err.println(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        try {
            return process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return 0;
        }
    }

    static void stopDebugListener(String string, String string2) throws IOException {
        Vector<String> vector = new Vector<String>();
        Client.addJavaArgs(vector, true);
        vector.addElement("com.iscobol.gui.client.Client");
        vector.addElement("-port");
        vector.addElement(string2);
        vector.addElement("-hostname");
        vector.addElement(string);
        vector.addElement("ASA$DEBUG_AUTO");
        vector.addElement("stop");
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        Runtime.getRuntime().exec(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void startGraphDebugger(String string, String string2, boolean bl) throws IOException {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        Client.addJavaArgs(vector, false);
        vector.addAll(Factory.getJVMArguments());
        for (String string3 : new String[]{"iscobol.debug.code_prefix", "iscobol.debug.remote_source"}) {
            String string4 = Config.a(string3, null);
            if (string4 == null) continue;
            vector.addElement("-D" + string3 + "=" + string4);
        }
        vector.addElement("com.iscobol.debugger.GraphDebugger");
        vector.addElement("-r_notifyclient");
        vector.addElement(string);
        vector.addElement(string2);
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        final Process process = Runtime.getRuntime().exec(stringArray);
        final boolean[] blArray = new boolean[]{false};
        final InputStream inputStream = process.getInputStream();
        final InputStream inputStream2 = process.getErrorStream();
        final OutputStream outputStream = process.getOutputStream();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    inputStream.read();
                    boolean[] blArray2 = blArray;
                    synchronized (blArray) {
                        blArray[0] = true;
                        blArray.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                    return;
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        System.err.println(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        if (bl) {
            object2 = blArray;
            // MONITORENTER : blArray
            if (!blArray[0]) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : object2
        }
        object2 = null;
        File file = new File(System.getProperty("user.home") + File.separator + "isdebugger.properties");
        boolean bl2 = true;
        if (file.exists()) {
            object = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ((Properties)object).load(fileInputStream);
                fileInputStream.close();
                bl2 = "1".equals(((Properties)object).getProperty("graphdebugger.consoleattached", "1"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl2) {
            try {
                object2 = (IDebuggerExtension2)Class.forName("com.iscobol.debugger.DebuggerImpl").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object2 == null) return;
        object = System.out;
        System.setOut(object2.newDebugOutputStream(new Appender(){

            @Override
            public void appendLine(String string) {
                try {
                    outputStream.write((string + "\n").getBytes());
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }));
        new Thread((PrintStream)object){
            final /* synthetic */ PrintStream val$sysout;
            {
                this.val$sysout = printStream;
            }

            @Override
            public void run() {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.setOut(this.val$sysout);
            }
        }.start();
    }

    public static boolean isExiting() {
        return exiting;
    }

    public static void setExiting(boolean bl) {
        exiting = bl;
    }

    private static String copyright() {
        String string = "C/S Version " + Config.a(".runtime.cs.version", "c/s version unknown");
        String string2 = "F/S Version " + Config.a(".runtime.fs.version", "F/S version unknown");
        String string3 = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String string4 = RuntimeProperties.getFullVersionNumber();
        if (string4.startsWith("isCOBOL")) {
            string4 = "isCOBOL-Client" + string4.substring(7);
        }
        String string5 = RuntimeProperties.getProductCopyright();
        return string4 + eol + string5 + eol + string + ", " + string2 + ", UID Version " + Version.getUIDVersion() + eol + eol + "Java version:    " + string3 + eol + "                 " + System.getProperty("java.home");
    }

    public static boolean isWebClient() {
        return webClient != null;
    }

    static {
        eol = System.getProperty("line.separator", "\n");
        usage = "usage:" + eol + "<command> [--system | --metal | --motif | --GTK | --nimbus ] [-port n[,n2,...]] [-hostname host[,host2,...]] [-user user] [-password password] [-c conf-file] [-utility] [-noupdate] [-uc updater-conf-file] [-nodisconnecterr] progname [arg1 [arg2] ...]" + eol + "<command> -d [-debugport n] [-port n[,n2,...]] [-hostname host[,host2,...]] [-user user] [-password password] [-c conf-file] [-utility] [-noupdate] [-uc updater-conf-file] [-nodisconnecterr]" + eol + "          [-lc localconf-file] progname [arg1 [arg2] ...]" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-user user] [-password password] -admin" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-user user] [-password password] -info" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-user user] [-password password] -kill threadID|AS" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-user user] [-password password] -panel" + eol + "<command> -v";
    }
}

