/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.ClientCall;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Client;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.Memory;
import com.iscobol.rts.RuntimeEnvironmentType;
import com.iscobol.rts.RuntimeInfo;
import com.iscobol.rts_n.Factory;
import com.iscobol.types.CobolVar;
import com.iscobol.types_n.PicX;
import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class ClientCallImpl
extends UnicastRemoteObject
implements ClientCall {
    private static final long serialVersionUID = 22222222999999999L;
    static Thread mainThread;
    private AbstractGuiFactoryImpl clientContext;

    public ClientCallImpl() {
        this.setCallTimeout(0);
    }

    public ClientCallImpl(AbstractGuiFactoryImpl abstractGuiFactoryImpl) throws IOException {
        this();
        this.clientContext = abstractGuiFactoryImpl;
    }

    @Override
    public Object[] call(String string, Object[] objectArray, boolean bl, boolean bl2) throws IOException {
        Message message = new Message(() -> {
            try {
                return bl2 ? this.myCallCp(string, objectArray, bl) : this.myCall(string, objectArray, bl);
            }
            catch (IscobolRuntimeException iscobolRuntimeException) {
                return new Object[]{iscobolRuntimeException};
            }
            catch (Exception exception) {
                return new Object[]{new IscobolRuntimeException(exception)};
            }
        });
        this.clientContext.getCCMessageLoop().putMessage(message);
        message.waitFor();
        return (Object[])message.result;
    }

    private Object[] myCall(String string, Object[] objectArray, boolean bl) {
        int n2 = objectArray == null ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[n2 + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[i2] instanceof CobolVar && ((CobolVar)objectArray[i2]).isByVal()) continue;
            objectArray2[i2] = objectArray[i2];
        }
        try {
            objectArray2[i2] = com.iscobol.rts.Factory.call(string, null, objectArray, bl);
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            objectArray2[n2] = iscobolRuntimeException;
        }
        return objectArray2;
    }

    private Object[] myCallCp(String string, Object[] objectArray, boolean bl) {
        Object object;
        int n2;
        int n3 = objectArray == null ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[n3];
        Object[] objectArray3 = new Object[n3 + 1];
        for (n2 = 0; n2 < n3; ++n2) {
            if (objectArray[n2] instanceof CobolVar) {
                object = ((CobolVar)objectArray[n2]).getBytes();
                int n4 = ((byte[])object).length;
                Memory memory = Factory.getNotOptmzdMem(n4);
                objectArray2[n2] = new PicX(memory, 0, n4, null, null, null, false, false);
                ((PicX)objectArray2[n2]).set((byte[])object, 0, n4, false);
                continue;
            }
            objectArray2[n2] = objectArray[n2];
        }
        try {
            objectArray3[n3] = Factory.call(string, null, objectArray2, bl);
            if (objectArray3[n3] instanceof com.iscobol.types_n.CobolVar) {
                objectArray3[n3] = com.iscobol.rts.Factory.getNumLiteral(((com.iscobol.types_n.CobolVar)objectArray3[n3]).toint(), 18, 0, false);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (!(objectArray2[n2] instanceof com.iscobol.types_n.CobolVar) || ((CobolVar)objectArray[n2]).isByVal()) continue;
                object = (com.iscobol.types_n.CobolVar)objectArray2[n2];
                CobolVar cobolVar = (CobolVar)objectArray[n2];
                int n5 = Math.min(((com.iscobol.types_n.CobolVar)object).length(), cobolVar.length());
                cobolVar.set(((com.iscobol.types_n.CobolVar)object).getBytes(), 0, n5, true);
                objectArray3[n2] = cobolVar;
            }
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            objectArray3[n3] = iscobolRuntimeException;
        }
        return objectArray3;
    }

    @Override
    public void cancel(String string, boolean bl) throws IOException {
        Message message = new Message(() -> {
            if (bl) {
                Factory.cancel(string);
            } else {
                com.iscobol.rts.Factory.cancel(string);
            }
            return null;
        });
        this.clientContext.getCCMessageLoop().putMessage(message);
        message.waitFor();
    }

    @Override
    public void cancelAll(boolean bl) throws IOException {
        Message message = new Message(() -> {
            if (bl) {
                Factory.cancelAll();
            } else {
                com.iscobol.rts.Factory.cancelAll();
            }
            return null;
        });
        this.clientContext.getCCMessageLoop().putMessage(message);
        message.waitFor();
    }

    public static class MessageLoop
    extends Thread {
        LinkedList messageQueue = new LinkedList();

        MessageLoop() {
            this.setName(this.getClass().getName());
            this.setDaemon(true);
            if (mainThread != null) {
                IscobolSystem.duplicateEnv(mainThread, this);
                Config config = (Config)IscobolSystem.getIfExists(Config.class, mainThread);
                if (config != null) {
                    config.b();
                }
                mainThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeInfo.set(Client.isWebClient() ? RuntimeEnvironmentType.WEB_THIN_CLIENT_REMOTE : RuntimeEnvironmentType.THIN_CLIENT_REMOTE);
            while (true) {
                Runnable runnable = null;
                LinkedList linkedList = this.messageQueue;
                synchronized (linkedList) {
                    if (this.messageQueue.isEmpty()) {
                        try {
                            this.messageQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    try {
                        runnable = (Runnable)this.messageQueue.removeFirst();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                if (runnable == null) continue;
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putMessage(Runnable runnable) {
            LinkedList linkedList = this.messageQueue;
            synchronized (linkedList) {
                this.messageQueue.addLast(runnable);
                this.messageQueue.notify();
            }
        }
    }

    public static class Message
    implements Runnable {
        private boolean done = false;
        private final Supplier c;
        private Object result;

        public Message(Supplier supplier) {
            this.c = supplier;
        }

        @Override
        public void run() {
            this.result = this.c.get();
            this.done();
        }

        public synchronized Object getResult() {
            this.waitFor();
            return this.result;
        }

        public synchronized void done() {
            this.done = true;
            this.notify();
        }

        public synchronized void waitFor() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

