/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.concurrent.ConcurrentHashMap;

public abstract class IscobolLayout
implements LayoutManager2 {
    public static final int RESIZE_X = 1;
    public static final int MOVE_X = 2;
    public static final int NO_MIN_X = 4;
    public static final int RESIZE_Y = 16;
    public static final int MOVE_Y = 32;
    public static final int NO_MIN_Y = 64;
    public static final int RESIZE_X_ANY = 5;
    public static final int RESIZE_Y_ANY = 80;
    public static final int MOVE_X_ANY = 6;
    public static final int MOVE_Y_ANY = 96;
    public static final int RESIZE_BOTH = 17;
    public static final int RESIZE_BOTH_ANY = 85;
    public static final int MOVE_BOTH = 34;
    public static final int MOVE_BOTH_ANY = 102;
    protected Dimension origContainerSize;
    protected ConcurrentHashMap<Component, LayoutData> constraintsTable = new ConcurrentHashMap();
    private boolean layingOut;

    public IscobolLayout(Container container) {
        this.setOriginalContainerSize(container.getSize());
    }

    @Override
    public final void layoutContainer(Container container) {
        this.layingOut = true;
        try {
            if (this.origContainerSize == null) {
                this.setOriginalContainerSize(container.getSize());
            } else {
                this.layoutContainer(container.getSize());
            }
        }
        finally {
            this.layingOut = false;
        }
    }

    public boolean isLayingOut() {
        return this.layingOut;
    }

    protected abstract int getNewWidth(Rectangle var1);

    protected abstract int getNewHeight(Rectangle var1);

    protected abstract int getNewX(Rectangle var1);

    protected abstract int getNewY(Rectangle var1);

    protected void layoutContainer(Dimension dimension) {
        for (Component component : this.constraintsTable.keySet()) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            LayoutData layoutData = this.constraintsTable.get(component);
            boolean bl = (layoutData.getAction() & 4) == 4;
            boolean bl2 = (layoutData.getAction() & 0x40) == 64;
            Rectangle rectangle = component.getBounds();
            if ((layoutData.getAction() & 1) == 1) {
                n6 = this.getNewWidth(layoutData.getOrigBounds());
                n5 = bl ? layoutData.getMinWidth() : layoutData.getOrigBounds().width;
                n6 = Math.max(n5, Math.min(layoutData.getMaxWidth(), n6));
            } else {
                n6 = rectangle.width;
            }
            if ((layoutData.getAction() & 0x10) == 16) {
                n4 = this.getNewHeight(layoutData.getOrigBounds());
                n5 = bl2 ? layoutData.getMinHeight() : layoutData.getOrigBounds().height;
                n4 = Math.max(n5, Math.min(layoutData.getMaxHeight(), n4));
            } else {
                n4 = rectangle.height;
            }
            if ((layoutData.getAction() & 2) == 2) {
                n3 = this.getNewX(layoutData.getOrigBounds());
                n3 = !bl ? Math.max(layoutData.getOrigBounds().x, n3) : Math.max(0, n3);
            } else {
                n3 = rectangle.x;
            }
            if ((layoutData.getAction() & 0x20) == 32) {
                n2 = this.getNewY(layoutData.getOrigBounds());
                n2 = !bl2 ? Math.max(layoutData.getOrigBounds().y, n2) : Math.max(0, n2);
            } else {
                n2 = rectangle.y;
            }
            if (n6 == rectangle.width && n4 == rectangle.height && n3 == rectangle.x && n2 == rectangle.y) continue;
            component.setBounds(n3, n2, n6, n4);
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraintsTable.remove(component);
    }

    public void addLayoutComponent(Component component, LayoutData layoutData) {
        if (layoutData == null) {
            layoutData = this.createLayoutData(component, 0, 1, 0, 1, "0", null);
        }
        this.constraintsTable.put(component, layoutData);
    }

    public LayoutData getLayoutData(Component component) {
        return this.constraintsTable.get(component);
    }

    public Dimension getOriginalContainerSize() {
        return this.origContainerSize;
    }

    public void setOriginalContainerSize(Dimension dimension) {
        if (dimension != null && dimension.width > 0 && dimension.height > 0) {
            this.origContainerSize = dimension;
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = this.createLayoutData(component, 0, 1, 0, 1, "0", null);
        }
        if (!(object instanceof LayoutData)) {
            throw new IllegalArgumentException("LayoutData object required.");
        }
        this.constraintsTable.put(component, (LayoutData)object);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Rectangle rectangle = componentArray[i2].getBounds();
            n2 = Math.max(n2, rectangle.x + rectangle.width);
            n3 = Math.max(n3, rectangle.y + rectangle.height);
        }
        Dimension dimension = new Dimension(n2, n3);
        return dimension;
    }

    public LayoutData createLayoutData(Component component, int n2, int n3, int n4, int n5, String string, String string2) {
        return new DefaultLayoutData(component, n2, n3, n4, n5, string);
    }

    public boolean hasDefaultLayoutData(String string) {
        return false;
    }

    public String getDefaultLayoutDataString(String string) {
        return "0";
    }

    public int getAction(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static class DefaultLayoutData
    implements LayoutData {
        private int minHeight;
        private int maxHeight;
        private int minWidth;
        private int maxWidth;
        private Rectangle origBounds;
        private int action;

        public DefaultLayoutData(Component component, int n2, int n3, int n4, int n5, String string) {
            this(component, n2, n3, n4, n5, string, null);
        }

        public DefaultLayoutData(Component component, int n2, int n3, int n4, int n5, String string, String string2) {
            this.origBounds = component.getBounds();
            if (this.origBounds.width <= 0) {
                this.origBounds.width = component.getPreferredSize().width;
            }
            if (this.origBounds.height <= 0) {
                this.origBounds.height = component.getPreferredSize().height;
            }
            this.maxWidth = n2 <= 0 ? 1000000 : n2;
            this.minWidth = n3 < 1 ? 1 : n3;
            if (this.maxWidth < this.minWidth) {
                this.maxWidth = this.minWidth;
            }
            this.maxHeight = n4 <= 0 ? 1000000 : n4;
            this.minHeight = n5 < 1 ? 1 : n5;
            if (this.maxHeight < this.minHeight) {
                this.maxHeight = this.minHeight;
            }
            this.initialize(string, string2);
        }

        @Override
        public int getMinHeight() {
            return this.minHeight;
        }

        @Override
        public int getMaxHeight() {
            return this.maxHeight;
        }

        @Override
        public int getMinWidth() {
            return this.minWidth;
        }

        @Override
        public int getMaxWidth() {
            return this.maxWidth;
        }

        @Override
        public Rectangle getOrigBounds() {
            return this.origBounds != null ? new Rectangle(this.origBounds) : null;
        }

        @Override
        public int getAction() {
            return this.action;
        }

        @Override
        public void setMinHeight(int n2) {
            this.minHeight = n2;
        }

        @Override
        public void setMaxHeight(int n2) {
            this.maxHeight = n2;
        }

        @Override
        public void setMinWidth(int n2) {
            this.minWidth = n2;
        }

        @Override
        public void setMaxWidth(int n2) {
            this.maxWidth = n2;
        }

        @Override
        public void setOrigBounds(Rectangle rectangle) {
            if (rectangle != null) {
                this.origBounds = new Rectangle(rectangle);
            }
        }

        @Override
        public void setAction(int n2) {
            this.action = n2;
        }

        @Override
        public void setOrigLocation(int n2, int n3) {
            this.origBounds.x = n2;
            this.origBounds.y = n3;
        }

        @Override
        public void initialize(String string, String string2) {
            try {
                this.setAction(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static interface LayoutData {
        public int getMinHeight();

        public int getMaxHeight();

        public int getMinWidth();

        public int getMaxWidth();

        public Rectangle getOrigBounds();

        public int getAction();

        public void setMinHeight(int var1);

        public void setMaxHeight(int var1);

        public void setMinWidth(int var1);

        public void setMaxWidth(int var1);

        public void setOrigBounds(Rectangle var1);

        public void setAction(int var1);

        public void setOrigLocation(int var1, int var2);

        public void initialize(String var1, String var2);
    }
}

