/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.Hashtable;
import java.util.Map;

public abstract class LocalFontCmp {
    private Font font;
    private FontMetrics screenMetrics;
    private FontRenderContext frc;
    private float height;
    private float width;
    private float ascent;
    private float descent;
    private float leading;
    private int cellWidth;
    private int cellHeight;
    private boolean printer;
    protected AbstractGuiFactoryImpl gf;
    private boolean frompe;

    public LocalFontCmp() {
    }

    public LocalFontCmp(AbstractGuiFactoryImpl abstractGuiFactoryImpl, Hashtable hashtable, boolean bl) {
        this.gf = abstractGuiFactoryImpl;
        this.init(this.createFont(hashtable, bl), bl);
    }

    public LocalFontCmp(AbstractGuiFactoryImpl abstractGuiFactoryImpl, String string, int n2, float f2, boolean bl) {
        this.gf = abstractGuiFactoryImpl;
        this.init(this.createFont(string, n2, f2, bl), bl);
    }

    public LocalFontCmp(AbstractGuiFactoryImpl abstractGuiFactoryImpl, Font font) {
        this.gf = abstractGuiFactoryImpl;
        this.init(font, false);
    }

    public LocalFontCmp(AbstractGuiFactoryImpl abstractGuiFactoryImpl, Font font, boolean bl) {
        this.gf = abstractGuiFactoryImpl;
        this.init(font, bl);
    }

    private Font createFont(Hashtable hashtable, boolean bl) {
        Font font;
        hashtable = (Hashtable)hashtable.clone();
        if (!bl) {
            float f2 = ((Float)hashtable.get(FontAttribute.SIZE)).floatValue();
            if (f2 < 1.0f) {
                f2 = 12.0f;
            }
            float f3 = this.pix2pnt(f2);
            if (this.gf.shouldRoundFontSize()) {
                f3 = Math.round(f3);
            }
            hashtable.put(FontAttribute.SIZE, new Float(f3));
        }
        if ((font = this.gf.getAllFonts().get(hashtable)) == null) {
            try {
                font = this.intGetFont(hashtable);
                this.gf.getAllFonts().put(hashtable, font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return font;
    }

    public void addCreatedFont(Font font) {
        this.gf.getCreatedFonts().put(font.getFamily(), font);
    }

    public Font getCreatedFont(String string) {
        return this.gf.getCreatedFonts().get(string);
    }

    private Font createFont(String string, int n2, float f2, boolean bl) {
        Hashtable<FontAttribute, Object> hashtable = new Hashtable<FontAttribute, Object>();
        hashtable.put(FontAttribute.FAMILY, string);
        hashtable.put(FontAttribute.SIZE, new Float(f2));
        if ((n2 & 1) != 0) {
            hashtable.put(FontAttribute.WEIGHT, FontAttribute.WEIGHT_BOLD);
        }
        if ((n2 & 2) != 0) {
            hashtable.put(FontAttribute.POSTURE, FontAttribute.POSTURE_OBLIQUE);
        }
        return this.createFont(hashtable, bl);
    }

    private void init(Font font, boolean bl) {
        this.font = font;
        this.printer = bl;
        if (this.printer) {
            this.frc = new FontRenderContext(null, false, true);
            TextLayout textLayout = new TextLayout("0123456789", this.font, this.frc);
            this.width = textLayout.getAdvance() / 10.0f;
            this.height = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            this.ascent = textLayout.getAscent();
            this.descent = textLayout.getDescent();
            this.leading = textLayout.getLeading();
        } else {
            this.screenMetrics = new Label().getFontMetrics(this.font);
            this.width = this.screenMetrics.stringWidth("0123456789") / 10;
            this.height = this.screenMetrics.getHeight();
            this.ascent = this.screenMetrics.getAscent();
            this.descent = this.screenMetrics.getDescent();
            this.leading = this.screenMetrics.getLeading();
        }
        this.gf.getAllLocalFonts().addElement(this);
    }

    public float computeScreenSizes(String string) {
        if (string == null) {
            return 0.0f;
        }
        if (this.printer) {
            TextLayout textLayout = new TextLayout(string, this.font, this.frc);
            TextLayout textLayout2 = new TextLayout("0123456789", this.font, this.frc);
            return textLayout.getAdvance() * 10.0f / textLayout2.getAdvance();
        }
        if (this.screenMetrics != null) {
            return (float)this.screenMetrics.stringWidth(string) / this.width;
        }
        return string.length();
    }

    public int computeScreenWidth(String string) {
        if (string == null) {
            return 0;
        }
        if (this.printer) {
            return Math.round(new TextLayout(string, this.font, this.frc).getAdvance());
        }
        if (this.screenMetrics != null) {
            return this.screenMetrics.stringWidth(string);
        }
        return string.length();
    }

    public FontMetrics getFontMetrics() {
        return this.screenMetrics;
    }

    public float computeScreenWidth(float f2) {
        return Math.round(f2 * this.width);
    }

    public int getAscent() {
        return Math.round(this.ascent);
    }

    public int getDescent() {
        return Math.round(this.descent);
    }

    public int getLeading() {
        return Math.round(this.leading);
    }

    public Font getFont() {
        return this.font;
    }

    public int getHeight() {
        return Math.round(this.height);
    }

    public int getWidth() {
        return Math.round(this.width);
    }

    public Map getAttributes() {
        return this.font.getAttributes();
    }

    public String getFamily() {
        return this.font.getFamily();
    }

    public String getName() {
        return this.font.getName();
    }

    public int getSize() {
        if (this.printer) {
            return this.font.getSize();
        }
        return Math.round(this.pnt2pix(this.font.getSize()));
    }

    float pix2pnt(float f2) {
        return f2 * (float)this.gf.getScreenRes() / 72.0f;
    }

    float pnt2pix(float f2) {
        return f2 * 72.0f / (float)this.gf.getScreenRes();
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int n2) {
        this.cellWidth = n2;
        if (n2 > 0) {
            this.width = n2;
        }
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int n2) {
        this.cellHeight = n2;
        if (n2 > 0) {
            this.height = n2;
        }
    }

    public int getStyle() {
        return this.font.getStyle();
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isFixedPitch() {
        FontMetrics fontMetrics = new Label().getFontMetrics(this.font);
        return fontMetrics.charWidth('W') == fontMetrics.charWidth('i');
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    public boolean isPrinter() {
        return this.printer;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalFontCmp)) {
            return false;
        }
        LocalFontCmp localFontCmp = (LocalFontCmp)object;
        return LocalFontCmp.equals(this, localFontCmp.getName(), localFontCmp.getStyle(), localFontCmp.getSize());
    }

    public void setFrompe(boolean bl) {
        this.frompe = bl;
    }

    public boolean isFrompe() {
        return this.frompe;
    }

    public static boolean equals(LocalFontCmp localFontCmp, String string, int n2, int n3) {
        return localFontCmp.getName().equalsIgnoreCase(string) && localFontCmp.getStyle() == n2 && localFontCmp.getSize() == n3;
    }

    public abstract Font intGetFont(Hashtable var1);
}

