/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.ScreenUtility;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class LocalImage {
    private Image theImage;
    private byte[] imageBytes;
    private boolean lightGrayTransparent;
    private int type;
    private final int bitmapLoadMethod;

    public LocalImage(Image image, int n2, int n3) {
        this.theImage = image;
        this.type = n2;
        this.bitmapLoadMethod = n3;
    }

    public LocalImage(byte[] byArray, int n2, boolean bl, int n3) {
        this.imageBytes = byArray;
        this.type = n2;
        this.lightGrayTransparent = bl;
        this.bitmapLoadMethod = n3;
    }

    public Image getImage() {
        if (this.theImage == null && this.imageBytes != null) {
            this.theImage = ScreenUtility.createImage(this.imageBytes, new int[]{this.type}, true, this.lightGrayTransparent, this.bitmapLoadMethod);
            this.imageBytes = null;
        }
        return this.theImage;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        Image image = this.getImage();
        return image != null ? image.getWidth(null) : 0;
    }

    public int getHeight() {
        Image image = this.getImage();
        return image != null ? image.getHeight(null) : 0;
    }

    public byte[] save(String string, char c2, int n2, int n3, boolean bl) {
        String string2;
        Image image = this.getImage();
        if (image == null) {
            return new byte[0];
        }
        switch (c2) {
            case 'b': {
                string2 = "bmp";
                break;
            }
            case 'g': {
                string2 = "gif";
                break;
            }
            case 'j': {
                string2 = "jpg";
                break;
            }
            default: {
                string2 = "png";
            }
        }
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName(string2).next();
        Image image2 = image;
        JPEGImageWriteParam jPEGImageWriteParam = null;
        int n4 = 1;
        if ("jpg".equals(string2)) {
            jPEGImageWriteParam = new JPEGImageWriteParam(null);
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality((float)n2 / 100.0f);
        } else if ("png".equals(string2) || "gif".equals(string2)) {
            if (n3 >= 0) {
                image2 = ScreenUtility.makeColorTransparent(image2, n3);
            }
            n4 = 2;
        }
        try {
            ImageOutputStreamImpl imageOutputStreamImpl;
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (bl) {
                imageOutputStreamImpl = new FileImageOutputStream(new File(string));
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                imageOutputStreamImpl = new MemoryCacheImageOutputStream(byteArrayOutputStream);
            }
            imageWriter.setOutput(imageOutputStreamImpl);
            imageWriter.write(null, new IIOImage(LocalImage.getBufferedImage(image2, n4), null, null), jPEGImageWriteParam);
            imageOutputStreamImpl.close();
            imageWriter.dispose();
            if (bl) {
                return new byte[]{1};
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new byte[0];
        }
    }

    private static BufferedImage getBufferedImage(Image image, int n2) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker mediaTracker = new MediaTracker(new Component(){});
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

