/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.AppFactory;
import com.iscobol.gui.client.Client;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import java.io.IOException;
import java.util.prefs.Preferences;

public class MultitaskingClientHandler
extends AbstractServerRpcHandler {
    private String debugPort;
    private final MyServer server;

    public MultitaskingClientHandler(DualRpcServerDispatcher dualRpcServerDispatcher) {
        super(dualRpcServerDispatcher);
        this.server = (MyServer)dualRpcServerDispatcher.getDualRpcServer();
        this.getDispatcher().setCallbackHandler(this.server.cbh);
        RemoteRegistry.setClientCaller(new ClientCaller(this.getDispatcher()));
        Logger logger = LoggerFactory.get(64);
        Logger logger2 = LoggerFactory.get(128);
        RemoteRegistry.setClientProblemLogger(logger);
        RemoteRegistry.setClientRpcCallLogger(logger2);
    }

    public AppFactory getAppFactory() throws IOException {
        return this.server.af;
    }

    public void setDebugArgs(String string) throws IOException {
        this.debugPort = string;
        if (this.server.debugHost != null) {
            if (this.server.startGraphDebugger) {
                new Thread(() -> {
                    try {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Client.startGraphDebugger(this.server.debugHost, this.debugPort, false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }).start();
            } else {
                Preferences preferences = Preferences.userNodeForPackage(this.getClass()).node("debug");
                preferences.put("port", this.debugPort);
            }
        }
    }

    static class MyServer
    extends DualRpcServer {
        final String debugHost;
        final AppFactory af;
        final IServerCallbackHandler cbh;
        final boolean startGraphDebugger;

        MyServer(String string, int n2, boolean bl, Object object, String string2, AppFactory appFactory, IServerCallbackHandler iServerCallbackHandler, boolean bl2) {
            super(string, n2, bl, object);
            this.debugHost = string2;
            this.af = appFactory;
            this.cbh = iServerCallbackHandler;
            this.startGraphDebugger = bl2;
        }
    }
}

