/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import javax.swing.JColorChooser;
import javax.swing.JDialog;

public class RemotePalette
implements Constants {
    Color[] defaultColors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 128), new Color(0, 128, 0), new Color(0, 128, 128), new Color(128, 0, 0), new Color(128, 0, 128), new Color(128, 128, 0), new Color(192, 192, 192), new Color(128, 128, 128), new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255)};
    private static final int USER_GRAY_NUM = 7;
    private static final int USER_WHITE_NUM = 15;
    private static Color defaultUserGray;
    private static Color defaultUserWhite;
    public static final Color windowColor;
    public static final Color controlColor;
    public static final Color controlHighlightColor;
    private final AbstractGuiFactoryImpl gf;

    public RemotePalette() {
        this(null);
    }

    public RemotePalette(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        defaultUserGray = this.defaultColors[7];
        defaultUserWhite = this.defaultColors[15];
        this.gf = abstractGuiFactoryImpl;
    }

    public boolean setColor(int n2, int n3, int n4, int n5) {
        if (n2 >= 0 && n2 < this.defaultColors.length) {
            this.defaultColors[n2] = new Color(n3, n4, n5);
            return true;
        }
        return false;
    }

    public Color getColor(int n2) {
        if (n2 >= 0 && n2 < this.defaultColors.length) {
            return this.defaultColors[n2];
        }
        if (ColorCmp.isRGB(n2)) {
            return ColorCmp.getRGBColor(n2);
        }
        return null;
    }

    public void setUserGray(boolean bl) {
        this.defaultColors[7] = bl ? controlColor : defaultUserGray;
    }

    public void setUserWhite(boolean bl) {
        this.defaultColors[15] = bl ? windowColor : defaultUserWhite;
    }

    public Color chooseColor(int n2, int n3, int n4, int n5) {
        JColorChooser jColorChooser = new JColorChooser(new Color(n3, n4, n5));
        boolean[] blArray = new boolean[1];
        JDialog jDialog = JColorChooser.createDialog(null, null, true, jColorChooser, actionEvent -> {
            blArray[0] = true;
        }, null);
        if (this.gf != null && this.gf.getIcon() != null) {
            jDialog.setIconImage(this.gf.getIcon());
        }
        jDialog.setVisible(true);
        return blArray[0] ? jColorChooser.getColor() : null;
    }

    public boolean setUserColor(int n2, int n3) {
        if (n2 >= 0 && n2 < this.defaultColors.length) {
            switch (n3) {
                case 1: {
                    this.defaultColors[n2] = controlColor;
                    return true;
                }
                case 2: {
                    this.defaultColors[n2] = windowColor;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public Color getDefaultColor(int n2) {
        if (ColorCmp.isRGB(n2)) {
            return ColorCmp.getRGBColor(n2);
        }
        switch (n2) {
            case 16: {
                return windowColor;
            }
        }
        if (n2 < 0 || n2 >= this.defaultColors.length) {
            return null;
        }
        return this.defaultColors[n2];
    }

    public int getNumColors() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray.length > 0) {
            DisplayMode displayMode = graphicsDeviceArray[0].getDisplayMode();
            int n2 = displayMode.getBitDepth();
            if (n2 == -1) {
                n2 = 24;
            }
            return (int)Math.pow(2.0, n2);
        }
        return 0;
    }

    static {
        windowColor = SystemColor.window;
        controlColor = SystemColor.control;
        controlHighlightColor = SystemColor.controlHighlight;
    }
}

