/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.IscobolWindow;
import com.iscobol.rts.Config;
import java.awt.Component;
import java.awt.Container;
import java.awt.TextField;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class RemoteVirtualKeyboard
extends VirtualKeyboard {
    private static KeyEvent ENTER_KEY_EVENT;
    public static final int MOUSE_MOVED = 10001;
    public static final int LEFT_DOWN = 10002;
    public static final int LEFT_UP = 10003;
    public static final int LEFT_DOUBLE = 10004;
    public static final int MIDDLE_DOWN = 10005;
    public static final int MIDDLE_UP = 10006;
    public static final int MIDDLE_DOUBLE = 10007;
    public static final int RIGHT_DOWN = 10008;
    public static final int RIGHT_UP = 10009;
    public static final int RIGHT_DOUBLE = 10010;
    private VirtualKey vkEnter = new VirtualKey("enter", 18874381);
    private VirtualKey vkTab = new VirtualKey("tab", 35848201);
    private VirtualKey vkBcksp = new VirtualKey("backspace", 0x30C0000);
    private VirtualKey vkEnd = new VirtualKey("end", 0x4020000);
    private VirtualKey vkHome = new VirtualKey("home", 0x5010000);
    private VirtualKey vkInsert = new VirtualKey("insert", 0x60D0000);
    private VirtualKey vkDelete = new VirtualKey("delete", 0x70B0000);
    private VirtualKey vkHelp = new VirtualKey("help", 152043610);
    private VirtualKey vkLeft = new VirtualKey("left", 0xA090000);
    private VirtualKey vkRight = new VirtualKey("right", 0xB0A0000);
    private VirtualKey vkUp = new VirtualKey("up", 202637364);
    private VirtualKey vkDown = new VirtualKey("down", 219349045);
    private VirtualKey vkPageUp = new VirtualKey("pageup", 236388419);
    private VirtualKey vkPageDown = new VirtualKey("pagedown", 253231172);
    private VirtualKey vkF1 = new VirtualKey("f1", 0x10100001);
    private VirtualKey vkF2 = new VirtualKey("f2", 0x11100002);
    private VirtualKey vkF3 = new VirtualKey("f3", 303038467);
    private VirtualKey vkF4 = new VirtualKey("f4", 319815684);
    private VirtualKey vkF5 = new VirtualKey("f5", 336592901);
    private VirtualKey vkF6 = new VirtualKey("f6", 353370118);
    private VirtualKey vkF7 = new VirtualKey("f7", 370147335);
    private VirtualKey vkF8 = new VirtualKey("f8", 386924552);
    private VirtualKey vkF9 = new VirtualKey("f9", 403701769);
    private VirtualKey vkF10 = new VirtualKey("f10", 420478986);
    private VirtualKey vkF11 = new VirtualKey("f11", 437256203);
    private VirtualKey vkF12 = new VirtualKey("f12", 454033420);
    private VirtualKey vkEscape = new VirtualKey("escape", 605028379);
    private VirtualKey vkPause = new VirtualKey("pause", 621871103);
    private VirtualKey vkDivide = new VirtualKey("divide", 0x26000000);
    private VirtualKey vkMultiply = new VirtualKey("multiply", 0x27000000);
    private VirtualKey vkSubtract = new VirtualKey("subtract", 0x28000000);
    private VirtualKey vkAdd = new VirtualKey("add", 0x29000000);
    private VirtualKey vkDecimal = new VirtualKey("decimal", 0x2A000000);
    private VirtualKey vkNumpad0 = new VirtualKey("numpad0", 0x2B000000);
    private VirtualKey vkNumpad1 = new VirtualKey("numpad1", 0x2C000000);
    private VirtualKey vkNumpad2 = new VirtualKey("numpad2", 0x2D000000);
    private VirtualKey vkNumpad3 = new VirtualKey("numpad3", 0x2E000000);
    private VirtualKey vkNumpad4 = new VirtualKey("numpad4", 0x2F000000);
    private VirtualKey vkNumpad5 = new VirtualKey("numpad5", 0x30000000);
    private VirtualKey vkNumpad6 = new VirtualKey("numpad6", 0x31000000);
    private VirtualKey vkNumpad7 = new VirtualKey("numpad7", 0x32000000);
    private VirtualKey vkNumpad8 = new VirtualKey("numpad8", 0x33000000);
    private VirtualKey vkNumpad9 = new VirtualKey("numpad9", 0x34000000);
    private VirtualKey mMoved = new VirtualKey("mmov", 1058013264);
    private VirtualKey mLeftDown = new VirtualKey("mldw", 907018321);
    private VirtualKey mLeftUp = new VirtualKey("mlup", 923795538);
    private VirtualKey mLeftDouble = new VirtualKey("mldc", 940572755);
    private VirtualKey mMiddleDown = new VirtualKey("mmdw", 957349972);
    private VirtualKey mMiddleUp = new VirtualKey("mmup", 974127189);
    private VirtualKey mMiddleDouble = new VirtualKey("mmdc", 990904406);
    private VirtualKey mRightDown = new VirtualKey("mrdw", 1007681623);
    private VirtualKey mRightUp = new VirtualKey("mrup", 1024458840);
    private VirtualKey mRightDouble = new VirtualKey("mrdc", 1041236057);
    private VirtualKey[] mKeyArray = new VirtualKey[]{this.vkEnter, this.vkTab, this.vkBcksp, this.vkEnd, this.vkHome, this.vkInsert, this.vkDelete, new VirtualKey("clear", 0x80E0000), new VirtualKey("cl2end", 890175488), this.vkHelp, this.vkLeft, this.vkRight, this.vkUp, this.vkDown, this.vkPageUp, this.vkPageDown, this.vkF1, this.vkF2, this.vkF3, this.vkF4, this.vkF5, this.vkF6, this.vkF7, this.vkF8, this.vkF9, this.vkF10, this.vkF11, this.vkF12, new VirtualKey("f13", 470810637), new VirtualKey("f14", 487587854), new VirtualKey("f15", 504365071), new VirtualKey("f16", 0x1F100010), new VirtualKey("f17", 0x20100011), new VirtualKey("f18", 0x21100012), new VirtualKey("f19", 571473939), new VirtualKey("f20", 588251156), this.vkEscape, this.vkPause, this.vkDivide, this.vkMultiply, this.vkSubtract, this.vkAdd, this.vkDecimal, this.vkNumpad0, this.vkNumpad1, this.vkNumpad2, this.vkNumpad3, this.vkNumpad4, this.vkNumpad5, this.vkNumpad6, this.vkNumpad7, this.vkNumpad8, this.vkNumpad9, this.mMoved, this.mLeftDown, this.mLeftUp, this.mLeftDouble, this.mMiddleDown, this.mMiddleUp, this.mMiddleDouble, this.mRightDown, this.mRightUp, this.mRightDouble};
    private Hashtable mKeyHash;
    private Hashtable hotKeys;
    private Hashtable searchKeys;
    private VirtualKey[] letters;
    private VirtualKey[] digits;
    private int autoterminatedvalue;
    private AbstractGuiFactoryImpl gf;
    private boolean havepastemouse = false;
    private boolean havepastekey = false;

    public RemoteVirtualKeyboard(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        int n2;
        this.gf = abstractGuiFactoryImpl;
        this.vkTab.shift = new VirtualKey(this.vkTab.description, 262144);
        this.mKeyHash = new Hashtable(this.mKeyArray.length);
        for (n2 = this.mKeyArray.length - 1; n2 >= 0; --n2) {
            this.mKeyHash.put(this.mKeyArray[n2].description, this.mKeyArray[n2]);
        }
        this.modifyKey("decimal", "data=" + LOCALE_DECIMAL_SEPARATOR);
        this.hotKeys = new Hashtable();
        this.searchKeys = new Hashtable();
        this.letters = new VirtualKey[26];
        for (n2 = 0; n2 < 26; ++n2) {
            char c2 = (char)(65 + n2);
            this.letters[n2] = new VirtualKey(c2, true);
            this.letters[n2].ctrl = (this.letters[n2].shiftCtrl = new VirtualKey("" + c2, 0x100000 | n2 + 1));
        }
        this.digits = new VirtualKey[10];
        for (n2 = 0; n2 < 10; ++n2) {
            this.digits[n2] = new VirtualKey((char)(48 + n2), true);
        }
        this.modifyKey("*f", "searchdefault=print-preview,web-browser,grid,list-box,tree-view");
        this.modifyKey("mrdw", "paste_key");
    }

    private VirtualKey findKey(int n2) {
        switch (n2) {
            case 10: {
                return this.vkEnter;
            }
            case 9: {
                return this.vkTab;
            }
            case 8: {
                return this.vkBcksp;
            }
            case 35: {
                return this.vkEnd;
            }
            case 36: {
                return this.vkHome;
            }
            case 155: {
                return this.vkInsert;
            }
            case 127: {
                return this.vkDelete;
            }
            case 156: {
                return this.vkHelp;
            }
            case 37: 
            case 226: {
                return this.vkLeft;
            }
            case 39: 
            case 227: {
                return this.vkRight;
            }
            case 38: 
            case 224: {
                return this.vkUp;
            }
            case 40: 
            case 225: {
                return this.vkDown;
            }
            case 33: {
                return this.vkPageUp;
            }
            case 34: {
                return this.vkPageDown;
            }
            case 112: {
                return this.vkF1;
            }
            case 113: {
                return this.vkF2;
            }
            case 114: {
                return this.vkF3;
            }
            case 115: {
                return this.vkF4;
            }
            case 116: {
                return this.vkF5;
            }
            case 117: {
                return this.vkF6;
            }
            case 118: {
                return this.vkF7;
            }
            case 119: {
                return this.vkF8;
            }
            case 120: {
                return this.vkF9;
            }
            case 121: {
                return this.vkF10;
            }
            case 122: {
                return this.vkF11;
            }
            case 123: {
                return this.vkF12;
            }
            case 27: {
                return this.vkEscape;
            }
            case 19: {
                return this.vkPause;
            }
            case 111: {
                return this.vkDivide;
            }
            case 106: {
                return this.vkMultiply;
            }
            case 109: {
                return this.vkSubtract;
            }
            case 107: {
                return this.vkAdd;
            }
            case 110: {
                return this.vkDecimal;
            }
            case 96: {
                return this.vkNumpad0;
            }
            case 97: {
                return this.vkNumpad1;
            }
            case 98: {
                return this.vkNumpad2;
            }
            case 99: {
                return this.vkNumpad3;
            }
            case 100: {
                return this.vkNumpad4;
            }
            case 101: {
                return this.vkNumpad5;
            }
            case 102: {
                return this.vkNumpad6;
            }
            case 103: {
                return this.vkNumpad7;
            }
            case 104: {
                return this.vkNumpad8;
            }
            case 105: {
                return this.vkNumpad9;
            }
            case 10001: {
                return this.mMoved;
            }
            case 10002: {
                return this.mLeftDown;
            }
            case 10003: {
                return this.mLeftUp;
            }
            case 10004: {
                return this.mLeftDouble;
            }
            case 10005: {
                return this.mMiddleDown;
            }
            case 10006: {
                return this.mMiddleUp;
            }
            case 10007: {
                return this.mMiddleDouble;
            }
            case 10008: {
                return this.mRightDown;
            }
            case 10009: {
                return this.mRightUp;
            }
            case 10010: {
                return this.mRightDouble;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.letters[n2 - 65];
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.digits[n2 - 48];
            }
        }
        return null;
    }

    public boolean modifyKey(String string, String string2) {
        StringTokenizer stringTokenizer;
        String string3 = string;
        boolean bl = false;
        if (string.equals("kbd_auto_return")) {
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAutoTerminatedValue(n2);
            return true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        char c2 = string.charAt(0);
        if (c2 == '^' || c2 == '*' || c2 == '@') {
            if (c2 == '^') {
                bl3 = true;
            } else if (c2 == '*') {
                bl2 = true;
            } else {
                bl4 = true;
            }
            if (string.length() > 1 && (c2 = string.charAt(1)) == '^' || c2 == '*' || c2 == '@') {
                if (c2 == '^') {
                    bl3 = true;
                } else if (c2 == '*') {
                    bl2 = true;
                } else {
                    bl4 = true;
                }
                if (string.length() > 2 && (c2 = string.charAt(2)) == '^' || c2 == '*' || c2 == '@') {
                    if (c2 == '^') {
                        bl3 = true;
                    } else if (c2 == '*') {
                        bl2 = true;
                    } else {
                        bl4 = true;
                    }
                    string = string.substring(3);
                } else {
                    string = string.substring(2);
                }
            } else {
                string = string.substring(1);
            }
        }
        VirtualKey virtualKey = string.length() == 1 ? ((c2 = Character.toUpperCase(string.charAt(0))) >= 'A' && c2 <= 'Z' ? this.letters[c2 - 65] : (c2 >= '0' && c2 <= '9' ? this.digits[c2 - 48] : (VirtualKey)this.mKeyHash.get(string))) : (VirtualKey)this.mKeyHash.get(string);
        if (virtualKey != null) {
            if (bl2 || bl3 || bl4) {
                if (bl2 && bl3 && bl4) {
                    if (virtualKey.altShiftCtrl == null) {
                        virtualKey.altShiftCtrl = new VirtualKey(virtualKey.description, virtualKey.type);
                    }
                    virtualKey = virtualKey.altShiftCtrl;
                } else if (bl2 && bl3) {
                    if (virtualKey.shiftCtrl == null) {
                        virtualKey.shiftCtrl = new VirtualKey(virtualKey.description, virtualKey.type);
                    }
                    virtualKey = virtualKey.shiftCtrl;
                } else if (bl2 && bl4) {
                    if (virtualKey.altCtrl == null) {
                        virtualKey.altCtrl = new VirtualKey(virtualKey.description, virtualKey.type);
                    }
                    virtualKey = virtualKey.altCtrl;
                } else if (bl3 && bl4) {
                    if (virtualKey.altShift == null) {
                        virtualKey.altShift = new VirtualKey(virtualKey.description, virtualKey.type);
                    }
                    virtualKey = virtualKey.altShift;
                } else if (bl2) {
                    if (virtualKey.ctrl == null) {
                        virtualKey.ctrl = new VirtualKey(virtualKey.description, virtualKey.type);
                    }
                    virtualKey = virtualKey.ctrl;
                } else if (bl4) {
                    if (virtualKey.alt == null) {
                        virtualKey.alt = new VirtualKey(virtualKey.description, virtualKey.type);
                    }
                    virtualKey = virtualKey.alt;
                } else if (bl3) {
                    if (virtualKey.shift == null) {
                        virtualKey.shift = new VirtualKey(virtualKey.description, virtualKey.type);
                    }
                    virtualKey = virtualKey.shift;
                }
            }
            int n3 = virtualKey.type;
            Object object = virtualKey;
            ((VirtualKey)object).type = ((VirtualKey)object).type & 0xFF00FFFF;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            string2 = string2.toLowerCase();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                Object object2;
                String string4;
                object = stringTokenizer2.nextToken();
                String string5 = stringTokenizer3.nextToken();
                if (string5.startsWith("edit=")) {
                    if (string5.length() > 5) {
                        string4 = string5.substring(5);
                        if (string4.equals("first")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x10000;
                            continue;
                        }
                        if (string4.equals("last")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x20000;
                            continue;
                        }
                        if (string4.equals("next")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x30000;
                            continue;
                        }
                        if (string4.equals("previous")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x40000;
                            continue;
                        }
                        if (string4.equals("up")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x50000;
                            continue;
                        }
                        if (string4.equals("down")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x60000;
                            continue;
                        }
                        if (string4.equals("pageup")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x70000;
                            continue;
                        }
                        if (string4.equals("pagedown")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x80000;
                            continue;
                        }
                        if (string4.equals("left")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0x90000;
                            continue;
                        }
                        if (string4.equals("right")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0xA0000;
                            continue;
                        }
                        if (string4.equals("backspace")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0xC0000;
                            continue;
                        }
                        if (string4.equals("insert")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0xD0000;
                            continue;
                        }
                        if (string4.equals("delete")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0xB0000;
                            continue;
                        }
                        if (string4.equals("clear")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0xE0000;
                            continue;
                        }
                        if (string4.equals("cl2end")) {
                            virtualKey.type = virtualKey.type & 0xFFF0FFFF | 0xF0000;
                            continue;
                        }
                        if (!string4.equals("erase-all")) continue;
                        virtualKey.exttype = virtualKey.exttype & 0xFFF0FFFF | 0x10000;
                        virtualKey.type = n3;
                        continue;
                    }
                    virtualKey.type = virtualKey.type & 0xFFF0FFFF;
                    continue;
                }
                if (string5.startsWith("termination=")) {
                    if (string5.length() <= 12) continue;
                    string4 = string5.substring(12);
                    try {
                        int n4 = Integer.parseInt(string4);
                        if (n4 < 0) continue;
                        object2 = virtualKey;
                        ((VirtualKey)object2).type = ((VirtualKey)object2).type | 0x200000;
                        virtualKey.type = virtualKey.type & 0xFFFF0000 | n4;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string5.startsWith("exception=")) {
                    if (string5.length() <= 10) continue;
                    string4 = string5.substring(10);
                    try {
                        int n5 = Integer.parseInt(string4);
                        if (n5 < 0) continue;
                        object2 = virtualKey;
                        ((VirtualKey)object2).type = ((VirtualKey)object2).type | 0x100000;
                        virtualKey.type = virtualKey.type & 0xFFFF0000 | n5;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string5.startsWith("data=")) {
                    if (((String)object).length() <= 5) continue;
                    virtualKey.value = ((String)object).charAt(5);
                    continue;
                }
                if (string5.startsWith("invalid=")) {
                    if (string5.length() <= 8) continue;
                    string4 = string5.substring(8);
                    virtualKey.invalid = Config.c(string4);
                    continue;
                }
                if (string5.startsWith("hotkey=")) {
                    if (string5.length() > 7) {
                        virtualKey.type = virtualKey.type & 0xFF00FFFF | 0x400000;
                        this.hotKeys.put(this.getKey(virtualKey.type, bl3, bl2, bl4), ((String)object).substring(7));
                        continue;
                    }
                    virtualKey.type = virtualKey.type & 0xFF0FFFFF;
                    this.hotKeys.remove(this.getKey(virtualKey.type, bl3, bl2, bl4));
                    continue;
                }
                if (string5.startsWith("search=") || string5.startsWith("searchdefault=")) {
                    VirtualKeySearch virtualKeySearch = null;
                    object2 = null;
                    Vector vector = null;
                    Iterator iterator = null;
                    Iterator iterator2 = null;
                    boolean bl5 = false;
                    String string62 = "";
                    boolean bl6 = string5.startsWith("searchdefault=");
                    Set set = this.searchKeys.keySet();
                    int n6 = 7;
                    if (bl6) {
                        n6 = 14;
                    } else {
                        for (String string62 : set) {
                            vector = (Vector)this.searchKeys.get(string62);
                            if (vector == null || vector.size() <= 0 || (object2 = (VirtualKeySearch)vector.firstElement()) == null || !((VirtualKeySearch)object2).isDefaultValue()) continue;
                            vector.remove(0);
                        }
                    }
                    set = this.searchKeys.keySet();
                    String string7 = this.getKey(virtualKey.type, bl3, bl2, bl4);
                    virtualKey.value = c2;
                    virtualKeySearch = new VirtualKeySearch(virtualKey, string7, bl6, string, bl3, bl4, bl2);
                    iterator = set.iterator();
                    string62 = "";
                    while (iterator.hasNext()) {
                        string62 = (String)iterator.next();
                        vector = (Vector)this.searchKeys.get(string62);
                        if (vector == null) continue;
                        iterator2 = vector.iterator();
                        while (!bl && iterator2.hasNext()) {
                            object2 = (VirtualKeySearch)iterator2.next();
                            if (!((VirtualKeySearch)object2).equals(virtualKeySearch)) continue;
                            iterator2.remove();
                        }
                    }
                    if (string5.length() > n6) {
                        StringTokenizer stringTokenizer4 = new StringTokenizer(((String)object).substring(n6), ",");
                        while (stringTokenizer4.hasMoreTokens()) {
                            object = stringTokenizer4.nextToken();
                            vector = (Vector)this.searchKeys.get(object);
                            if (vector == null) {
                                vector = new Vector();
                                this.searchKeys.put(object, vector);
                            }
                            iterator = vector.iterator();
                            bl5 = false;
                            while (!bl5 && iterator.hasNext()) {
                                object2 = (VirtualKeySearch)iterator.next();
                                bl5 = ((VirtualKeySearch)object2).equals(virtualKeySearch);
                            }
                            if (bl5) continue;
                            vector.add(virtualKeySearch);
                        }
                    }
                    object2 = null;
                    set = this.searchKeys.keySet();
                    for (String string62 : set) {
                        vector = (Vector)this.searchKeys.get(string62);
                        if (vector == null) continue;
                        iterator2 = vector.iterator();
                        while (!bl && iterator2.hasNext()) {
                            object2 = (VirtualKeySearch)iterator2.next();
                        }
                    }
                    continue;
                }
                if (!string5.equals("paste_key")) continue;
                if (VirtualKeyboard.isMouseEvent(n3)) {
                    this.mRightDown.exttype = this.mRightDown.exttype & 0xFFFDFFFF;
                    this.havepastemouse = true;
                } else {
                    this.havepastekey = true;
                }
                virtualKey.exttype = virtualKey.exttype & 0xFFF0FFFF | 0x20000;
                virtualKey.type = n3;
            }
            bl = true;
        } else if (string2 != null && string2.equalsIgnoreCase("paste_key") && (stringTokenizer = new StringTokenizer(string3, ",")) != null && stringTokenizer.countTokens() > 1) {
            while (stringTokenizer.hasMoreTokens()) {
                this.modifyKey(stringTokenizer.nextToken(), string2);
            }
        }
        return bl;
    }

    private String getKey(int n2, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('^');
        }
        if (bl2) {
            stringBuffer.append('*');
        }
        if (bl3) {
            stringBuffer.append('@');
        }
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    private int mapKey(VirtualKey virtualKey, InputEvent inputEvent, boolean bl) {
        if (virtualKey.invalid) {
            return 0x300000;
        }
        if (!(bl && virtualKey.isLetterOrDigit || virtualKey.value == 0 || !(inputEvent instanceof KeyEvent))) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            keyEvent.setKeyChar((char)virtualKey.value);
            keyEvent.setKeyCode(virtualKey.value);
        }
        return virtualKey.type;
    }

    public int mapMouseEvent(MouseEvent mouseEvent, int n2) {
        return this.mapKey(mouseEvent, n2);
    }

    public int mapKey(KeyEvent keyEvent) {
        int n2 = this.mapKey(keyEvent, keyEvent.getKeyCode());
        switch (n2 & 0xF00000) {
            case 0x100000: 
            case 0x400000: {
                String string = null;
                switch (n2 & 0xFF000000) {
                    case 0x10000000: {
                        string = "f1";
                        break;
                    }
                    case 0x11000000: {
                        string = "f2";
                        break;
                    }
                    case 0x12000000: {
                        string = "f3";
                        break;
                    }
                    case 0x13000000: {
                        string = "f4";
                        break;
                    }
                    case 0x14000000: {
                        string = "f5";
                        break;
                    }
                    case 0x15000000: {
                        string = "f6";
                        break;
                    }
                    case 0x16000000: {
                        string = "f7";
                        break;
                    }
                    case 0x17000000: {
                        string = "f8";
                        break;
                    }
                    case 0x18000000: {
                        string = "f9";
                        break;
                    }
                    case 0x19000000: {
                        string = "f10";
                        break;
                    }
                    case 0x1A000000: {
                        string = "f11";
                        break;
                    }
                    case 0x1B000000: {
                        string = "f12";
                        break;
                    }
                    case 0x1C000000: {
                        string = "f13";
                        break;
                    }
                    case 0x1D000000: {
                        string = "f14";
                        break;
                    }
                    case 0x1E000000: {
                        string = "f15";
                        break;
                    }
                    case 0x1F000000: {
                        string = "f16";
                        break;
                    }
                    case 0x20000000: {
                        string = "f17";
                        break;
                    }
                    case 0x21000000: {
                        string = "f18";
                        break;
                    }
                    case 0x22000000: {
                        string = "f19";
                        break;
                    }
                    case 0x23000000: {
                        string = "f20";
                        break;
                    }
                }
                if (string == null) break;
                String string2 = "iscobol.key.";
                if (keyEvent.isShiftDown()) {
                    string2 = string2 + "^";
                }
                if (keyEvent.isControlDown()) {
                    string2 = string2 + "*";
                }
                if (keyEvent.isAltDown()) {
                    string2 = string2 + "@";
                }
                string2 = string2 + string;
                if ("iscobol.key.f10.system".equals(string2 = string2 + ".system")) {
                    if (this.hasMenuBar(keyEvent.getComponent())) {
                        if (this.gf == null || this.gf.getCsProperty().get(string2, true)) {
                            n2 = 0;
                            break;
                        }
                        keyEvent.consume();
                        break;
                    }
                    keyEvent.consume();
                    break;
                }
                if (!"iscobol.key.@f4.system".equals(string2)) break;
                if (this.gf == null || this.gf.getCsProperty().get(string2, true)) {
                    n2 = 0;
                    break;
                }
                keyEvent.consume();
                break;
            }
        }
        return n2;
    }

    private boolean hasMenuBar(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof IscobolWindow)) continue;
            return ((IscobolWindow)((Object)container)).hasMenuBar();
        }
        return false;
    }

    public int mapKey(InputEvent inputEvent, int n2) {
        VirtualKey virtualKey = this.findKey(n2);
        int n3 = virtualKey != null ? (inputEvent.isShiftDown() ? (inputEvent.isControlDown() ? (inputEvent.isAltDown() ? (virtualKey.altShiftCtrl != null ? this.mapKey(virtualKey.altShiftCtrl, inputEvent, false) : this.mapKey(virtualKey, inputEvent, true)) : (virtualKey.shiftCtrl != null ? this.mapKey(virtualKey.shiftCtrl, inputEvent, false) : this.mapKey(virtualKey, inputEvent, true))) : (inputEvent.isAltDown() ? (virtualKey.altShift != null ? this.mapKey(virtualKey.altShift, inputEvent, false) : this.mapKey(virtualKey, inputEvent, true)) : (virtualKey.shift != null ? this.mapKey(virtualKey.shift, inputEvent, false) : this.mapKey(virtualKey, inputEvent, true)))) : (inputEvent.isControlDown() ? (inputEvent.isAltDown() ? (virtualKey.altCtrl != null ? this.mapKey(virtualKey.altCtrl, inputEvent, false) : this.mapKey(virtualKey, inputEvent, true)) : (virtualKey.ctrl != null ? this.mapKey(virtualKey.ctrl, inputEvent, false) : this.mapKey(virtualKey, inputEvent, true))) : (inputEvent.isAltDown() ? (virtualKey.alt != null ? this.mapKey(virtualKey.alt, inputEvent, false) : this.mapKey(virtualKey, inputEvent, true)) : this.mapKey(virtualKey, inputEvent, true)))) : 0;
        return n3;
    }

    public int mapExtKey(KeyEvent keyEvent) {
        int n2 = 0;
        VirtualKey virtualKey = this.findKey(keyEvent.getKeyCode());
        if (virtualKey != null) {
            if (keyEvent.isShiftDown()) {
                if (keyEvent.isControlDown()) {
                    if (keyEvent.isAltDown()) {
                        if (virtualKey.altShiftCtrl != null) {
                            virtualKey = virtualKey.altShiftCtrl;
                        }
                    } else if (virtualKey.shiftCtrl != null) {
                        virtualKey = virtualKey.shiftCtrl;
                    }
                } else if (keyEvent.isAltDown()) {
                    if (virtualKey.altShift != null) {
                        virtualKey = virtualKey.altShift;
                    }
                } else if (virtualKey.shift != null) {
                    virtualKey = virtualKey.shift;
                }
            } else if (keyEvent.isControlDown()) {
                if (keyEvent.isAltDown()) {
                    if (virtualKey.altCtrl != null) {
                        virtualKey = virtualKey.altCtrl;
                    }
                } else if (virtualKey.ctrl != null) {
                    virtualKey = virtualKey.ctrl;
                }
            } else if (keyEvent.isAltDown() && virtualKey.alt != null) {
                virtualKey = virtualKey.alt;
            }
            n2 = virtualKey.exttype;
        }
        return n2;
    }

    public int mapMouseExtKey(MouseEvent mouseEvent, int n2) {
        int n3 = 0;
        VirtualKey virtualKey = this.findKey(n2);
        if (virtualKey != null) {
            n3 = virtualKey.exttype;
        }
        return n3;
    }

    public String toString(int n2) {
        return this.toString(n2, 0);
    }

    public String toString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n2 & 0xF00000) {
            case 0: {
                stringBuffer.append("data");
                break;
            }
            case 0x100000: {
                stringBuffer.append("exception=" + (n2 & 0xFFFF));
                break;
            }
            case 0x200000: {
                stringBuffer.append("termination=" + (n2 & 0xFFFF));
                break;
            }
            case 0x300000: {
                stringBuffer.append("invalid");
                break;
            }
            case 0x400000: {
                stringBuffer.append("hotkey");
                break;
            }
            default: {
                stringBuffer.append("" + (n2 & 0xF00000) + "," + (n2 & 0xFFFF));
            }
        }
        stringBuffer.append(", edit=");
        switch (n2 & 0xF0000) {
            case 0: {
                if ((n3 & 0xF0000) == 65536) {
                    stringBuffer.append("erase-all");
                    break;
                }
                if ((n3 & 0xF0000) == 131072) {
                    stringBuffer.append("paste_key");
                    break;
                }
                stringBuffer.append("null");
                break;
            }
            case 65536: {
                stringBuffer.append("first");
                break;
            }
            case 131072: {
                stringBuffer.append("last");
                break;
            }
            case 196608: {
                stringBuffer.append("next");
                break;
            }
            case 262144: {
                stringBuffer.append("prev");
                break;
            }
            case 983040: {
                stringBuffer.append("" + (n2 & 0xF0000));
            }
        }
        return stringBuffer.toString();
    }

    public String getHotKey(int n2, boolean bl, boolean bl2, boolean bl3) {
        return (String)this.hotKeys.get(this.getKey(n2, bl, bl2, bl3));
    }

    public boolean isSearchKey(int n2, boolean bl, boolean bl2, boolean bl3, String string) {
        boolean bl4 = false;
        if (n2 != 0) {
            Object object;
            VirtualKey virtualKey = null;
            if (n2 >= 65 && n2 <= 90) {
                virtualKey = this.letters[n2 - 65];
            }
            if (virtualKey != null) {
                object = virtualKey;
                ((VirtualKey)object).type = ((VirtualKey)object).type & 0xFF00FFFF;
                virtualKey.value = n2;
            }
            object = this.getKey(virtualKey != null ? virtualKey.type : n2, bl, bl2, bl3);
            VirtualKeySearch virtualKeySearch = null;
            virtualKeySearch = new VirtualKeySearch(virtualKey, (String)object, false, new Integer(n2).toString(), bl, bl3, bl2);
            VirtualKeySearch virtualKeySearch2 = null;
            Vector vector = (Vector)this.searchKeys.get(string);
            if (vector != null) {
                Iterator iterator = vector.iterator();
                while (!bl4 && iterator.hasNext()) {
                    virtualKeySearch2 = (VirtualKeySearch)iterator.next();
                    bl4 = virtualKeySearch2.equals(virtualKeySearch);
                }
            }
        }
        return bl4;
    }

    public int[] getSearchChars(String string) {
        int[] nArray = null;
        VirtualKeySearch virtualKeySearch = null;
        Vector vector = (Vector)this.searchKeys.get(string);
        if (vector != null && vector.size() > 0) {
            nArray = new int[vector.size()];
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                virtualKeySearch = (VirtualKeySearch)vector.elementAt(i2);
                if (virtualKeySearch == null) continue;
                nArray[i2] = virtualKeySearch.getValue();
            }
        }
        return nArray;
    }

    public int[] getSearchMasks(String string) {
        int[] nArray = null;
        VirtualKeySearch virtualKeySearch = null;
        Vector vector = (Vector)this.searchKeys.get(string);
        if (vector != null && vector.size() > 0) {
            nArray = new int[vector.size()];
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                virtualKeySearch = (VirtualKeySearch)vector.elementAt(i2);
                if (virtualKeySearch == null) continue;
                if (virtualKeySearch.isControlDown()) {
                    int n2 = i2;
                    nArray[n2] = nArray[n2] + 128;
                }
                if (virtualKeySearch.isAltDown()) {
                    int n3 = i2;
                    nArray[n3] = nArray[n3] + 512;
                }
                if (!virtualKeySearch.isShiftDown()) continue;
                int n4 = i2;
                nArray[n4] = nArray[n4] + 64;
            }
        }
        return nArray;
    }

    public int getAutoTerminated() {
        return 0x230000 | this.autoterminatedvalue;
    }

    public void setAutoTerminatedValue(int n2) {
        this.autoterminatedvalue = n2;
    }

    private static KeyEvent getEKE() {
        if (ENTER_KEY_EVENT == null) {
            ENTER_KEY_EVENT = new KeyEvent(new TextField(), 401, System.currentTimeMillis(), 0, 10, '\uffff');
        }
        return ENTER_KEY_EVENT;
    }

    public boolean isPushButtonActivatedByEnter() {
        if (this.gf.getCsProperty().get("iscobol.gui.push_activated_by_enter", false)) {
            return true;
        }
        int n2 = this.mapKey(RemoteVirtualKeyboard.getEKE());
        return RemoteVirtualKeyboard.isTermination(n2) && RemoteVirtualKeyboard.termination(n2) == 13;
    }

    public boolean havePasteKey() {
        return this.havepastekey;
    }

    public boolean havePasteMouse() {
        return this.havepastemouse;
    }

    private void debug(VirtualKey virtualKey, String string) {
        if (virtualKey != null) {
            System.out.println(string + " type [" + virtualKey.type + "] exttype [" + virtualKey.exttype + "] shift [" + virtualKey.shift + "] ctrl [" + virtualKey.ctrl + "] shiftctrl [" + virtualKey.shiftCtrl + "] alt [" + virtualKey.alt + "] altshift [" + virtualKey.altShift + "] atctrl [" + virtualKey.altCtrl + "] altshiftctrl [" + virtualKey.altShiftCtrl + "] value [" + virtualKey.value + "]");
        }
    }

    private class VirtualKeySearch {
        private VirtualKey vk;
        boolean defaultvalue;
        String name;
        String getkey;
        boolean shift;
        boolean alt;
        boolean control;

        VirtualKeySearch(VirtualKey virtualKey, String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4) {
            this.vk = virtualKey;
            this.defaultvalue = bl;
            this.name = string2;
            this.getkey = string;
            this.shift = bl2;
            this.alt = bl3;
            this.control = bl4;
        }

        public String getGetkey() {
            return this.getkey;
        }

        public boolean isShiftDown() {
            return this.shift;
        }

        public boolean isAltDown() {
            return this.alt;
        }

        public boolean isControlDown() {
            return this.control;
        }

        public boolean isDefaultValue() {
            return this.defaultvalue;
        }

        public int getValue() {
            if (this.vk != null) {
                return this.vk.getValue();
            }
            return 0;
        }

        public boolean equals(VirtualKeySearch virtualKeySearch) {
            if (virtualKeySearch != null) {
                return this.shift == virtualKeySearch.isShiftDown() && this.alt == virtualKeySearch.isAltDown() && this.control == virtualKeySearch.isControlDown() && (this.vk != null && this.vk.getValue() == virtualKeySearch.getValue() || this.vk == null && this.getkey.equals(virtualKeySearch.getGetkey()));
            }
            return false;
        }

        public String toString() {
            return "==>VKS: [" + this.name + "] [" + this.defaultvalue + "] [" + this.getkey + "] shift [" + this.shift + "] alt [" + this.alt + "] ctrl [" + this.control + "] value [" + this.getValue() + "]";
        }
    }

    public class VirtualKey {
        private String description;
        private int value;
        private int type;
        private int exttype;
        private boolean invalid;
        private final boolean isLetterOrDigit;
        private VirtualKey shift;
        private VirtualKey ctrl;
        private VirtualKey shiftCtrl;
        private VirtualKey alt;
        private VirtualKey altShift;
        private VirtualKey altCtrl;
        private VirtualKey altShiftCtrl;

        private VirtualKey(String string, int n2, int n3) {
            this.description = string;
            this.type = n2;
            this.exttype = n3;
            this.isLetterOrDigit = false;
        }

        private VirtualKey(String string, int n2) {
            this(string, n2, 0);
        }

        private VirtualKey(char c2, boolean bl) {
            this.description = "" + c2;
            this.type = 0 | (c2 << 24 | Integer.MIN_VALUE) & 0xFF000000;
            this.value = c2;
            this.isLetterOrDigit = bl;
        }

        public void setExtendedType(int n2) {
            this.exttype = n2;
        }

        public int getExtendedType() {
            return this.exttype;
        }

        public int getValue() {
            return this.value;
        }
    }
}

