/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.client.IRemoteBaseGUIWindow;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.ScaleLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ResponsiveLayout
extends ScaleLayout {
    private static final Component DEF_CMP = new Label();
    private static final Map<String, Integer> scaleConstants = new HashMap<String, Integer>();
    private final IRemoteBaseGUIWindow parentWindow;
    private List<Format> formats = new ArrayList<Format>();

    public ResponsiveLayout(Container container) {
        this(container, null, null);
    }

    public ResponsiveLayout(Container container, String string, IRemoteBaseGUIWindow iRemoteBaseGUIWindow) {
        super(container, ResponsiveLayout.getScaleLayoutDefaults(string));
        this.parentWindow = iRemoteBaseGUIWindow;
        if (string != null) {
            Object object;
            int n2 = string.indexOf(59);
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                object = new StringTokenizer(string2);
                float f2 = 1.0f;
                String string3 = ((StringTokenizer)object).nextToken().trim();
                boolean bl = true;
                n2 = string3.indexOf(61);
                if (n2 > 0) {
                    if (n2 < string3.length() - 1) {
                        try {
                            f2 = ResponsiveLayout.parseFloat(string3.substring(n2 + 1)).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    string3 = string3.substring(0, n2);
                    bl = !((StringTokenizer)object).hasMoreTokens() || "cells".equalsIgnoreCase(((StringTokenizer)object).nextToken().trim());
                }
                boolean bl2 = false;
                Format format = new Format(string3.toLowerCase(), f2, bl);
                for (int i2 = 0; i2 < this.formats.size(); ++i2) {
                    Format format2 = this.formats.get(i2);
                    if (format2.name.equalsIgnoreCase(format.name)) {
                        throw new IllegalArgumentException("Duplicate format name: '" + string3 + "'");
                    }
                    int n3 = format2.getMinWidth() - format.getMinWidth();
                    if (n3 == 0) {
                        throw new IllegalArgumentException("Duplicate format minimun width: " + f2 + (bl ? " cells" : ""));
                    }
                    if (bl2 || n3 <= 0) continue;
                    this.formats.add(i2, format);
                    bl2 = true;
                }
                if (bl2) continue;
                this.formats.add(format);
            }
            if (this.formats.size() > 0) {
                object = this.formats.get(0);
                ((Format)object).firstLimit = ((Format)object).minWidth;
                ((Format)object).minWidth = 1.0f;
            }
        }
    }

    @Override
    public IscobolLayout.LayoutData createLayoutData(Component component, int n2, int n3, int n4, int n5, String string, String string2) {
        return new ResponsiveLayoutData(component, n2, n3, n4, n5, string, string2);
    }

    @Override
    public int getAction(String string) {
        return new ResponsiveLayoutData(string).getAction();
    }

    @Override
    public String getDefaultLayoutDataString(String string) {
        int n2 = Integer.parseInt(super.getDefaultLayoutDataString(string));
        String string2 = "";
        if ((n2 & 1) == 1) {
            string2 = string2 + "resize-x ";
        }
        if ((n2 & 2) == 2) {
            string2 = string2 + "move-x ";
        }
        if ((n2 & 4) == 4) {
            string2 = string2 + "no-min-x ";
        }
        if ((n2 & 0x10) == 16) {
            string2 = string2 + "resize-y ";
        }
        if ((n2 & 0x20) == 32) {
            string2 = string2 + "move-y ";
        }
        if ((n2 & 0x40) == 64) {
            string2 = string2 + "no-min-y ";
        }
        return string2;
    }

    @Override
    protected void layoutContainer(Dimension dimension) {
        Format format = this.getCurrentFormat(dimension);
        this.containerWidthDelta = (float)dimension.width / (float)this.origContainerSize.width;
        this.containerHeightDelta = (float)dimension.height / (float)this.origContainerSize.height;
        int n2 = 1;
        if (format != null) {
            int n3 = format.getMinWidth();
            if (n3 > 1) {
                n2 = n3;
            } else {
                n3 = format.getFirstLimit();
                if (n3 > 1 && dimension.width > n3) {
                    n2 = n3;
                }
            }
        }
        float f2 = n2 > 1 ? (float)dimension.width / (float)n2 : 1.0f;
        for (Component component : this.constraintsTable.keySet()) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            float f3;
            int n10;
            ResponsiveLayoutData responsiveLayoutData = (ResponsiveLayoutData)this.constraintsTable.get(component);
            if (responsiveLayoutData.noActions) continue;
            Bounds bounds = null;
            if (format != null) {
                bounds = responsiveLayoutData.getFormatBounds(format.name);
            }
            if (bounds == null) {
                bounds = new Bounds();
            }
            if (bounds.visible == Boolean.FALSE) {
                component.setVisible(false);
            } else {
                component.setVisible(responsiveLayoutData.origVisible);
            }
            int n11 = bounds.action > 0 ? bounds.action : (bounds.action == -1 ? 0 : responsiveLayoutData.getAction());
            boolean bl = (n11 & 4) == 4;
            boolean bl2 = (n11 & 0x40) == 64;
            boolean bl3 = (n11 & 1) == 1;
            boolean bl4 = (n11 & 0x10) == 16;
            boolean bl5 = (n11 & 2) == 2;
            boolean bl6 = (n11 & 0x20) == 32;
            Rectangle rectangle = component.getBounds();
            Rectangle rectangle2 = responsiveLayoutData.getOrigBounds();
            if (bounds.x != null) {
                n10 = bounds.getValue(bounds.x, bounds.cx, true, 0);
                f3 = f2;
            } else {
                n10 = rectangle2.x;
                f3 = this.containerWidthDelta;
            }
            if (bl5) {
                n9 = (int)((float)n10 * f3);
                n9 = !bl ? Math.max(n10, n9) : Math.max(0, n9);
            } else {
                n9 = n10;
            }
            if (bounds.w != null) {
                n8 = bounds.getValue(bounds.w, bounds.cw, true, 0);
                f3 = f2;
            } else {
                n8 = rectangle2.width;
                f3 = this.containerWidthDelta;
            }
            if (bl3) {
                n7 = (int)((float)n8 * f3);
                n6 = bl ? responsiveLayoutData.getMinWidth() : n8;
                n7 = Math.max(n6, Math.min(responsiveLayoutData.getMaxWidth(), n7));
            } else {
                n7 = n8;
            }
            f3 = this.containerHeightDelta;
            int n12 = bounds.y != null ? bounds.getValue(bounds.y, bounds.cy, false, 0) : rectangle2.y;
            if (bl6) {
                n5 = (int)((float)n12 * f3);
                n5 = !bl2 ? Math.max(n12, n5) : Math.max(0, n5);
            } else {
                n5 = n12;
            }
            int n13 = bounds.h != null ? bounds.getValue(bounds.h, bounds.ch, false, 0) : rectangle2.height;
            if (bl4) {
                n4 = (int)((float)n13 * f3);
                n6 = bl2 ? responsiveLayoutData.getMinHeight() : n13;
                n4 = Math.max(n6, Math.min(responsiveLayoutData.getMaxHeight(), n4));
            } else {
                n4 = n13;
            }
            if (n7 == rectangle.width && n4 == rectangle.height && n9 == rectangle.x && n5 == rectangle.y) continue;
            component.setBounds(n9, n5, n7, n4);
        }
    }

    private Format getCurrentFormat(Dimension dimension) {
        Format format = null;
        for (int i2 = this.formats.size() - 1; i2 >= 0; --i2) {
            int n2 = this.formats.get(i2).getMinWidth();
            if (n2 > dimension.width) continue;
            format = this.formats.get(i2);
            break;
        }
        return format;
    }

    private static String getScaleLayoutDefaults(String string) {
        int n2;
        if (string == null || (n2 = string.indexOf(59)) <= 0 || n2 == string.length() - 1) {
            return null;
        }
        return string.substring(n2 + 1);
    }

    private static Float parseFloat(String string) throws NumberFormatException {
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        return new Float(string.replace(',', '.'));
    }

    static {
        scaleConstants.put("resize-x", 1);
        scaleConstants.put("move-x", 2);
        scaleConstants.put("no-min-x", 4);
        scaleConstants.put("resize-y", 16);
        scaleConstants.put("move-y", 32);
        scaleConstants.put("no-min-y", 64);
        scaleConstants.put("resize-x-any", 5);
        scaleConstants.put("move-x-any", 6);
        scaleConstants.put("resize-y-any", 80);
        scaleConstants.put("move-y-any", 96);
        scaleConstants.put("resize-both", 17);
        scaleConstants.put("move-both", 34);
        scaleConstants.put("resize-both-any", 85);
        scaleConstants.put("move-both-any", 102);
        scaleConstants.put("no-scale", -1);
    }

    private class Format {
        String name;
        float minWidth;
        boolean cells;
        float firstLimit;

        Format(String string, float f2, boolean bl) {
            this.name = string;
            this.minWidth = f2;
            this.cells = bl;
        }

        int getMinWidth() {
            float f2 = this.cells && ResponsiveLayout.this.parentWindow != null && this.minWidth > 1.0f ? this.minWidth * (float)ResponsiveLayout.this.parentWindow.getCellWidth() : this.minWidth;
            return Math.round(f2);
        }

        int getFirstLimit() {
            float f2 = this.cells && ResponsiveLayout.this.parentWindow != null && this.firstLimit > 1.0f ? this.firstLimit * (float)ResponsiveLayout.this.parentWindow.getCellWidth() : this.firstLimit;
            return Math.round(f2);
        }
    }

    public class ResponsiveLayoutData
    extends IscobolLayout.DefaultLayoutData {
        private Map<String, Bounds> formatBounds;
        private final boolean noActions;
        private boolean origVisible;

        private ResponsiveLayoutData(String string) {
            this(DEF_CMP, 0, 0, 0, 0, string, "");
        }

        public ResponsiveLayoutData(Component component, int n2, int n3, int n4, int n5, String string, String string2) {
            super(component, n2, n3, n4, n5, string, string2);
            this.origVisible = true;
            this.noActions = "0".equals(string);
        }

        @Override
        public void initialize(String string, String string2) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringTokenizer.nextToken();
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            block9: for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String string3 = stringArray[i3].trim().toLowerCase();
                if (",".equals(string3)) continue;
                Object object2 = (Integer)scaleConstants.get(string3);
                if (object2 != null) {
                    if ((Integer)object2 == -1) {
                        n2 = -1;
                        continue;
                    }
                    if (n2 < 0) continue;
                    n2 += ((Integer)object2).intValue();
                    continue;
                }
                for (Format format : ResponsiveLayout.this.formats) {
                    Bounds bounds;
                    String string4 = "-" + format.name;
                    if (!string3.endsWith(string4)) continue;
                    String string5 = string3.substring(0, string3.length() - string4.length());
                    if ("visible".equals(string5)) {
                        this.getFormatBounds((String)format.name).visible = Boolean.TRUE;
                        ++n3;
                        continue block9;
                    }
                    if ("hidden".equals(string5)) {
                        this.getFormatBounds((String)format.name).visible = Boolean.FALSE;
                        ++n4;
                        continue block9;
                    }
                    object2 = (Integer)scaleConstants.get(string5);
                    if (object2 != null) {
                        bounds = this.getFormatBounds(format.name);
                        if ((Integer)object2 == -1) {
                            bounds.action = -1;
                            continue block9;
                        }
                        if (bounds.action < 0) continue block9;
                        bounds.action += ((Integer)object2).intValue();
                        continue block9;
                    }
                    if (i3 >= stringArray.length - 1) continue;
                    if ("line".equals(string5)) {
                        bounds = this.getFormatBounds(format.name);
                        ++i3;
                        try {
                            bounds.y = ResponsiveLayout.parseFloat(stringArray[i3]);
                            bounds.cy = true;
                            if (i3 >= stringArray.length - 1) continue block9;
                            if ("cells".equalsIgnoreCase(stringArray[i3 + 1])) {
                                ++i3;
                                bounds.cy = true;
                                continue block9;
                            }
                            if (!"pixel".equalsIgnoreCase(stringArray[i3 + 1])) continue block9;
                            ++i3;
                            bounds.cy = false;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block9;
                    }
                    if ("col".equals(string5) || "column".equals(string5)) {
                        bounds = this.getFormatBounds(format.name);
                        ++i3;
                        try {
                            bounds.x = ResponsiveLayout.parseFloat(stringArray[i3]);
                            bounds.cx = true;
                            if (i3 >= stringArray.length - 1) continue block9;
                            if ("cells".equalsIgnoreCase(stringArray[i3 + 1])) {
                                ++i3;
                                bounds.cx = true;
                                continue block9;
                            }
                            if (!"pixel".equalsIgnoreCase(stringArray[i3 + 1])) continue block9;
                            ++i3;
                            bounds.cx = false;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block9;
                    }
                    if ("lines".equals(string5)) {
                        bounds = this.getFormatBounds(format.name);
                        ++i3;
                        try {
                            bounds.h = ResponsiveLayout.parseFloat(stringArray[i3]);
                            bounds.ch = true;
                            if (i3 >= stringArray.length - 1) continue block9;
                            if ("cells".equalsIgnoreCase(stringArray[i3 + 1])) {
                                ++i3;
                                bounds.ch = true;
                                continue block9;
                            }
                            if (!"pixel".equalsIgnoreCase(stringArray[i3 + 1])) continue block9;
                            ++i3;
                            bounds.ch = false;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block9;
                    }
                    if (!"size".equals(string5)) continue;
                    bounds = this.getFormatBounds(format.name);
                    ++i3;
                    try {
                        bounds.w = ResponsiveLayout.parseFloat(stringArray[i3]);
                        bounds.cw = true;
                        if (i3 >= stringArray.length - 1) continue block9;
                        if ("cells".equalsIgnoreCase(stringArray[i3 + 1])) {
                            ++i3;
                            bounds.cw = true;
                            continue block9;
                        }
                        if (!"pixel".equalsIgnoreCase(stringArray[i3 + 1])) continue block9;
                        ++i3;
                        bounds.cw = false;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block9;
                }
            }
            if (n2 > 0) {
                this.setAction(n2);
            } else if (n2 == -1) {
                this.setAction(0);
            } else {
                this.setAction(Integer.parseInt(ResponsiveLayout.super.getDefaultLayoutDataString(string2)));
            }
            if (n3 > 0 && n4 == 0) {
                for (Object object2 : ResponsiveLayout.this.formats) {
                    object = this.getFormatBounds(((Format)object2).name);
                    if (((Bounds)object).visible != null) continue;
                    ((Bounds)object).visible = Boolean.FALSE;
                }
            }
            if (n4 > 0 && n3 == 0) {
                for (Object object2 : ResponsiveLayout.this.formats) {
                    object = this.getFormatBounds(((Format)object2).name);
                    if (((Bounds)object).visible != null) continue;
                    ((Bounds)object).visible = Boolean.TRUE;
                }
            }
        }

        private Map<String, Bounds> getFormatBoundsTable() {
            if (this.formatBounds == null) {
                this.formatBounds = new HashMap<String, Bounds>();
            }
            return this.formatBounds;
        }

        private Bounds getFormatBounds(String string) {
            Map<String, Bounds> map = this.getFormatBoundsTable();
            Bounds bounds = map.get(string);
            if (bounds == null) {
                bounds = new Bounds();
                map.put(string, bounds);
            }
            return bounds;
        }

        public boolean isOrigVisible() {
            return this.origVisible;
        }

        public void setOrigVisible(boolean bl) {
            this.origVisible = bl;
        }
    }

    private class Bounds {
        Float x;
        Float y;
        Float w;
        Float h;
        boolean cx;
        boolean cy;
        boolean cw;
        boolean ch;
        Boolean visible;
        int action;

        private Bounds() {
        }

        int getValue(Float f2, boolean bl, boolean bl2, int n2) {
            if (f2 != null) {
                float f3 = f2.floatValue() - 1.0f;
                if (bl && ResponsiveLayout.this.parentWindow != null) {
                    return Math.round(f3 * (float)(bl2 ? ResponsiveLayout.this.parentWindow.getCellWidth() : ResponsiveLayout.this.parentWindow.getCellHeight()));
                }
                return Math.round(f3);
            }
            return n2;
        }
    }
}

