/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.TerminalModel;
import com.iscobol.logger.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Terminal
extends Component
implements PropertyChangeListener {
    private static final int DEFAULT_BLINK_RATE = 600;
    private TerminalModel tm;
    private boolean needPaint;
    private boolean empty = true;
    private Dimension charDim;
    private final Logger guiLog = KeyboardBuffer.guiLog;
    private int cursorType;
    private int cursorBlink;
    private CursorTimer cursorTimer;
    AbstractGuiFactoryImpl gf;

    public Terminal(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        this.gf = abstractGuiFactoryImpl;
        this.tm = new TerminalModel(abstractGuiFactoryImpl);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Component[] componentArray;
                Container container;
                Component component;
                KeyboardFocusManager keyboardFocusManager;
                if (Terminal.this.guiLog != null) {
                    Terminal.this.guiLog.info("Terminal: keyPressed [" + keyEvent + "] focus owner [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + "] focus cycle root [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot() + "] focused window [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() + "] active window [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() + "]");
                }
                int n2 = Terminal.this.gf.getRemoteVirtualKeyboard().mapKey(keyEvent);
                boolean bl = false;
                if (keyEvent instanceof KeyEvent && keyEvent.getKeyCode() == 19 && keyEvent.getID() == 401 && keyEvent.isAltDown()) {
                    bl = true;
                } else if (VirtualKeyboard.isException(n2) && VirtualKeyboard.exception(n2) == 65534) {
                    bl = true;
                }
                if (bl && (keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()) != null && (component = keyboardFocusManager.getFocusOwner()) == Terminal.this && (container = Terminal.this.getParent()) != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                    if (Terminal.this.guiLog != null) {
                        Terminal.this.guiLog.info("Terminal: keyPressed wparent [" + container + "] num components [" + componentArray.length + "]");
                    }
                    Component component2 = null;
                    for (int i2 = 0; i2 < componentArray.length; ++i2) {
                        if (componentArray[i2] != null) {
                            if (component2 == null && componentArray[i2] != Terminal.this) {
                                component2 = componentArray[i2];
                            }
                            if (Terminal.this.guiLog == null) continue;
                            Terminal.this.guiLog.info("Terminal: components [" + i2 + "] [" + componentArray[i2] + "] hasfocus [" + componentArray[i2].hasFocus() + "] isfocusable [" + componentArray[i2].isFocusable() + "] visible [" + componentArray[i2].isVisible() + "] newfocus [" + component2 + "]");
                            continue;
                        }
                        if (Terminal.this.guiLog == null) continue;
                        Terminal.this.guiLog.info("Terminal: components [" + i2 + "] [" + componentArray[i2] + "]");
                    }
                    if (component2 != null && component2.isFocusable() && component2.isVisible()) {
                        component2.requestFocusInWindow();
                    }
                }
            }
        });
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void init() {
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            Terminal.class.getMethod("setFocusable", classArray).invoke((Object)this, new Boolean(true));
            Terminal.class.getMethod("setFocusTraversalKeysEnabled", classArray).invoke((Object)this, new Boolean(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(float f2, float f3, LocalFontCmp localFontCmp, int n2, int n3) {
        int n4 = (int)Math.ceil(f2);
        int n5 = (int)Math.ceil(f3);
        this.init();
        Font font = localFontCmp.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics.charWidth('W') != fontMetrics.charWidth('i')) {
            font = new Font("Monospaced", font.getStyle(), font.getSize());
        }
        this.setFont(font);
        this.charDim = new Dimension();
        this.charDim.width = n2 / n4;
        this.charDim.height = n3 / n5;
        if (n2 % n4 > n4 / 2) {
            ++this.charDim.width;
        }
        if (n3 % n5 > n5 / 2) {
            ++this.charDim.height;
        }
        this.gf.getCsProperty().addPropertyChangeListener(this);
        this.tm.init(n4, n5, this.charDim, this.getFontMetrics(font));
        this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        this.cursorBlink = this.gf.getCsProperty().get("iscobol.terminal.cursor_blink", 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.gf != null) {
            int n2;
            if (propertyChangeEvent.getPropertyName().equals("iscobol.terminal.cursor_type")) {
                this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
                if (this.cursorBlink == 0) {
                    this.tm.setCursorType(this.cursorType);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("iscobol.terminal.cursor_blink") && (n2 = this.gf.getCsProperty().get("iscobol.terminal.cursor_blink", 0)) != this.cursorBlink) {
                this.cursorBlink = n2;
                if (this.cursorBlink > 0) {
                    this.restartCursorTimer();
                } else {
                    this.tm.setCursorType(this.cursorType);
                    if (this.cursorTimer != null) {
                        this.cursorTimer.stopped = true;
                        this.cursorTimer.interrupt();
                        this.cursorTimer = null;
                    }
                }
            }
        }
    }

    public boolean moveAt(int n2, int n3) {
        return this.tm.move(n2, n3);
    }

    public Rectangle display(int n2, int n3, String string, int n4, Color color, int n5, Color color2, Justification justification, boolean bl) {
        this.needPaint = true;
        this.empty = false;
        this.restartCursorTimer();
        if (this.moveAt(n2, n3)) {
            this.repaint();
        }
        return this.tm.addstr(justification.get(string, n4), n4, color, n5, color2, bl);
    }

    public TerminalModel getTerminalModel() {
        this.needPaint = true;
        this.restartCursorTimer();
        return this.tm;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.tm.getPreferredSize();
    }

    private void restartCursorTimer() {
        if (this.cursorBlink > 0) {
            if (this.cursorTimer != null) {
                this.cursorTimer.interrupt();
            } else {
                this.cursorTimer = new CursorTimer();
                this.cursorTimer.delay = this.cursorBlink == 1 ? 600 : this.cursorBlink;
                this.cursorTimer.start();
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.needPaint) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(Color.green);
            this.tm.paint(graphics2D);
        } else {
            super.paint(graphics);
        }
    }

    public void setBackground(int n2, int n3, int n4, int n5, Color color) {
        this.tm.setBackground(n2, n3, n4, n5, color);
    }

    public void setForeground(int n2, int n3, int n4, int n5, Color color, int n6) {
        this.tm.setForeground(n2, n3, n4, n5, color, n6);
    }

    @Override
    public void setBackground(Color color) {
        this.tm.setBackground(color);
        super.setBackground(color);
    }

    public void setBackColor(Color color) {
        this.tm.setBackColor(color);
    }

    public void setForeColor(Color color) {
        this.tm.setForeColor(color);
    }

    public String acceptFromScreen(int n2, int n3, int n4) {
        return this.tm.acceptFromScreen(n2, n3, n4);
    }

    public String attrFromScreen(int n2, int n3, int n4) {
        return this.tm.attrFromScreen(n2, n3, n4);
    }

    public void writeToScreen(int n2, int n3, int n4, String string, String string2) {
        this.tm.writeToScreen(n2, n3, n4, string, string2);
    }

    public void changeWidth(int n2) {
        this.tm.changeWidth(n2);
        this.setSize(this.getPreferredSize());
    }

    public void end() {
        this.gf.getCsProperty().removePropertyChangeListener(this);
        this.tm.end();
        this.needPaint = false;
        this.tm = null;
        this.gf = null;
        if (this.cursorTimer != null) {
            this.cursorTimer.interrupt();
            this.cursorTimer = null;
        }
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    @Override
    public void repaint() {
    }

    public void myrepaint() {
        super.repaint();
    }

    private class CursorTimer
    implements Runnable {
        private int delay = 600;
        private Thread thread;
        private boolean cursorVisible;
        private boolean stopped;

        private CursorTimer() {
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    Thread.sleep(this.delay);
                    if (Terminal.this.tm == null) {
                        return;
                    }
                    Terminal.this.tm.setCursorType(this.cursorVisible ? Terminal.this.cursorType : 0);
                    Terminal.this.needPaint = true;
                    Terminal.this.repaint();
                    this.cursorVisible = !this.cursorVisible;
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        void interrupt() {
            this.thread.interrupt();
        }

        void start() {
            this.thread = new Thread(this);
            this.thread.setName(Terminal.class.getName() + ".CursorTimer");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }
}

