/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.PicobolTextEvent;
import com.iscobol.gui.PicobolTextListener;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.Terminal;
import com.iscobol.gui.client.TerminalModel;
import com.iscobol.rts.Factory;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TerminalAccept
extends Component
implements PicobolWidget,
InputMethodListener,
KeyListener,
InputMethodRequests {
    private static final char UNDERSCORE_CHAR = '_';
    private static final long NOT_SET = 0xFFFFFFFFFFFFFFFL;
    private boolean doubleByteCompat;
    private final boolean alphaAutoClear;
    private final boolean numericAutoClear;
    private final boolean noAutoClear;
    private final boolean editedFormatted;
    private final boolean updateFromScreen;
    private final boolean cl2endFillSpaces;
    private final char[] acceptedControlCharacters;
    private final int[] dataRange;
    private boolean national;
    private String undo;
    private InpData inp = new InpData();
    private Terminal tt;
    private TerminalModel tm;
    private int col;
    private int line;
    private Dimension size;
    private boolean isNumeric;
    private int attr;
    private boolean autoTermination;
    private PicobolTextListener listener;
    private boolean aKeyTyped;
    private boolean activeAccept;
    private boolean update;
    private boolean prompt;
    private char promptChar;
    private boolean upper;
    private boolean lower;
    private boolean full;
    private boolean required;
    private boolean zeroFill;
    private long savebackcolor = 0xFFFFFFFFFFFFFFFL;
    private long savetermattr = 0xFFFFFFFFFFFFFFFL;
    private Justification just;
    private AbstractGuiFactoryImpl gf;
    private char promptCharOrig;
    private boolean promptAll;
    private String promptAllStr;
    private int taMaxIdx;
    private final int upperLowerMethod;
    private boolean listenersAdded;
    private int lastKeyCode;
    private static final AttributedCharacterIterator EMPTY_TEXT = new AttributedString("").getIterator();
    private InpData savedInp;
    private int maxImeLen;
    private boolean imeActive;
    private boolean gomyrepaint;

    private static final boolean isEditing(char c2) {
        switch (c2) {
            case '+': 
            case '-': 
            case '9': 
            case 'Z': {
                return false;
            }
        }
        return true;
    }

    private static final char[] normalizePic(String string) {
        int n2;
        if (string != null && (n2 = string.length()) > 0) {
            int n3;
            StringBuilder stringBuilder = new StringBuilder();
            char c2 = '\u0000';
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                if (c3 == '(') {
                    n3 = 0;
                    while (Character.isDigit(c3 = string.charAt(++i2))) {
                        n3 *= 10;
                        n3 += Character.digit(c3, 10);
                    }
                    --n3;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        stringBuilder.append(c2);
                    }
                    continue;
                }
                c2 = c3;
                stringBuilder.append(c2);
            }
            char[] cArray = stringBuilder.toString().toCharArray();
            block6: for (n3 = 0; n3 < cArray.length; ++n3) {
                switch (cArray[n3]) {
                    case 'B': 
                    case 'b': {
                        cArray[n3] = 32;
                        continue block6;
                    }
                }
            }
            return cArray;
        }
        return null;
    }

    public TerminalAccept(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        String[] stringArray;
        this.promptCharOrig = this.promptChar = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.screen_prompt", '_');
        this.promptAllStr = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.screen_prompt_all", "");
        if (this.promptAllStr != null && (this.promptAllStr.equalsIgnoreCase("YES") || this.promptAllStr.equalsIgnoreCase("PROTECTED"))) {
            this.promptAll = true;
        }
        this.doubleByteCompat = true;
        this.alphaAutoClear = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.alpha_autoclear", false);
        this.numericAutoClear = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.numeric_autoclear", true);
        this.noAutoClear = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.no_autoclear", false);
        this.editedFormatted = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.edited_formatted", false);
        this.updateFromScreen = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.update_from_screen", false);
        this.cl2endFillSpaces = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.cl2end_fill_spaces", false);
        String string = abstractGuiFactoryImpl.getCsProperty().get("iscobol.key.accepted_control_characters", null);
        this.acceptedControlCharacters = string != null ? string.toCharArray() : null;
        this.upperLowerMethod = abstractGuiFactoryImpl.getUpperLowerMethod();
        string = abstractGuiFactoryImpl.getCsProperty().get("iscobol.terminal.data_range", null);
        int[] nArray = null;
        if (string != null && (stringArray = string.split("\\,")).length > 0) {
            if (stringArray.length == 1) {
                try {
                    nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.MAX_VALUE};
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.dataRange = nArray;
        this.gf = abstractGuiFactoryImpl;
    }

    @Override
    public void repaint() {
        this.repaint(true);
    }

    private void repaint(boolean bl) {
        if (bl && this.isVisible()) {
            if (this.savedInp != null) {
                int n2;
                int n3 = this.savedInp.col;
                if (this.inp.imeCol > 0) {
                    for (n2 = 0; n2 < this.inp.imeCol && n2 + this.savedInp.idx < this.inp.data.length; ++n2) {
                        n3 += this.tm.dblWidth(this.inp.data[n2 + this.savedInp.idx]) ? 2 : 1;
                    }
                }
                if (this.doubleByteCompat && n3 > this.inp.len) {
                    n3 = this.inp.len;
                }
                int n4 = this.doubleByteCompat ? (n3 == this.inp.len ? 1 : 0) : (n2 = this.savedInp.idx + this.inp.imeCol == this.inp.len ? 1 : 0);
                if (n2 != 0) {
                    this.tm.setCaretAt(this.col + n3 - 1, this.line, this);
                } else {
                    this.tm.setCaretAt(this.col + n3, this.line, this);
                }
            } else if (this.inp.isAtEnd()) {
                this.tm.setCaretAt(this.col + this.inp.col - 1, this.line, this);
            } else {
                this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
            }
        } else {
            this.tm.unsetCaret(this);
        }
        if (this.gomyrepaint) {
            this.tt.myrepaint();
        } else {
            this.tt.repaint();
        }
    }

    public void clear() {
        if (!this.updateFromScreen && this.inp != null) {
            this.inp.clear();
        }
    }

    public void display() {
        this.display(this.promptAll, true);
    }

    public void display(boolean bl) {
        this.display(bl, true);
    }

    public void display(boolean bl, boolean bl2) {
        this.tm.move(this.col, this.line);
        if (bl2) {
            this.tm.setAttr(this.attr);
            this.tm.setBackColor(this.getBackground());
            this.tm.setForeColor(this.getForeground());
        }
        if (this.aKeyTyped || (this.attr & 0x10000000) == 0) {
            char[] cArray = this.just != null && !bl && (!this.noAutoClear || this.update) ? this.just.get(this.inp.getData(this.prompt & bl)) : this.inp.getData(this.prompt & bl);
            this.taMaxIdx = Math.max(this.taMaxIdx, this.inp.idx);
            if (this.noAutoClear && !this.update && this.taMaxIdx < cArray.length) {
                char[] cArray2 = this.tm.getTextAt(this.line, this.col + this.taMaxIdx, cArray.length - this.taMaxIdx);
                System.arraycopy(cArray2, 0, cArray, this.taMaxIdx, cArray2.length);
            }
            this.tm.addstr(cArray, this.doubleByteCompat ? this.inp.len : 0);
            if (this.savedInp != null && this.inp.imeTextLen > 0 && this.inp.imeHl != null) {
                int n2 = 0;
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    n2 += this.tm.dblWidth(cArray[i2]) ? 2 : 1;
                }
                StringBuilder stringBuilder = new StringBuilder();
                int n3 = this.maxImeLen - n2;
                if (n3 > 0) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        stringBuilder.append(' ');
                    }
                    char[] cArray3 = stringBuilder.toString().toCharArray();
                    this.tm.addstr(cArray3, this.doubleByteCompat ? Math.min(cArray3.length, this.inp.len) : 0);
                }
                this.maxImeLen = Math.max(this.maxImeLen, n2);
                this.tm.move(this.col + this.savedInp.col, this.line);
                stringBuilder = new StringBuilder();
                int n4 = 0;
                for (int i4 = this.savedInp.idx; n4 < this.inp.imeTextLen && i4 < this.inp.data.length; ++n4, ++i4) {
                    stringBuilder.append(this.inp.data[i4]);
                }
                if (this.inp.imeHl.getState() == 0) {
                    this.tm.setAttr(this.attr | 0x2000000);
                } else {
                    this.tm.setBackColor(Color.blue);
                    this.tm.setForeColor(Color.white);
                }
                char[] cArray4 = stringBuilder.toString().toCharArray();
                this.tm.addstr(cArray4, this.doubleByteCompat ? Math.min(cArray4.length, this.inp.len) : 0);
            }
        }
        this.repaint(bl);
    }

    private void toClipBoard(char[] cArray) {
        StringSelection stringSelection = new StringSelection(new String(cArray));
        Clipboard clipboard = this.tt.getToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private String fromClipBoard() {
        String string;
        Clipboard clipboard = this.tt.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this.tt);
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public void setPicture(String string, boolean bl) {
        if (this.inp != null) {
            this.inp.setPicture(string, bl);
        }
    }

    public void initializerowcol(int n2, int n3) {
        this.col = n2;
        this.line = n3;
    }

    public void initialize(Terminal terminal, int n2, int n3, String string, int n4, String string2, boolean bl) {
        this.setFocusable(true);
        this.col = n2;
        this.line = n3;
        this.tt = terminal;
        this.tm = terminal.getTerminalModel();
        int n5 = this.tm.getWidth();
        int n6 = this.col + n4 <= n5 ? n4 : (n5 > this.col ? n5 - this.col : 0);
        this.size = n6 == 0 ? new Dimension(1, this.tm.getCharDim().height) : new Dimension(this.tm.getCharDim().width * n6, this.tm.getCharDim().height);
        this.inp.setLen(n6);
        this.inp.setPicture(string2, bl);
        if (this.updateFromScreen) {
            string = this.tm.acceptFromScreen(this.line + 1, this.col + 1, n6);
        }
        if (string != null && string.length() >= 0) {
            this.undo = string;
            this.inp.setValue(this.undo);
        }
        if (!this.listenersAdded) {
            this.listenersAdded = true;
            this.addKeyListener(this);
            this.enableEvents(2056L);
            this.enableInputMethods(true);
            this.addInputMethodListener(this);
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    public void addTextListener(PicobolTextListener picobolTextListener) {
        this.listener = picobolTextListener;
    }

    public void removeTextListener() {
        this.listener = null;
    }

    public void setUnderline(boolean bl) {
        if (bl) {
            if (this.promptChar == '_') {
                this.promptChar = (char)32;
            }
            this.attr |= 0x2000000;
        } else {
            this.attr &= 0xFDFFFFFF;
            this.promptChar = this.promptCharOrig;
        }
    }

    public void setBold(boolean bl) {
        this.attr = bl ? (this.attr |= 0x1000000) : (this.attr &= 0xFEFFFFFF);
    }

    public void setNoEcho(boolean bl) {
        if (bl) {
            this.attr |= 0x10000000;
            if (this.updateFromScreen) {
                this.inp.setValue("");
            }
        } else {
            this.attr &= 0xEFFFFFFF;
        }
    }

    public void setBlink(boolean bl) {
        this.attr = bl ? (this.attr |= 0x8000000) : (this.attr &= 0xF7FFFFFF);
    }

    public void setAuto(boolean bl) {
        this.autoTermination = bl;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public void setPrompt(boolean bl) {
        this.prompt = bl;
    }

    public void setPromptChar(char c2) {
        this.promptChar = c2;
    }

    public void setLower(boolean bl) {
        this.lower = bl;
    }

    public void setUpper(boolean bl) {
        this.upper = bl;
    }

    public void setFull(boolean bl) {
        this.full = bl;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setZeroFill(boolean bl) {
        this.zeroFill = bl;
    }

    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        this.tm.move(this.col, this.line);
        this.savebackcolor = this.tm.getBackColor();
        this.savetermattr = this.tm.getTermAttr();
        this.tm.setAttr(this.attr);
        this.tm.setBackColor(this.getBackground());
        this.tm.setForeColor(this.getForeground());
        if (this.update || this.prompt) {
            this.tm.addstr(this.inp.getData(this.prompt), this.doubleByteCompat ? this.inp.len : 0);
        }
        this.tm.move(this.col + this.inp.idx, this.line);
        this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
        if (this.alphaAutoClear && (!this.isNumeric || this.inp.pict != null && this.editedFormatted) || this.numericAutoClear && this.isNumeric && (this.inp.pict == null || !this.editedFormatted)) {
            this.inp.setSelectedAll(true);
        }
        this.tt.myrepaint();
    }

    public void focusLost(CobolFocusEvent cobolFocusEvent) {
        this.tm.unsetCaret(this);
        this.inp.col = (this.inp.idx = 0);
        this.resetInsMode();
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        this.tt.myrepaint();
    }

    @Override
    public void setActiveAccept(boolean bl) {
        if (this.tm != null && !bl && this.promptAll && (this.activeAccept && this.promptAllStr.equalsIgnoreCase("PROTECTED") || !this.activeAccept)) {
            this.display(false);
        }
        this.activeAccept = bl;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean bl) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void setSize(int n2, int n3) {
        if (this.size != null) {
            super.setSize(this.size.width, this.size.height);
        } else {
            super.setSize(1, 1);
        }
    }

    @Override
    public void setLocation(int n2, int n3) {
        super.setLocation(n2, n3);
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        if (this.size != null) {
            super.setBounds(n2, n3, this.size.width, this.size.height);
        } else {
            super.setBounds(n2, n3, 1, 1);
        }
    }

    public void setValue(String string) {
        this.inp.setValue(string);
        this.display(this.promptAll);
    }

    public String getValue() {
        String string = this.inp.getValue();
        if (this.just != null) {
            string = this.just.get(string, this.inp.getLength());
        }
        if (this.upper) {
            return Factory.toUpperCase(string, this.upperLowerMethod);
        }
        if (this.lower) {
            return Factory.toLowerCase(string, this.upperLowerMethod);
        }
        if (this.gf.getKdbUpper()) {
            return Factory.toUpperCase(string, this.upperLowerMethod);
        }
        if (this.gf.getKdbLower()) {
            return Factory.toLowerCase(string, this.upperLowerMethod);
        }
        return string;
    }

    public void setNumeric(boolean bl) {
        this.isNumeric = bl;
    }

    public void setCursorPos(int n2) {
        if (this.update && n2 > 0 && (n2 >> 16) - 1 == this.line) {
            this.inp.setOffset((n2 & 0xFFFF) - 1 - this.col);
        }
    }

    public void setJustification(Justification justification) {
        this.just = justification;
    }

    public int getCursorPos() {
        int n2 = this.inp.getOffset();
        if (n2 == this.inp.getLength()) {
            --n2;
        }
        return this.line + 1 << 16 | this.col + n2 + 1;
    }

    public int getOffset() {
        return this.inp.getOffset();
    }

    public int getIdx() {
        return this.inp.getIdx();
    }

    public String check() {
        if (this.required && this.getValue().trim().length() == 0) {
            return Factory.getSysMsg("ef_input_required_msg");
        }
        if (this.full && this.inp.idx != this.inp.len && this.inp.idx != 0) {
            return Factory.getSysMsg("ef_input_filled_msg");
        }
        if (this.zeroFill) {
            this.inp.end();
            while (this.inp.idx < this.inp.len) {
                this.inp.addch('0');
            }
        }
        this.display(this.promptAll);
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        return null;
    }

    public void setKdbUpper(boolean bl) {
        if (bl) {
            this.setKdbLower(false);
        }
    }

    public void setKdbLower(boolean bl) {
        if (bl) {
            this.setKdbUpper(false);
        }
    }

    private void resetInsMode() {
        if (this.inp.insMode) {
            this.toggleInsMode();
        }
    }

    private void toggleInsMode() {
        this.tm.insertCursor = this.inp.insMode = !this.inp.insMode;
        this.inp.selectedAll = false;
    }

    public void saveBGandAttr() {
        if (this.savebackcolor == 0xFFFFFFFFFFFFFFFL) {
            this.savebackcolor = this.tm.getBackColor();
        }
        if (this.savetermattr == 0xFFFFFFFFFFFFFFFL) {
            this.savetermattr = this.tm.getTermAttr();
        }
    }

    public void restoreBGandAttr() {
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
    }

    private char getValidChar(char n2) {
        return (char)(this.dataRange == null || n2 >= this.dataRange[0] && n2 <= this.dataRange[1] ? n2 : 32);
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Point point;
        InpData inpData = this.savedInp != null ? this.savedInp : this.inp;
        try {
            point = this.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            point = new Point(0, 0);
        }
        Rectangle rectangle = new Rectangle(point, this.getSize());
        Dimension dimension = this.tm.getCharDim();
        int n2 = this.col + inpData.col;
        if (inpData.isAtEnd()) {
            --n2;
        }
        rectangle.width += n2 * dimension.width;
        rectangle.height += this.tm.getFontMetrics().getAscent();
        return rectangle;
    }

    @Override
    public TextHitInfo getLocationOffset(int n2, int n3) {
        InpData inpData = this.savedInp != null ? this.savedInp : this.inp;
        Point point = this.getLocationOnScreen();
        int n4 = (n2 -= point.x) / this.tm.getCharDim().width;
        TextHitInfo textHitInfo = n4 < inpData.len ? TextHitInfo.leading(n4) : null;
        return textHitInfo;
    }

    @Override
    public int getInsertPositionOffset() {
        InpData inpData = this.savedInp != null ? this.savedInp : this.inp;
        int n2 = this.doubleByteCompat ? inpData.col : inpData.idx;
        return n2;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int n2, int n3, AttributedCharacterIterator.Attribute[] attributeArray) {
        InpData inpData = this.savedInp != null ? this.savedInp : this.inp;
        AttributedString attributedString = new AttributedString(new String(inpData.data, 0, this.doubleByteCompat ? inpData.col : inpData.idx));
        return attributedString.getIterator(null, n2, n3);
    }

    @Override
    public int getCommittedTextLength() {
        InpData inpData = this.savedInp != null ? this.savedInp : this.inp;
        int n2 = this.doubleByteCompat ? inpData.col : inpData.idx;
        return n2;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return EMPTY_TEXT;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        if (attributedCharacterIterator != null) {
            int n2 = inputMethodEvent.getCommittedCharacterCount();
            if (n2 > 0) {
                if (this.savedInp != null) {
                    this.inp = this.savedInp;
                }
                this.savedInp = null;
                this.inp.imeTextLen = 0;
                this.inp.imeHl = null;
            } else {
                if (this.savedInp != null) {
                    this.inp = this.savedInp.Clone();
                } else {
                    this.savedInp = this.inp;
                    this.inp = this.inp.Clone();
                }
                AttributedString attributedString = new AttributedString(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), new TextAttribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT});
                AttributedCharacterIterator attributedCharacterIterator2 = attributedString.getIterator();
                this.inp.imeHl = (InputMethodHighlight)attributedCharacterIterator2.getAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT);
                if (this.inp.imeHl == null || this.inp.imeHl.getState() == 0) {
                    this.inp.imeCol = inputMethodEvent.getCaret().getInsertionIndex();
                }
            }
            int n3 = 0;
            char c2 = attributedCharacterIterator.first();
            this.imeActive = true;
            for (int i2 = 0; c2 != '\uffff' && (n2 == 0 || i2 < n2); ++i2) {
                this.charTyped(c2, false, false);
                c2 = attributedCharacterIterator.next();
                ++n3;
            }
            this.imeActive = false;
            if (n2 == 0) {
                this.inp.imeTextLen = n3;
            }
            this.display(true);
            if (n2 > 0) {
                this.checkAutoTermination();
            }
        } else {
            if (this.savedInp != null) {
                this.inp = this.savedInp;
            }
            this.inp.imeTextLen = 0;
            this.savedInp = null;
        }
        inputMethodEvent.consume();
    }

    @Override
    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        inputMethodEvent.consume();
    }

    private final void undo() {
        this.inp.clear();
        this.inp.setValue(this.undo);
        this.display(true);
    }

    private final void copy() {
        this.toClipBoard(this.inp.getData(false));
    }

    private final void cut() {
        this.toClipBoard(this.inp.getData(false));
        this.inp.clear();
        this.inp.setValue(null);
        this.display(true);
    }

    public final void paste() {
        String string = this.fromClipBoard();
        if (string != null) {
            char[] cArray = string.toCharArray();
            if (this.isNumeric || this.alphaAutoClear) {
                this.inp.clear();
            }
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                this.inp.addch(cArray[i2]);
            }
            this.display(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.lastKeyCode = keyEvent.getKeyCode();
        int n2 = this.gf.getRemoteVirtualKeyboard().mapKey(keyEvent, keyEvent.getKeyCode());
        this.gomyrepaint = true;
        switch (VirtualKeyboard.editing(n2)) {
            case 65536: {
                this.resetInsMode();
                if (this.inp.home()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(n2) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 131072: {
                this.resetInsMode();
                if (this.inp.end()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(n2) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 851968: {
                this.toggleInsMode();
                this.repaint();
                if (VirtualKeyboard.exception(n2) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 720896: {
                boolean bl;
                if (this.isNumeric && !this.numericAutoClear) {
                    bl = this.inp.delNnac();
                } else {
                    this.inp.delcur();
                    bl = true;
                }
                if (bl) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(n2) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 786432: {
                boolean bl;
                boolean bl2 = bl = this.isNumeric && !this.numericAutoClear ? this.inp.delNnac() : this.inp.delch();
                if (bl) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(n2) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 589824: {
                this.resetInsMode();
                if (this.inp.myleft()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 655360: {
                this.resetInsMode();
                if (this.inp.myright()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 917504: {
                this.inp.clear();
                this.display(true);
                if (VirtualKeyboard.exception(n2) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 983040: {
                if (this.cl2endFillSpaces) {
                    while (this.inp.idx < this.inp.len) {
                        this.inp.addch(' ');
                    }
                    this.display(true);
                    if (!this.autoTermination) break;
                    this.check();
                    this.listener.inputTerminated(new PicobolTextEvent(this, 2202));
                    break;
                }
                if (this.isNumeric && !this.numericAutoClear) {
                    this.inp.cl2EndNnac();
                } else {
                    this.inp.cl2End();
                }
                this.display(true);
                if (VirtualKeyboard.exception(n2) < 0) break;
                this.listener.inputTerminated(keyEvent);
            }
        }
        this.gomyrepaint = false;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n2 = keyEvent.getModifiers();
        this.gomyrepaint = true;
        int n3 = this.gf.getRemoteVirtualKeyboard().mapExtKey(keyEvent);
        if (n3 > 0 && (n3 & 0x20000) == 131072) {
            this.paste();
            return;
        }
        switch (n2) {
            case 0: {
                switch (keyEvent.getKeyCode()) {
                    case 65483: {
                        this.undo();
                        break;
                    }
                    case 65485: {
                        this.copy();
                        break;
                    }
                    case 65489: {
                        this.cut();
                        break;
                    }
                    case 65487: {
                        if (this.gf.getRemoteVirtualKeyboard().havePasteKey()) break;
                        this.paste();
                    }
                }
                break;
            }
            case 2: {
                switch (keyEvent.getKeyCode()) {
                    case 90: {
                        this.undo();
                        break;
                    }
                    case 67: 
                    case 155: {
                        this.copy();
                        break;
                    }
                    case 88: {
                        this.cut();
                        break;
                    }
                    case 86: {
                        if (this.gf.getRemoteVirtualKeyboard().havePasteKey()) break;
                        this.paste();
                    }
                }
                break;
            }
            case 1: {
                switch (keyEvent.getKeyCode()) {
                    case 127: {
                        this.cut();
                        break;
                    }
                    case 155: {
                        if (this.gf.getRemoteVirtualKeyboard().havePasteKey()) break;
                        this.paste();
                    }
                }
                break;
            }
            case 8: {
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        this.undo();
                    }
                }
            }
        }
        this.gomyrepaint = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.gomyrepaint = true;
        this.aKeyTyped = true;
        this.gf.getRemoteVirtualKeyboard().mapKey(keyEvent, this.lastKeyCode);
        char c2 = keyEvent.getKeyChar();
        this.charTyped(c2, keyEvent.isAltDown(), keyEvent.getModifiers() != 0);
        this.gomyrepaint = false;
    }

    private void charTyped(char c2, boolean bl, boolean bl2) {
        if (this.isNumeric) {
            boolean bl3 = Character.isDigit(c2);
            boolean bl4 = false;
            boolean bl5 = false;
            int n2 = -1;
            if (!bl3) {
                if (this.numericAutoClear) {
                    bl3 = c2 == ',' || c2 == '.' || c2 == '/' || c2 == ' ' || c2 == '-';
                } else {
                    bl5 = c2 == '-' || c2 == '+';
                    if (bl5) {
                        if (this.inp.isSigned) {
                            for (n2 = this.inp.getFirstDigitIdx() - 1; n2 >= 0 && this.inp.isEditingIndex(n2); --n2) {
                            }
                            if (this.inp.decPointIdx > 0 && n2 > this.inp.decPointIdx) {
                                n2 = this.inp.decPointIdx - 1;
                            }
                            if (n2 < 0) {
                                n2 = 0;
                            }
                            bl3 = true;
                        }
                    } else if (c2 == this.inp.decPointChar) {
                        bl3 = bl4 = this.inp.idx <= this.inp.decPointIdx;
                    }
                }
            }
            if (bl3) {
                if (bl4) {
                    this.inp.addDecPoint();
                } else if (bl5) {
                    if (c2 == '-') {
                        ((InpData)this.inp).data[n2] = 45;
                    } else if (this.inp.data[n2] == '-') {
                        ((InpData)this.inp).data[n2] = 32;
                    }
                } else {
                    this.inp.addch(c2);
                }
                this.display(true);
            } else if (c2 != '\b' && c2 != '\u007f') {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (c2 >= ' ' && c2 != '\u007f' || !bl2 && this.checkControlCharacter(c2)) {
            if (!bl || c2 >= '\u007f') {
                if (this.upper) {
                    this.inp.addch(Character.toUpperCase(c2));
                } else if (this.lower) {
                    this.inp.addch(Character.toLowerCase(c2));
                } else if (this.gf.getKdbUpper()) {
                    this.inp.addch(Character.toUpperCase(c2));
                } else if (this.gf.getKdbLower()) {
                    this.inp.addch(Character.toLowerCase(c2));
                } else {
                    this.inp.addch(c2);
                }
            }
            this.display(true);
        }
        this.checkAutoTermination();
    }

    private void checkAutoTermination() {
        if (this.autoTermination && !this.imeActive) {
            boolean bl;
            int n2 = this.doubleByteCompat ? this.inp.col : this.inp.idx;
            boolean bl2 = bl = n2 >= this.inp.getLastNotEditIdx();
            if (!this.numericAutoClear && this.isNumeric && this.update) {
                boolean bl3 = bl && this.inp.isSignificantDigit(this.inp.getFirstNotEditIdx(this.inp.decPointIdx >= 0 ? this.inp.leadingZ : 0)) ? true : (bl = false);
            }
            if (bl) {
                this.check();
                this.listener.inputTerminated(new PicobolTextEvent(this, 2202));
            }
        }
    }

    private boolean checkControlCharacter(char c2) {
        if (this.acceptedControlCharacters == null) {
            return false;
        }
        for (char c3 : this.acceptedControlCharacters) {
            if (c3 >= ' ' && c3 != '\u007f' || c3 != c2) continue;
            return true;
        }
        return false;
    }

    public void setNational(boolean bl) {
        this.national = bl;
        if (bl) {
            this.doubleByteCompat = false;
        }
    }

    public void ttmyrepaint() {
        if (this.tt != null) {
            this.tt.myrepaint();
        }
    }

    public boolean getAlphaAutoClear() {
        return this.alphaAutoClear;
    }

    private class InpData
    implements Cloneable {
        private char[] data;
        private int len;
        private int maxIdx;
        private int maxCol;
        private int idx;
        private int col;
        private boolean selectedAll;
        private boolean insMode;
        private char[] pict;
        private char decPointChar;
        private int decPointIdx;
        private boolean isSigned;
        private int imeCol;
        private int imeTextLen;
        private int leadingZ;
        private InputMethodHighlight imeHl;

        InpData() {
        }

        InpData Clone() {
            InpData inpData;
            try {
                inpData = (InpData)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
            inpData.data = new char[this.data.length];
            System.arraycopy(this.data, 0, inpData.data, 0, this.data.length);
            return inpData;
        }

        public String toString() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                n2 += TerminalAccept.this.tm.dblWidth(this.data[i2]) ? 2 : 1;
            }
            String string = "data='" + new String(this.data) + "'";
            string = string + ",idx=" + this.idx;
            string = string + ",col=" + this.col;
            string = string + ",dataRealLen=" + n2;
            string = string + ",imeCol=" + this.imeCol;
            string = string + ",imeTextLen=" + this.imeTextLen;
            return string;
        }

        void setPicture(String string, boolean bl) {
            this.pict = TerminalAccept.normalizePic(string);
            if (this.pict != null) {
                int n2;
                boolean bl2 = false;
                boolean bl3 = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                this.decPointChar = (char)(bl ? 44 : 46);
                if (this.pict[0] == 'S') {
                    this.isSigned = true;
                    this.pict[0] = 57;
                }
                this.decPointIdx = -1;
                for (n2 = this.pict.length - 1; n2 >= 0; --n2) {
                    bl2 |= TerminalAccept.isEditing(this.pict[n2]);
                    if (!bl3) continue;
                    if (this.pict[n2] == this.decPointChar) {
                        this.decPointIdx = n2;
                    }
                    this.isSigned |= this.pict[n2] == '-' || this.pict[n2] == '+';
                }
                n2 = this.decPointIdx >= 0 ? this.decPointIdx - 1 : this.pict.length - 1;
                this.leadingZ = 0;
                while (this.leadingZ <= n2 && (this.pict[this.leadingZ] == 'z' || this.pict[this.leadingZ] == 'Z' || this.isEditingIndex(this.leadingZ))) {
                    ++this.leadingZ;
                }
                if (!bl2) {
                    this.pict = null;
                }
            } else {
                this.decPointChar = (char)46;
                this.decPointIdx = -1;
                this.isSigned = true;
                this.leadingZ = 0;
            }
        }

        void setSelectedAll(boolean bl) {
            this.selectedAll = !TerminalAccept.this.updateFromScreen && bl;
        }

        void setLen(int n2) {
            this.len = n2;
            if (this.data != null) {
                if (n2 != this.data.length) {
                    int n3;
                    char[] cArray = this.data;
                    this.data = new char[n2];
                    int n4 = n3 = n2 <= cArray.length ? n2 : cArray.length;
                    while (--n3 >= 0) {
                        this.data[n3] = cArray[n3];
                    }
                }
            } else {
                this.data = new char[n2];
            }
        }

        private int getMaxCol() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.maxIdx; ++i2) {
                n2 += TerminalAccept.this.tm.dblWidth(this.data[i2]) ? 2 : 1;
            }
            return n2;
        }

        private boolean isEditingIndex(int n2) {
            return this.pict != null && n2 < this.pict.length && TerminalAccept.isEditing(this.pict[n2]);
        }

        void setValue(String string) {
            if (string != null && string.length() > 0) {
                boolean bl;
                if (this.data == null) {
                    this.setLen(string.length());
                }
                boolean bl2 = bl = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                if (bl) {
                    int n2;
                    char[] cArray;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    string = string.trim();
                    if (this.decPointIdx > 0) {
                        n6 = string.lastIndexOf(this.decPointChar);
                        if (n6 < 0 || n6 == string.length() - 1) {
                            n5 = this.decPointIdx - this.leadingZ;
                            while (string.length() > n5 && string.charAt(0) == '0') {
                                string = string.substring(1);
                            }
                            string = string + this.decPointChar;
                            for (n4 = this.decPointIdx + 1; n4 < this.pict.length; ++n4) {
                                string = this.isEditingIndex(n4) ? string + this.pict[n4] : string + '0';
                            }
                        } else {
                            char[] cArray2 = string.substring(n6 + 1).toCharArray();
                            string = string.substring(0, n6 + 1);
                            n3 = 0;
                            for (n4 = this.decPointIdx + 1; n4 < this.pict.length; ++n4) {
                                string = this.isEditingIndex(n4) ? string + this.pict[n4] : (n3 < cArray2.length ? string + cArray2[n3++] : string + '0');
                            }
                        }
                    } else if (this.pict != null && this.leadingZ > 0) {
                        n6 = this.pict.length - this.leadingZ;
                        while (string.length() > n6 && string.charAt(0) == '0') {
                            string = string.substring(1);
                        }
                    }
                    n5 = this.len <= (cArray = string.toCharArray()).length ? this.len : cArray.length;
                    for (n4 = 0; n4 < this.len - n5; ++n4) {
                        this.data[n4] = 32;
                    }
                    this.maxIdx = this.len;
                    n4 = TerminalAccept.this.editedFormatted && this.pict != null && this.len <= cArray.length ? 1 : 0;
                    n3 = 0;
                    for (n2 = this.len - n5; n3 < cArray.length && n2 < this.data.length; ++n3, ++n2) {
                        this.data[n2] = n4 != 0 && TerminalAccept.isEditing(this.pict[n2]) ? this.pict[n2] : cArray[n3];
                    }
                    n3 = this.decPointIdx > 0 ? this.decPointIdx - 1 : this.len - 1;
                    for (n2 = Math.min(this.len - n5, n3); n2 < n3 && (this.data[n2] == ' ' || this.data[n2] == '-'); ++n2) {
                    }
                    if (!this.isEditingIndex(n2)) {
                        int n7 = this.decPointIdx;
                        char[] cArray3 = this.pict;
                        this.pict = null;
                        this.decPointIdx = -1;
                        this.setOffset(n2);
                        this.pict = cArray3;
                        this.decPointIdx = n7;
                    }
                } else {
                    char[] cArray;
                    int n8;
                    for (int i2 = n8 = this.len <= (cArray = string.toCharArray()).length ? this.len : cArray.length; i2 < this.len; ++i2) {
                        this.data[i2] = 32;
                    }
                    --n8;
                    while (n8 >= 0 && cArray[n8] == ' ') {
                        --n8;
                    }
                    ++n8;
                    this.maxIdx = n8--;
                    while (n8 >= 0) {
                        this.data[n8] = TerminalAccept.this.getValidChar(cArray[n8]);
                        --n8;
                    }
                }
                if (TerminalAccept.this.doubleByteCompat) {
                    this.maxCol = this.getMaxCol();
                }
            } else {
                for (int i3 = 0; i3 < this.len; ++i3) {
                    this.data[i3] = 32;
                }
                this.maxIdx = 0;
                this.maxCol = 0;
            }
        }

        String getValue() {
            return new String(this.data, 0, this.maxIdx);
        }

        void clear() {
            this.idx = 0;
            this.col = 0;
            this.maxIdx = 0;
            this.maxCol = 0;
        }

        void cl2End() {
            this.maxIdx = this.col = this.idx;
            this.maxCol = this.col;
        }

        void cl2EndNnac() {
            boolean bl;
            int n2 = this.idx;
            if (n2 >= this.len) {
                n2 = this.len - 1;
            }
            boolean bl2 = bl = this.decPointIdx >= 0;
            if (!bl || this.idx < this.decPointIdx) {
                int n3;
                int n4 = this.idx = bl ? this.decPointIdx - 1 : this.len - 1;
                while (this.isEditingIndex(this.idx)) {
                    --this.idx;
                }
                int n5 = 0;
                for (n3 = n2; n3 <= this.idx; ++n3) {
                    if (this.isEditingIndex(n3)) continue;
                    ++n5;
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    this.delNnac();
                }
                this.idx = bl ? (this.col = this.decPointIdx) : (this.col = this.len);
            } else {
                if (n2 == this.decPointIdx) {
                    ++n2;
                }
                while (n2 < this.len) {
                    if (!this.isEditingIndex(n2)) {
                        this.data[n2] = 48;
                    }
                    ++n2;
                }
            }
        }

        void addDecPoint() {
            int n2 = this.idx;
            this.idx = this.decPointIdx - 1;
            for (int i2 = this.decPointIdx - 1; i2 >= n2; --i2) {
                if (this.isEditingIndex(i2)) continue;
                this.delNnac();
            }
            this.col = this.idx = this.decPointIdx + 1;
        }

        boolean addch(char c2) {
            if (this.selectedAll) {
                this.clear();
                this.selectedAll = false;
            }
            if (TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear) {
                int n2;
                int n3 = n2 = this.decPointIdx > 0 && this.idx <= this.decPointIdx ? this.decPointIdx : this.len;
                if (this.idx < n2) {
                    int n4;
                    if (this.insMode) {
                        for (n4 = n2 - 1; n4 > this.idx; --n4) {
                            int n5 = n4 - 1;
                            while (this.isEditingIndex(n5)) {
                                --n5;
                            }
                            this.data[n4] = this.data[n5];
                            n4 = n5 + 1;
                        }
                        if (this.maxIdx < n2) {
                            ++this.maxIdx;
                        }
                    }
                    this.data[this.idx] = c2;
                    ++this.idx;
                    ++this.col;
                    if (this.idx > this.maxIdx) {
                        for (n4 = this.idx - 2; n4 >= this.maxIdx; --n4) {
                            this.data[n4] = 32;
                        }
                        this.maxIdx = this.idx;
                    }
                    if (this.idx < n2 && !this.insMode && this.isEditingIndex(this.idx)) {
                        return this.addch(this.pict[this.idx]);
                    }
                    return true;
                }
                this.addNnac(c2);
                return false;
            }
            if (TerminalAccept.this.doubleByteCompat) {
                return this.addchDBC(c2);
            }
            if (this.idx < this.len) {
                int n6;
                if (this.insMode) {
                    int n7 = n6 = this.maxIdx < this.len ? this.maxIdx : this.maxIdx - 1;
                    while (n6 > this.idx) {
                        this.data[n6] = this.data[n6 - 1];
                        --n6;
                    }
                    if (this.maxIdx < this.len) {
                        ++this.maxIdx;
                    }
                }
                this.data[this.idx] = c2;
                ++this.idx;
                this.col += TerminalAccept.this.tm.dblWidth(c2) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    for (n6 = this.idx - 2; n6 >= this.maxIdx; --n6) {
                        this.data[n6] = 32;
                    }
                    this.maxIdx = this.idx;
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.addch(this.pict[this.idx]);
                }
                return true;
            }
            if (this.idx > 0 && !TerminalAccept.this.imeActive) {
                this.data[this.idx - 1] = c2;
            }
            return false;
        }

        private int getFirstNotEditIdx(int n2) {
            while (n2 < this.data.length && this.isEditingIndex(n2)) {
                ++n2;
            }
            return n2;
        }

        private int getLastNotEditIdx() {
            int n2;
            for (n2 = this.len - 1; n2 >= 0 && this.isEditingIndex(n2); --n2) {
            }
            return n2 + 1;
        }

        private boolean isSignificantDigit(int n2) {
            return this.data[n2] != ' ' && this.data[n2] != '+' && this.data[n2] != '-';
        }

        private int getFirstDigitIdx() {
            int n2;
            for (n2 = 0; n2 < this.data.length && (!this.isSignificantDigit(n2) || this.isEditingIndex(n2)); ++n2) {
            }
            return n2;
        }

        private void addNnac(char c2) {
            int n2;
            int n3;
            boolean bl;
            boolean bl2 = bl = this.decPointIdx > 0 && this.idx > this.decPointIdx;
            if (bl) {
                n3 = this.decPointIdx + 1;
                n2 = this.data.length;
            } else {
                n3 = 0;
                n2 = this.decPointIdx > 0 ? this.decPointIdx : this.data.length;
            }
            int n4 = this.getFirstDigitIdx();
            if (!bl && n4 > 0) {
                int n5 = 0;
                for (int i2 = n3 + 1; i2 < n2; ++i2) {
                    if (this.isEditingIndex(i2)) {
                        if (i2 >= n4 - 1) {
                            this.data[i2] = this.pict[i2];
                        }
                        ++n5;
                        continue;
                    }
                    this.data[i2 - 1 - n5] = this.data[i2];
                    n5 = 0;
                }
            } else if (this.idx > 0 && this.idx == this.decPointIdx && this.getFirstDigitIdx() == 0) {
                this.right();
                this.addch(c2);
                return;
            }
            this.data[n2 - 1] = c2;
        }

        private boolean addchDBC(char c2) {
            int n2;
            int n3 = n2 = TerminalAccept.this.tm.dblWidth(c2) ? 2 : 1;
            if (this.col + n2 <= this.len) {
                if (this.insMode) {
                    int n4;
                    int n5 = n4 = this.maxIdx < this.len ? this.maxIdx : this.maxIdx - 1;
                    while (n4 > this.idx) {
                        this.data[n4] = this.data[n4 - 1];
                        --n4;
                    }
                    if (this.maxCol + n2 <= this.len) {
                        this.maxCol += n2;
                        ++this.maxIdx;
                    }
                }
                this.data[this.idx] = c2;
                ++this.idx;
                this.col += TerminalAccept.this.tm.dblWidth(c2) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    this.maxIdx = this.idx;
                }
                this.maxCol = this.getMaxCol();
                return true;
            }
            if (this.idx > 0 && !TerminalAccept.this.imeActive) {
                this.data[this.idx - 1] = c2;
                this.maxCol = this.getMaxCol();
            }
            return false;
        }

        boolean isAtEnd() {
            if (TerminalAccept.this.doubleByteCompat) {
                return this.col == this.len;
            }
            return this.idx == this.len;
        }

        void delcur() {
            this.selectedAll = false;
            if (this.idx < this.maxIdx) {
                for (int i2 = this.idx + 1; i2 < this.maxIdx; ++i2) {
                    this.data[i2 - 1] = this.data[i2];
                }
                if (this.maxIdx > 0) {
                    this.data[--this.maxIdx] = 32;
                }
                if (this.idx > this.maxIdx) {
                    this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                    --this.idx;
                }
                if (TerminalAccept.this.doubleByteCompat) {
                    this.maxCol = this.getMaxCol();
                }
            }
        }

        boolean delNnac() {
            this.selectedAll = false;
            int n2 = this.idx;
            if (n2 >= this.len) {
                n2 = this.len - 1;
            }
            while (this.isEditingIndex(n2)) {
                --n2;
            }
            int n3 = this.decPointIdx > 0 ? (n2 > this.decPointIdx ? this.decPointIdx + 1 : 0) : 0;
            int n4 = this.getFirstDigitIdx();
            ++n4;
            while (this.isEditingIndex(n4)) {
                ++n4;
            }
            block2: for (int i2 = n2; i2 > n3; --i2) {
                if (this.pict != null) {
                    if (i2 < this.pict.length && TerminalAccept.isEditing(this.pict[i2])) {
                        if (i2 > n4) continue;
                        this.data[i2] = 32;
                        continue;
                    }
                    for (int i3 = i2 - 1; i3 >= n3; --i3) {
                        if (i3 < this.pict.length && TerminalAccept.isEditing(this.pict[i3])) continue;
                        this.data[i2] = this.data[i3];
                        continue block2;
                    }
                    continue;
                }
                this.data[i2] = this.data[i2 - 1];
            }
            if (!this.isEditingIndex(n3)) {
                this.data[n3] = this.decPointIdx > 0 && n3 > this.decPointIdx ? 48 : 32;
                ++n2;
                while (n2 != this.decPointIdx && n2 < this.len && this.isEditingIndex(n2)) {
                    this.data[n2] = 32;
                    ++n2;
                }
                if (n4 > this.idx) {
                    this.idx = n2;
                    this.col = n2;
                }
            }
            return true;
        }

        boolean delch() {
            boolean bl;
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    --this.idx;
                } else {
                    for (int i2 = this.idx; i2 < this.maxIdx; ++i2) {
                        this.data[i2 - 1] = this.data[i2];
                    }
                    --this.idx;
                    this.data[--this.maxIdx] = 32;
                }
                if (TerminalAccept.this.doubleByteCompat) {
                    this.maxCol = this.getMaxCol();
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.delch();
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        boolean myleft() {
            if (this.idx == 0 || this.getValue() != null && this.getValue().length() == 0 && this.idx == 0) {
                return false;
            }
            return this.left();
        }

        boolean left() {
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                --this.idx;
                if ((TerminalAccept.this.editedFormatted || this.idx != this.decPointIdx) && this.isEditingIndex(this.idx)) {
                    return this.left();
                }
                return true;
            }
            return false;
        }

        boolean myright() {
            int n2;
            String string = this.getValue();
            int n3 = n2 = TerminalAccept.this.national ? this.idx : this.col;
            if (string != null && string.length() != 0 && string.length() == n2) {
                return false;
            }
            return this.right();
        }

        boolean right() {
            this.selectedAll = false;
            int n2 = TerminalAccept.this.doubleByteCompat ? this.len - this.maxCol + this.maxIdx : this.len;
            if (this.idx < (TerminalAccept.this.update ? n2 - 1 : this.maxIdx)) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                ++this.idx;
                if ((TerminalAccept.this.editedFormatted || this.idx != this.decPointIdx) && this.isEditingIndex(this.idx)) {
                    this.right();
                }
                return true;
            }
            return false;
        }

        boolean home() {
            int n2;
            this.selectedAll = false;
            boolean bl = this.idx != 0;
            this.col = this.idx = (n2 = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear ? this.getFirstDigitIdx() : 0);
            return bl;
        }

        boolean end() {
            boolean bl;
            this.selectedAll = false;
            if (TerminalAccept.this.doubleByteCompat) {
                if (this.maxCol == this.len) {
                    bl = this.idx != this.maxIdx - 1;
                    this.idx = this.maxIdx - 1;
                } else {
                    bl = this.idx != this.maxIdx;
                    this.idx = this.maxIdx;
                }
            } else if (this.maxIdx == this.len) {
                bl = this.idx != this.maxIdx - 1;
                this.idx = this.maxIdx - 1;
            } else {
                bl = this.idx != this.maxIdx;
                this.idx = this.maxIdx;
            }
            this.col = 0;
            for (int i2 = 0; i2 < this.idx; ++i2) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[i2]) ? 2 : 1;
            }
            return bl;
        }

        void setOffset(int n2) {
            if (n2 > 0) {
                while (this.idx < this.len && this.idx < n2) {
                    if (this.data[this.idx] >= ' ' && this.data[this.idx] != '\u007f') {
                        this.addch(this.data[this.idx]);
                        continue;
                    }
                    this.addch(' ');
                }
            }
            if (this.maxIdx > 0 && n2 < this.maxIdx) {
                this.idx = n2;
                this.col = 0;
                for (int i2 = 0; i2 < this.idx; ++i2) {
                    this.col += TerminalAccept.this.tm.dblWidth(this.data[i2]) ? 2 : 1;
                }
            }
        }

        int getOffset() {
            return this.col;
        }

        int getIdx() {
            return this.idx;
        }

        int getLength() {
            return this.len;
        }

        char[] getData(boolean bl) {
            int n2;
            char[] cArray;
            int n3;
            if (TerminalAccept.this.doubleByteCompat) {
                n3 = Math.min(this.len - this.maxCol + this.maxIdx, this.data.length);
                cArray = new char[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    cArray[n2] = this.data[n2];
                }
            } else {
                n3 = this.len;
                cArray = this.data;
            }
            if (bl) {
                for (n2 = this.maxIdx; n2 < n3; ++n2) {
                    cArray[n2] = TerminalAccept.this.promptChar;
                }
            } else {
                for (n2 = this.maxIdx; n2 < n3; ++n2) {
                    cArray[n2] = 32;
                }
            }
            return cArray;
        }
    }
}

