/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.KeyboardBuffer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;

public class TerminalModel
implements Constants,
PropertyChangeListener {
    public static final int A_BOLD = 0x1000000;
    public static final int A_UNDERLINE = 0x2000000;
    public static final int A_REVERSE = 0x4000000;
    public static final int A_BLINK = 0x8000000;
    public static final int A_NOECHO = 0x10000000;
    public static final int A_GRAPHIC = 0x20000000;
    public static final int A_NORESET = 0x30000000;
    public static final int A_MASK = -16777216;
    public static final char ACS_HLINE = '\u0003';
    public static final char ACS_LHLINE = '\u0002';
    public static final char ACS_RHLINE = '\u0001';
    public static final char ACS_VLINE = '\f';
    public static final char ACS_TVLINE = '\u0004';
    public static final char ACS_BVLINE = '\b';
    public static final char ACS_ULCORNER = '\u0006';
    public static final char ACS_URCORNER = '\u0005';
    public static final char ACS_LLCORNER = '\n';
    public static final char ACS_LRCORNER = '\t';
    public static final char ACS_BTEE = '\u000b';
    public static final char ACS_TTEE = '\u0007';
    public static final char ACS_LTEE = '\u000e';
    public static final char ACS_RTEE = '\r';
    public static final char ACS_PLUS = '\u000f';
    public static final char KSN_TYP_HOR_OVER = '\u0000';
    public static final char KSN_TYP_HOR_UNDER = '\u0001';
    public static final char KSN_TYP_VER_LEFT = '\u0002';
    public static final char KSN_TYP_VER_RIGHT = '\u0003';
    public static final char KSN_CLR_BLACK = '\u0000';
    public static final char KSN_CLR_BLUE = '\u0001';
    public static final char KSN_CLR_GREEN = '\u0002';
    public static final char KSN_CLR_CYAN = '\u0003';
    public static final char KSN_CLR_RED = '\u0004';
    public static final char KSN_CLR_MAGENTA = '\u0005';
    public static final char KSN_CLR_YELLOW = '\u0006';
    public static final char KSN_CLR_WHITE = '\u0007';
    public static final char KSN_CLR_MASK = '\u000f';
    public static final char KSN_STK_SOLID = '\u0010';
    public static final char KSN_STK_DASHED = ' ';
    public static final char KSN_STK_DOTTED = '0';
    public static final char KSN_STK_DASHLINE = '@';
    public static final char KSN_STK_TWODOT = 'P';
    public static final char KSN_STK_MASK = '\u00f0';
    public static final boolean DEF_AUTOWRAP = false;
    public static final boolean DEF_ANTIALIASING = false;
    public static final int CURSOR_INVIS = 0;
    public static final int CURSOR_UNDER = 1;
    public static final int CURSOR_BLOCK = 2;
    public static final int CURSOR_MIXED = 3;
    public static final int CURSOR_VLINE = 4;
    public static final int DEF_CURSTYPE = 2;
    public static final char defChar = ' ';
    public static final int defAttr = 0xFFFFFF;
    private int x0Orig;
    private int y0Orig;
    private int x0;
    private int y0;
    private int heightOrig;
    private int widthOrig;
    private int width;
    private int height;
    private int heightOutBound;
    private int[][] backMatrix;
    private int[][] attrMatrix;
    private char[][] charMatrix;
    private int[][] kesnMatrix;
    private Point cursor;
    private Point caret;
    private Component withFocus;
    private Point lastCaret;
    private Color lastCaretColor;
    private Color fixedCaretColor;
    private int backColor;
    private int termAttr;
    private Dimension charDim;
    private FontMetrics fm;
    private int zeroWidth;
    private int cursorType;
    boolean insertCursor;
    Selection selection = new Selection();
    private static final Color selColor = new Color(192, 192, 192);
    private boolean autowrap;
    private boolean doubleByteCompat;
    private boolean antialiasing;
    private boolean dragEnabled;
    private String pasteKey;
    private boolean lines3D;
    private AbstractGuiFactoryImpl gf;
    private int lastx = -1;
    private int lasty = -1;
    private static final String eol = System.getProperty("line.separator", "\n");

    public TerminalModel(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        this.gf = abstractGuiFactoryImpl;
        this.setBackColor(Color.black);
        this.setForeColor(Color.white);
    }

    public synchronized void init(int n2, int n3, Dimension dimension, FontMetrics fontMetrics) {
        if (this.charMatrix != null && this.widthOrig > 0 && this.heightOrig > 0) {
            if (n2 != this.widthOrig || n3 != this.heightOrig) {
                if (n3 == this.heightOrig && n2 != this.widthOrig) {
                    this.changeWidth(n2, false);
                } else {
                    this.changeSize(n2, n3);
                }
            }
            return;
        }
        this.fm = fontMetrics;
        this.zeroWidth = this.fm.charWidth('0');
        this.x0 = 0;
        this.x0Orig = 0;
        this.y0 = 0;
        this.y0Orig = 0;
        this.widthOrig = this.width = n2;
        this.heightOrig = this.height = n3;
        this.charDim = dimension;
        this.cursor = new Point();
        this.caret = new Point(-1, -1);
        this.lastCaret = new Point(-1, -1);
        this.backMatrix = null;
        this.attrMatrix = null;
        this.charMatrix = null;
        this.kesnMatrix = null;
        this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        this.antialiasing = this.gf.getCsProperty().get("iscobol.terminal.antialiasing", false);
        this.dragEnabled = this.gf.getCsProperty().get("iscobol.terminal.drag_enabled", true);
        this.lines3D = this.gf.getCsProperty().get("iscobol.terminal.lines_3d", false);
        this.doubleByteCompat = true;
        this.setCaretColor();
        this.gf.getCsProperty().addPropertyChangeListener(this);
    }

    private void setCaretColor() {
        int n2 = this.gf.getCsProperty().get("iscobol.terminal.cursor_color", -1);
        this.fixedCaretColor = n2 >= 0 ? this.gf.getRemotePalette().getDefaultColor(n2) : null;
    }

    private synchronized void initMatrices() {
        if (this.cursor != null && this.backMatrix == null) {
            if (KeyboardBuffer.guiLog != null) {
                Exception exception = new Exception("INIT TERMINAL MATRICES");
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                printWriter.close();
                KeyboardBuffer.guiLog.info(stringWriter.toString());
            }
            this.backMatrix = new int[this.widthOrig][this.heightOrig];
            this.attrMatrix = new int[this.widthOrig][this.heightOrig];
            this.charMatrix = new char[this.widthOrig][this.heightOrig];
            this.kesnMatrix = new int[this.widthOrig][this.heightOrig];
            this.erase();
        }
    }

    public synchronized void changeWidth(int n2) {
        this.changeWidth(n2, true);
    }

    public synchronized void changeWidth(int n2, boolean bl) {
        int n3;
        int n4;
        if (bl) {
            this.initMatrices();
        }
        int n5 = n2 > this.widthOrig ? this.widthOrig : n2;
        int[][] nArray = new int[n2][this.heightOrig];
        int[][] nArray2 = new int[n2][this.heightOrig];
        char[][] cArray = new char[n2][this.heightOrig];
        int[][] nArray3 = new int[n2][this.heightOrig];
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < this.heightOrig; ++n3) {
                nArray[n4][n3] = this.backMatrix[n4][n3];
                nArray2[n4][n3] = this.attrMatrix[n4][n3];
                cArray[n4][n3] = this.charMatrix[n4][n3];
                nArray3[n4][n3] = this.kesnMatrix[n4][n3];
            }
        }
        while (n4 < n2) {
            for (n3 = 0; n3 < this.heightOrig; ++n3) {
                nArray[n4][n3] = this.backColor;
                nArray2[n4][n3] = this.termAttr;
                cArray[n4][n3] = 32;
                nArray3[n4][n3] = 0;
            }
            ++n4;
        }
        this.backMatrix = nArray;
        this.attrMatrix = nArray2;
        this.charMatrix = cArray;
        this.kesnMatrix = nArray3;
        if (this.width == this.widthOrig) {
            this.width = n2;
        }
        this.widthOrig = n2;
    }

    public synchronized void changeSize(int n2, int n3) {
        int n4;
        int n5;
        int n6 = n2 > this.widthOrig ? this.widthOrig : n2;
        int n7 = n3 > this.heightOrig ? this.heightOrig : n3;
        int[][] nArray = new int[n2][n3];
        int[][] nArray2 = new int[n2][n3];
        char[][] cArray = new char[n2][n3];
        int[][] nArray3 = new int[n2][n3];
        for (n5 = 0; n5 < n6; ++n5) {
            for (n4 = 0; n4 < n7; ++n4) {
                nArray[n5][n4] = this.backMatrix[n5][n4];
                nArray2[n5][n4] = this.attrMatrix[n5][n4];
                cArray[n5][n4] = this.charMatrix[n5][n4];
                nArray3[n5][n4] = this.kesnMatrix[n5][n4];
            }
        }
        for (n5 = n6; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                nArray[n5][n4] = this.backColor;
                nArray2[n5][n4] = this.termAttr;
                cArray[n5][n4] = 32;
                nArray3[n5][n4] = 0;
            }
        }
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = n7; n4 < n3; ++n4) {
                nArray[n5][n4] = this.backColor;
                nArray2[n5][n4] = this.termAttr;
                cArray[n5][n4] = 32;
                nArray3[n5][n4] = 0;
            }
        }
        this.backMatrix = nArray;
        this.attrMatrix = nArray2;
        this.charMatrix = cArray;
        this.kesnMatrix = nArray3;
        if (this.width == this.widthOrig) {
            this.width = n2;
        }
        this.widthOrig = n2;
        if (this.height == this.heightOrig) {
            this.height = n3;
        }
        this.heightOrig = n3;
    }

    private void mySetBackColor(Color color) {
        if (color != null) {
            this.backColor = color.getRGB();
        }
    }

    private void mySetForeColor(Color color) {
        if (color != null) {
            this.termAttr = color.getRGB() & 0xFFFFFF | this.termAttr & 0xFF000000;
        }
    }

    public void setSubwindow(int n2, int n3, int n4, int n5) {
        this.initMatrices();
        if (n2 >= 0 && n2 < this.widthOrig) {
            this.x0 = n2;
        }
        if (n3 >= 0 && n3 < this.heightOrig) {
            this.y0 = n3;
        }
        if (n4 >= 0 && n4 < this.widthOrig) {
            this.width = n4;
        }
        if (n5 >= 0 && n5 < this.heightOrig) {
            this.height = n5;
        }
        this.cursor.x = this.x0;
        this.cursor.y = this.y0;
    }

    public void resetSubwindow() {
        this.initMatrices();
        this.x0 = this.x0Orig;
        this.y0 = this.y0Orig;
        this.width = this.widthOrig;
        this.height = this.heightOrig;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.charDim.width * this.widthOrig, this.charDim.height * this.heightOrig);
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.setBackground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, color);
        }
    }

    public void setForeground(Color color, int n2) {
        if (color != null) {
            this.setForeground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, color, n2);
        }
    }

    public void setBackColor(Color color) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetForeColor(color);
        } else {
            this.mySetBackColor(color);
        }
    }

    public void setForeColor(Color color) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetBackColor(color);
        } else {
            this.mySetForeColor(color);
        }
    }

    private void swapForeBack() {
        int n2 = this.termAttr;
        this.termAttr = this.backColor & 0xFFFFFF | this.termAttr & 0xFF000000;
        this.backColor = n2 & 0xFFFFFF;
    }

    public void setCaret(Component component) {
        this.setCaretAt(this.cursor.x, this.cursor.y, component);
    }

    public void setCaretAt(int n2, int n3, Component component) {
        this.withFocus = component;
        this.caret.y = n3 < 0 ? 0 : (n3 >= this.heightOrig ? this.heightOrig - 1 : n3);
        this.caret.x = n2 < 0 ? 0 : (n2 > this.widthOrig ? this.widthOrig : n2);
    }

    public void caretLeft() {
        if (this.caret.x < this.width - 1) {
            ++this.caret.x;
        }
    }

    public void caretRight() {
        if (this.caret.x > this.x0) {
            --this.caret.x;
        }
    }

    public void unsetCaret(Component component) {
        if (component == this.withFocus) {
            this.caret.y = -1;
            this.caret.x = -1;
            this.withFocus = null;
        }
    }

    public void setAttr(int n2) {
        boolean bl = (n2 & 0x4000000) != 0 && (this.termAttr & 0x4000000) == 0;
        this.termAttr = this.termAttr & 0xFFFFFF | n2 & 0xFF000000;
        if (bl) {
            this.swapForeBack();
        }
    }

    public void unsetAttr(int n2) {
        boolean bl = (n2 & 0x4000000) != 0 && (this.termAttr & 0x4000000) != 0;
        this.termAttr &= ~(n2 & 0xFF000000);
        if (bl) {
            this.swapForeBack();
        }
    }

    public void clearAttr() {
        if ((this.termAttr & 0x4000000) != 0) {
            this.swapForeBack();
        }
        this.termAttr &= 0xFFFFFF;
    }

    public boolean move(int n2, int n3) {
        boolean bl = false;
        boolean bl2 = true;
        if (n2 == this.lastx && n3 == this.lasty) {
            bl2 = false;
        }
        this.lastx = n2;
        this.lasty = n3;
        this.initMatrices();
        if (n3 >= this.height) {
            if (bl2) {
                if (this.heightOutBound > 0 && n3 > this.heightOutBound) {
                    this.scroll(n3 - this.heightOutBound);
                } else {
                    this.scroll(n3 - this.height + 1);
                }
                this.heightOutBound = n3;
            }
            n3 = this.height - 1;
            bl = true;
        } else {
            this.heightOutBound = 0;
        }
        if (n2 > this.width) {
            n2 = this.width;
        }
        this.imove(n2, n3);
        return bl;
    }

    private void imove(int n2, int n3) {
        this.cursor.y = n3 < 0 ? 0 : (n3 >= this.heightOrig ? this.heightOrig - 1 : n3);
        this.cursor.x = n2 < 0 ? 0 : (n2 > this.widthOrig ? this.widthOrig : n2);
    }

    public Point getyx() {
        return this.cursor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private synchronized void clearToLine(int n2) {
        int n3;
        this.initMatrices();
        int n4 = this.cursor.y;
        if (this.cursor.x > this.x0) {
            for (n3 = this.cursor.x; n3 < this.width; ++n3) {
                this.backMatrix[n3][n4] = this.backColor;
                this.attrMatrix[n3][n4] = this.termAttr &= 0xFDFFFFFF;
                this.charMatrix[n3][n4] = 32;
                this.kesnMatrix[n3][n4] = 0;
            }
            ++n4;
        }
        while (n4 <= n2) {
            for (n3 = this.x0; n3 < this.width; ++n3) {
                this.backMatrix[n3][n4] = this.backColor;
                this.attrMatrix[n3][n4] = this.termAttr &= 0xFDFFFFFF;
                this.charMatrix[n3][n4] = 32;
                this.kesnMatrix[n3][n4] = 0;
            }
            ++n4;
        }
    }

    public void erase() {
        this.initMatrices();
        this.imove(this.x0, this.y0);
        this.clrtobot();
        this.imove(this.x0, this.y0);
    }

    public void clrtoeol() {
        this.clearToLine(this.cursor.y);
    }

    public void clrtobot() {
        this.clearToLine(this.height - 1);
    }

    public synchronized void scroll(int n2) {
        int n3;
        int n4;
        this.initMatrices();
        if (n2 > 0) {
            int n5 = this.y0;
            n4 = this.y0 + n2;
            while (n5 < this.height - n2) {
                for (n3 = this.x0; n3 < this.width; ++n3) {
                    this.backMatrix[n3][n5] = this.backMatrix[n3][n4];
                    this.attrMatrix[n3][n5] = this.attrMatrix[n3][n4];
                    this.charMatrix[n3][n5] = this.charMatrix[n3][n4];
                    this.kesnMatrix[n3][n5] = this.kesnMatrix[n3][n4];
                }
                ++n5;
                ++n4;
            }
            n3 = this.cursor.x;
            n4 = this.cursor.y - 1;
            this.imove(this.x0, n5);
            this.clearToLine(this.height - 1);
        } else if (n2 == 0) {
            n3 = this.cursor.x;
            n4 = this.cursor.y;
        } else {
            int n6 = this.height - (n2 *= -1) - 1;
            n4 = this.height - 1;
            while (n6 >= this.y0) {
                for (n3 = this.x0; n3 < this.width; ++n3) {
                    this.backMatrix[n3][n4] = this.backMatrix[n3][n6];
                    this.attrMatrix[n3][n4] = this.attrMatrix[n3][n6];
                    this.charMatrix[n3][n4] = this.charMatrix[n3][n6];
                    this.kesnMatrix[n3][n4] = this.kesnMatrix[n3][n6];
                }
                --n6;
                --n4;
            }
            n3 = this.cursor.x;
            n4 = this.cursor.y - 1;
            this.imove(this.x0, this.y0);
            this.clearToLine(this.y0 + n2 - 1);
        }
        if (n4 < 0) {
            n4 = 0;
        }
        this.imove(n3, n4);
    }

    public void setForeground(int n2, int n3, int n4, int n5, Color color, int n6) {
        this.setForeColor(color);
        if (n4 < 1 || n5 < 1) {
            return;
        }
        n6 &= 0xFF000000;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        this.initMatrices();
        if (color == null) {
            for (int i2 = n3 + n5 - 1; i2 >= n3; --i2) {
                for (int i3 = n2 + n4 - 1; i3 >= n2; --i3) {
                    this.attrMatrix[i3][i2] = this.attrMatrix[i3][i2] & 0x20FFFFFF | n6;
                }
            }
        } else {
            int n7 = color.getRGB() & 0xFFFFFF;
            for (int i4 = n3 + n5 - 1; i4 >= n3; --i4) {
                for (int i5 = n2 + n4 - 1; i5 >= n2; --i5) {
                    this.attrMatrix[i5][i4] = n7 | this.attrMatrix[i5][i4] & 0x20000000 | n6;
                }
            }
        }
    }

    public synchronized void setBackground(int n2, int n3, int n4, int n5, Color color) {
        this.setBackColor(color);
        if (n4 < 1 || n5 < 1 || color == null) {
            return;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n4 > this.widthOrig) {
            n4 = this.widthOrig;
        }
        if (n5 > this.heightOrig) {
            n5 = this.heightOrig;
        }
        int n6 = color.getRGB();
        this.initMatrices();
        for (int i2 = n3 + n5 - 1; i2 >= n3; --i2) {
            for (int i3 = n2 + n4 - 1; i3 >= n2; --i3) {
                this.backMatrix[i3][i2] = n6;
            }
        }
    }

    public void clrarea(int n2, int n3, int n4, int n5, Color color, int n6, Color color2) {
        this.initMatrices();
        int n7 = this.termAttr;
        int n8 = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(n6);
        this.setForeColor(color);
        this.setBackColor(color2);
        this.clrarea(n2, n3, n4, n5);
        this.termAttr = n7;
        this.backColor = n8;
    }

    public synchronized void clrarea(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            return;
        }
        if (n3 < this.y0) {
            n3 = this.y0;
        } else if (n3 >= this.height) {
            n3 = this.height - 1;
        }
        if (n2 < this.x0) {
            n2 = this.x0;
        } else if (n2 > this.width) {
            n2 = this.width - 1;
        }
        if (n2 + n4 > this.width) {
            n4 = this.width - n2;
        }
        if (n3 + n5 > this.height) {
            n5 = this.height - n3;
        }
        this.initMatrices();
        for (int i2 = n3 + n5 - 1; i2 >= n3; --i2) {
            for (int i3 = n2 + n4 - 1; i3 >= n2; --i3) {
                this.backMatrix[i3][i2] = this.backColor;
                this.attrMatrix[i3][i2] = this.termAttr;
                this.charMatrix[i3][i2] = 32;
                this.kesnMatrix[i3][i2] = 0;
            }
        }
    }

    private synchronized void rawGLAdd(char c2, boolean bl) {
        if (!bl || (this.attrMatrix[this.cursor.x][this.cursor.y] & 0x20000000) == 0) {
            this.rawadd(c2);
        } else {
            this.rawadd((char)(c2 | this.charMatrix[this.cursor.x][this.cursor.y]));
        }
    }

    public boolean dblWidth(char c2) {
        if (c2 < '\u0080') {
            return false;
        }
        return this.fm.charWidth(c2) > this.zeroWidth;
    }

    private synchronized void rawadd(char c2) {
        this.charMatrix[this.cursor.x][this.cursor.y] = c2;
        this.backMatrix[this.cursor.x][this.cursor.y] = this.backColor;
        this.attrMatrix[this.cursor.x][this.cursor.y] = this.termAttr;
        if (this.cursor.x < this.widthOrig - 1) {
            ++this.cursor.x;
        }
        if (this.dblWidth(c2)) {
            this.rawadd(' ');
        }
    }

    private synchronized boolean addch(char c2) {
        boolean bl = this.dblWidth(c2);
        int n2 = bl ? 2 : 1;
        int n3 = this.cursor.x <= this.width - n2 ? this.cursor.x : this.width - n2;
        this.backMatrix[n3][this.cursor.y] = this.backColor;
        if (this.cursor.x++ >= this.width && this.autowrap) {
            if (++this.cursor.y >= this.height) {
                this.scroll(1);
            }
            this.cursor.x = this.x0;
            n3 = this.cursor.x++;
        }
        if (c2 != '\u0000') {
            this.attrMatrix[n3][this.cursor.y] = this.termAttr;
            this.charMatrix[n3][this.cursor.y] = c2;
        } else {
            int[] nArray = this.attrMatrix[n3];
            int n4 = this.cursor.y;
            nArray[n4] = nArray[n4] & 0x30000000;
            int[] nArray2 = this.attrMatrix[n3];
            int n5 = this.cursor.y;
            nArray2[n5] = nArray2[n5] | this.termAttr;
        }
        if (bl) {
            this.addch(' ');
        }
        return bl;
    }

    public void right() {
        this.initMatrices();
        if (this.cursor.x < this.width) {
            int n2;
            int n3 = n2 = this.dblWidth(this.charMatrix[this.cursor.x][this.cursor.y]) ? 2 : 1;
            if (this.cursor.x <= this.width - n2) {
                this.cursor.x += n2;
            }
        }
    }

    public void left() {
        this.initMatrices();
        if (this.cursor.x > this.x0) {
            --this.cursor.x;
        }
    }

    public void crlf() {
        this.initMatrices();
        if (this.cursor.y < this.height - 1) {
            ++this.cursor.y;
        }
        this.cursor.x = this.x0;
    }

    public Rectangle addstr(char[] cArray) {
        return this.addstr(cArray, 0);
    }

    public Rectangle addstr(char[] cArray, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (cArray == null) {
            return rectangle;
        }
        this.initMatrices();
        this.upperLeft(rectangle);
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.addch(cArray[i2])) continue;
                --n2;
            }
        } else {
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                this.addch(cArray[i3]);
            }
        }
        this.bottomRight(rectangle);
        return rectangle;
    }

    public Rectangle addstr(String string, int n2, Color color, int n3, Color color2, boolean bl) {
        int n4;
        this.initMatrices();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        this.upperLeft(rectangle);
        int n5 = this.termAttr;
        int n6 = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(n3);
        this.setForeColor(color);
        this.setBackColor(color2);
        char[] cArray = new char[n2];
        char[] cArray2 = string != null ? string.toCharArray() : new char[n2];
        int n7 = cArray.length < cArray2.length ? cArray.length : cArray2.length;
        for (n4 = 0; n4 < n7; ++n4) {
            cArray[n4] = cArray2[n4];
        }
        while (n4 < cArray.length) {
            cArray[n4] = 32;
            ++n4;
        }
        if (this.doubleByteCompat && !bl) {
            for (n4 = 0; n4 < n2; ++n4) {
                if (!this.addch(cArray[n4])) continue;
                --n2;
            }
        } else {
            for (n4 = 0; n4 < n2; ++n4) {
                this.addch(cArray[n4]);
            }
        }
        this.termAttr = n5;
        this.backColor = n6;
        this.bottomRight(rectangle);
        return rectangle;
    }

    private void paintBack(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(new Color(n2 & 0xFFFFFF));
        if (n3 > 0 && n6 > n4) {
            graphics.fillRect(n3 * this.charDim.width, n4 * this.charDim.height, this.widthOrig * this.charDim.width, n4 * this.charDim.height + this.charDim.height);
            n3 = 0;
            ++n4;
        }
        if (n3 == 0 && n6 > n4) {
            graphics.fillRect(0, n4 * this.charDim.height, this.widthOrig * this.charDim.width, (n6 - 1) * this.charDim.height + this.charDim.height);
            n3 = 0;
            n4 = n6;
        }
        graphics.fillRect(n3 * this.charDim.width, n4 * this.charDim.height, n5 * this.charDim.width, n4 * this.charDim.height + this.charDim.height);
    }

    private void myDrawString(Graphics graphics, StringBuffer stringBuffer, int n2, int n3) {
        int n4 = stringBuffer.length();
        char[] cArray = new char[1];
        for (int i2 = 0; i2 < n4; ++i2) {
            cArray[0] = stringBuffer.charAt(i2);
            if (cArray[0] == ' ') continue;
            graphics.drawChars(cArray, 0, 1, (n2 + i2) * this.charDim.width, n3);
        }
    }

    private void paintForeLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = n2 & 0xFFFFFF;
        Color color = new Color(n6);
        graphics.setColor(color);
        if ((n2 & 0x20000000) != 0) {
            int n7 = n4 * this.charDim.height + this.charDim.height / 2;
            int n8 = this.charDim.width / 2;
            int n9 = this.charDim.height / 2;
            block13: for (int i2 = n3; i2 < n5; ++i2) {
                switch (this.charMatrix[i2][n4]) {
                    default: {
                        continue block13;
                    }
                    case '\u000f': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width, n7 + 1, i2 * this.charDim.width + this.charDim.width, n7 + 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width, n7 - 1, i2 * this.charDim.width + this.charDim.width, n7 - 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width, n7, i2 * this.charDim.width + this.charDim.width, n7);
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height, i2 * this.charDim.width + n8, n4 * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width, n7 + 1, i2 * this.charDim.width + this.charDim.width, n7 + 1);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width, n7 - 1, i2 * this.charDim.width + this.charDim.width, n7 - 1);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width, n7, i2 * this.charDim.width + this.charDim.width, n7);
                        continue block13;
                    }
                    case '\u0004': 
                    case '\b': 
                    case '\f': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height, i2 * this.charDim.width + n8, n4 * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u0006': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n7 + 1, i2 * this.charDim.width + this.charDim.width, n7 + 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + n9 + 1, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width + n8, n7 - 1, i2 * this.charDim.width + this.charDim.width, n7 - 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + n9 - 1, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width + n8, n7, i2 * this.charDim.width + this.charDim.width, n7);
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height + n9, i2 * this.charDim.width + n8, n4 * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u0005': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width, n7 + 1, i2 * this.charDim.width + n8 - 2, n7 + 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + n9, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width, n7 - 1, i2 * this.charDim.width + n8, n7 - 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + n9 + 1, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width, n7, i2 * this.charDim.width + n8, n7);
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height + n9, i2 * this.charDim.width + n8, n4 * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\t': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width, n7 + 1, i2 * this.charDim.width + n8, n7 + 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + n9);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width, n7 - 1, i2 * this.charDim.width + n8 - 1, n7 - 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + n9 - 1);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width, n7, i2 * this.charDim.width + n8, n7);
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height, i2 * this.charDim.width + n8, n4 * this.charDim.height + n9);
                        continue block13;
                    }
                    case '\n': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width + n8, n7 + 1, i2 * this.charDim.width + this.charDim.width, n7 + 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + n9);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n7 - 1, i2 * this.charDim.width + this.charDim.width, n7 - 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + n9);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width + n8, n7, i2 * this.charDim.width + this.charDim.width, n7);
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height, i2 * this.charDim.width + n8, n4 * this.charDim.height + n9);
                        continue block13;
                    }
                    case '\u0007': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width, n7 + 1, i2 * this.charDim.width + this.charDim.width, n7 + 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + n9, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width, n7 - 1, i2 * this.charDim.width + this.charDim.width, n7 - 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + n9, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width, n7, i2 * this.charDim.width + this.charDim.width, n7);
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height + n9, i2 * this.charDim.width + n8, n4 * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u000b': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width, n7 + 1, i2 * this.charDim.width + this.charDim.width, n7 + 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + n9);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width, n7 - 1, i2 * this.charDim.width + this.charDim.width, n7 - 1);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + n9);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width, n7, i2 * this.charDim.width + this.charDim.width, n7);
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height, i2 * this.charDim.width + n8, n4 * this.charDim.height + n9);
                        continue block13;
                    }
                    case '\u000e': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.drawLine(i2 * this.charDim.width + n8, n7 + 1, i2 * this.charDim.width + this.charDim.width, n7 + 1);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.drawLine(i2 * this.charDim.width + n8, n7 - 1, i2 * this.charDim.width + this.charDim.width, n7 - 1);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height, i2 * this.charDim.width + n8, n4 * this.charDim.height + this.charDim.height);
                        graphics.drawLine(i2 * this.charDim.width + n8, n7, i2 * this.charDim.width + this.charDim.width, n7);
                        continue block13;
                    }
                    case '\r': {
                        if (this.lines3D && n6 == 0) {
                            graphics.setColor(Color.white);
                            graphics.drawLine(i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 + 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.drawLine(i2 * this.charDim.width, n7 + 1, i2 * this.charDim.width + n8, n7 + 1);
                            graphics.setColor(Color.gray);
                            graphics.drawLine(i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height, i2 * this.charDim.width + n8 - 1, n4 * this.charDim.height + this.charDim.height);
                            graphics.drawLine(i2 * this.charDim.width, n7 - 1, i2 * this.charDim.width + n8, n7 - 1);
                            graphics.setColor(color);
                        }
                        graphics.drawLine(i2 * this.charDim.width + n8, n4 * this.charDim.height, i2 * this.charDim.width + n8, n4 * this.charDim.height + this.charDim.height);
                        graphics.drawLine(i2 * this.charDim.width, n7, i2 * this.charDim.width + n8, n7);
                    }
                }
            }
        } else if (n5 > n3) {
            int n10 = n4 * this.charDim.height + this.charDim.height - this.fm.getDescent();
            int n11 = n10 + 1;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i3 = n3; i3 < n5; ++i3) {
                stringBuffer.append(this.charMatrix[i3][n4]);
            }
            if ((n2 & 0x1000000) != 0) {
                Font font = graphics.getFont();
                graphics.setFont(new Font(font.getName(), font.getStyle() | 1, font.getSize()));
            }
            if ((n2 & 0x10000000) == 0) {
                this.myDrawString(graphics, stringBuffer, n3, n10);
            }
            if ((n2 & 0x2000000) != 0) {
                graphics.drawLine(n3 * this.charDim.width, n11, n5 * this.charDim.width, n11);
            }
        }
    }

    public void shadow(int n2, int n3, int n4, int n5, boolean bl) {
        if (n4 > 1 && n5 > 1) {
            int n6;
            this.initMatrices();
            int n7 = this.backColor;
            this.setBackColor(Color.black);
            if (n2 + n4 < this.widthOrig) {
                if (bl) {
                    this.imove(n2 + n4, n3 + 1);
                    this.rawadd(' ');
                } else {
                    this.imove(n2 + n4, n3);
                    this.rawadd(' ');
                    this.imove(n2 + n4, n3 + 1);
                    this.rawadd(' ');
                }
                for (n6 = n3 + 2; n6 < n3 + n5 && n6 < this.heightOrig; ++n6) {
                    this.imove(n2 + n4, n6);
                    this.rawadd(' ');
                }
            }
            if (n3 + n5 < this.heightOrig) {
                this.imove(n2 + 1, n3 + n5);
                this.rawadd(' ');
                for (n6 = n2 + 2; n6 < n2 + n4 && n6 < this.widthOrig; ++n6) {
                    this.rawadd(' ');
                }
                this.rawadd(' ');
            }
            this.backColor = n7;
        }
    }

    private void box(int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        this.setAttr(0x20000000);
        if (n5 == 1 && !bl2) {
            if (n4 > 0) {
                this.imove(n2, n3);
                if (n4 > 1) {
                    this.rawGLAdd('\u0002', bl);
                    for (int i2 = 1; i2 < n4 - 1; ++i2) {
                        this.rawGLAdd('\u0003', bl);
                    }
                    this.rawGLAdd('\u0001', bl);
                } else {
                    this.rawGLAdd('\u0003', bl);
                }
            }
        } else if (n4 == 1) {
            if (n5 > 0) {
                this.imove(n2, n3);
                if (n5 > 1) {
                    int n6;
                    this.rawGLAdd('\u0004', bl);
                    for (n6 = 1; n6 < n5 - 1; ++n6) {
                        this.imove(n2, n3 + n6);
                        this.rawGLAdd('\f', bl);
                    }
                    this.imove(n2, n3 + n6);
                    this.rawGLAdd('\b', bl);
                } else {
                    this.rawGLAdd('\f', bl);
                }
            }
        } else {
            int n7;
            this.imove(n2, n3);
            this.rawGLAdd('\u0006', bl);
            for (n7 = 2; n7 < n4; ++n7) {
                this.rawGLAdd('\u0003', bl);
            }
            this.rawGLAdd('\u0005', bl);
            for (n7 = 1; n7 < n5 - 1; ++n7) {
                this.imove(n2, n3 + n7);
                this.rawGLAdd('\f', bl);
                this.imove(n2 + n4 - 1, n3 + n7);
                this.rawGLAdd('\f', bl);
            }
            this.imove(n2, n3 + n5 - 1);
            this.rawGLAdd('\n', bl);
            for (n7 = 2; n7 < n4; ++n7) {
                this.rawGLAdd('\u0003', bl);
            }
            this.rawGLAdd('\t', bl);
        }
        this.unsetAttr(0x20000000);
    }

    private void printtitle(int n2, int n3, int n4, int n5, String string, int n6) {
        if (string != null && n4 > 6) {
            int n7 = string.length();
            if (n7 > n4 - 6) {
                n7 = n4 - 6;
                string = string.substring(0, n7);
            }
            if (string.length() > 0) {
                string = " " + string + " ";
                n7 += 2;
            }
            switch (n6) {
                default: {
                    this.move(n2 + (n4 - n7) / 2, n3);
                    break;
                }
                case 1: {
                    this.move(n2 + 2, n3);
                    break;
                }
                case 3: {
                    this.move(n2 + n4 - n7 - 2, n3);
                    break;
                }
                case 5: {
                    this.imove(n2 + (n4 - n7) / 2, n3 + n5 - 1);
                    break;
                }
                case 4: {
                    this.imove(n2 + 2, n3 + n5 - 1);
                    break;
                }
                case 6: {
                    this.imove(n2 + n4 - n7 - 2, n3 + n5 - 1);
                }
            }
            this.addstr(string.toCharArray());
            this.imove(n2 + n4, n3 + n5 - 1);
        }
    }

    public void box(int n2, int n3, int n4, int n5, Color color, int n6, Color color2, String[] stringArray, int[] nArray, boolean bl) {
        this.box(n2, n3, n4, n5, color, n6, color2, stringArray, nArray, bl, false);
    }

    public void box(int n2, int n3, int n4, int n5, Color color, int n6, Color color2, String[] stringArray, int[] nArray, boolean bl, boolean bl2) {
        this.initMatrices();
        int n7 = this.termAttr;
        int n8 = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(n6);
        this.setForeColor(color);
        this.setBackColor(color2);
        this.box(n2, n3, n4, n5, bl, bl2);
        if (stringArray[0] != null) {
            this.printtitle(n2, n3, n4, n5, stringArray[0], nArray[0]);
        }
        if (stringArray[1] != null) {
            this.printtitle(n2, n3, n4, n5, stringArray[1], nArray[1]);
        }
        this.termAttr = n7;
        this.backColor = n8;
    }

    private void drawCaretOn(Graphics graphics) {
        if (this.caret.x >= 0) {
            this.lastCaret.x = this.caret.x;
            this.lastCaret.y = this.caret.y;
            int n2 = this.lastCaret.x < this.widthOrig ? this.lastCaret.x : this.widthOrig - 1;
            this.lastCaretColor = this.fixedCaretColor != null ? this.fixedCaretColor : new Color(this.attrMatrix[n2][this.lastCaret.y] & 0xFFFFFF);
            graphics.setColor(this.lastCaretColor);
            graphics.setXORMode(new Color(this.backMatrix[n2][this.lastCaret.y] & 0xFFFFFF));
            switch (this.cursorType) {
                case 0: {
                    break;
                }
                case 1: {
                    graphics.fillRect(n2 * this.charDim.width, this.lastCaret.y * this.charDim.height + this.fm.getAscent(), this.charDim.width, this.fm.getDescent());
                    break;
                }
                case 3: {
                    if (this.insertCursor) {
                        graphics.fillRect(n2 * this.charDim.width, this.lastCaret.y * this.charDim.height + this.charDim.height / 2, this.charDim.width, this.charDim.height / 2);
                        break;
                    }
                    graphics.fillRect(n2 * this.charDim.width, this.lastCaret.y * this.charDim.height + this.fm.getAscent(), this.charDim.width, this.fm.getDescent());
                    break;
                }
                case 4: {
                    if (this.insertCursor) {
                        graphics.fillRect(n2 * this.charDim.width, this.lastCaret.y * this.charDim.height, this.charDim.width / 2, this.charDim.height);
                        break;
                    }
                    graphics.fillRect(n2 * this.charDim.width, this.lastCaret.y * this.charDim.height, 2, this.charDim.height);
                    break;
                }
                default: {
                    if (this.insertCursor) {
                        graphics.fillRect(n2 * this.charDim.width, this.lastCaret.y * this.charDim.height + this.charDim.height / 2, this.charDim.width, this.charDim.height / 2);
                        break;
                    }
                    graphics.fillRect(n2 * this.charDim.width, this.lastCaret.y * this.charDim.height, this.charDim.width, this.charDim.height);
                }
            }
            graphics.setPaintMode();
        }
    }

    private void drawCaretOff(Graphics graphics) {
        if (this.lastCaret.x >= 0) {
            this.lastCaret.y = -1;
            this.lastCaret.x = -1;
            this.lastCaretColor = null;
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n2;
        this.initMatrices();
        int n3 = 0;
        int n4 = this.backMatrix[0][0];
        int n5 = 0;
        int n6 = 0;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialiasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawCaretOff(graphics);
        for (n2 = 0; n2 < this.heightOrig; ++n2) {
            for (n3 = 0; n3 < this.widthOrig; ++n3) {
                if (this.backMatrix[n3][n2] == n4) continue;
                this.paintBack(graphics, n4, n5, n6, n3, n2);
                n4 = this.backMatrix[n3][n2];
                n5 = n3;
                n6 = n2;
            }
        }
        this.paintBack(graphics, n4, n5, n6, n3, n2);
        int n7 = this.attrMatrix[0][0];
        n5 = 0;
        n6 = 0;
        for (n2 = 0; n2 < this.heightOrig; ++n2) {
            for (n3 = 0; n3 < this.widthOrig; ++n3) {
                if (this.attrMatrix[n3][n2] == n7) continue;
                graphics.setColor(new Color(n7 & 0xFF000000));
                while (n6 < n2) {
                    this.paintForeLine(graphics, n7, n5, n6, this.widthOrig);
                    n5 = 0;
                    ++n6;
                }
                this.paintForeLine(graphics, n7, n5, n6, n3);
                n7 = this.attrMatrix[n3][n2];
                n5 = n3;
                n6 = n2;
            }
        }
        while (n6 < n2 - 1) {
            this.paintForeLine(graphics, n7, n5, n6, this.widthOrig);
            n5 = 0;
            ++n6;
        }
        this.paintForeLine(graphics, n7, n5, n6, n3);
        this.paintKeisen(graphics);
        this.drawSelection(graphics);
        this.drawCaretOn(graphics);
    }

    private void drawSelection(Graphics graphics) {
        if (this.selection.x1 != -1) {
            graphics.setColor(selColor);
            graphics.setXORMode(Color.white);
            Selection selection = this.selection.sort();
            if (selection.y1 != selection.y2) {
                graphics.fillRect(selection.x1 * this.charDim.width, selection.y1 * this.charDim.height, this.widthOrig * this.charDim.width, this.charDim.height);
                ++selection.y1;
                while (selection.y1 < selection.y2) {
                    graphics.fillRect(0, selection.y1 * this.charDim.height, this.widthOrig * this.charDim.width, this.charDim.height);
                    ++selection.y1;
                }
                selection.x1 = 0;
            }
            graphics.fillRect(selection.x1 * this.charDim.width, selection.y1 * this.charDim.height, (selection.x2 - selection.x1) * this.charDim.width, this.charDim.height);
            graphics.setPaintMode();
        }
    }

    private void drawKeisenLine(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        BasicStroke basicStroke;
        Color color;
        Graphics2D graphics2D = (Graphics2D)graphics;
        switch (n2 & 0xF) {
            default: {
                color = Color.black;
                break;
            }
            case 1: {
                color = Color.blue;
                break;
            }
            case 2: {
                color = Color.green;
                break;
            }
            case 3: {
                color = Color.cyan;
                break;
            }
            case 4: {
                color = Color.red;
                break;
            }
            case 5: {
                color = Color.magenta;
                break;
            }
            case 6: {
                color = Color.yellow;
                break;
            }
            case 7: {
                color = Color.white;
            }
        }
        graphics2D.setColor(color);
        switch (n2 & 0xF0) {
            default: {
                basicStroke = new BasicStroke();
                break;
            }
            case 32: {
                basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
                break;
            }
            case 48: {
                basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
                break;
            }
            case 64: {
                basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
                break;
            }
            case 80: {
                basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
            }
        }
        graphics2D.setStroke(basicStroke);
        switch (n3) {
            case 0: {
                graphics2D.drawLine(n4 * this.charDim.width, n5 * this.charDim.height, (n4 + n6) * this.charDim.width - 1, n5 * this.charDim.height);
                break;
            }
            case 1: {
                graphics2D.drawLine(n4 * this.charDim.width, (n5 + 1) * this.charDim.height - 1, (n4 + n6) * this.charDim.width - 1, (n5 + 1) * this.charDim.height - 1);
                break;
            }
            case 2: {
                graphics2D.drawLine(n4 * this.charDim.width, n5 * this.charDim.height, n4 * this.charDim.width, (n5 + n6) * this.charDim.height - 1);
                break;
            }
            case 3: {
                graphics2D.drawLine((n4 + 1) * this.charDim.width - 1, n5 * this.charDim.height, (n4 + 1) * this.charDim.width - 1, (n5 + n6) * this.charDim.height - 1);
                break;
            }
        }
    }

    public void keisen(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.initMatrices();
        int n8 = n3 + n5 - 1;
        int n9 = n4 + n6 - 1;
        if (n8 >= this.widthOrig) {
            n8 = this.widthOrig - 1;
        }
        if (n9 >= this.heightOrig) {
            n9 = this.heightOrig - 1;
        }
        switch (n2) {
            case 0: {
                for (int i2 = 0; i2 < this.widthOrig; ++i2) {
                    for (int i3 = 0; i3 < this.heightOrig; ++i3) {
                        this.kesnMatrix[i2][i3] = 0;
                    }
                }
                break;
            }
            case 65536: {
                for (int i4 = n3; i4 <= n8; ++i4) {
                    int[] nArray = this.kesnMatrix[i4];
                    int n10 = n4;
                    nArray[n10] = nArray[n10] | n7;
                }
                break;
            }
            case 393216: {
                int[] nArray = this.kesnMatrix[n3];
                int n11 = n4;
                nArray[n11] = nArray[n11] | n7 << 16;
            }
            case 131072: {
                for (int i5 = n3; i5 <= n8; ++i5) {
                    int[] nArray = this.kesnMatrix[i5];
                    int n12 = n4;
                    nArray[n12] = nArray[n12] | n7 << 8;
                }
                break;
            }
            case 196608: {
                int n13 = n4;
                while (n13 <= n9) {
                    int[] nArray = this.kesnMatrix[n3];
                    int n14 = n13++;
                    nArray[n14] = nArray[n14] | n7 << 16;
                }
                break;
            }
            case 262144: {
                int n15 = n4;
                while (n15 <= n9) {
                    int[] nArray = this.kesnMatrix[n3];
                    int n16 = n15++;
                    nArray[n16] = nArray[n16] | n7 << 24;
                }
                break;
            }
            case 327680: {
                int n17;
                int[] nArray = this.kesnMatrix[n3];
                int n18 = n4;
                nArray[n18] = nArray[n18] | n7 << 16;
                for (n17 = n3; n17 <= n8; ++n17) {
                    int[] nArray2 = this.kesnMatrix[n17];
                    int n19 = n4;
                    nArray2[n19] = nArray2[n19] | n7;
                }
                int[] nArray3 = this.kesnMatrix[n8];
                int n20 = n4;
                nArray3[n20] = nArray3[n20] | n7 << 24;
                n17 = n4 + 1;
                while (n17 < n9) {
                    int[] nArray4 = this.kesnMatrix[n3];
                    int n21 = n17;
                    nArray4[n21] = nArray4[n21] | n7 << 16;
                    int[] nArray5 = this.kesnMatrix[n8];
                    int n22 = n17++;
                    nArray5[n22] = nArray5[n22] | n7 << 24;
                }
                int[] nArray6 = this.kesnMatrix[n3];
                int n23 = n9;
                nArray6[n23] = nArray6[n23] | n7 << 16;
                for (n17 = n3; n17 <= n8; ++n17) {
                    int[] nArray7 = this.kesnMatrix[n17];
                    int n24 = n9;
                    nArray7[n24] = nArray7[n24] | n7 << 8;
                }
                int[] nArray8 = this.kesnMatrix[n8];
                int n25 = n9;
                nArray8[n25] = nArray8[n25] | n7 << 24;
                break;
            }
        }
    }

    void paintKeisen(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        this.initMatrices();
        for (n11 = 0; n11 < this.heightOrig; ++n11) {
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            n6 = 0;
            for (n5 = 0; n5 < this.widthOrig; ++n5) {
                n4 = this.kesnMatrix[n5][n11];
                if (n4 == n10) continue;
                n3 = n4 & 0xFF;
                if (n3 != n9) {
                    if (n9 != 0) {
                        this.drawKeisenLine(graphics, n9, 0, n7, n11, n5 - n7);
                    }
                    n7 = n5;
                    n9 = n3;
                }
                if ((n2 = (n4 & 0xFF00) >>> 8) != n8) {
                    if (n8 != 0) {
                        this.drawKeisenLine(graphics, n8, 1, n6, n11, n5 - n6);
                    }
                    n6 = n5;
                    n8 = n2;
                }
                n10 = n4;
            }
            if (n9 != 0) {
                this.drawKeisenLine(graphics, n9, 0, n7, n11, n5 - n7);
            }
            if (n8 == 0) continue;
            this.drawKeisenLine(graphics, n8, 1, n6, n11, n5 - n6);
        }
        for (n5 = 0; n5 < this.widthOrig; ++n5) {
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            n6 = 0;
            for (n11 = 0; n11 < this.heightOrig; ++n11) {
                n4 = this.kesnMatrix[n5][n11];
                if (n4 == n10) continue;
                n3 = (n4 & 0xFF0000) >>> 16;
                if (n3 != n9) {
                    if (n9 != 0) {
                        this.drawKeisenLine(graphics, n9, 2, n5, n7, n11 - n7);
                    }
                    n7 = n11;
                    n9 = n3;
                }
                if ((n2 = (n4 & 0xFF000000) >>> 24) != n8) {
                    if (n8 != 0) {
                        this.drawKeisenLine(graphics, n8, 3, n5, n6, n11 - n6);
                    }
                    n6 = n11;
                    n8 = n2;
                }
                n10 = n4;
            }
            if (n9 != 0) {
                this.drawKeisenLine(graphics, n9, 2, n5, n7, n11 - n7);
            }
            if (n8 == 0) continue;
            this.drawKeisenLine(graphics, n8, 3, n5, n6, n11 - n6);
        }
    }

    private static void rtrim(StringBuffer stringBuffer) {
        int n2;
        block3: for (n2 = stringBuffer.length() - 1; n2 >= 0; --n2) {
            switch (stringBuffer.charAt(n2)) {
                case ' ': 
                case '\u3000': {
                    continue block3;
                }
            }
        }
        stringBuffer.setLength(n2 + 1);
        stringBuffer.append(eol);
    }

    public StringBuffer getSelectedText() {
        StringBuffer stringBuffer;
        this.initMatrices();
        if (this.selection.x1 != -1) {
            int n2;
            stringBuffer = new StringBuffer();
            Selection selection = this.selection.sort();
            if (selection.x2 > this.widthOrig) {
                selection.x2 = this.widthOrig - 1;
            }
            if (selection.y2 > this.heightOrig) {
                selection.y2 = this.heightOrig - 1;
            }
            if (selection.y1 != selection.y2) {
                for (n2 = selection.x1; n2 < this.widthOrig && n2 < this.charMatrix.length && selection.y1 < this.charMatrix[n2].length; ++n2) {
                    stringBuffer.append(this.getSelectedChar(n2, selection.y1));
                }
                TerminalModel.rtrim(stringBuffer);
                ++selection.y1;
                while (selection.y1 < selection.y2) {
                    for (n2 = 0; n2 < this.widthOrig && n2 < this.charMatrix.length && selection.y1 < this.charMatrix[n2].length; ++n2) {
                        stringBuffer.append(this.getSelectedChar(n2, selection.y1));
                    }
                    TerminalModel.rtrim(stringBuffer);
                    ++selection.y1;
                }
                selection.x1 = 0;
            }
            for (n2 = selection.x1; n2 < selection.x2 && n2 < this.charMatrix.length && selection.y1 < this.charMatrix[n2].length; ++n2) {
                stringBuffer.append(this.getSelectedChar(n2, selection.y1));
            }
        } else {
            stringBuffer = null;
        }
        return stringBuffer;
    }

    private char getSelectedChar(int n2, int n3) {
        if ((this.attrMatrix[n2][n3] & 0x10000000) == 0x10000000) {
            return ' ';
        }
        return this.charMatrix[n2][n3];
    }

    public Area getArea(int n2, int n3, int n4, int n5) {
        this.initMatrices();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        return new Area(n2, n3, n4, n5, this.backMatrix, this.attrMatrix, this.charMatrix, this.kesnMatrix);
    }

    public synchronized void restoreArea(Area area, int n2, int n3, int n4, int n5) {
        this.initMatrices();
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        int n6 = n3 + n5 - 1;
        int n7 = n3 + n5 - area.y0 - 1;
        while (n6 >= n3) {
            int n8 = n2 + n4 - 1;
            int n9 = n2 + n4 - area.x0 - 1;
            while (n8 >= n2) {
                this.backMatrix[n8][n6] = area.backMatrix[n9][n7];
                this.attrMatrix[n8][n6] = area.attrMatrix[n9][n7];
                this.charMatrix[n8][n6] = area.charMatrix[n9][n7];
                this.kesnMatrix[n8][n6] = area.kesnMatrix[n9][n7];
                --n8;
                --n9;
            }
            --n6;
            --n7;
        }
    }

    private void upperLeft(Rectangle rectangle) {
        rectangle.x = this.cursor.x;
        rectangle.y = this.cursor.y;
    }

    private void bottomRight(Rectangle rectangle) {
        if (rectangle.y == this.cursor.y && rectangle.x < this.cursor.x) {
            rectangle.width = (this.cursor.x - rectangle.x) * this.charDim.width;
            rectangle.height = this.charDim.height;
            rectangle.x *= this.charDim.width;
            rectangle.y *= this.charDim.height;
        } else if (rectangle.y < this.cursor.y) {
            rectangle.width = this.width * this.charDim.width;
            rectangle.height = (this.cursor.y - rectangle.y + 1) * this.charDim.height;
            rectangle.x = 0;
            rectangle.y *= this.charDim.height;
        } else {
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
        }
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public synchronized String acceptFromScreen(int n2, int n3, int n4) {
        this.initMatrices();
        char[] cArray = new char[n4];
        int n5 = 0;
        n3 = n3 < 1 ? (n2 < 1 ? this.cursor.x : 0) : --n3;
        n2 = n2 < 1 ? this.cursor.y : --n2;
        if (n3 < this.width && n2 < this.height) {
            while (n4 > 0 && n2 < this.height) {
                cArray[n5++] = this.charMatrix[n3][n2];
                if (++n3 >= this.width) {
                    n3 = 0;
                    ++n2;
                }
                --n4;
            }
        }
        return new String(cArray);
    }

    protected synchronized char[] getTextAt(int n2, int n3, int n4) {
        this.initMatrices();
        if (n2 < 0 || n3 < 0 || n4 < 1 || n2 >= this.height || n3 >= this.width) {
            return new char[0];
        }
        char[] cArray = new char[Math.min(n4, this.width - n3)];
        int n5 = n3;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = this.charMatrix[n5][n2];
            ++n5;
        }
        return cArray;
    }

    private char getVirtualAttr(int n2, int n3) {
        int n4 = this.attrMatrix[n2][n3] & 0xFF000000;
        int n5 = this.attrMatrix[n2][n3] & 0xFFFFFF;
        int n6 = this.backMatrix[n2][n3] & 0xFFFFFF;
        int n7 = n5 == 0 ? (n6 == 0 ? n4 | 0x10000000 : n4 | 0x4000000) : (n5 == 0xFFFFFF ? n4 | 0x1000000 : (n6 == 0xFFFFFF ? (n5 == 0x808080 ? n4 | 0x4000000 | 0x1000000 : n4 | 0x4000000) : n4));
        return (char)(n7 >>> 24);
    }

    private void setVirtualAttr(char c2, int n2, int n3) {
        int n4 = c2 << 24;
        this.attrMatrix[n2][n3] = n4 | 0xC0C0C0;
        switch (n4 & 0x5000000) {
            case 0x4000000: {
                this.attrMatrix[n2][n3] = n4;
                this.backMatrix[n2][n3] = 0xFFFFFF | this.backMatrix[n2][n3] & 0xFF000000;
                break;
            }
            case 0x1000000: {
                this.attrMatrix[n2][n3] = n4 | 0xFFFFFF;
                this.backMatrix[n2][n3] = this.backMatrix[n2][n3] & 0xFF000000;
                break;
            }
            case 0x5000000: {
                this.attrMatrix[n2][n3] = n4 | 0x808080;
                this.backMatrix[n2][n3] = 0xFFFFFF | this.backMatrix[n2][n3] & 0xFF000000;
            }
        }
    }

    public synchronized String attrFromScreen(int n2, int n3, int n4) {
        this.initMatrices();
        char[] cArray = new char[n4];
        int n5 = 0;
        n2 = n2 < 1 ? this.cursor.y : --n2;
        n3 = n3 < 1 ? this.cursor.x : --n3;
        if (n3 < this.width && n2 < this.height) {
            while (n4 > 0 && n2 < this.height) {
                cArray[n5++] = this.getVirtualAttr(n3, n2);
                if (++n3 >= this.width) {
                    n3 = 0;
                    ++n2;
                }
                --n4;
            }
        }
        return new String(cArray);
    }

    public synchronized void writeToScreen(int n2, int n3, int n4, String string, String string2) {
        this.initMatrices();
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n5 = 0;
        n2 = n2 < 1 ? this.cursor.y : --n2;
        n3 = n3 < 1 ? this.cursor.x : --n3;
        if (n3 < this.width && n2 < this.height) {
            while (n4 > 0 && n2 < this.height) {
                this.charMatrix[n3][n2] = cArray[n5];
                this.setVirtualAttr(cArray2[n5], n3, n2);
                ++n5;
                if (++n3 >= this.width) {
                    n3 = 0;
                    ++n2;
                }
                --n4;
            }
        }
    }

    public int getBackColor() {
        return this.backColor;
    }

    public int getTermAttr() {
        return this.termAttr;
    }

    public void setBackColor(int n2) {
        this.backColor = n2;
    }

    public void setTermAttr(int n2) {
        this.termAttr = n2;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.gf != null && string.equals("iscobol.terminal.autowrap")) {
            this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        }
        if (this.gf != null && string.equals("iscobol.terminal.drag_enabled")) {
            this.dragEnabled = this.gf.getCsProperty().get("iscobol.terminal.drag_enabled", true);
        }
        if (this.gf != null && string.equals("iscobol.terminal.cursor_color")) {
            this.setCaretColor();
        }
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public String getPasteKey() {
        return this.pasteKey;
    }

    public synchronized void end() {
        this.gf.getCsProperty().removePropertyChangeListener(this);
        this.gf = null;
        this.backMatrix = null;
        this.attrMatrix = null;
        this.charMatrix = null;
        this.kesnMatrix = null;
        this.cursor = null;
        this.caret = null;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int n2) {
        this.cursorType = n2;
    }

    public boolean isDoubleByteCompat() {
        return this.doubleByteCompat;
    }

    public static class Selection {
        public int x1 = -1;
        public int y1 = -1;
        public int x2 = -1;
        public int y2 = -1;

        Selection sort() {
            Selection selection = new Selection();
            if (this.y2 >= this.y1) {
                selection.y1 = this.y1;
                selection.y2 = this.y2;
                if (this.y2 == this.y1 && this.x2 < this.x1) {
                    selection.x1 = this.x2;
                    selection.x2 = this.x1 + 1;
                } else {
                    selection.x1 = this.x1;
                    selection.x2 = this.x2;
                }
            } else {
                selection.y1 = this.y2;
                selection.y2 = this.y1;
                selection.x1 = this.x2;
                selection.x2 = this.x1 + 1;
            }
            return selection;
        }
    }

    public static class Area {
        private int[][] backMatrix;
        private int[][] attrMatrix;
        private char[][] charMatrix;
        private int[][] kesnMatrix;
        int x0;
        int y0;
        int width;
        int height;

        private Area(int n2, int n3, int n4, int n5, int[][] nArray, int[][] nArray2, char[][] cArray, int[][] nArray3) {
            this.x0 = n2;
            this.y0 = n3;
            this.width = n4;
            this.height = n5;
            this.backMatrix = new int[this.width][this.height];
            this.attrMatrix = new int[this.width][this.height];
            this.charMatrix = new char[this.width][this.height];
            this.kesnMatrix = new int[this.width][this.height];
            for (int i2 = 0; i2 < this.height; ++i2) {
                for (int i3 = 0; i3 < this.width; ++i3) {
                    this.backMatrix[i3][i2] = nArray[i3 + n2][i2 + n3];
                    this.attrMatrix[i3][i2] = nArray2[i3 + n2][i2 + n3];
                    this.charMatrix[i3][i2] = cArray[i3 + n2][i2 + n3];
                    this.kesnMatrix[i3][i2] = nArray3[i3 + n2][i2 + n3];
                }
            }
        }
    }
}

