/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.ScaleLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class ZoomLayout
extends ScaleLayout {
    private float maxFontZoom;
    private float minFontZoom;

    public ZoomLayout(Container container, String string) {
        this(container, string, 0, 0);
    }

    public ZoomLayout(Container container, String string, int n2, int n3) {
        super(container, string);
        Integer n4 = (Integer)this.cTypeLayoutDatas.get("max-font-zoom");
        if (n4 != null) {
            this.maxFontZoom = n4.floatValue() / 100.0f;
            this.cTypeLayoutDatas.remove("max-font-zoom");
        } else {
            this.maxFontZoom = (float)n3 / 100.0f;
        }
        n4 = (Integer)this.cTypeLayoutDatas.get("min-font-zoom");
        if (n4 != null) {
            this.minFontZoom = n4.floatValue() / 100.0f;
            this.cTypeLayoutDatas.remove("min-font-zoom");
        } else {
            this.minFontZoom = (float)n2 / 100.0f;
        }
    }

    @Override
    public void addLayoutComponent(Component component, IscobolLayout.LayoutData layoutData) {
        this.addLayoutComponent(component, (Object)layoutData);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = this.createLayoutData(component, 0, 1, 0, 1, "0", null);
        } else if (!(object instanceof ZoomLayoutData)) {
            throw new IllegalArgumentException("ZoomLayoutData object required.");
        }
        super.addLayoutComponent(component, object);
        ((ZoomLayoutData)object).setOrigFont(component.getFont());
    }

    @Override
    public IscobolLayout.LayoutData createLayoutData(Component component, int n2, int n3, int n4, int n5, String string, String string2) {
        return new ZoomLayoutData(component, n2, n3, n4, n5, string);
    }

    @Override
    protected void layoutContainer(Dimension dimension) {
        super.layoutContainer(dimension);
        float f2 = this.getResizeFontDelta();
        for (Component component : this.constraintsTable.keySet()) {
            Font font;
            ZoomLayoutData zoomLayoutData = (ZoomLayoutData)this.constraintsTable.get(component);
            if ((zoomLayoutData.getAction() & 0x10) != 16 || (font = zoomLayoutData.getOrigFont()) == null) continue;
            component.setFont(font.deriveFont(font.getSize2D() * f2));
            for (FontProvider fontProvider : zoomLayoutData.additionalFonts.keySet()) {
                Font font2 = (Font)zoomLayoutData.additionalFonts.get(fontProvider);
                if (font2 == null) {
                    font2 = fontProvider.getFont();
                    zoomLayoutData.additionalFonts.put(fontProvider, font2);
                }
                if (font2 == null) continue;
                fontProvider.setFont(font2.deriveFont(font2.getSize2D() * f2));
            }
        }
    }

    private float getResizeFontDelta() {
        float f2 = this.containerHeightDelta;
        if (this.minFontZoom > 0.0f && this.containerHeightDelta < this.minFontZoom) {
            f2 = this.minFontZoom;
        }
        if (this.maxFontZoom > 0.0f && this.containerHeightDelta > this.maxFontZoom) {
            f2 = this.maxFontZoom;
        }
        return f2;
    }

    @Override
    public String getDefaultLayoutDataString(String string) {
        try {
            string = string.toLowerCase();
            Integer n2 = (Integer)this.cTypeLayoutDatas.get(string);
            if (n2 != null) {
                return n2.toString();
            }
            return String.valueOf(119);
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public static class ZoomLayoutData
    extends IscobolLayout.DefaultLayoutData {
        private Font origFont;
        private Map<FontProvider, Font> additionalFonts = new HashMap<FontProvider, Font>();

        public ZoomLayoutData(Component component, int n2, int n3, int n4, int n5, String string) {
            super(component, n2, n3, n4, n5, string, null);
        }

        public void putAdditionalOrigFont(FontProvider fontProvider) {
            this.additionalFonts.put(fontProvider, fontProvider.getFont());
        }

        public void removeAdditionalOrigFont(FontProvider fontProvider) {
            this.additionalFonts.remove(fontProvider);
        }

        public void setOrigFont(Font font) {
            this.origFont = font;
        }

        public Font getOrigFont() {
            return this.origFont;
        }
    }

    public static interface FontProvider {
        public Font getFont();

        public void setFont(Font var1);
    }
}

