/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.IllegalComponentStateException;
import charva.awt.Insets;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.AWTEvent;
import charva.awt.event.WindowEvent;
import charvax.swing.JButton;
import charvax.swing.JDialog;
import charvax.swing.JFrame;
import charvax.swing.JMenuBar;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.charva.CobolEventCouple;
import com.iscobol.gui.client.charva.ISCharvaUtility;
import com.iscobol.gui.client.charva.KeyboardBufferQueue;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import com.iscobol.gui.client.charva.Terminal;
import com.iscobol.gui.client.charva.TerminalModel;
import java.awt.Color;
import java.util.EventObject;
import java.util.LinkedList;

public class BorderedFrame
implements Constants,
Runnable {
    private Window component;
    private boolean isActive;
    private boolean isActiveAccept;
    private LinkedList fifo = new LinkedList();
    private int type;
    private Thread eventThread;
    RemoteDisplayWindow parentDW;
    private Terminal charTerminal;

    public BorderedFrame(RemoteDisplayWindow remoteDisplayWindow, BorderedFrame borderedFrame, int n2) {
        this.type = n2;
        this.parentDW = remoteDisplayWindow;
        switch (this.type) {
            case 2: 
            case 3: 
            case 6: {
                this.component = new MyJFrame(this);
            }
        }
        this.charTerminal = new Terminal(this.parentDW.getGuiFactory());
        this.initialize(remoteDisplayWindow);
    }

    public boolean isJFrame() {
        return this.component instanceof JFrame;
    }

    public boolean isJDialog() {
        return this.component instanceof JDialog;
    }

    public JFrame getJFrame() {
        if (this.component instanceof JFrame) {
            return (JFrame)this.component;
        }
        return null;
    }

    public JDialog getJDialog() {
        if (this.component instanceof JDialog) {
            return (JDialog)this.component;
        }
        return null;
    }

    public Window getWindow() {
        return this.component;
    }

    public MyJFrame getMFWindow() {
        return (MyJFrame)this.component;
    }

    public void resumeRunBody() {
        if (this.component != null) {
            ((MyJFrame)this.component).resumeRunBody();
        }
    }

    public void suspendRunBody() {
        if (this.component != null) {
            ((MyJFrame)this.component).suspendRunBody();
        }
    }

    private void initialize(RemoteDisplayWindow remoteDisplayWindow) {
        this.eventThread = new Thread(this);
        this.eventThread.setDaemon(true);
        this.eventThread.setName("Picobol-" + this.eventThread.getName());
        this.eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.eventThread != null) {
            CobolEventCouple cobolEventCouple;
            LinkedList linkedList = this.fifo;
            synchronized (linkedList) {
                while (this.fifo.isEmpty()) {
                    try {
                        this.fifo.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                cobolEventCouple = (CobolEventCouple)this.fifo.removeLast();
            }
            if (cobolEventCouple.sendToServer()) continue;
            KeyboardBufferQueue.getInstance().enable(null);
            break;
        }
    }

    public void setActiveAccept(boolean bl) {
        this.isActiveAccept = bl;
    }

    public boolean isActiveAccept() {
        return this.isActiveAccept;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void putNewLocalControlFocused(CobolEventCouple cobolEventCouple) {
        if (cobolEventCouple != null && this.parentDW != null && cobolEventCouple.getRemoteRecordAccept() != null) {
            RemoteBaseGUIControl remoteBaseGUIControl = this.parentDW.getNewLocalFocusOwner();
            if (remoteBaseGUIControl != null) {
                cobolEventCouple.getRemoteRecordAccept().setNewControlFocused(remoteBaseGUIControl.getServerId());
            }
            this.parentDW.resetNewLocalFocusOwner();
            cobolEventCouple.getRemoteRecordAccept().setOldFocusValues(this.parentDW.getOldFocusValues());
            this.parentDW.resetOldFocusValues();
        }
    }

    protected void push(CobolEventCouple cobolEventCouple) {
        this.push(cobolEventCouple, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushWithPriority(CobolEventCouple cobolEventCouple) {
        KeyboardBufferQueue.getInstance().disable();
        this.suspendRunBody();
        this.putNewLocalControlFocused(cobolEventCouple);
        LinkedList linkedList = this.fifo;
        synchronized (linkedList) {
            this.fifo.addLast(cobolEventCouple);
            this.fifo.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(CobolEventCouple cobolEventCouple, boolean bl) {
        if (bl) {
            KeyboardBufferQueue.getInstance().disable();
            this.suspendRunBody();
        }
        this.putNewLocalControlFocused(cobolEventCouple);
        LinkedList linkedList = this.fifo;
        synchronized (linkedList) {
            this.fifo.addFirst(cobolEventCouple);
            this.fifo.notify();
        }
    }

    public void setResizable(boolean bl) {
    }

    public Container getContentPane() {
        if (this.component != null) {
            return ((MyWindow)this.component).getContentPane();
        }
        return null;
    }

    public void setInitD(int n2, int n3) {
        this.pack();
    }

    public void setInitD(int n2, int n3, float f2, float f3, LocalFontCmp localFontCmp) {
        this.charTerminal.init(f2, f3, n2, n3);
        this.charTerminal.setBounds(0, 0, n2, n3);
        this.setInitD(n2, n3);
    }

    private void installListeners() {
    }

    public Container getPanel() {
        return this.getContentPane();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        ((MyWindow)this.component).setJMenuBar(jMenuBar);
    }

    public void setAutoResize(boolean bl) {
    }

    private void addScrollbars() {
    }

    private void removeScrollbars() {
    }

    public void pack() {
        ((MyWindow)this.component).myPack();
    }

    void setDefaultButton(JButton jButton) {
    }

    public void setVisible(boolean bl) {
    }

    public void internalsetVisible(boolean bl) {
        ((MyWindow)this.component).mySetVisible(bl);
    }

    private void setVisibleSeparateThread() {
    }

    public java.awt.Rectangle getBounds() {
        Rectangle rectangle = this.component.getBounds();
        java.awt.Rectangle rectangle2 = new java.awt.Rectangle(rectangle.getTop(), rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight());
        return rectangle2;
    }

    public void setEnabled(boolean bl) {
        this.component.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.component.isEnabled();
    }

    public Component getFocusOwner() {
        return null;
    }

    public void setBackground(Color color) {
        this.charTerminal.setBackground(new charva.awt.Color(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public void setBackColor(Color color) {
        this.charTerminal.setBackColor(new charva.awt.Color(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public void setForeground(Color color) {
        this.charTerminal.setForeground(new charva.awt.Color(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public void box(int n2, int n3, int n4, int n5, Color color, int n6, Color color2, String[] stringArray, int[] nArray, boolean bl) {
        charva.awt.Color color3 = new charva.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
        charva.awt.Color color4 = new charva.awt.Color(color2.getRed(), color2.getGreen(), color2.getBlue());
        this.charTerminal.getTerminalModel().box(n2, n3, n4, n5, color3, n6, color4, stringArray, nArray, true, bl, this.charTerminal.getGraphics());
    }

    public java.awt.Rectangle display(int n2, int n3, String string, int n4, Color color, int n5, Color color2, Justification justification) {
        Rectangle rectangle = null;
        charva.awt.Color color3 = new charva.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
        charva.awt.Color color4 = new charva.awt.Color(color2.getRed(), color2.getGreen(), color2.getBlue());
        rectangle = this.charTerminal.display(n2, n3, string, n4, color3, n5, color4, justification);
        return new java.awt.Rectangle(rectangle.getTop(), rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight());
    }

    public Terminal getCharTerminal() {
        return this.charTerminal;
    }

    public void erase(int n2, int n3, int n4, charva.awt.Color color) {
        TerminalModel terminalModel = this.charTerminal.getTerminalModel();
        switch (n2) {
            case 2: {
                terminalModel.move(n3, n4);
                terminalModel.clrtoeol();
                break;
            }
            case 1: {
                terminalModel.move(n3, n4);
                if (color != null) {
                    terminalModel.setBackColor(color);
                }
                terminalModel.clrtobot();
                break;
            }
            case 3: {
                if (color != null) {
                    terminalModel.setBackground(color);
                }
                terminalModel.erase();
            }
        }
        this.charTerminal.repaint();
    }

    public void scroll(int n2, int n3, int n4) {
        TerminalModel terminalModel = this.charTerminal.getTerminalModel();
        terminalModel.scroll(n2);
        this.charTerminal.repaint();
    }

    public java.awt.Rectangle display(String string, boolean bl) {
        TerminalModel terminalModel = this.charTerminal.getTerminalModel();
        Rectangle rectangle = terminalModel.addstr(string.toCharArray());
        if (bl) {
            terminalModel.crlf();
        }
        return new java.awt.Rectangle(rectangle.getTop(), rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight());
    }

    public void setModal(boolean bl) {
    }

    public boolean isModal() {
        return false;
    }

    public void setTitle(String string) {
        ((MyWindow)this.component).setTitle(string);
    }

    public void setTitleBar(boolean bl) {
    }

    public void setLocation(int n2, int n3) {
        this.component.setLocation(n2, n3);
    }

    public boolean isResizable() {
        return false;
    }

    public String getTitle() {
        return ((MyWindow)this.component).getTitle();
    }

    public Insets getInsets() {
        return this.component.getInsets();
    }

    public Dimension getSize() {
        return this.component.getSize();
    }

    public void setState(int n2) {
    }

    public void dispose() {
        this.getMFWindow().dispose();
        this.charTerminal.end();
        this.charTerminal = null;
    }

    private static class MyJFrame
    extends JFrame
    implements MyWindow {
        BorderedFrame parent;
        private boolean isDestroyed;
        private boolean suspended;
        KeyboardBufferQueue kbq;

        MyJFrame(BorderedFrame borderedFrame) {
            this.parent = borderedFrame;
            Container container = this.getContentPane();
            container.setLayout(null);
            container.setSize(0, 0);
            this.kbq = KeyboardBufferQueue.getInstance();
        }

        @Override
        public Component getCurrentFocus() {
            return this.getCurrentFocus(true);
        }

        @Override
        public Component getCurrentFocus(boolean bl) {
            Component component;
            block2: {
                component = null;
                try {
                    component = super.getCurrentFocus();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    if (!bl) break block2;
                    ISCharvaUtility.printExceptionToStderr("Window [" + this + "] has currentFocus = null", (Exception)((Object)illegalComponentStateException));
                }
            }
            return component;
        }

        public void run() {
            if (this.parent.type == 2) {
                new Thread(){

                    @Override
                    public void run() {
                        this.runbody();
                    }
                }.start();
            } else {
                this.runbody();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void runbody() {
            EventQueue eventQueue = this._term.getSystemEventQueue();
            Toolkit toolkit = null;
            Window window = null;
            Component component = null;
            try {
                this.isDestroyed = false;
                while (!this.isDestroyed && !this.suspended) {
                    Object object;
                    toolkit = Toolkit.getDefaultToolkit();
                    window = toolkit.getTopWindow();
                    if (window != null && this == window) {
                        component = this.getCurrentFocus(false);
                        if (component == null) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else if (this.kbq.isEmpty()) {
                            this._term.checkForKeystroke();
                        } else {
                            this.kbq.repostBufEvents(this.getTitle());
                        }
                    }
                    while (!this.isDestroyed && !eventQueue.queuesAreEmpty()) {
                        object = eventQueue.getNextEvent();
                        if ((object = this.kbq.dispatchEvent((EventObject)object, this)) == null) continue;
                        this.processEvent((AWTEvent)object);
                    }
                    object = this;
                    synchronized (object) {
                        while (this.suspended) {
                            this.wait();
                        }
                    }
                }
                return;
            }
            catch (Exception exception) {
                ISCharvaUtility.printExceptionToStderr("BorderedFrame exit(1)", exception);
                System.exit(1);
            }
        }

        public void pack() {
            this.parent.pack();
        }

        public void setVisible(boolean bl) {
            this.parent.setVisible(bl);
        }

        @Override
        public void myPack() {
            super.pack();
        }

        @Override
        public void mySetVisible(boolean bl) {
            if (this.isVisible() != bl) {
                super.setVisible(bl);
            }
        }

        public void dispose() {
            this.isDestroyed = true;
            this.processEvent((AWTEvent)new WindowEvent((Window)this, 3));
        }

        @Override
        public boolean isDestroyed() {
            return this.isDestroyed;
        }

        @Override
        public void suspendRunBody() {
            this.suspended = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resumeRunBody() {
            if (!this.isDestroyed) {
                MyJFrame myJFrame = this;
                synchronized (myJFrame) {
                    this.suspended = false;
                    this.notify();
                }
            }
        }
    }

    static interface MyWindow {
        public void myPack();

        public void mySetVisible(boolean var1);

        public Container getContentPane();

        public void setDefaultCloseOperation(int var1);

        public void setTitle(String var1);

        public String getTitle();

        public void setJMenuBar(JMenuBar var1);

        public boolean isDestroyed();

        public Component getCurrentFocus();

        public Component getCurrentFocus(boolean var1);

        public void suspendRunBody();

        public void resumeRunBody();
    }
}

