/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Component;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charvax.swing.JLabel;
import com.iscobol.gui.client.charva.BorderedFrame;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.ListIterator;

public class KeyboardBufferQueue {
    private LinkedList keyboardQueue = new LinkedList();
    private boolean isActive = true;
    private boolean inputStatus;
    private int lastCursorX;
    private int lastCursorY;
    private boolean rightButtonDown;
    private boolean leftButtonDown;
    private boolean middleButtonDown;
    private static volatile KeyboardBufferQueue instance = null;

    private native int myreadKey();

    private KeyboardBufferQueue() {
    }

    public static synchronized KeyboardBufferQueue getInstance() {
        if (instance == null) {
            instance = new KeyboardBufferQueue();
        }
        return instance;
    }

    public synchronized boolean isEmpty() {
        return this.keyboardQueue.size() == 0;
    }

    public void enable(BorderedFrame.MyWindow myWindow) {
        this.isActive = true;
    }

    public synchronized void disable() {
        this.isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventObject dispatchEvent(EventObject eventObject, BorderedFrame.MyWindow myWindow) {
        EventObject eventObject2 = eventObject;
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            this.lastCursorX = mouseEvent.getX();
            this.lastCursorY = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 100: {
                    int n2 = mouseEvent.getModifiers();
                    if (n2 == 1) {
                        this.leftButtonDown = true;
                        break;
                    }
                    if (n2 == 2) {
                        this.middleButtonDown = true;
                        break;
                    }
                    if (n2 != 3) break;
                    this.rightButtonDown = true;
                    break;
                }
                case 101: {
                    int n3 = mouseEvent.getModifiers();
                    if (n3 == 1) {
                        this.leftButtonDown = false;
                        break;
                    }
                    if (n3 == 2) {
                        this.middleButtonDown = false;
                        break;
                    }
                    if (n3 != 3) break;
                    this.rightButtonDown = false;
                    break;
                }
                case 102: {
                    break;
                }
            }
            if (!this.isActive && (mouseEvent.getID() == 100 || mouseEvent.getID() == 102 && mouseEvent.getClickCount() <= 1)) {
                eventObject2 = null;
            }
        } else if (!this.isActive && eventObject instanceof KeyEvent) {
            LinkedList linkedList = this.keyboardQueue;
            synchronized (linkedList) {
                if (((KeyEvent)eventObject).getID() == 1) {
                    this.inputStatus = true;
                }
                this.keyboardQueue.add(eventObject);
                eventObject2 = null;
            }
        }
        return eventObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repostBufEvents(String string) {
        LinkedList linkedList = this.keyboardQueue;
        synchronized (linkedList) {
            this.inputStatus = false;
            if (!this.keyboardQueue.isEmpty()) {
                if (!this.isActive) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
                KeyEvent keyEvent = null;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                keyEvent = (KeyEvent)this.keyboardQueue.getFirst();
                Window window = toolkit.getTopWindow();
                if (keyEvent != null) {
                    if (window != null && window.getCurrentFocus() != null) {
                        toolkit.fireKeystroke(keyEvent.getKeyCode());
                    }
                    this.keyboardQueue.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyEvent popKeyEvent(RemoteDisplayWindow remoteDisplayWindow) {
        KeyEvent keyEvent = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (remoteDisplayWindow != null && remoteDisplayWindow.getMainWindow() != null) {
            remoteDisplayWindow.getMainWindow().getCharTerminal().drawCaretOn();
        }
        LinkedList linkedList = this.keyboardQueue;
        synchronized (linkedList) {
            while (keyEvent == null) {
                if (!this.keyboardQueue.isEmpty()) {
                    keyEvent = (KeyEvent)this.keyboardQueue.getFirst();
                    if (keyEvent == null) continue;
                    this.keyboardQueue.remove(0);
                    continue;
                }
                keyEvent = this.mycheckforkeystroke();
            }
        }
        if (remoteDisplayWindow != null && remoteDisplayWindow.getMainWindow() != null) {
            remoteDisplayWindow.getMainWindow().getCharTerminal().drawCaretOff();
        }
        return keyEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInputStatus(boolean bl) {
        LinkedList linkedList = this.keyboardQueue;
        synchronized (linkedList) {
            if (this.inputStatus) {
                if (bl) {
                    if (this.keyboardQueue.size() > 0) {
                        ListIterator listIterator = this.keyboardQueue.listIterator();
                        while (listIterator.hasNext()) {
                            KeyEvent keyEvent = (KeyEvent)listIterator.next();
                            if (keyEvent.getID() != 1) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return this.keyboardQueue.size() > 0;
            }
            return false;
        }
    }

    public KeyEvent mycheckforkeystroke() {
        KeyEvent keyEvent = null;
        int n2 = this.myreadKey();
        if (n2 == -1) {
            return null;
        }
        if (n2 == 10 || n2 == 13) {
            n2 = 343;
        } else if (n2 == 8) {
            n2 = 263;
        }
        if (n2 != 409) {
            int n3 = -1;
            n3 = Toolkit.isActionKey((int)n2) ? 2 : 1;
            keyEvent = new KeyEvent(n2, n3, (Component)new JLabel());
        }
        return keyEvent;
    }

    public int getLastCursorX() {
        return this.lastCursorX;
    }

    public int getLastCursorY() {
        return this.lastCursorY;
    }

    public boolean getInputStatus() {
        return this.inputStatus;
    }

    public boolean isLeftButtonDown() {
        return this.leftButtonDown;
    }

    public boolean isRightButtonDown() {
        return this.rightButtonDown;
    }

    public boolean isMiddleButtonDown() {
        return this.middleButtonDown;
    }

    public void enableInputStatus() {
        this.disable();
    }
}

