/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.event.KeyEvent;
import charvax.swing.JOptionPane;
import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.charva.GuiFactoryImpl;
import com.iscobol.gui.client.charva.MyKeyEvent;
import com.iscobol.gui.client.charva.PicobolTextEvent;
import com.iscobol.gui.client.charva.PicobolTextListener;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import com.iscobol.gui.client.charva.RemoteBaseGUIWindow;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import com.iscobol.gui.client.charva.RemoteTerminalDisplay;
import com.iscobol.gui.client.charva.TerminalAccept;
import java.util.ArrayList;
import java.util.Vector;

public class RemoteTerminalAccept
extends RemoteTerminalDisplay {
    protected boolean autoTermination;
    protected boolean update;
    protected boolean prompt;
    protected char promptChar;
    protected boolean upper;
    protected boolean lower;
    protected boolean full;
    protected boolean required;
    protected boolean zeroFill;
    protected int cursor;
    private String editPict;
    private boolean noAutoClear;
    private boolean decPointComma;
    private boolean isOnScreenSection;

    public RemoteTerminalAccept(GuiFactoryImpl guiFactoryImpl) {
        super(guiFactoryImpl);
        this.noAutoClear = guiFactoryImpl.getCsProperty().get("iscobol.terminal.no_autoclear", false);
    }

    @Override
    public String setValue(String string) {
        if (this.guiComponent == null) {
            super.setValue(string);
        } else {
            ((TerminalAccept)this.guiComponent).setValue(string);
        }
        return null;
    }

    @Override
    public String refreshValue(String string) {
        if (this.guiComponent == null) {
            super.setValue(string);
        } else {
            TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
            terminalAccept.saveBGandAttr();
            if (!this.noAutoClear || this.update) {
                terminalAccept.setValue(string);
            }
            terminalAccept.restoreBGandAttr();
        }
        return null;
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return super.getValue();
        }
        super.setValue(((TerminalAccept)this.guiComponent).getValue());
        return super.getValue();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.destroyed) {
            return;
        }
        if (this.getLength() == 0) {
            ((RemoteDisplayWindow)this.parentWindow).keyPressed(keyEvent);
            return;
        }
        if (this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        switch (keyEvent.getKeyCode()) {
            case 260: 
            case 261: {
                MyKeyEvent myKeyEvent = new MyKeyEvent();
                myKeyEvent.setKeyChar(keyEvent.getKeyChar());
                myKeyEvent.setKeyCode(keyEvent.getKeyCode());
                int n2 = this.gf.getMyRemoteVirtualKeyboard().mapKey(myKeyEvent);
                if (!(VirtualKeyboard.editing(n2) == 589824 || VirtualKeyboard.editing(n2) == 655360 || VirtualKeyboard.exception(n2) < 0 && VirtualKeyboard.termination(n2) < 0)) {
                    super.keyPressed(keyEvent);
                }
                return;
            }
            case 262: 
            case 263: 
            case 330: 
            case 360: {
                MyKeyEvent myKeyEvent = new MyKeyEvent();
                myKeyEvent.setKeyChar(keyEvent.getKeyChar());
                myKeyEvent.setKeyCode(keyEvent.getKeyCode());
                int n3 = this.gf.getMyRemoteVirtualKeyboard().mapKey(myKeyEvent);
                if (VirtualKeyboard.exception(n3) >= 0 || VirtualKeyboard.termination(n3) >= 0) break;
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    @Override
    protected void setEditPict(String string, boolean bl) {
        this.editPict = string;
        this.decPointComma = bl;
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        if (terminalAccept != null) {
            terminalAccept.setPicture(this.editPict, bl);
        }
    }

    @Override
    public void initialize() {
        TerminalAccept terminalAccept = new TerminalAccept(this.gf);
        this.setComponent(terminalAccept);
        this.intInitialize();
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        if (this.isNumeric) {
            terminalAccept.setNumeric(true);
        }
        terminalAccept.initialize(remoteDisplayWindow.mainWindow.getCharTerminal(), this.getColumn(), this.getLine(), super.getValue(), this.getLength(), this.editPict, this.decPointComma);
        this.guiComponent.addKeyListener(this);
        if (this.getNoecho()) {
            terminalAccept.setNoEcho(true);
        }
        if (this.isUnderline) {
            terminalAccept.setUnderline(true);
        }
        if (this.isBold) {
            terminalAccept.setBold(true);
        }
        if (this.isBlink) {
            terminalAccept.setBlink(true);
        }
        if (this.isReverse) {
            terminalAccept.setReverse(true);
        }
        if (this.autoTermination) {
            terminalAccept.setAuto(true);
        }
        if (this.update) {
            terminalAccept.setUpdate(true);
        }
        if (this.promptChar != '\u0000') {
            terminalAccept.setPromptChar(this.promptChar);
        }
        if (this.prompt) {
            terminalAccept.setPrompt(true);
        }
        if (this.upper) {
            terminalAccept.setUpper(true);
        }
        if (this.lower) {
            terminalAccept.setLower(true);
        }
        if (this.full) {
            terminalAccept.setFull(true);
        }
        if (this.required) {
            terminalAccept.setRequired(true);
        }
        if (this.zeroFill) {
            terminalAccept.setZeroFill(true);
        }
        if (this.cursor > 0) {
            terminalAccept.setCursorPos(this.cursor);
        }
        terminalAccept.setJustification(this.just);
        terminalAccept.addTextListener(new PicobolTextListener(){

            @Override
            public void textChanged(PicobolTextEvent picobolTextEvent) {
            }

            @Override
            public void valueIncrementing(PicobolTextEvent picobolTextEvent) {
            }

            @Override
            public void valueDecrementing(PicobolTextEvent picobolTextEvent) {
            }

            @Override
            public void inputTerminated(PicobolTextEvent picobolTextEvent) {
                RemoteTerminalAccept.this.intKeyPressed(RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().getAutoTerminated(), true, null);
            }

            @Override
            public void inputTerminated(KeyEvent keyEvent) {
                MyKeyEvent myKeyEvent = new MyKeyEvent();
                myKeyEvent.setKeyChar(keyEvent.getKeyChar());
                myKeyEvent.setKeyCode(keyEvent.getKeyCode());
                int n2 = RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().mapKey(myKeyEvent);
                if (VirtualKeyboard.editing(n2) == 589824 || VirtualKeyboard.editing(n2) == 655360) {
                    RemoteTerminalAccept.this.superkeyPressed(keyEvent);
                } else {
                    RemoteTerminalAccept.this.intKeyPressed(RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().mapKey(myKeyEvent), false, null, false);
                }
            }

            @Override
            public boolean getFirstLast(KeyEvent keyEvent) {
                MyKeyEvent myKeyEvent = new MyKeyEvent();
                myKeyEvent.setKeyChar(keyEvent.getKeyChar());
                myKeyEvent.setKeyCode(keyEvent.getKeyCode());
                return RemoteTerminalAccept.this.intKeyPressed(keyEvent, RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().mapKey(myKeyEvent), false, null, false);
            }
        });
        ((TerminalAccept)this.guiComponent).dorepaint = false;
        this.guiComponent.setVisible(true);
        terminalAccept.saveBGandAttr();
        terminalAccept.display();
        terminalAccept.restoreBGandAttr();
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        if (terminalAccept != null) {
            terminalAccept.focusGained(cobolFocusEvent);
        }
        super.focusGained(cobolFocusEvent);
    }

    @Override
    public void focusLost(CobolFocusEvent cobolFocusEvent) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        if (terminalAccept != null) {
            terminalAccept.focusLost(cobolFocusEvent);
        }
        super.focusLost(cobolFocusEvent);
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl remoteBaseGUIControl) {
        String string;
        this.saveCursorValue();
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        if (!(remoteBaseGUIControl != null && remoteBaseGUIControl.isSelfAct() || terminalAccept == null || (string = terminalAccept.check()) == null)) {
            JOptionPane.showMessageDialog(null, (Object)string, (String)"!!!", (int)100);
            return false;
        }
        return true;
    }

    @Override
    public void setIsNumeric(boolean bl) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        super.setIsNumeric(bl);
        if (terminalAccept != null) {
            terminalAccept.setNumeric(bl);
        }
    }

    @Override
    public void setNoecho(boolean bl) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        super.setNoecho(bl);
        if (terminalAccept != null) {
            terminalAccept.setNoEcho(bl);
        }
    }

    @Override
    public void setUnderline(boolean bl) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        super.setUnderline(bl);
        if (terminalAccept != null) {
            terminalAccept.setUnderline(bl);
        }
    }

    @Override
    public void setBlink(boolean bl) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        super.setBlink(bl);
        if (terminalAccept != null) {
            terminalAccept.setBlink(bl);
        }
    }

    @Override
    public void setReverse(boolean bl) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        super.setReverse(bl);
        if (terminalAccept != null) {
            terminalAccept.setReverse(bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.guiComponent.setVisible(bl);
        super.setVisible(bl);
    }

    @Override
    public void setLocation(int n2, int n3) {
        super.setLocation(n2, n3);
    }

    public void setCursor(int n2) {
        this.setCursor(n2, false);
    }

    public void setCursor(int n2, boolean bl) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        this.cursor = n2;
        if (terminalAccept != null) {
            terminalAccept.setCursorPos(this.cursor, bl);
        }
    }

    @Override
    public void setPromptChar(char c2) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        this.promptChar = c2;
        if (terminalAccept != null) {
            terminalAccept.setPromptChar(this.promptChar);
        }
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize paramElementSize, int n2) {
        if (paramElementSize.sizes > 0.0f) {
            return paramElementSize.sizes;
        }
        if (paramElementSize.ccPIClen != -1) {
            return paramElementSize.ccPIClen;
        }
        if (paramElementSize.ccOlen != -1) {
            return paramElementSize.ccOlen;
        }
        if (paramElementSize.ccIlen != -1) {
            return paramElementSize.ccIlen;
        }
        return super.paramgetDefaultWidth(paramElementSize, n2);
    }

    @Override
    public void setStyle(int n2, boolean bl) {
        TerminalAccept terminalAccept;
        if ((n2 & 1) == 1) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.autoTermination = true;
            if (terminalAccept != null) {
                terminalAccept.setAuto(this.autoTermination);
            }
        }
        if ((n2 & 0x2000) == 8192) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.update = true;
            if (terminalAccept != null) {
                terminalAccept.setUpdate(this.update);
            }
        }
        if ((n2 & 0x200) == 512) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.prompt = true;
            if (terminalAccept != null) {
                terminalAccept.setPrompt(this.prompt);
            }
        }
        if ((n2 & 0x4000) == 16384) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.upper = true;
            if (terminalAccept != null) {
                terminalAccept.setUpper(this.upper);
            }
        }
        if ((n2 & 0x40) == 64) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.lower = true;
            if (terminalAccept != null) {
                terminalAccept.setLower(this.lower);
            }
        }
        if ((n2 & 0x10000) == 65536) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.full = true;
            if (terminalAccept != null) {
                terminalAccept.setFull(this.full);
            }
        }
        if ((n2 & 0x20000) == 131072 || (n2 & 0x100000) == 0x100000) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.required = true;
            if (terminalAccept != null) {
                terminalAccept.setFull(this.required);
            }
        }
        if ((n2 & 0x40000) == 262144) {
            terminalAccept = (TerminalAccept)this.guiComponent;
            this.zeroFill = true;
            if (terminalAccept != null) {
                terminalAccept.setZeroFill(this.zeroFill);
            }
        }
        super.setStyle(n2, bl);
    }

    @Override
    public int getCursor() {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        if (terminalAccept != null) {
            return terminalAccept.getCursorPos();
        }
        return -1;
    }

    @Override
    public void setCursorValue(RemoteDisplayWindow remoteDisplayWindow) {
        remoteDisplayWindow.setCursorValue(this.getCursor());
    }

    private void saveCursorValue() {
        RemoteBaseGUIControl remoteBaseGUIControl;
        RemoteDisplayWindow remoteDisplayWindow = (RemoteDisplayWindow)this.parentWindow;
        if (remoteDisplayWindow != null && (remoteBaseGUIControl = (RemoteBaseGUIControl)remoteDisplayWindow.getFocusOwner()) == this) {
            remoteDisplayWindow.setCursorValue(this.getLine() + 1 << 16 | this.getColumn() + this.getLength() + 1);
        }
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIWindow remoteBaseGUIWindow) {
        this.saveCursorValue();
        return true;
    }

    @Override
    public void setActiveAccept(boolean bl, ArrayList arrayList) {
        if (!bl) {
            this.saveCursorValue();
        }
        super.setActiveAccept(bl, arrayList);
    }

    @Override
    public void intFocusGained(boolean bl) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        if (terminalAccept != null) {
            terminalAccept.saveBGandAttr();
            terminalAccept.display(true);
        }
    }

    @Override
    public String getType() {
        return "terminalaccept";
    }

    @Override
    public void setJust(int n2) {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        super.setJust(n2);
        if (terminalAccept != null) {
            terminalAccept.setJustification(this.just);
        }
    }

    @Override
    public void destroy() {
        TerminalAccept terminalAccept = (TerminalAccept)this.guiComponent;
        if (terminalAccept != null) {
            terminalAccept.removeTextListener();
        }
        super.destroy();
    }

    public boolean isOnScreenSection() {
        return this.isOnScreenSection;
    }

    @Override
    public void setControlInfo(int n2) {
        super.setControlInfo(n2);
        this.isOnScreenSection = (n2 & 0x400) == 1024;
        this.controlinfo &= 0xFFFFFBFF;
        this.controlinfo &= 0xFFFFF7FF;
    }

    @Override
    public void removeTerminalAcceptAndHeader(Vector vector) {
        if (!this.isOnScreenSection) {
            vector.add(new Integer(this.getServerId()));
        }
    }

    public void superkeyPressed(KeyEvent keyEvent) {
        if (!this.isOnScreenSection && this.getParentBGW() != null && !this.getParentBGW().getIsonexceptionAccept()) {
            return;
        }
        super.keyPressed(keyEvent);
    }

    @Override
    public void initializerowcol() {
        TerminalAccept terminalAccept;
        if (this.isOnScreenSection && (terminalAccept = (TerminalAccept)this.guiComponent) != null) {
            terminalAccept.initializerowcol(this.getColumn(), this.getLine());
        }
    }
}

