/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Rectangle;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.charva.Graphics;
import com.iscobol.gui.client.charva.TerminalModel;
import java.awt.Font;
import java.awt.Point;

public class Terminal
extends Component {
    private TerminalModel tm;
    private boolean notEmpty;
    private Graphics g;
    private int cols;
    private int lines;
    private Dimension charDim;
    AbstractGuiFactoryImpl gf;

    public Terminal(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        this.gf = abstractGuiFactoryImpl;
        this.tm = new TerminalModel(abstractGuiFactoryImpl);
    }

    private void init() {
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            Terminal.class.getMethod("setFocusable", classArray).invoke((Object)this, new Boolean(true));
            Terminal.class.getMethod("setFocusTraversalKeysEnabled", classArray).invoke((Object)this, new Boolean(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.g = new Graphics();
    }

    public void init(float f2, float f3, int n2, int n3) {
        this.cols = (int)Math.ceil(f2);
        this.lines = (int)Math.ceil(f3);
        this.init();
        this.charDim = new Dimension();
        this.charDim.width = n2 / this.cols;
        this.charDim.height = n3 / this.lines;
        if (n2 % this.cols > this.cols / 2) {
            ++this.charDim.width;
        }
        if (n3 % this.lines > this.lines / 2) {
            ++this.charDim.height;
        }
        this.tm.init(this.cols, this.lines, this.charDim);
    }

    public boolean moveAt(int n2, int n3) {
        return this.tm.move(n2, n3);
    }

    public Rectangle display(int n2, int n3, String string, int n4, Color color, int n5, Color color2, Justification justification) {
        this.notEmpty = true;
        if (this.moveAt(n2, n3)) {
            this.repaint();
        }
        return this.tm.addstr(justification.get(string, n4), n4, color, n5, color2);
    }

    public TerminalModel getTerminalModel() {
        this.notEmpty = true;
        return this.tm;
    }

    public Dimension getPreferredSize() {
        return this.tm.getPreferredSize();
    }

    public void repaint() {
        if (this.notEmpty) {
            this.tm.paint(this.g);
        } else {
            super.repaint();
        }
    }

    public void repaint(int n2, int n3, int n4) {
        if (this.notEmpty) {
            this.tm.paint(this.g, n2, n3, n4);
        } else {
            super.repaint();
        }
    }

    public void setBackground(int n2, int n3, int n4, int n5, Color color) {
        this.tm.setBackground(n2, n3, n4, n5, color);
    }

    public void setForeground(int n2, int n3, int n4, int n5, Color color, int n6) {
        this.tm.setForeground(n2, n3, n4, n5, color, n6);
    }

    public void setBackground(Color color) {
        this.tm.setBackground(color);
        super.setBackground(color);
    }

    public void setBackColor(Color color) {
        this.tm.setBackColor(color);
    }

    public void setForeColor(Color color) {
        this.tm.setForeColor(color);
    }

    public String acceptFromScreen(int n2, int n3, int n4) {
        return this.tm.acceptFromScreen(n2, n3, n4);
    }

    public String attrFromScreen(int n2, int n3, int n4) {
        return this.tm.attrFromScreen(n2, n3, n4);
    }

    public void writeToScreen(int n2, int n3, int n4, String string, String string2) {
        this.tm.writeToScreen(n2, n3, n4, string, string2);
    }

    public void changeWidth(int n2) {
        this.tm.changeWidth(n2);
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public void debug(int n2) {
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getHeight() {
        return this.lines;
    }

    public int getWidth() {
        return this.cols;
    }

    public Dimension getSize() {
        return new Dimension(this.cols, this.lines);
    }

    public void draw() {
    }

    public void setFont(Font font) {
    }

    public void setLocation(Point point) {
    }

    public void end() {
        this.tm.end();
        this.tm = null;
        this.gf = null;
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    public void chrepaint() {
        if (this.g != null) {
            this.g.repaint();
        }
    }

    public void chrepaintD() {
        if (this.g != null) {
            this.g.repaintD();
        }
    }

    public void drawCaretOn() {
        if (this.tm != null && this.g != null) {
            this.tm.intdrawCaretOn(this.g, this.tm.getyx().x, this.tm.getyx().y, true);
        }
    }

    public void drawCaretOff() {
        if (this.tm != null && this.g != null) {
            this.tm.intdrawCaretOff(this.g, this.tm.getyx().x, this.tm.getyx().y);
        }
    }
}

