/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.FocusEvent;
import charva.awt.event.FocusListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charva.awt.event.MouseEvent;
import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.charva.GuiFactoryImpl;
import com.iscobol.gui.client.charva.MyKeyEvent;
import com.iscobol.gui.client.charva.PicobolTextEvent;
import com.iscobol.gui.client.charva.PicobolTextListener;
import com.iscobol.gui.client.charva.PicobolWidget;
import com.iscobol.gui.client.charva.Terminal;
import com.iscobol.gui.client.charva.TerminalModel;
import com.iscobol.rts.Factory;

public class TerminalAccept
extends Component
implements FocusListener,
KeyListener,
PicobolWidget {
    private static final char UNDERSCORE_CHAR = '_';
    private static final long NOT_SET = 0xFFFFFFFFFFFFFFFL;
    private final boolean alphaAutoClear;
    private final boolean numericAutoClear;
    private final boolean editedFormatted;
    private final boolean updateFromScreen;
    private final boolean cl2endFillSpaces;
    private final int[] dataRange;
    private String undo;
    private InpData inp = new InpData();
    private Terminal tt;
    private TerminalModel tm;
    private int col;
    private int line;
    private int length;
    private Dimension size;
    private boolean isNumeric;
    private int attr;
    private boolean autoTermination;
    private PicobolTextListener listener;
    private boolean activeAccept;
    private boolean update;
    private boolean prompt;
    private char promptChar;
    private boolean upper;
    private boolean lower;
    private boolean full;
    private boolean required;
    private boolean zeroFill;
    private long savebackcolor = 0xFFFFFFFFFFFFFFFL;
    private long savetermattr = 0xFFFFFFFFFFFFFFFL;
    private Justification just;
    private GuiFactoryImpl gf;
    private char promptCharOrig;
    private boolean promptAll;
    private String promptAllStr;
    private int taMaxIdx;
    private final boolean noAutoClear;
    private final int upperLowerMethod;
    public boolean dorepaint = true;

    private static final boolean isEditing(char c2) {
        switch (c2) {
            case '+': 
            case '-': 
            case '9': 
            case 'Z': {
                return false;
            }
        }
        return true;
    }

    public TerminalAccept(GuiFactoryImpl guiFactoryImpl) {
        String[] stringArray;
        this.promptCharOrig = this.promptChar = guiFactoryImpl.getCsProperty().get("iscobol.terminal.screen_prompt", '_');
        this.promptAllStr = guiFactoryImpl.getCsProperty().get("iscobol.terminal.screen_prompt_all", "");
        if (this.promptAllStr != null && (this.promptAllStr.equalsIgnoreCase("YES") || this.promptAllStr.equalsIgnoreCase("PROTECTED"))) {
            this.promptAll = true;
        }
        this.alphaAutoClear = guiFactoryImpl.getCsProperty().get("iscobol.terminal.alpha_autoclear", false);
        this.noAutoClear = guiFactoryImpl.getCsProperty().get("iscobol.terminal.no_autoclear", false);
        this.numericAutoClear = guiFactoryImpl.getCsProperty().get("iscobol.terminal.numeric_autoclear", true);
        this.editedFormatted = guiFactoryImpl.getCsProperty().get("iscobol.terminal.edited_formatted", false);
        this.updateFromScreen = guiFactoryImpl.getCsProperty().get("iscobol.terminal.update_from_screen", false);
        this.cl2endFillSpaces = guiFactoryImpl.getCsProperty().get("iscobol.terminal.cl2end_fill_spaces", false);
        this.upperLowerMethod = guiFactoryImpl.getUpperLowerMethod();
        String string = guiFactoryImpl.getCsProperty().get("iscobol.terminal.data_range", null);
        int[] nArray = null;
        if (string != null && (stringArray = string.split("\\,")).length > 0) {
            if (stringArray.length == 1) {
                try {
                    nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.MAX_VALUE};
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.dataRange = nArray;
        this.gf = guiFactoryImpl;
    }

    public void repaint() {
        this.repaint(true);
    }

    private void repaint(boolean bl) {
        if (this.tm != null) {
            if (bl && this.isVisible()) {
                if (this.inp.isAtEnd()) {
                    this.tm.setCaretAt(this.col + this.inp.col - 1, this.line, this);
                } else {
                    this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
                }
            } else {
                this.tm.unsetCaret(this);
            }
        }
        if (this.tt != null && this.dorepaint) {
            this.tt.repaint();
        }
        this.dorepaint = true;
    }

    public void display() {
        this.display(this.promptAll, true);
    }

    public void display(boolean bl) {
        this.display(bl, true);
    }

    public void display(boolean bl, boolean bl2) {
        if (this.length == 0) {
            return;
        }
        this.tm.move(this.col, this.line);
        if (bl2) {
            this.tm.setAttr(this.attr);
            this.tm.setBackColor(this.getBackground());
            this.tm.setForeColor(this.getForeground());
        }
        char[] cArray = this.just != null && !bl && (!this.noAutoClear || this.update) ? this.just.get(this.inp.getData(this.prompt & bl)) : this.inp.getData(this.prompt & bl);
        this.taMaxIdx = Math.max(this.taMaxIdx, this.inp.idx);
        if (this.noAutoClear && !this.update && this.taMaxIdx < cArray.length) {
            char[] cArray2 = this.tm.getTextAt(this.line, this.col + this.taMaxIdx, cArray.length - this.taMaxIdx);
            System.arraycopy(cArray2, 0, cArray, this.taMaxIdx, cArray2.length);
        }
        this.tm.addstr(cArray);
        this.repaint(bl);
    }

    public void setPicture(String string, boolean bl) {
        if (this.inp != null) {
            this.inp.setPicture(string, bl);
        }
    }

    public void initializerowcol(int n2, int n3) {
        this.col = n2;
        this.line = n3;
    }

    public void initialize(Terminal terminal, int n2, int n3, String string, int n4, String string2, boolean bl) {
        this.col = n2;
        this.line = n3;
        this.length = n4;
        this.tt = terminal;
        this.tm = terminal.getTerminalModel();
        int n5 = this.tm.getWidth();
        int n6 = this.col + n4 <= n5 ? n4 : (n5 > this.col ? n5 - this.col : 0);
        this.size = n6 == 0 ? new Dimension(1, this.tm.getCharDim().height) : new Dimension(this.tm.getCharDim().width * n6, this.tm.getCharDim().height);
        this.inp.setLen(n6);
        this.inp.setPicture(string2, bl);
        if (this.updateFromScreen) {
            string = this.tm.acceptFromScreen(this.line + 1, this.col + 1, n6);
        }
        if (string != null && string.length() >= 0) {
            this.undo = string;
            this.inp.setValue(this.undo);
        }
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyPressed(keyEvent, true);
    }

    public void keyPressed(KeyEvent keyEvent, boolean bl) {
        if (this.length == 0) {
            return;
        }
        int n2 = keyEvent.getKeyCode();
        if (n2 == 12) {
            Toolkit.getDefaultToolkit().redrawWin();
            Toolkit.getDefaultToolkit().sync();
            return;
        }
        if (n2 == 24) {
            this.inp.clear();
            this.display(true);
            return;
        }
        if (n2 == 26) {
            this.inp.clear();
            this.inp.setValue(this.undo);
            this.display(true);
            return;
        }
        if (n2 >= 1 && n2 <= 26) {
            return;
        }
        MyKeyEvent myKeyEvent = new MyKeyEvent();
        myKeyEvent.setKeyChar(keyEvent.getKeyChar());
        myKeyEvent.setKeyCode(keyEvent.getKeyCode());
        int n3 = this.gf.getMyRemoteVirtualKeyboard().mapKey(myKeyEvent, keyEvent.getKeyCode());
        int n4 = VirtualKeyboard.editing(n3);
        switch (n4) {
            case 65536: {
                this.resetInsMode();
                if (bl && this.listener.getFirstLast(keyEvent)) break;
                if (this.inp.home()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(n3) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 131072: {
                this.resetInsMode();
                if (bl && this.listener.getFirstLast(keyEvent)) break;
                if (this.inp.end()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(n3) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 851968: {
                this.toggleInsMode();
                this.repaint();
                if (VirtualKeyboard.exception(n3) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 720896: {
                boolean bl2;
                if (this.isNumeric && !this.numericAutoClear) {
                    bl2 = this.inp.delNnac();
                } else {
                    this.inp.delcur();
                    bl2 = true;
                }
                if (bl2) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(n3) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 786432: {
                boolean bl2;
                boolean bl3 = bl2 = this.isNumeric && !this.numericAutoClear ? this.inp.delNnac() : this.inp.delch();
                if (bl2) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(n3) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 589824: {
                this.resetInsMode();
                if (this.inp.myleft()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 655360: {
                this.resetInsMode();
                if (this.inp.myright()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 917504: {
                this.inp.clear();
                this.display(true);
                if (VirtualKeyboard.exception(n3) < 0) break;
                this.listener.inputTerminated(keyEvent);
                break;
            }
            case 983040: {
                if (this.cl2endFillSpaces) {
                    while (this.inp.idx < this.inp.len) {
                        this.inp.addch(' ');
                    }
                    this.display(true);
                    if (!this.autoTermination) break;
                    this.check();
                    this.listener.inputTerminated(new PicobolTextEvent(this, 303));
                    break;
                }
                if (this.isNumeric && !this.numericAutoClear) {
                    this.inp.cl2EndNnac();
                } else {
                    this.inp.cl2End();
                }
                this.display(true);
                if (VirtualKeyboard.exception(n3) < 0) break;
                this.listener.inputTerminated(keyEvent);
            }
        }
        if (!keyEvent.isActionKey() && n4 == 0) {
            boolean bl4;
            char c2 = keyEvent.getKeyChar();
            c2 = keyEvent.getKeyCode() == 32 ? (char)' ' : (char)Toolkit.key2ASCII((int)keyEvent.getKeyCode()).charAt(0);
            if (this.isNumeric) {
                bl4 = Character.isDigit(c2);
                boolean bl5 = false;
                boolean bl6 = false;
                int n5 = -1;
                if (!bl4) {
                    if (this.numericAutoClear) {
                        bl4 = c2 == ',' || c2 == '.' || c2 == '/' || c2 == ' ' || c2 == '-';
                    } else {
                        bl6 = c2 == '-' || c2 == '+';
                        if (bl6) {
                            if (this.inp.isSigned) {
                                for (n5 = this.inp.getFirstDigitIdx() - 1; n5 >= 0 && this.inp.isEditingIndex(n5); --n5) {
                                }
                                if (this.inp.decPointIdx > 0 && n5 > this.inp.decPointIdx) {
                                    n5 = this.inp.decPointIdx - 1;
                                }
                                if (n5 < 0) {
                                    n5 = 0;
                                }
                                bl4 = true;
                            }
                        } else if (c2 == this.inp.decPointChar) {
                            bl4 = bl5 = this.inp.idx <= this.inp.decPointIdx;
                        }
                    }
                }
                if (bl4) {
                    if (bl5) {
                        this.inp.addDecPoint();
                    } else if (bl6) {
                        if (c2 == '-') {
                            ((InpData)this.inp).data[n5] = 45;
                        } else if (this.inp.data[n5] == '-') {
                            ((InpData)this.inp).data[n5] = 32;
                        }
                    } else {
                        this.inp.addch(c2);
                    }
                    this.display(true);
                } else if (c2 != '\u0107' && c2 != '\u014a') {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (c2 >= ' ' && c2 != '\u007f') {
                if (n2 > 127 && n2 <= 249) {
                    this.inp.addch((char)n2);
                } else if (this.upper) {
                    this.inp.addch(Character.toUpperCase(c2));
                } else if (this.lower) {
                    this.inp.addch(Character.toLowerCase(c2));
                } else if (this.gf.getKdbUpper()) {
                    this.inp.addch(Character.toUpperCase(c2));
                } else if (this.gf.getKdbLower()) {
                    this.inp.addch(Character.toLowerCase(c2));
                } else {
                    this.inp.addch(c2);
                }
                this.display(true);
            }
            if (this.autoTermination) {
                boolean bl7 = bl4 = this.inp.idx >= this.inp.getLastNotEditIdx();
                if (!this.numericAutoClear && this.isNumeric && this.update) {
                    boolean bl8 = bl4 && this.inp.isSignificantDigit(this.inp.getFirstNotEditIdx(this.inp.decPointIdx >= 0 ? this.inp.leadingZ : 0)) ? true : (bl4 = false);
                }
                if (bl4) {
                    this.check();
                    this.listener.inputTerminated(new PicobolTextEvent(this, 303));
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void addTextListener(PicobolTextListener picobolTextListener) {
        this.listener = picobolTextListener;
    }

    public void removeTextListener() {
        this.listener = null;
    }

    public void setUnderline(boolean bl) {
        if (bl) {
            if (this.promptChar == '_') {
                this.promptChar = (char)32;
            }
            this.attr |= 0x2000000;
        } else {
            this.attr &= 0xFDFFFFFF;
            this.promptChar = this.promptCharOrig;
        }
    }

    public void setBold(boolean bl) {
        this.attr = bl ? (this.attr |= 0x1000000) : (this.attr &= 0xFEFFFFFF);
    }

    public void setNoEcho(boolean bl) {
        if (bl) {
            this.attr |= 0x10000000;
            if (this.updateFromScreen) {
                this.inp.setValue("");
            }
        } else {
            this.attr &= 0xEFFFFFFF;
        }
    }

    public void setBlink(boolean bl) {
        this.attr = bl ? (this.attr |= 0x8000000) : (this.attr &= 0xF7FFFFFF);
    }

    public void setReverse(boolean bl) {
        this.attr = bl ? (this.attr |= 0x4000000) : (this.attr &= 0xFBFFFFFF);
    }

    public void setAuto(boolean bl) {
        this.autoTermination = bl;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public void setPrompt(boolean bl) {
        this.prompt = bl;
    }

    public void setPromptChar(char c2) {
        this.promptChar = c2;
    }

    public void setLower(boolean bl) {
        this.lower = bl;
    }

    public void setUpper(boolean bl) {
        this.upper = bl;
    }

    public void setFull(boolean bl) {
        this.full = bl;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setZeroFill(boolean bl) {
        this.zeroFill = bl;
    }

    public void focusGained(CobolFocusEvent cobolFocusEvent) {
        if (this.length == 0) {
            return;
        }
        this.tm.move(this.col, this.line);
        this.savebackcolor = this.tm.getBackColor();
        this.savetermattr = this.tm.getTermAttr();
        this.tm.setAttr(this.attr);
        this.tm.setBackColor(this.getBackground());
        this.tm.setForeColor(this.getForeground());
        if (this.update || this.prompt) {
            this.tm.addstr(this.inp.getData(this.prompt));
        }
        this.tm.move(this.col + this.inp.idx, this.line);
        this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
        if (this.alphaAutoClear && (!this.isNumeric || this.inp.pict != null && this.editedFormatted) || this.numericAutoClear && this.isNumeric && (this.inp.pict == null || !this.editedFormatted)) {
            this.inp.setSelectedAll(true);
        }
        this.tt.repaint();
    }

    public void focusLost(CobolFocusEvent cobolFocusEvent) {
        if (this.length == 0) {
            return;
        }
        this.tm.unsetCaret(this);
        this.inp.col = (this.inp.idx = 0);
        this.resetInsMode();
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        this.tt.repaint();
    }

    @Override
    public void setActiveAccept(boolean bl) {
        if (!bl && this.promptAll && (this.activeAccept && this.promptAllStr.equalsIgnoreCase("PROTECTED") || !this.activeAccept)) {
            this.display(false);
        }
        this.activeAccept = bl;
    }

    @Override
    public void asyncProcessEvent(AWTEvent aWTEvent) {
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)aWTEvent);
        }
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean bl) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    public void setSize(int n2, int n3) {
    }

    @Override
    public void setLocation(int n2, int n3) {
        super.setLocation(n2, n3);
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        if (this.size != null) {
            super.setBounds(n2, n3, this.size.width, this.size.height);
        } else {
            super.setBounds(n2, n3, 1, 1);
        }
    }

    public void setValue(String string) {
        this.inp.setValue(string);
        this.display(this.promptAll);
    }

    public void refreshValue(String string) {
        this.inp.setValue(string);
        this.display(this.promptAll, false);
    }

    public String getValue() {
        String string = this.inp.getValue();
        if (this.just != null) {
            string = this.just.get(string, this.inp.getLength());
        }
        if (this.upper) {
            return Factory.toUpperCase(string, this.upperLowerMethod);
        }
        if (this.lower) {
            return Factory.toLowerCase(string, this.upperLowerMethod);
        }
        if (this.gf.getKdbUpper()) {
            return Factory.toUpperCase(string, this.upperLowerMethod);
        }
        if (this.gf.getKdbLower()) {
            return Factory.toLowerCase(string, this.upperLowerMethod);
        }
        return string;
    }

    public void setNumeric(boolean bl) {
        this.isNumeric = bl;
    }

    public void setCursorPos(int n2) {
        this.setCursorPos(n2, false);
    }

    public void setCursorPos(int n2, boolean bl) {
        if (this.update && n2 > 0 && (n2 >> 16) - 1 == this.line) {
            boolean bl2 = this.inp.selectedAll;
            if (this.isNumeric && bl) {
                this.inp.selectedAll = false;
            }
            this.inp.setOffset((n2 & 0xFFFF) - 1 - this.col);
            if (this.isNumeric && bl) {
                this.inp.selectedAll = bl2;
            }
        }
    }

    public void setJustification(Justification justification) {
        this.just = justification;
    }

    public int getCursorPos() {
        return this.line + 1 << 16 | this.col + this.inp.getOffset() + 1;
    }

    public int getOffset() {
        return this.inp.getOffset();
    }

    public int getIdx() {
        return this.inp.getIdx();
    }

    public String check() {
        if (this.length == 0) {
            return null;
        }
        if (this.required && this.inp.idx == 0) {
            return Factory.getSysMsg("ef_input_required_msg");
        }
        if (this.full && this.inp.idx != this.inp.len && this.inp.idx != 0) {
            return Factory.getSysMsg("ef_input_filled_msg");
        }
        if (this.zeroFill) {
            this.inp.end();
            while (this.inp.idx < this.inp.len) {
                this.inp.addch('0');
            }
        }
        this.display(this.promptAll);
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        return null;
    }

    public void setKdbUpper(boolean bl) {
        if (bl) {
            this.setKdbLower(false);
        }
    }

    public void setKdbLower(boolean bl) {
        if (bl) {
            this.setKdbUpper(false);
        }
    }

    public void debug(int n2) {
    }

    public Dimension minimumSize() {
        return new Dimension(0, 0);
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }

    public Dimension getSize() {
        return new Dimension(0, 0);
    }

    public void draw() {
    }

    @Override
    public void setSize(Dimension dimension) {
    }

    @Override
    public void setLocation(Point point) {
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setParent(Container container) {
        if (container != null) {
            super.setParent(container);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    private void resetInsMode() {
        if (this.inp.insMode) {
            this.toggleInsMode();
        }
    }

    private void toggleInsMode() {
        this.tm.insertCursor = this.inp.insMode = !this.inp.insMode;
        this.inp.selectedAll = false;
    }

    public void saveBGandAttr() {
        if (this.savebackcolor == 0xFFFFFFFFFFFFFFFL) {
            this.savebackcolor = this.tm.getBackColor();
        }
        if (this.savetermattr == 0xFFFFFFFFFFFFFFFL) {
            this.savetermattr = this.tm.getTermAttr();
        }
    }

    public void restoreBGandAttr() {
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
    }

    private static final char[] normalizePic(String string) {
        int n2;
        if (string != null && (n2 = string.length()) > 0) {
            int n3;
            StringBuilder stringBuilder = new StringBuilder();
            char c2 = '\u0000';
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                if (c3 == '(') {
                    n3 = 0;
                    while (Character.isDigit(c3 = string.charAt(++i2))) {
                        n3 *= 10;
                        n3 += Character.digit(c3, 10);
                    }
                    --n3;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        stringBuilder.append(c2);
                    }
                    continue;
                }
                c2 = c3;
                stringBuilder.append(c2);
            }
            char[] cArray = stringBuilder.toString().toCharArray();
            block6: for (n3 = 0; n3 < cArray.length; ++n3) {
                switch (cArray[n3]) {
                    case 'B': 
                    case 'b': {
                        cArray[n3] = 32;
                        continue block6;
                    }
                }
            }
            return cArray;
        }
        return null;
    }

    private char getValidChar(char n2) {
        return (char)(this.dataRange == null || n2 >= this.dataRange[0] && n2 <= this.dataRange[1] ? n2 : 32);
    }

    private class InpData {
        private char[] data;
        private int len;
        private int maxIdx;
        private int idx;
        private int col;
        private boolean selectedAll;
        private boolean insMode;
        private char[] pict;
        private char decPointChar;
        private int decPointIdx;
        private boolean isSigned;
        private int leadingZ;

        InpData() {
        }

        void setPicture(String string, boolean bl) {
            this.pict = TerminalAccept.normalizePic(string);
            if (this.pict != null) {
                int n2;
                boolean bl2;
                this.decPointChar = (char)(bl ? 44 : 46);
                boolean bl3 = false;
                boolean bl4 = bl2 = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                if (this.pict[0] == 'S') {
                    this.isSigned = true;
                    this.pict[0] = 57;
                }
                this.decPointIdx = -1;
                for (n2 = this.pict.length - 1; n2 >= 0; --n2) {
                    bl3 |= TerminalAccept.isEditing(this.pict[n2]);
                    if (!bl2) continue;
                    if (this.pict[n2] == this.decPointChar) {
                        this.decPointIdx = n2;
                    }
                    this.isSigned |= this.pict[n2] == '-' || this.pict[n2] == '+';
                }
                n2 = this.decPointIdx >= 0 ? this.decPointIdx - 1 : this.pict.length - 1;
                this.leadingZ = 0;
                while (this.leadingZ <= n2 && (this.pict[this.leadingZ] == 'z' || this.pict[this.leadingZ] == 'Z' || this.isEditingIndex(this.leadingZ))) {
                    ++this.leadingZ;
                }
                if (!bl3) {
                    this.pict = null;
                }
            } else {
                this.decPointChar = (char)46;
                this.decPointIdx = -1;
                this.isSigned = true;
                this.leadingZ = 0;
            }
        }

        public void setSelectedAll(boolean bl) {
            this.selectedAll = !TerminalAccept.this.updateFromScreen && bl;
        }

        public void setLen(int n2) {
            this.len = n2;
            if (this.data != null) {
                if (n2 != this.data.length) {
                    int n3;
                    char[] cArray = this.data;
                    this.data = new char[n2];
                    int n4 = n3 = n2 <= cArray.length ? n2 : cArray.length;
                    while (--n3 >= 0) {
                        this.data[n3] = cArray[n3];
                    }
                }
            } else {
                this.data = new char[n2];
            }
        }

        private boolean isEditingIndex(int n2) {
            return this.pict != null && n2 < this.pict.length && TerminalAccept.isEditing(this.pict[n2]);
        }

        void setValue(String string) {
            block19: {
                block17: {
                    char[] cArray;
                    int n2;
                    block18: {
                        int n3;
                        char[] cArray2;
                        int n4;
                        int n5;
                        int n6;
                        int n7;
                        boolean bl;
                        if (string == null || string.length() <= 0) break block17;
                        if (this.data == null) {
                            this.setLen(string.length());
                        }
                        boolean bl2 = bl = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                        if (!bl) break block18;
                        string = string.trim();
                        if (this.decPointIdx > 0) {
                            n7 = string.lastIndexOf(this.decPointChar);
                            if (n7 < 0 || n7 == string.length() - 1) {
                                n6 = this.decPointIdx - this.leadingZ;
                                while (string.length() > n6 && string.charAt(0) == '0') {
                                    string = string.substring(1);
                                }
                                string = string + this.decPointChar;
                                for (n5 = this.decPointIdx + 1; n5 < this.pict.length; ++n5) {
                                    string = this.isEditingIndex(n5) ? string + this.pict[n5] : string + '0';
                                }
                            } else {
                                char[] cArray3 = string.substring(n7 + 1).toCharArray();
                                string = string.substring(0, n7 + 1);
                                n4 = 0;
                                for (n5 = this.decPointIdx + 1; n5 < this.pict.length; ++n5) {
                                    string = this.isEditingIndex(n5) ? string + this.pict[n5] : (n4 < cArray3.length ? string + cArray3[n4++] : string + '0');
                                }
                            }
                        } else if (this.pict != null && this.leadingZ > 0) {
                            n7 = this.pict.length - this.leadingZ;
                            while (string.length() > n7 && string.charAt(0) == '0') {
                                string = string.substring(1);
                            }
                        }
                        n6 = this.len <= (cArray2 = string.toCharArray()).length ? this.len : cArray2.length;
                        for (n5 = 0; n5 < this.len - n6; ++n5) {
                            this.data[n5] = 32;
                        }
                        this.maxIdx = this.len;
                        n5 = TerminalAccept.this.editedFormatted && this.pict != null && this.len <= cArray2.length ? 1 : 0;
                        n4 = 0;
                        for (n3 = this.len - n6; n4 < cArray2.length && n3 < this.data.length; ++n4, ++n3) {
                            this.data[n3] = n5 != 0 && TerminalAccept.isEditing(this.pict[n3]) ? this.pict[n3] : cArray2[n4];
                        }
                        n4 = this.decPointIdx > 0 ? this.decPointIdx - 1 : this.len - 1;
                        for (n3 = Math.min(this.len - n6, n4); n3 < n4 && (this.data[n3] == ' ' || this.data[n3] == '-'); ++n3) {
                        }
                        if (this.isEditingIndex(n3)) break block19;
                        int n8 = this.decPointIdx;
                        char[] cArray4 = this.pict;
                        this.pict = null;
                        this.decPointIdx = -1;
                        this.setOffset(n3);
                        this.pict = cArray4;
                        this.decPointIdx = n8;
                        break block19;
                    }
                    for (int i2 = n2 = this.len <= (cArray = string.toCharArray()).length ? this.len : cArray.length; i2 < this.len; ++i2) {
                        this.data[i2] = 32;
                    }
                    --n2;
                    while (n2 >= 0 && cArray[n2] == ' ') {
                        --n2;
                    }
                    ++n2;
                    this.maxIdx = n2--;
                    while (n2 >= 0) {
                        this.data[n2] = TerminalAccept.this.getValidChar(cArray[n2]);
                        --n2;
                    }
                    break block19;
                }
                for (int i3 = 0; i3 < this.len; ++i3) {
                    this.data[i3] = 32;
                }
            }
        }

        public String getValue() {
            return new String(this.data, 0, this.maxIdx);
        }

        public void clear() {
            this.idx = 0;
            this.col = 0;
            this.maxIdx = 0;
        }

        public void cl2End() {
            this.maxIdx = this.col = this.idx;
        }

        void cl2EndNnac() {
            boolean bl;
            int n2 = this.idx;
            if (n2 >= this.len) {
                n2 = this.len - 1;
            }
            boolean bl2 = bl = this.decPointIdx >= 0;
            if (!bl || this.idx < this.decPointIdx) {
                int n3;
                int n4 = this.idx = bl ? this.decPointIdx - 1 : this.len - 1;
                while (this.isEditingIndex(this.idx)) {
                    --this.idx;
                }
                int n5 = 0;
                for (n3 = n2; n3 <= this.idx; ++n3) {
                    if (this.isEditingIndex(n3)) continue;
                    ++n5;
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    this.delNnac();
                }
                this.idx = bl ? (this.col = this.decPointIdx) : (this.col = this.len);
            } else {
                if (n2 == this.decPointIdx) {
                    ++n2;
                }
                while (n2 < this.len) {
                    if (!this.isEditingIndex(n2)) {
                        this.data[n2] = 48;
                    }
                    ++n2;
                }
            }
        }

        void addDecPoint() {
            int n2 = this.idx;
            this.idx = this.decPointIdx - 1;
            for (int i2 = this.decPointIdx - 1; i2 >= n2; --i2) {
                if (this.isEditingIndex(i2)) continue;
                this.delNnac();
            }
            this.col = this.idx = this.decPointIdx + 1;
        }

        boolean addch(char c2) {
            if (this.selectedAll) {
                this.clear();
                this.selectedAll = false;
            }
            if (TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear) {
                int n2;
                int n3 = n2 = this.decPointIdx > 0 && this.idx <= this.decPointIdx ? this.decPointIdx : this.len;
                if (this.idx < n2) {
                    int n4;
                    if (this.insMode) {
                        for (n4 = n2 - 1; n4 > this.idx; --n4) {
                            int n5 = n4 - 1;
                            while (this.isEditingIndex(n5)) {
                                --n5;
                            }
                            this.data[n4] = this.data[n5];
                            n4 = n5 + 1;
                        }
                        if (this.maxIdx < n2) {
                            ++this.maxIdx;
                        }
                    }
                    this.data[this.idx] = c2;
                    ++this.idx;
                    ++this.col;
                    if (this.idx > this.maxIdx) {
                        for (n4 = this.idx - 2; n4 >= this.maxIdx; --n4) {
                            this.data[n4] = 32;
                        }
                        this.maxIdx = this.idx;
                    }
                    if (this.idx < n2 && !this.insMode && this.isEditingIndex(this.idx)) {
                        return this.addch(this.pict[this.idx]);
                    }
                    return true;
                }
                this.addNnac(c2);
                return false;
            }
            if (this.idx < this.len) {
                int n6;
                if (this.insMode) {
                    int n7 = n6 = this.maxIdx < this.len ? this.maxIdx : this.maxIdx - 1;
                    while (n6 > this.idx) {
                        this.data[n6] = this.data[n6 - 1];
                        --n6;
                    }
                    if (this.maxIdx < this.len) {
                        ++this.maxIdx;
                    }
                }
                this.data[this.idx] = c2;
                ++this.idx;
                this.col += TerminalAccept.this.tm.dblWidth(c2) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    for (n6 = this.idx - 2; n6 >= this.maxIdx; --n6) {
                        this.data[n6] = 32;
                    }
                    this.maxIdx = this.idx;
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.addch(this.pict[this.idx]);
                }
                return true;
            }
            if (this.idx > 0) {
                this.data[this.idx - 1] = c2;
            }
            return false;
        }

        private int getFirstNotEditIdx(int n2) {
            while (n2 < this.data.length && this.isEditingIndex(n2)) {
                ++n2;
            }
            return n2;
        }

        private int getLastNotEditIdx() {
            int n2;
            for (n2 = this.len - 1; n2 >= 0 && this.isEditingIndex(n2); --n2) {
            }
            return n2 + 1;
        }

        private boolean isSignificantDigit(int n2) {
            return this.data[n2] != ' ' && this.data[n2] != '+' && this.data[n2] != '-';
        }

        private int getFirstDigitIdx() {
            int n2;
            for (n2 = 0; n2 < this.data.length && (!this.isSignificantDigit(n2) || this.isEditingIndex(n2)); ++n2) {
            }
            return n2;
        }

        private void addNnac(char c2) {
            int n2;
            int n3;
            boolean bl;
            boolean bl2 = bl = this.decPointIdx > 0 && this.idx > this.decPointIdx;
            if (bl) {
                n3 = this.decPointIdx + 1;
                n2 = this.data.length;
            } else {
                n3 = 0;
                n2 = this.decPointIdx > 0 ? this.decPointIdx : this.data.length;
            }
            int n4 = this.getFirstDigitIdx();
            if (!bl && n4 > 0) {
                int n5 = 0;
                for (int i2 = n3 + 1; i2 < n2; ++i2) {
                    if (this.isEditingIndex(i2)) {
                        if (i2 >= n4 - 1) {
                            this.data[i2] = this.pict[i2];
                        }
                        ++n5;
                        continue;
                    }
                    this.data[i2 - 1 - n5] = this.data[i2];
                    n5 = 0;
                }
            } else if (this.idx > 0 && this.idx == this.decPointIdx && this.getFirstDigitIdx() == 0) {
                this.right();
                this.addch(c2);
                return;
            }
            this.data[n2 - 1] = c2;
        }

        public boolean isAtEnd() {
            return this.idx == this.len;
        }

        public void delcur() {
            this.selectedAll = false;
            if (this.idx < this.maxIdx) {
                for (int i2 = this.idx + 1; i2 < this.maxIdx; ++i2) {
                    this.data[i2 - 1] = this.data[i2];
                }
                if (this.maxIdx > 0) {
                    this.data[--this.maxIdx] = 32;
                }
                if (this.idx > this.maxIdx) {
                    this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                    --this.idx;
                }
            }
        }

        boolean delNnac() {
            this.selectedAll = false;
            int n2 = this.idx;
            if (n2 >= this.len) {
                n2 = this.len - 1;
            }
            while (this.isEditingIndex(n2)) {
                --n2;
            }
            int n3 = this.decPointIdx > 0 ? (n2 > this.decPointIdx ? this.decPointIdx + 1 : 0) : 0;
            int n4 = this.getFirstDigitIdx();
            ++n4;
            while (this.isEditingIndex(n4)) {
                ++n4;
            }
            block2: for (int i2 = n2; i2 > n3; --i2) {
                if (this.pict != null) {
                    if (i2 < this.pict.length && TerminalAccept.isEditing(this.pict[i2])) {
                        if (i2 > n4) continue;
                        this.data[i2] = 32;
                        continue;
                    }
                    for (int i3 = i2 - 1; i3 >= n3; --i3) {
                        if (i3 < this.pict.length && TerminalAccept.isEditing(this.pict[i3])) continue;
                        this.data[i2] = this.data[i3];
                        continue block2;
                    }
                    continue;
                }
                this.data[i2] = this.data[i2 - 1];
            }
            if (!this.isEditingIndex(n3)) {
                this.data[n3] = this.decPointIdx > 0 && n3 > this.decPointIdx ? 48 : 32;
                ++n2;
                while (n2 != this.decPointIdx && n2 < this.len && this.isEditingIndex(n2)) {
                    this.data[n2] = 32;
                    ++n2;
                }
                this.idx = n2;
                this.col = n2;
            }
            return true;
        }

        public boolean delch() {
            boolean bl;
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    --this.idx;
                } else {
                    for (int i2 = this.idx; i2 < this.maxIdx; ++i2) {
                        this.data[i2 - 1] = this.data[i2];
                    }
                    --this.idx;
                    this.data[--this.maxIdx] = 32;
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.delch();
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        boolean myleft() {
            if (this.idx == 0 || this.getValue() != null && this.getValue().length() == 0 && this.idx == 0) {
                return false;
            }
            return this.left();
        }

        public boolean left() {
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                --this.idx;
                if ((TerminalAccept.this.editedFormatted || this.idx != this.decPointIdx) && this.isEditingIndex(this.idx)) {
                    return this.left();
                }
                return true;
            }
            return false;
        }

        boolean myright() {
            String string = this.getValue();
            int n2 = this.col;
            if (string != null && string.length() != 0 && string.length() == n2) {
                return false;
            }
            return this.right();
        }

        public boolean right() {
            this.selectedAll = false;
            if (this.idx < (TerminalAccept.this.update ? this.len - 1 : this.maxIdx)) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                ++this.idx;
                if (this.pict != null && this.idx < this.pict.length && TerminalAccept.isEditing(this.pict[this.idx])) {
                    this.right();
                }
                return true;
            }
            return false;
        }

        public boolean home() {
            int n2;
            this.selectedAll = false;
            boolean bl = this.idx != 0;
            this.col = this.idx = (n2 = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear ? this.getFirstDigitIdx() : 0);
            return bl;
        }

        public boolean end() {
            boolean bl;
            this.selectedAll = false;
            if (this.maxIdx == this.len) {
                bl = this.idx != this.maxIdx - 1;
                this.idx = this.maxIdx - 1;
            } else {
                bl = this.idx != this.maxIdx;
                this.idx = this.maxIdx;
            }
            this.col = 0;
            for (int i2 = 0; i2 < this.idx; ++i2) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[i2]) ? 2 : 1;
            }
            return bl;
        }

        public void setOffset(int n2) {
            if (n2 > 0) {
                while (this.idx < this.len && this.idx < n2) {
                    if (this.data[this.idx] >= ' ' && this.data[this.idx] != '\u007f') {
                        this.addch(this.data[this.idx]);
                        continue;
                    }
                    this.addch(' ');
                }
            }
            if (this.maxIdx > 0 && n2 < this.maxIdx) {
                this.idx = n2;
                this.col = 0;
                for (int i2 = 0; i2 < this.idx; ++i2) {
                    this.col += TerminalAccept.this.tm.dblWidth(this.data[i2]) ? 2 : 1;
                }
            }
        }

        public int getOffset() {
            return this.col;
        }

        int getIdx() {
            return this.idx;
        }

        int getLength() {
            return this.len;
        }

        public char[] getData(boolean bl) {
            if (bl) {
                for (int i2 = this.maxIdx; i2 < this.len; ++i2) {
                    this.data[i2] = TerminalAccept.this.promptChar;
                }
            } else {
                for (int i3 = this.maxIdx; i3 < this.len; ++i3) {
                    this.data[i3] = 32;
                }
            }
            return this.data;
        }
    }
}

