/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.charva.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TerminalModel
implements Constants,
PropertyChangeListener {
    public static final int A_BOLD = 0x1000000;
    public static final int A_UNDERLINE = 0x2000000;
    public static final int A_REVERSE = 0x4000000;
    public static final int A_BLINK = 0x8000000;
    public static final int A_NOECHO = 0x10000000;
    public static final int A_GRAPHIC = 0x20000000;
    public static final int A_NORESET = 0x30000000;
    public static final int A_MASK = -16777216;
    public static final char ACS_HLINE = '\u0003';
    public static final char ACS_LHLINE = '\u0002';
    public static final char ACS_RHLINE = '\u0001';
    public static final char ACS_VLINE = '\f';
    public static final char ACS_TVLINE = '\u0004';
    public static final char ACS_BVLINE = '\b';
    public static final char ACS_ULCORNER = '\u0006';
    public static final char ACS_URCORNER = '\u0005';
    public static final char ACS_LLCORNER = '\n';
    public static final char ACS_LRCORNER = '\t';
    public static final char ACS_BTEE = '\u000b';
    public static final char ACS_TTEE = '\u0007';
    public static final char ACS_LTEE = '\u000e';
    public static final char ACS_RTEE = '\r';
    public static final char ACS_PLUS = '\u000f';
    public static final boolean DEF_AUTOWRAP = false;
    public static final int CURSOR_INVIS = 0;
    public static final int CURSOR_UNDER = 1;
    public static final int CURSOR_BLOCK = 2;
    public static final int CURSOR_MIXED = 3;
    public static final int CURSOR_VLINE = 4;
    public static final int DEF_CURSTYPE = 2;
    public static final char defChar = ' ';
    public static final int defAttr = 0xFFFFFF;
    private int x0Orig;
    private int y0Orig;
    private int x0;
    private int y0;
    private int heightOrig;
    private int widthOrig;
    private int width;
    private int height;
    private int heightOutBound;
    private int[][] backMatrix;
    private int[][] attrMatrix;
    private char[][] charMatrix;
    private Point cursor;
    private Point caret;
    private Component withFocus;
    private Point lastCaret;
    private Color lastCaretColor;
    private int backColor;
    private int termAttr;
    private Dimension charDim;
    private int cursorType;
    boolean insertCursor;
    private boolean autowrap;
    private AbstractGuiFactoryImpl gf;
    private int lastx = -1;
    private int lasty = -1;
    private Point wgetcxy;
    private boolean wgetcrunning;

    public TerminalModel(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        this.gf = abstractGuiFactoryImpl;
        this.setBackColor(Color.black);
        this.setForeColor(Color.white);
    }

    public synchronized void init(int n2, int n3, Dimension dimension) {
        this.x0 = 0;
        this.x0Orig = 0;
        this.y0 = 0;
        this.y0Orig = 0;
        this.widthOrig = this.width = n2;
        this.heightOrig = this.height = n3;
        this.charDim = dimension;
        this.backMatrix = new int[n2][n3];
        this.attrMatrix = new int[n2][n3];
        this.charMatrix = new char[n2][n3];
        this.cursor = new Point(0, 0);
        this.caret = new Point(-1, -1);
        this.lastCaret = new Point(-1, -1);
        this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        this.gf.getCsProperty().addPropertyChangeListener(this);
        this.erase();
    }

    public synchronized void changeWidth(int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 > this.widthOrig) {
            n6 = n2;
            n5 = this.widthOrig;
        } else {
            n6 = this.widthOrig;
            n5 = n2;
        }
        int[][] nArray = new int[n2][this.heightOrig];
        int[][] nArray2 = new int[n2][this.heightOrig];
        char[][] cArray = new char[n2][this.heightOrig];
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < this.heightOrig; ++n3) {
                nArray[n4][n3] = this.backMatrix[n4][n3];
                nArray2[n4][n3] = this.attrMatrix[n4][n3];
                cArray[n4][n3] = this.charMatrix[n4][n3];
            }
        }
        while (n4 < n2) {
            for (n3 = 0; n3 < this.heightOrig; ++n3) {
                nArray[n4][n3] = this.backColor;
                nArray2[n4][n3] = this.termAttr;
                cArray[n4][n3] = 32;
            }
            ++n4;
        }
        this.backMatrix = nArray;
        this.attrMatrix = nArray2;
        this.charMatrix = cArray;
        if (this.width == this.widthOrig) {
            this.width = n2;
        }
        this.widthOrig = n2;
    }

    private void mySetBackColor(Color color) {
        if (color != null) {
            this.backColor = color.getCursesColor();
        }
    }

    private void mySetForeColor(Color color) {
        if (color != null) {
            this.termAttr = color.getCursesColor() & 0xFFFFFF | this.termAttr & 0xFF000000;
        }
    }

    public void setSubwindow(int n2, int n3, int n4, int n5) {
        if (n2 >= 0 && n2 < this.widthOrig) {
            this.x0 = n2;
        }
        if (n3 >= 0 && n3 < this.heightOrig) {
            this.y0 = n3;
        }
        if (n4 >= 0 && n4 < this.widthOrig) {
            this.width = n4;
        }
        if (n5 >= 0 && n5 < this.heightOrig) {
            this.height = n5;
        }
        this.cursor.x = this.x0;
        this.cursor.y = this.y0;
    }

    public void resetSubwindow() {
        this.x0 = this.x0Orig;
        this.y0 = this.y0Orig;
        this.width = this.widthOrig;
        this.height = this.heightOrig;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.charDim.width * this.widthOrig, this.charDim.height * this.heightOrig);
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.setBackground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, color);
        }
    }

    public void setForeground(Color color, int n2) {
        if (color != null) {
            this.setForeground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, color, n2);
        }
    }

    public void setBackColor(Color color) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetForeColor(color);
        } else {
            this.mySetBackColor(color);
        }
    }

    public void setForeColor(Color color) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetBackColor(color);
        } else {
            this.mySetForeColor(color);
        }
    }

    private void swapForeBack() {
        int n2 = this.termAttr;
        this.termAttr = this.backColor & 0xFFFFFF | this.termAttr & 0xFF000000;
        this.backColor = n2 & 0xFFFFFF;
    }

    public void setCaretAt(int n2, int n3, Component component) {
        this.withFocus = component;
        this.caret.y = n3 < 0 ? 0 : (n3 >= this.heightOrig ? this.heightOrig - 1 : n3);
        this.caret.x = n2 < 0 ? 0 : (n2 > this.widthOrig ? this.widthOrig : n2);
    }

    public void caretLeft() {
        if (this.caret.x < this.width - 1) {
            ++this.caret.x;
        }
    }

    public void caretRight() {
        if (this.caret.x > this.x0) {
            --this.caret.x;
        }
    }

    public void unsetCaret(Component component) {
        if (component == this.withFocus) {
            this.caret.y = -1;
            this.caret.x = -1;
            this.withFocus = null;
        }
    }

    public void setAttr(int n2) {
        boolean bl = (n2 & 0x4000000) != 0 && (this.termAttr & 0x4000000) == 0;
        this.termAttr = this.termAttr & 0xFFFFFF | n2 & 0xFF000000;
        if (bl) {
            this.swapForeBack();
        }
    }

    public void unsetAttr(int n2) {
        boolean bl = (n2 & 0x4000000) != 0 && (this.termAttr & 0x4000000) != 0;
        this.termAttr &= ~(n2 & 0xFF000000);
        if (bl) {
            this.swapForeBack();
        }
    }

    public void clearAttr() {
        if ((this.termAttr & 0x4000000) != 0) {
            this.swapForeBack();
        }
        this.termAttr &= 0xFFFFFF;
    }

    public boolean move(int n2, int n3) {
        boolean bl = false;
        boolean bl2 = true;
        if (n2 == this.lastx && n3 == this.lasty) {
            bl2 = false;
        }
        this.lastx = n2;
        this.lasty = n3;
        if (n3 >= this.height) {
            if (bl2) {
                if (this.heightOutBound > 0 && n3 > this.heightOutBound) {
                    this.scroll(n3 - this.heightOutBound);
                } else {
                    this.scroll(n3 - this.height + 1);
                }
                this.heightOutBound = n3;
            }
            n3 = this.height - 1;
            bl = true;
        } else {
            this.heightOutBound = 0;
        }
        if (n2 > this.width) {
            n2 = this.width;
        }
        this.imove(n2, n3);
        return bl;
    }

    private void imove(int n2, int n3) {
        this.cursor.y = n3 < 0 ? 0 : (n3 >= this.heightOrig ? this.heightOrig - 1 : n3);
        this.cursor.x = n2 < 0 ? 0 : (n2 > this.widthOrig ? this.widthOrig : n2);
    }

    public Point getyx() {
        return this.cursor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private synchronized void clearToLine(int n2) {
        int n3;
        int n4 = this.cursor.y;
        if (this.cursor.x > this.x0) {
            for (n3 = this.cursor.x; n3 < this.width; ++n3) {
                this.backMatrix[n3][n4] = this.backColor;
                this.attrMatrix[n3][n4] = this.termAttr;
                this.charMatrix[n3][n4] = 32;
            }
            ++n4;
        }
        while (n4 <= n2) {
            for (n3 = this.x0; n3 < this.width; ++n3) {
                this.backMatrix[n3][n4] = this.backColor;
                this.attrMatrix[n3][n4] = this.termAttr;
                this.charMatrix[n3][n4] = 32;
            }
            ++n4;
        }
    }

    public void erase() {
        this.imove(this.x0, this.y0);
        this.clrtobot();
        this.imove(this.x0, this.y0);
    }

    public void clrtoeol() {
        this.clearToLine(this.cursor.y);
    }

    public void clrtobot() {
        this.clearToLine(this.height - 1);
    }

    public synchronized void scroll(int n2) {
        int n3;
        int n4;
        if (n2 > 0) {
            int n5 = this.y0;
            n4 = this.y0 + n2;
            while (n5 < this.height - n2) {
                for (n3 = this.x0; n3 < this.width; ++n3) {
                    this.backMatrix[n3][n5] = this.backMatrix[n3][n4];
                    this.attrMatrix[n3][n5] = this.attrMatrix[n3][n4];
                    this.charMatrix[n3][n5] = this.charMatrix[n3][n4];
                }
                ++n5;
                ++n4;
            }
            n3 = this.cursor.x;
            n4 = this.cursor.y - 1;
            this.imove(this.x0, n5);
            this.clearToLine(this.height - 1);
        } else if (n2 == 0) {
            n3 = this.cursor.x;
            n4 = this.cursor.y;
        } else {
            int n6 = this.height - (n2 *= -1) - 1;
            n4 = this.height - 1;
            while (n6 >= this.y0) {
                for (n3 = this.x0; n3 < this.width; ++n3) {
                    this.backMatrix[n3][n4] = this.backMatrix[n3][n6];
                    this.attrMatrix[n3][n4] = this.attrMatrix[n3][n6];
                    this.charMatrix[n3][n4] = this.charMatrix[n3][n6];
                }
                --n6;
                --n4;
            }
            n3 = this.cursor.x;
            n4 = this.cursor.y - 1;
            this.imove(this.x0, this.y0);
            this.clearToLine(this.y0 + n2 - 1);
        }
        if (n4 < 0) {
            n4 = 0;
        }
        this.imove(n3, n4);
    }

    public void setForeground(int n2, int n3, int n4, int n5, Color color, int n6) {
        this.setForeColor(color);
        if (n4 < 1 || n5 < 1) {
            return;
        }
        n6 &= 0xFF000000;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        if (color == null) {
            for (int i2 = n3 + n5 - 1; i2 >= n3; --i2) {
                for (int i3 = n2 + n4 - 1; i3 >= n2; --i3) {
                    this.attrMatrix[i3][i2] = this.attrMatrix[i3][i2] & 0x20FFFFFF | n6;
                }
            }
        } else {
            int n7 = color.getCursesColor() & 0xFFFFFF;
            for (int i4 = n3 + n5 - 1; i4 >= n3; --i4) {
                for (int i5 = n2 + n4 - 1; i5 >= n2; --i5) {
                    this.attrMatrix[i5][i4] = n7 | this.attrMatrix[i5][i4] & 0x20000000 | n6;
                }
            }
        }
    }

    public synchronized void setBackground(int n2, int n3, int n4, int n5, Color color) {
        this.setBackColor(color);
        if (n4 < 1 || n5 < 1 || color == null) {
            return;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n4 > this.widthOrig) {
            n4 = this.widthOrig;
        }
        if (n5 > this.heightOrig) {
            n5 = this.heightOrig;
        }
        int n6 = color.getCursesColor();
        for (int i2 = n3 + n5 - 1; i2 >= n3; --i2) {
            for (int i3 = n2 + n4 - 1; i3 >= n2; --i3) {
                this.backMatrix[i3][i2] = n6;
            }
        }
    }

    public void clrarea(int n2, int n3, int n4, int n5, Color color, int n6, Color color2) {
        int n7 = this.termAttr;
        int n8 = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(n6);
        this.setForeColor(color);
        this.setBackColor(color2);
        this.clrarea(n2, n3, n4, n5);
        this.termAttr = n7;
        this.backColor = n8;
    }

    public synchronized void clrarea(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            return;
        }
        if (n3 < this.y0) {
            n3 = this.y0;
        } else if (n3 >= this.height) {
            n3 = this.height - 1;
        }
        if (n2 < this.x0) {
            n2 = this.x0;
        } else if (n2 > this.width) {
            n2 = this.width - 1;
        }
        if (n2 + n4 > this.width) {
            n4 = this.width - n2;
        }
        if (n3 + n5 > this.height) {
            n5 = this.height - n3;
        }
        int n6 = this.termAttr;
        this.termAttr &= 0xFFFFFF;
        for (int i2 = n3 + n5 - 1; i2 >= n3; --i2) {
            for (int i3 = n2 + n4 - 1; i3 >= n2; --i3) {
                this.backMatrix[i3][i2] = this.backColor;
                this.attrMatrix[i3][i2] = this.termAttr;
                this.charMatrix[i3][i2] = 32;
            }
        }
        this.termAttr = n6;
    }

    private synchronized void rawGLAdd(char c2, boolean bl) {
        if (!bl || (this.attrMatrix[this.cursor.x][this.cursor.y] & 0x20000000) == 0) {
            this.rawadd(c2);
        } else {
            this.rawadd((char)(c2 | this.charMatrix[this.cursor.x][this.cursor.y]));
        }
    }

    boolean dblWidth(char c2) {
        return false;
    }

    private synchronized void rawadd(char c2) {
        this.charMatrix[this.cursor.x][this.cursor.y] = c2;
        this.backMatrix[this.cursor.x][this.cursor.y] = this.backColor;
        this.attrMatrix[this.cursor.x][this.cursor.y] = this.termAttr;
        if (this.cursor.x < this.widthOrig - 1) {
            ++this.cursor.x;
        }
        if (this.dblWidth(c2)) {
            this.rawadd(' ');
        }
    }

    private synchronized void addchonly(char c2) {
        int n2;
        int n3 = this.dblWidth(c2) ? 2 : 1;
        int n4 = n2 = this.cursor.x <= this.width - n3 ? this.cursor.x : this.width - n3;
        if ((this.cursor.x += n3) >= this.width && this.autowrap) {
            if (++this.cursor.y >= this.height) {
                this.scroll(1);
            }
            this.cursor.x = this.x0;
            n2 = this.cursor.x++;
        }
        if (c2 != '\u0000') {
            this.charMatrix[n2][this.cursor.y] = c2;
        }
    }

    private synchronized void addch(char c2) {
        int n2 = this.dblWidth(c2) ? 2 : 1;
        int n3 = this.cursor.x <= this.width - n2 ? this.cursor.x : this.width - n2;
        this.backMatrix[n3][this.cursor.y] = this.backColor;
        if (this.cursor.x++ >= this.width && this.autowrap) {
            if (++this.cursor.y >= this.height) {
                this.scroll(1);
            }
            this.cursor.x = this.x0;
            n3 = this.cursor.x++;
        }
        if (c2 != '\u0000') {
            this.attrMatrix[n3][this.cursor.y] = this.termAttr;
            this.charMatrix[n3][this.cursor.y] = c2;
        } else {
            int[] nArray = this.attrMatrix[n3];
            int n4 = this.cursor.y;
            nArray[n4] = nArray[n4] & 0x30000000;
            int[] nArray2 = this.attrMatrix[n3];
            int n5 = this.cursor.y;
            nArray2[n5] = nArray2[n5] | this.termAttr;
        }
        if (n2 > 1) {
            this.addch(' ');
        }
    }

    public void right() {
        if (this.cursor.x < this.width) {
            int n2;
            int n3 = n2 = this.dblWidth(this.charMatrix[this.cursor.x][this.cursor.y]) ? 2 : 1;
            if (this.cursor.x <= this.width - n2) {
                this.cursor.x += n2;
            }
        }
    }

    public void left() {
        if (this.cursor.x > this.x0) {
            --this.cursor.x;
        }
    }

    public void crlf() {
        if (this.cursor.y < this.height - 1) {
            ++this.cursor.y;
        }
        this.cursor.x = this.x0;
    }

    public Rectangle addstr(char[] cArray) {
        Rectangle rectangle = new Rectangle(0, 0, 80, 24);
        if (cArray == null) {
            return rectangle;
        }
        this.upperLeft(rectangle);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            this.addch(cArray[i2]);
        }
        this.bottomRight(rectangle);
        return rectangle;
    }

    public Rectangle addstr(String string, int n2, Color color, int n3, Color color2) {
        int n4;
        Rectangle rectangle = new Rectangle(0, 0, 80, 24);
        this.upperLeft(rectangle);
        int n5 = this.termAttr;
        int n6 = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(n3);
        this.setForeColor(color);
        this.setBackColor(color2);
        char[] cArray = new char[n2];
        char[] cArray2 = string != null ? string.toCharArray() : new char[n2];
        int n7 = cArray.length < cArray2.length ? cArray.length : cArray2.length;
        for (n4 = 0; n4 < n7; ++n4) {
            cArray[n4] = cArray2[n4];
        }
        while (n4 < cArray.length) {
            cArray[n4] = 32;
            ++n4;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            this.addch(cArray[n4]);
        }
        this.termAttr = n5;
        this.backColor = n6;
        this.bottomRight(rectangle);
        return rectangle;
    }

    private void paintBack(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        graphics.setBackColor(Color.fromCursesColor((int)(n2 & 0xFFFFFF)));
        if (n3 > 0 && n6 > n4) {
            graphics.fillRect(n3 * this.charDim.width, n4 * this.charDim.height, this.widthOrig * this.charDim.width, n4 * this.charDim.height + this.charDim.height);
            n3 = 0;
            ++n4;
        }
        if (n3 == 0 && n6 > n4) {
            graphics.fillRect(0, n4 * this.charDim.height, this.widthOrig * this.charDim.width, (n6 - 1) * this.charDim.height + this.charDim.height);
            n3 = 0;
            n4 = n6;
        }
        graphics.fillRect(n3 * this.charDim.width, n4 * this.charDim.height, n5 * this.charDim.width, n4 * this.charDim.height + this.charDim.height);
    }

    private void myDrawString(Graphics graphics, StringBuffer stringBuffer, int n2, int n3, int n4) {
        int n5 = stringBuffer.length();
        char[] cArray = new char[1];
        for (int i2 = 0; i2 < n5; ++i2) {
            cArray[0] = stringBuffer.charAt(i2);
            if (cArray[0] == ' ' && (n4 & 0x1000000) != 0x1000000 && (n4 & 0x2000000) != 0x2000000 && (n4 & 0x8000000) != 0x8000000 && (n4 & 0x4000000) != 0x4000000) continue;
            graphics.addChar(cArray[0], n4, (n2 + i2) * this.charDim.width, n3);
        }
    }

    private void paintForeLine(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        graphics.setForeColor(Color.fromCursesColor((int)(n2 & 0xFFFFFF)));
        graphics.setBackColor(Color.fromCursesColor((int)(n3 & 0xFFFFFF)));
        int n7 = n2 & 0x20000000;
        if (n7 != 0) {
            int n8 = n5 * this.charDim.height + this.charDim.height / 2;
            int n9 = this.charDim.width / 2;
            int n10 = this.charDim.height / 2;
            block15: for (int i2 = n4; i2 < n6; ++i2) {
                switch (this.charMatrix[i2][n5]) {
                    default: {
                        continue block15;
                    }
                    case '\u0003': {
                        graphics.addChar(Toolkit.ACS_HLINE, i2, n8);
                        continue block15;
                    }
                    case '\u000f': {
                        graphics.addChar(Toolkit.ACS_PLUS, i2, n8);
                        continue block15;
                    }
                    case '\f': {
                        graphics.addChar(Toolkit.ACS_VLINE, i2, n8);
                        continue block15;
                    }
                    case '\u0001': 
                    case '\u0002': {
                        graphics.addChar(Toolkit.ACS_HLINE, i2, n8);
                        continue block15;
                    }
                    case '\u0004': 
                    case '\b': {
                        graphics.addChar(Toolkit.ACS_VLINE, i2, n8);
                        continue block15;
                    }
                    case '\u0006': {
                        graphics.addChar(Toolkit.ACS_ULCORNER, i2, n8);
                        continue block15;
                    }
                    case '\u0005': {
                        graphics.addChar(Toolkit.ACS_URCORNER, i2, n8);
                        continue block15;
                    }
                    case '\t': {
                        graphics.addChar(Toolkit.ACS_LRCORNER, i2, n8);
                        continue block15;
                    }
                    case '\n': {
                        graphics.addChar(Toolkit.ACS_LLCORNER, i2, n8);
                        continue block15;
                    }
                    case '\u0007': {
                        graphics.addChar(Toolkit.ACS_TTEE, i2, n8);
                        continue block15;
                    }
                    case '\u000b': {
                        graphics.addChar(Toolkit.ACS_BTEE, i2, n8);
                        continue block15;
                    }
                    case '\u000e': {
                        graphics.addChar(Toolkit.ACS_LTEE, i2, n8);
                        continue block15;
                    }
                    case '\r': {
                        graphics.addChar(Toolkit.ACS_RTEE, i2, n8);
                    }
                }
            }
        } else if (n6 > n4) {
            int n11;
            int n12 = n11 = n5 * this.charDim.height;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i3 = n4; i3 < n6; ++i3) {
                stringBuffer.append(this.charMatrix[i3][n5]);
            }
            if ((n2 & 0x1000000) != 0) {
                // empty if block
            }
            if ((n2 & 0x10000000) == 0) {
                this.myDrawString(graphics, stringBuffer, n4, n11, n2);
            }
            if ((n2 & 0x2000000) != 0) {
                // empty if block
            }
        }
    }

    public void shadow(int n2, int n3, int n4, int n5, boolean bl) {
        if (n4 > 1 && n5 > 1) {
            int n6;
            int n7 = this.backColor;
            this.setBackColor(Color.black);
            if (n2 + n4 < this.widthOrig) {
                if (bl) {
                    this.imove(n2 + n4, n3 + 1);
                    this.rawadd(' ');
                } else {
                    this.imove(n2 + n4, n3);
                    this.rawadd(' ');
                    this.imove(n2 + n4, n3 + 1);
                    this.rawadd(' ');
                }
                for (n6 = n3 + 2; n6 < n3 + n5 && n6 < this.heightOrig; ++n6) {
                    this.imove(n2 + n4, n6);
                    this.rawadd(' ');
                }
            }
            if (n3 + n5 < this.heightOrig) {
                this.imove(n2 + 1, n3 + n5);
                this.rawadd(' ');
                for (n6 = n2 + 2; n6 < n2 + n4 && n6 < this.widthOrig; ++n6) {
                    this.rawadd(' ');
                }
                this.rawadd(' ');
            }
            this.backColor = n7;
        }
    }

    private void box(int n2, int n3, int n4, int n5, boolean bl, boolean bl2, Graphics graphics) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        this.setAttr(0x20000000);
        if (n5 == 1 && !bl2) {
            if (n4 > 0) {
                this.imove(n2, n3);
                if (n4 > 1) {
                    this.rawGLAdd('\u0002', bl);
                    for (int i2 = 1; i2 < n4 - 1; ++i2) {
                        this.rawGLAdd('\u0003', bl);
                    }
                    this.rawGLAdd('\u0001', bl);
                } else {
                    this.rawGLAdd('\u0003', bl);
                }
            }
        } else if (n4 == 1) {
            if (n5 > 0) {
                this.imove(n2, n3);
                if (n5 > 1) {
                    int n6;
                    this.rawGLAdd('\u0004', bl);
                    for (n6 = 1; n6 < n5 - 1; ++n6) {
                        this.imove(n2, n3 + n6);
                        this.rawGLAdd('\f', bl);
                    }
                    this.imove(n2, n3 + n6);
                    this.rawGLAdd('\b', bl);
                } else {
                    this.rawGLAdd('\f', bl);
                }
            }
        } else {
            int n7;
            this.imove(n2, n3);
            this.rawGLAdd('\u0006', bl);
            for (n7 = 2; n7 < n4; ++n7) {
                this.rawGLAdd('\u0003', bl);
            }
            this.rawGLAdd('\u0005', bl);
            for (n7 = 1; n7 < n5 - 1; ++n7) {
                this.imove(n2, n3 + n7);
                this.rawGLAdd('\f', bl);
                this.imove(n2 + n4 - 1, n3 + n7);
                this.rawGLAdd('\f', bl);
            }
            this.imove(n2, n3 + n5 - 1);
            this.rawGLAdd('\n', bl);
            for (n7 = 2; n7 < n4; ++n7) {
                this.rawGLAdd('\u0003', bl);
            }
            this.rawGLAdd('\t', bl);
        }
        this.unsetAttr(0x20000000);
    }

    private void printtitle(int n2, int n3, int n4, int n5, String string, int n6) {
        if (string != null) {
            int n7 = string.length();
            if (n7 > n4 - 6) {
                n7 = n4 - 6;
                string = string.substring(0, n7);
            }
            string = " " + string + " ";
            n7 += 2;
            switch (n6) {
                default: {
                    this.move(n2 + (n4 - n7) / 2, n3);
                    break;
                }
                case 1: {
                    this.move(n2 + 2, n3);
                    break;
                }
                case 3: {
                    this.move(n2 + n4 - n7 - 2, n3);
                    break;
                }
                case 5: {
                    this.imove(n2 + (n4 - n7) / 2, n3 + n5 - 1);
                    break;
                }
                case 4: {
                    this.imove(n2 + 2, n3 + n5 - 1);
                    break;
                }
                case 6: {
                    this.imove(n2 + n4 - n7 - 2, n3 + n5 - 1);
                }
            }
            this.addstr(string.toCharArray());
            this.imove(n2 + n4, n3 + n5 - 1);
        }
    }

    public void box(int n2, int n3, int n4, int n5, Color color, int n6, Color color2, String[] stringArray, int[] nArray, boolean bl, Graphics graphics) {
        this.box(n2, n3, n4, n5, color, n6, color2, stringArray, nArray, bl, false, graphics);
    }

    public void box(int n2, int n3, int n4, int n5, Color color, int n6, Color color2, String[] stringArray, int[] nArray, boolean bl, boolean bl2, Graphics graphics) {
        int n7 = this.termAttr;
        int n8 = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(n6);
        this.setForeColor(color);
        this.setBackColor(color2);
        this.box(n2, n3, n4, n5, bl, bl2, graphics);
        if (stringArray[0] != null) {
            this.printtitle(n2, n3, n4, n5, stringArray[0], nArray[0]);
        }
        if (stringArray[1] != null) {
            this.printtitle(n2, n3, n4, n5, stringArray[1], nArray[1]);
        }
        this.termAttr = n7;
        this.backColor = n8;
    }

    public void intdrawCaretOn(Graphics graphics, int n2, int n3, boolean bl) {
        Color color;
        this.lastCaretColor = Color.fromCursesColor((int)(this.attrMatrix[n2][n3] & 0xFFFFFF));
        Color color2 = color = Color.fromCursesColor((int)(this.backMatrix[n2][n3] & 0xFFFFFF));
        Color color3 = this.lastCaretColor;
        graphics.setForeColor(color3);
        graphics.setBackColor(color2);
        switch (this.cursorType) {
            default: 
        }
        graphics.fillCursorOn(this.charMatrix[n2][n3], this.attrMatrix[n2][n3], n2 * this.charDim.width, n3 * this.charDim.height, this.charDim.width, this.charDim.height);
        if (bl) {
            this.wgetcxy = new Point(n2, n3);
        }
        this.wgetcrunning = bl;
    }

    private void drawCaretOn(Graphics graphics) {
        if (this.wgetcrunning && this.wgetcxy != null) {
            this.intdrawCaretOn(graphics, this.wgetcxy.x, this.wgetcxy.y, true);
        } else if (this.caret.x >= 0) {
            this.lastCaret.x = this.caret.x;
            this.lastCaret.y = this.caret.y;
            int n2 = this.lastCaret.x < this.widthOrig ? this.lastCaret.x : this.widthOrig - 1;
            this.intdrawCaretOn(graphics, n2, this.lastCaret.y, false);
        }
    }

    public void intdrawCaretOff(Graphics graphics, int n2, int n3) {
        graphics.setForeColor(this.lastCaretColor);
        Color color = Color.fromCursesColor((int)(this.backMatrix[n2][n3] & 0xFFFFFF));
        graphics.setBackColor(color);
        graphics.fillCursorOff(n2 * this.charDim.width, n3 * this.charDim.height, this.charDim.width, this.charDim.height);
        this.lastCaret.y = -1;
        this.lastCaret.x = -1;
        this.lastCaretColor = null;
        this.wgetcrunning = false;
    }

    public void drawCaretOff(Graphics graphics) {
        if (this.wgetcrunning && this.wgetcxy != null) {
            this.intdrawCaretOn(graphics, this.wgetcxy.x, this.wgetcxy.y, true);
        } else if (this.lastCaret.x >= 0) {
            int n2 = this.lastCaret.x < this.widthOrig ? this.lastCaret.x : this.widthOrig - 1;
            this.intdrawCaretOff(graphics, n2, this.lastCaret.y);
        }
    }

    public synchronized void paint(Graphics graphics, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = this.backMatrix[n2][n4];
        int n7 = n2;
        this.drawCaretOff(graphics);
        for (n5 = n2; n5 < n3; ++n5) {
            if (this.backMatrix[n5][n4] == n6) continue;
            this.paintBack(graphics, n6, n7, n4, n5, n4);
            n6 = this.backMatrix[n5][n4];
            n7 = n5;
        }
        if (n7 == n2 || n7 < n3) {
            this.paintBack(graphics, n6, n7, n4, n3, n4);
        }
        n7 = n2;
        int n8 = this.attrMatrix[n2][n4];
        n6 = this.backMatrix[n2][n4];
        for (n5 = n2; n5 < n3; ++n5) {
            if (this.attrMatrix[n5][n4] == n8) continue;
            graphics.setForeColor(Color.fromCursesColor((int)(n8 & 0xFF000000)));
            this.paintForeLine(graphics, n8, n6, n7, n4, n5);
            n8 = this.attrMatrix[n5][n4];
            n6 = this.backMatrix[n5][n4];
            n7 = n5;
        }
        if (n7 == n2 || n7 < n3) {
            this.paintForeLine(graphics, n8, n6, n7, n4, n3);
        }
        this.drawCaretOn(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        int n2;
        int n3 = 0;
        int n4 = this.backMatrix[0][0];
        int n5 = 0;
        int n6 = 0;
        this.drawCaretOff(graphics);
        for (n2 = 0; n2 < this.heightOrig; ++n2) {
            for (n3 = 0; n3 < this.widthOrig; ++n3) {
                if (this.backMatrix[n3][n2] == n4) continue;
                this.paintBack(graphics, n4, n5, n6, n3, n2);
                n4 = this.backMatrix[n3][n2];
                n5 = n3;
                n6 = n2;
            }
        }
        this.paintBack(graphics, n4, n5, n6, n3, n2);
        int n7 = this.attrMatrix[0][0];
        n4 = this.backMatrix[0][0];
        n5 = 0;
        n6 = 0;
        for (n2 = 0; n2 < this.heightOrig; ++n2) {
            for (n3 = 0; n3 < this.widthOrig; ++n3) {
                if (this.attrMatrix[n3][n2] == n7 && this.charMatrix[n3][n2] == ' ') continue;
                graphics.setForeColor(Color.fromCursesColor((int)(n7 & 0xFF000000)));
                while (n6 < n2) {
                    this.paintForeLine(graphics, n7, n4, n5, n6, this.widthOrig);
                    n5 = 0;
                    ++n6;
                }
                this.paintForeLine(graphics, n7, n4, n5, n6, n3);
                n7 = this.attrMatrix[n3][n2];
                n4 = this.backMatrix[n3][n2];
                n5 = n3;
                n6 = n2;
            }
        }
        while (n6 < n2 - 1) {
            this.paintForeLine(graphics, n7, n4, n5, n6, this.widthOrig);
            n5 = 0;
            ++n6;
        }
        this.paintForeLine(graphics, n7, n4, n5, n6, n3);
        this.drawCaretOn(graphics);
    }

    public Area getArea(int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.widthOrig) {
            n2 = this.widthOrig - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.heightOrig) {
            n3 = this.heightOrig - 1;
        }
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        return new Area(n2, n3, n4, n5, this.backMatrix, this.attrMatrix, this.charMatrix);
    }

    public synchronized void restoreArea(Area area, int n2, int n3, int n4, int n5) {
        if (n2 + n4 > this.widthOrig) {
            n4 = this.widthOrig - n2;
        }
        if (n3 + n5 > this.heightOrig) {
            n5 = this.heightOrig - n3;
        }
        int n6 = n3 + n5 - 1;
        int n7 = n3 + n5 - area.y0 - 1;
        while (n6 >= n3) {
            int n8 = n2 + n4 - 1;
            int n9 = n2 + n4 - area.x0 - 1;
            while (n8 >= n2) {
                this.backMatrix[n8][n6] = area.backMatrix[n9][n7];
                this.attrMatrix[n8][n6] = area.attrMatrix[n9][n7];
                this.charMatrix[n8][n6] = area.charMatrix[n9][n7];
                --n8;
                --n9;
            }
            --n6;
            --n7;
        }
    }

    private void upperLeft(Rectangle rectangle) {
    }

    private void bottomRight(Rectangle rectangle) {
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    public synchronized String acceptFromScreen(int n2, int n3, int n4) {
        char[] cArray = new char[n4];
        int n5 = 0;
        n2 = n2 < 1 ? this.cursor.y : --n2;
        n3 = n3 < 1 ? this.cursor.x : --n3;
        if (n3 < this.width && n2 < this.height) {
            while (n4 > 0 && n2 < this.height) {
                cArray[n5++] = this.charMatrix[n3][n2];
                if (++n3 >= this.width) {
                    n3 = 0;
                    ++n2;
                }
                --n4;
            }
        }
        return new String(cArray);
    }

    protected synchronized char[] getTextAt(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n4 < 1 || n2 >= this.height || n3 >= this.width) {
            return new char[0];
        }
        char[] cArray = new char[Math.min(n4, this.width - n3)];
        int n5 = n3;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = this.charMatrix[n5][n2];
            ++n5;
        }
        return cArray;
    }

    private char getVirtualAttr(int n2, int n3) {
        int n4 = this.attrMatrix[n2][n3] & 0xFF000000;
        int n5 = this.attrMatrix[n2][n3] & 0xFFFFFF;
        int n6 = this.backMatrix[n2][n3] & 0xFFFFFF;
        int n7 = n5 == 0 ? (n6 == 0 ? n4 | 0x10000000 : n4 | 0x4000000) : (n5 == 0xFFFFFF ? n4 | 0x1000000 : (n6 == 0xFFFFFF ? (n5 == 0x808080 ? n4 | 0x4000000 | 0x1000000 : n4 | 0x4000000) : n4));
        return (char)(n7 >>> 24);
    }

    private void setVirtualAttr(char c2, int n2, int n3) {
        int n4 = c2 << 24;
        this.attrMatrix[n2][n3] = n4 | 0xC0C0C0;
        switch (n4 & 0x5000000) {
            case 0x4000000: {
                this.attrMatrix[n2][n3] = n4;
                this.backMatrix[n2][n3] = 0xFFFFFF | this.backMatrix[n2][n3] & 0xFF000000;
                break;
            }
            case 0x1000000: {
                this.attrMatrix[n2][n3] = n4 | 0xFFFFFF;
                this.backMatrix[n2][n3] = this.backMatrix[n2][n3] & 0xFF000000;
                break;
            }
            case 0x5000000: {
                this.attrMatrix[n2][n3] = n4 | 0x808080;
                this.backMatrix[n2][n3] = 0xFFFFFF | this.backMatrix[n2][n3] & 0xFF000000;
            }
        }
    }

    public synchronized String attrFromScreen(int n2, int n3, int n4) {
        char[] cArray = new char[n4];
        int n5 = 0;
        n2 = n2 < 1 ? this.cursor.y : --n2;
        n3 = n3 < 1 ? this.cursor.x : --n3;
        if (n3 < this.width && n2 < this.height) {
            while (n4 > 0 && n2 < this.height) {
                cArray[n5++] = this.getVirtualAttr(n3, n2);
                if (++n3 >= this.width) {
                    n3 = 0;
                    ++n2;
                }
                --n4;
            }
        }
        return new String(cArray);
    }

    public synchronized void writeToScreen(int n2, int n3, int n4, String string, String string2) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n5 = 0;
        n2 = n2 < 1 ? this.cursor.y : --n2;
        n3 = n3 < 1 ? this.cursor.x : --n3;
        if (n3 < this.width && n2 < this.height) {
            while (n4 > 0 && n2 < this.height) {
                this.charMatrix[n3][n2] = cArray[n5];
                this.setVirtualAttr(cArray2[n5], n3, n2);
                ++n5;
                if (++n3 >= this.width) {
                    n3 = 0;
                    ++n2;
                }
                --n4;
            }
        }
    }

    public int getBackColor() {
        return this.backColor;
    }

    public int getTermAttr() {
        return this.termAttr;
    }

    public void setBackColor(int n2) {
        this.backColor = n2;
    }

    public void setTermAttr(int n2) {
        this.termAttr = n2;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.gf != null && string.equals("iscobol.terminal.autowrap")) {
            this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        }
        if (this.gf != null && string.equals("iscobol.terminal.cursor_type")) {
            this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        }
    }

    public synchronized void end() {
        this.gf.getCsProperty().removePropertyChangeListener(this);
        this.gf = null;
        this.backMatrix = null;
        this.attrMatrix = null;
        this.charMatrix = null;
        this.cursor = null;
        this.caret = null;
    }

    public static class Area {
        private int[][] backMatrix;
        private int[][] attrMatrix;
        private char[][] charMatrix;
        int x0;
        int y0;
        int width;
        int height;

        private Area(int n2, int n3, int n4, int n5, int[][] nArray, int[][] nArray2, char[][] cArray) {
            this.x0 = n2;
            this.y0 = n3;
            this.width = n4;
            this.height = n5;
            this.backMatrix = new int[this.width][this.height];
            this.attrMatrix = new int[this.width][this.height];
            this.charMatrix = new char[this.width][this.height];
            for (int i2 = 0; i2 < this.height; ++i2) {
                for (int i3 = 0; i3 < this.width; ++i3) {
                    this.backMatrix[i3][i2] = nArray[i3 + n2][i2 + n3];
                    this.attrMatrix[i3][i2] = nArray2[i3 + n2][i2 + n3];
                    this.charMatrix[i3][i2] = cArray[i3 + n2][i2 + n3];
                }
            }
        }
    }
}

