/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.spellchecker;

import com.iscobol.gui.client.spellchecker.Span;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

public class SpellChecker {
    public static final int MISSPELLING;
    private static final boolean isSupported;
    private static final Method languages_getLanguageForShortName;
    private static final Constructor jlanguagetool;
    private static final Method jlanguagetool_check;
    private static final Method rulematch_getFromPos;
    private static final Method rulematch_getToPos;
    private static final Method rulematch_getShortMessage;
    private static final Method rulematch_getMessage;
    private static final Method rulematch_getSuggestedReplacements;
    private static final Method rulematch_getRule;
    private static final Method rule_getLocQualityIssueType;
    private static final Map languageTools;
    private static final Object defaultLanguage;

    private SpellChecker() {
    }

    public static boolean isSupported() {
        return isSupported;
    }

    public static Span[] check(String string, String string2) throws Exception {
        Object object;
        Object object2;
        if (!isSupported) {
            throw new Exception("Spell checking not supported!");
        }
        if ("default".equals(string2)) {
            object2 = defaultLanguage;
        } else {
            object2 = languageTools.get(string2);
            if (object2 == null) {
                object = languages_getLanguageForShortName.invoke(null, string2);
                object2 = jlanguagetool.newInstance(object);
                languageTools.put(string2, object2);
            }
        }
        object = (List)jlanguagetool_check.invoke(object2, string);
        Span[] spanArray = new Span[object.size()];
        int n2 = 0;
        Object[] objectArray = new Object[]{};
        ListIterator listIterator = object.listIterator();
        while (listIterator.hasNext()) {
            Object e2 = listIterator.next();
            int n3 = (Integer)rulematch_getFromPos.invoke(e2, objectArray);
            int n4 = (Integer)rulematch_getToPos.invoke(e2, objectArray);
            String string3 = (String)rulematch_getShortMessage.invoke(e2, objectArray);
            String string4 = (String)rulematch_getMessage.invoke(e2, objectArray);
            if (string3 == null || string3.length() == 0) {
                string3 = string4;
            }
            List list = (List)rulematch_getSuggestedReplacements.invoke(e2, objectArray);
            Object object3 = rulematch_getRule.invoke(e2, objectArray);
            int n5 = ((Enum)rule_getLocQualityIssueType.invoke(object3, objectArray)).ordinal();
            spanArray[n2] = new Span(n3, n4, string3, string4, list, n5);
            ++n2;
        }
        return spanArray;
    }

    static {
        languageTools = new HashMap();
        Method method = null;
        Constructor<?> constructor = null;
        Method method2 = null;
        Method method3 = null;
        Method method4 = null;
        Method method5 = null;
        Method method6 = null;
        Method method7 = null;
        Method method8 = null;
        Method method9 = null;
        Object var10_10 = null;
        int n2 = -1;
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("org.languagetool.Languages");
            try {
                method = clazz.getMethod("getLanguageForShortName", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getMethod("getLanguageForShortCode", String.class);
            }
            Method method10 = clazz.getMethod("getLanguageForLocale", Locale.class);
            Object object = method10.invoke(null, Locale.getDefault());
            Class<?> clazz2 = Class.forName("org.languagetool.Language");
            Class<?> clazz3 = Class.forName("org.languagetool.JLanguageTool");
            constructor = clazz3.getConstructor(clazz2);
            var10_10 = constructor.newInstance(object);
            method2 = clazz3.getMethod("check", String.class);
            Class<?> clazz4 = Class.forName("org.languagetool.rules.RuleMatch");
            method3 = clazz4.getMethod("getFromPos", new Class[0]);
            method4 = clazz4.getMethod("getToPos", new Class[0]);
            method5 = clazz4.getMethod("getShortMessage", new Class[0]);
            method6 = clazz4.getMethod("getMessage", new Class[0]);
            method7 = clazz4.getMethod("getSuggestedReplacements", new Class[0]);
            method8 = clazz4.getMethod("getRule", new Class[0]);
            Class<?> clazz5 = Class.forName("org.languagetool.rules.Rule");
            method9 = clazz5.getMethod("getLocQualityIssueType", new Class[0]);
            Class<?> clazz6 = Class.forName("org.languagetool.rules.ITSIssueType");
            Field field = clazz6.getField("Misspelling");
            n2 = ((Enum)field.get(null)).ordinal();
            bl = true;
        }
        catch (Throwable throwable) {
            new Exception("Spell checking not supported!", throwable).printStackTrace();
        }
        languages_getLanguageForShortName = method;
        jlanguagetool = constructor;
        jlanguagetool_check = method2;
        rulematch_getFromPos = method3;
        rulematch_getToPos = method4;
        rulematch_getMessage = method6;
        rulematch_getShortMessage = method5;
        rulematch_getSuggestedReplacements = method7;
        rulematch_getRule = method8;
        rule_getLocQualityIssueType = method9;
        MISSPELLING = n2;
        defaultLanguage = var10_10;
        isSupported = bl;
    }
}

