/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.swing.FontLabel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.InputList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AdvancedFontChooser
extends JDialog {
    private final float screenResolution;
    private JFrame parent;
    private int closedOption = -1;
    private InputList fontNameInputList;
    private InputList fontSizeInputList;
    private MutableAttributeSet attributes;
    private JCheckBox boldCheckBox = new JCheckBox("Bold");
    private JCheckBox italicCheckBox = new JCheckBox("Italic");
    private JCheckBox underlineCheckBox = new JCheckBox("Underline");
    private JCheckBox strikethroughCheckBox = new JCheckBox("Strikethrough");
    private FontLabel previewLabel;
    private Font theFont;

    public AdvancedFontChooser(JFrame jFrame, int n2, String[] stringArray, Integer[] integerArray) {
        super(jFrame, "Font Chooser", true);
        this.screenResolution = n2;
        this.fontNameInputList = new InputList(stringArray, "Name:");
        this.fontSizeInputList = new InputList(integerArray, "Size:");
        this.parent = jFrame;
        Image image = this.parent.getToolkit().getImage(this.getClass().getResource("iscobol.png"));
        this.parent.setIconImage(image);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 2));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Font"));
        jPanel.add(this.fontNameInputList);
        this.fontNameInputList.setDisplayedMnemonic('n');
        this.fontNameInputList.setToolTipText("Font name");
        jPanel.add(this.fontSizeInputList);
        this.fontSizeInputList.setDisplayedMnemonic('s');
        this.fontSizeInputList.setToolTipText("Font size");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        this.getContentPane().add(jPanel2);
        jPanel = new JPanel(new GridLayout(2, 2, 10, 5));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Effects"));
        this.boldCheckBox.setMnemonic('b');
        this.boldCheckBox.setToolTipText("Bold font");
        jPanel.add(this.boldCheckBox);
        this.italicCheckBox.setMnemonic('i');
        this.italicCheckBox.setToolTipText("Italic font");
        jPanel.add(this.italicCheckBox);
        this.underlineCheckBox.setMnemonic('u');
        this.underlineCheckBox.setToolTipText("Underline font");
        jPanel.add(this.underlineCheckBox);
        this.strikethroughCheckBox.setMnemonic('r');
        this.strikethroughCheckBox.setToolTipText("Strikethrough font");
        jPanel.add(this.strikethroughCheckBox);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(Box.createVerticalStrut(5));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(Box.createHorizontalStrut(20));
        jPanel.add(Box.createHorizontalStrut(10));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Preview"));
        this.previewLabel = new FontLabel("Preview Font");
        this.previewLabel.setPreferredSize(new Dimension(100, 75));
        jPanel.add(this.previewLabel);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new FlowLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton jButton = new JButton("OK");
        this.getRootPane().setDefaultButton(jButton);
        ActionListener actionListener = actionEvent -> {
            this.closedOption = 0;
            this.dispose();
            this.parent.dispose();
        };
        jButton.addActionListener(actionListener);
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        actionListener = actionEvent -> {
            this.closedOption = 2;
            this.dispose();
            this.parent.dispose();
        };
        jButton2.addActionListener(actionListener);
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        this.getContentPane().add(jPanel);
        this.pack();
        ListSelectionListener listSelectionListener = listSelectionEvent -> this.updatePreview();
        this.fontNameInputList.addListSelectionListener(listSelectionListener);
        this.fontSizeInputList.addListSelectionListener(listSelectionListener);
        actionListener = actionEvent -> this.updatePreview();
        this.boldCheckBox.addActionListener(actionListener);
        this.italicCheckBox.addActionListener(actionListener);
        this.underlineCheckBox.addActionListener(actionListener);
        this.strikethroughCheckBox.addActionListener(actionListener);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.isVisible()) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this.fontNameInputList.list, 1004));
        }
        super.setVisible(bl);
    }

    public void setAttributes(AttributeSet attributeSet) {
        this.attributes = new SimpleAttributeSet(attributeSet);
        String string = StyleConstants.getFontFamily(attributeSet);
        this.fontNameInputList.setSelected(string);
        int n2 = StyleConstants.getFontSize(attributeSet);
        this.fontSizeInputList.setSelectedInt(n2);
        this.boldCheckBox.setSelected(StyleConstants.isBold(attributeSet));
        this.italicCheckBox.setSelected(StyleConstants.isItalic(attributeSet));
        this.underlineCheckBox.setSelected(StyleConstants.isUnderline(attributeSet));
        this.strikethroughCheckBox.setSelected(StyleConstants.isStrikeThrough(attributeSet));
        this.updatePreview();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        StyleConstants.setFontFamily(this.attributes, this.fontNameInputList.getSelected());
        StyleConstants.setFontSize(this.attributes, this.fontSizeInputList.getSelectedInt());
        StyleConstants.setBold(this.attributes, this.boldCheckBox.isSelected());
        StyleConstants.setItalic(this.attributes, this.italicCheckBox.isSelected());
        StyleConstants.setUnderline(this.attributes, this.underlineCheckBox.isSelected());
        StyleConstants.setStrikeThrough(this.attributes, this.strikethroughCheckBox.isSelected());
        return this.attributes;
    }

    public int getOption() {
        return this.closedOption;
    }

    @Override
    public Font getFont() {
        return this.theFont;
    }

    protected void updatePreview() {
        String string = this.fontNameInputList.getSelected();
        float f2 = this.fontSizeInputList.getSelectedInt();
        if (string == null || f2 <= 0.0f) {
            return;
        }
        Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
        hashtable.put(TextAttribute.FAMILY, string);
        hashtable.put(TextAttribute.SIZE, new Float((double)(f2 * this.screenResolution) / 72.0));
        if (this.boldCheckBox.isSelected()) {
            hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.italicCheckBox.isSelected()) {
            hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.underlineCheckBox.isSelected()) {
            hashtable.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.strikethroughCheckBox.isSelected()) {
            hashtable.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        this.theFont = new Font(hashtable);
        this.previewLabel.setFont(this.theFont);
        this.previewLabel.repaint();
    }

    public static Font choose(GuiFactoryImpl guiFactoryImpl, int n2, int n3, int n4, Hashtable hashtable) {
        AdvancedFontChooser advancedFontChooser = AdvancedFontChooser.create(guiFactoryImpl, n2, n3, n4, hashtable);
        if (guiFactoryImpl != null && guiFactoryImpl.getIcon() != null) {
            advancedFontChooser.setIconImage(guiFactoryImpl.getIcon());
        }
        KeyboardBuffer.enable(null);
        advancedFontChooser.setVisible(true);
        if (advancedFontChooser.getOption() == 0) {
            return advancedFontChooser.getFont();
        }
        return null;
    }

    private static AdvancedFontChooser create(GuiFactoryImpl guiFactoryImpl, int n2, int n3, int n4, Hashtable hashtable) {
        Float f2;
        String string;
        String string2;
        if (n4 == 0) {
            n4 = Integer.MAX_VALUE;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(graphicsEnvironment.getAvailableFontFamilyNames()));
        if ((n2 & 1) == 1) {
            list = AdvancedFontChooser.filterFonts(list);
            string2 = "Monospaced";
        } else {
            string2 = "Dialog";
        }
        String[] stringArray = list.toArray(new String[list.size()]);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int simpleAttributeSet : new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72}) {
            if (simpleAttributeSet < n3 || simpleAttributeSet > n4) continue;
            arrayList.add(simpleAttributeSet);
        }
        Integer[] integerArray = arrayList.toArray(new Integer[arrayList.size()]);
        int n5 = guiFactoryImpl != null ? guiFactoryImpl.getScreenRes() : Toolkit.getDefaultToolkit().getScreenResolution();
        AdvancedFontChooser advancedFontChooser = new AdvancedFontChooser(new JFrame(), n5, stringArray, integerArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (hashtable != null) {
            string = (String)hashtable.get(FontAttribute.FAMILY);
            if (string == null || string.length() == 0) {
                string = string2;
            }
            if ((f2 = (Float)hashtable.get(FontAttribute.SIZE)) == null) {
                f2 = new Float(12.0);
            }
        } else {
            string = string2;
            f2 = new Float(12.0);
        }
        if (f2.floatValue() < (float)n3) {
            f2 = new Float(n3);
        }
        if (f2.floatValue() > (float)n4) {
            f2 = new Float(n4);
        }
        StyleConstants.setFontFamily(simpleAttributeSet, string);
        StyleConstants.setFontSize(simpleAttributeSet, f2.intValue());
        if (hashtable != null) {
            Object v2 = hashtable.get(FontAttribute.WEIGHT);
            if (v2 != null && FontAttribute.WEIGHT_BOLD.compareTo((Float)v2) <= 0) {
                StyleConstants.setBold(simpleAttributeSet, true);
            }
            if ((v2 = hashtable.get(FontAttribute.POSTURE)) != null && FontAttribute.POSTURE_OBLIQUE.compareTo((Float)v2) == 0) {
                StyleConstants.setItalic(simpleAttributeSet, true);
            }
            if ((v2 = hashtable.get(FontAttribute.UNDERLINE)) != null && FontAttribute.UNDERLINE_ON.compareTo((Integer)v2) == 0) {
                StyleConstants.setUnderline(simpleAttributeSet, true);
            }
            if ((v2 = hashtable.get(FontAttribute.STRIKETHROUGH)) != null && ((Boolean)v2).booleanValue()) {
                StyleConstants.setStrikeThrough(simpleAttributeSet, true);
            }
        }
        advancedFontChooser.setAttributes(simpleAttributeSet);
        return advancedFontChooser;
    }

    private static List<String> filterFonts(List<String> list) {
        JLabel jLabel = new JLabel();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            FontMetrics fontMetrics = jLabel.getFontMetrics(new Font(string, 0, 20));
            if (fontMetrics.charWidth('i') != fontMetrics.charWidth('W')) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

