/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class Bar
extends Component {
    public static final int SOLID = 0;
    public static final int DASH = 1;
    public static final int DOT = 2;
    public static final int DASHDOT = 3;
    public static final int DASHDOTDOT = 4;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private boolean isHorizontal;
    private Color[] colors = new Color[0];
    private int[] shading = new int[0];
    private Stroke style;
    private int[] trailingShift = new int[0];
    private int[] leadingShift = new int[0];

    public Bar() {
    }

    public Bar(int n2) {
        if (n2 == 1) {
            this.isHorizontal = true;
        }
    }

    public Bar setHorizontal() {
        this.isHorizontal = true;
        return this;
    }

    public Bar setVertical() {
        this.isHorizontal = false;
        return this;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public Bar setColors(Color[] colorArray) {
        this.colors = colorArray;
        return this;
    }

    private Color getColorAt(int n2) {
        Color color = null;
        if (n2 < this.colors.length) {
            color = this.colors[n2];
        } else if (this.colors.length > 0) {
            color = this.colors[this.colors.length - 1];
        }
        return color;
    }

    public Bar setShading(int[] nArray) {
        this.shading = nArray;
        return this;
    }

    private Color getShading(int n2, Color color) {
        if (n2 < this.shading.length) {
            switch (this.shading[n2]) {
                case -2: {
                    color = Color.black.darker();
                    break;
                }
                case -1: {
                    color = color.darker();
                    break;
                }
                case 0: {
                    color = null;
                    break;
                }
                case 1: {
                    color = color.brighter();
                    break;
                }
                case 2: {
                    color = Color.white.brighter();
                }
            }
        }
        return color;
    }

    public Bar setLeadingShift(int[] nArray) {
        this.leadingShift = nArray;
        return this;
    }

    private int getLeadingShift(int n2) {
        int n3 = 0;
        if (n2 < this.leadingShift.length) {
            n3 = this.leadingShift[n2];
        } else if (this.leadingShift.length > 0) {
            n3 = this.leadingShift[this.leadingShift.length - 1];
        }
        return n3;
    }

    public Bar setTrailingShift(int[] nArray) {
        this.trailingShift = nArray;
        return this;
    }

    private int getTrailingShift(int n2) {
        int n3 = 0;
        if (n2 < this.trailingShift.length) {
            n3 = this.trailingShift[n2];
        } else if (this.trailingShift.length > 0) {
            n3 = this.trailingShift[this.trailingShift.length - 1];
        }
        return n3;
    }

    public Bar setStyle(int n2) {
        switch (n2) {
            default: {
                this.style = null;
                break;
            }
            case 1: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
                break;
            }
            case 2: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
                break;
            }
            case 3: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
                break;
            }
            case 4: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
            }
        }
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        Dimension dimension = this.getSize();
        if (this.style != null) {
            graphics2D.setStroke(this.style);
        }
        if (this.isHorizontal) {
            int n2 = dimension.height;
            for (int i2 = 0; i2 < n2; ++i2) {
                Color color2 = this.getColorAt(i2);
                if (color2 != null) {
                    graphics2D.setColor(color2);
                }
                if ((color2 = this.getShading(i2, graphics2D.getColor())) != null) {
                    graphics2D.setColor(color2);
                }
                graphics2D.drawLine(this.getLeadingShift(i2), i2, dimension.width - this.getTrailingShift(i2) - 1, i2);
            }
        } else {
            int n3 = dimension.width;
            for (int i3 = 0; i3 < n3; ++i3) {
                Color color3 = this.getColorAt(i3);
                if (color3 != null) {
                    graphics2D.setColor(color3);
                }
                if ((color3 = this.getShading(i3, graphics2D.getColor())) != null) {
                    graphics2D.setColor(color3);
                }
                graphics2D.drawLine(i3, this.getLeadingShift(i3), i3, dimension.height - this.getTrailingShift(i3) - 1);
            }
        }
        graphics2D.setColor(color);
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("Bar Test"){

            @Override
            public void paint(Graphics graphics) {
                int n2;
                Dimension dimension = this.getSize();
                int n3 = 10;
                int n4 = 10;
                graphics.setColor(Color.cyan);
                for (n2 = n3; n2 <= dimension.width; n2 += n3) {
                    graphics.drawLine(n2, 0, n2, dimension.height - 1);
                }
                for (n2 = n4; n2 < dimension.height; n2 += n4) {
                    graphics.drawLine(0, n2, dimension.width - 1, n2);
                }
                super.paint(graphics);
            }
        };
        jFrame.getContentPane().setLayout(null);
        jFrame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent windowEvent) {
                JFrame jFrame2 = jFrame;
                synchronized (jFrame2) {
                    jFrame.notify();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setBounds(10, 10, 640, 480);
        jFrame.setBackground(Color.white);
        Bar bar = new Bar(1);
        bar.setColors(new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.yellow}).setLeadingShift(new int[]{0, 1, 2, 3, 4}).setTrailingShift(new int[]{0, 1, 2, 3, 4}).setStyle(3);
        bar.setBounds(50, 50, 100, 5);
        jFrame.getContentPane().add(bar);
        Bar bar2 = new Bar(0);
        bar2.setColors(new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.yellow}).setLeadingShift(new int[]{0, 1, 2, 3, 4}).setTrailingShift(new int[]{0, 1, 2, 3, 4}).setStyle(3);
        bar2.setBounds(70, 70, 5, 100);
        jFrame.getContentPane().add(bar2);
        Bar bar3 = new Bar(0);
        bar3.setColors(new Color[]{new Color(0, 127, 0)}).setLeadingShift(new int[]{0, 1, 2, 3, 4}).setTrailingShift(new int[]{0, 1, 2, 3, 4}).setShading(new int[]{-2, -1, 0, 1, 2}).setStyle(3);
        bar3.setBounds(90, 90, 5, 100);
        jFrame.getContentPane().add(bar3);
        jFrame.setVisible(true);
    }
}

