/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.ZoomLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class BmpLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private Image imageorig;
    private Image imageorigscale;
    private int bitmapNumber;
    private int bitmapScale;
    private boolean bitmapScaleBestQuality;

    public BmpLabel() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(1);
    }

    public void setImage(Image image, Image image2, int n2) {
        this.setText(null);
        this.imageorig = image2;
        this.bitmapNumber = n2;
        super.setIcon(new ImageIcon(image));
    }

    public void setImage(Image image, int n2, int n3, int n4, int n5) {
        this.setText(null);
        if (n5 >= 0) {
            image = ScreenUtility.makeColorTransparent(image, n5);
        }
        this.setIcon(this.getIcon(image, n2, n3, n4));
    }

    private Icon getIcon(Image image, int n2, int n3, int n4) {
        if (n4 > 0) {
            Image image2 = ScreenUtility.getImage(n2, n3, image, n4);
            if (image2 != null) {
                return new ImageIcon(image2);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        Dimension dimension = this.getSize();
        super.setBounds(n2, n3, n4, n5);
        Icon icon = super.getIcon();
        if (dimension.width != n4 || dimension.height != n5) {
            this.checkSetImage(n4, n5);
        }
    }

    private void checkSetImage(int n2, int n3) {
        Image image;
        int n4;
        int n5;
        switch (this.bitmapScale) {
            case 1: {
                n5 = 0;
                n4 = 5;
                break;
            }
            case 2: {
                n5 = 1;
                n4 = 7;
                break;
            }
            default: {
                n5 = -1;
                n4 = -1;
            }
        }
        if (n5 >= 0 && this.imageorigscale != null) {
            Image image2 = this.imageorigscale;
            image2 = ScreenUtility.scale(this.imageorigscale, n2, n3, n5, n4, this.bitmapScaleBestQuality);
            this.setImage(image2, image2, this.bitmapNumber);
        } else if (this.imageorig != null && (image = ScreenUtility.getImage(n2, n3, this.imageorig, this.bitmapNumber)) != null) {
            this.setImage(image, this.imageorig, this.bitmapNumber);
        }
    }

    public void setBitmapScale(int n2, boolean bl, Image image) {
        this.bitmapScale = n2;
        this.bitmapScaleBestQuality = bl;
        this.imageorigscale = image;
        if (image != null && this.getParent() != null && this.getParent().getLayout() != null && this.getParent().getLayout() instanceof ZoomLayout) {
            Rectangle rectangle = super.getBounds();
            Icon icon = super.getIcon();
            if (icon != null && rectangle != null && (icon.getIconWidth() != rectangle.width || icon.getIconHeight() != rectangle.height)) {
                this.checkSetImage(rectangle.width, rectangle.height);
            }
        }
    }
}

