/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JPanel;

public class BorderedPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Image offscreen;
    boolean paintSW;
    RemoteBaseGUIWindow parentDW;
    private int win3grid = -1;
    private GradientManager gradientMgr;

    public BorderedPanel(RemoteBaseGUIWindow remoteBaseGUIWindow, boolean bl) {
        this.parentDW = remoteBaseGUIWindow;
        this.paintSW = bl;
        if (remoteBaseGUIWindow != null) {
            this.win3grid = remoteBaseGUIWindow.win3_grid;
            this.gradientMgr = remoteBaseGUIWindow.gradientMgr;
            this.gradientMgr.addPropertyChangeListener(propertyChangeEvent -> this.repaint());
        }
    }

    public BorderedPanel(boolean bl) {
        this((RemoteBaseGUIWindow)null, bl);
    }

    void setParent(RemoteBaseGUIWindow remoteBaseGUIWindow) {
        this.parentDW = remoteBaseGUIWindow;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.gradientMgr != null) {
            this.gradientMgr.paint(graphics2D, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
        if (this.parentDW != null && this.win3grid >= 0) {
            Color color = graphics.getColor();
            if (this.win3grid % 7 == 0) {
                graphics.setColor(Color.yellow);
            } else if (this.win3grid % 6 == 0) {
                graphics.setColor(Color.magenta);
            } else if (this.win3grid % 5 == 0) {
                graphics.setColor(Color.red);
            } else if (this.win3grid % 4 == 0) {
                graphics.setColor(Color.cyan);
            } else if (this.win3grid % 3 == 0) {
                graphics.setColor(Color.green);
            } else if (this.win3grid % 2 == 0) {
                graphics.setColor(Color.blue);
            }
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
            Stroke stroke = graphics2D.getStroke();
            Dimension dimension = this.getSize();
            int n2 = this.parentDW.getCellWidth();
            int n3 = this.parentDW.getCellHeight();
            int n4 = n2;
            int n5 = 1;
            while (n4 <= dimension.width) {
                graphics2D.setStroke(n5 % 10 > 0 ? basicStroke : stroke);
                graphics.drawLine(n4, 0, n4, dimension.height - 1);
                n4 += n2;
                ++n5;
            }
            int n6 = n3;
            n5 = 1;
            while (n6 < dimension.height) {
                graphics2D.setStroke(n5 % 5 > 0 ? basicStroke : stroke);
                graphics.drawLine(0, n6, dimension.width - 1, n6);
                n6 += n3;
                ++n5;
            }
            graphics2D.setStroke(stroke);
            graphics.setColor(color);
        }
    }
}

