/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.TextOnIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;

public class Button
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final Color defDisabledForeground;
    private boolean transparent;
    private boolean flat;
    private String title;
    private Image image;
    private Image imageWithTC;
    private final Border defaultBorder = this.getBorder();
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapPressed;
    private int bitmapRollover;
    private int bitmapWidth;
    private int imageHeight;
    private int imageWidth;
    private Dimension origSize;
    private boolean scaleBestQuality;
    private boolean multiline;
    private int titlePosition;
    private boolean hasBitmap;
    private char mnemonic;
    private Dimension scalebitmaptosize;
    private boolean usetextonicon;
    private Color disabledBackground;
    private Color disabledForeground;
    private int transparentColor = -1;
    private Color background;
    private Color foreground;
    private Color rolloverBackground;
    private Color rolloverForeground;
    private boolean isMouseHovering;
    private Vector<Integer> borderWidth;
    private Color borderColor;
    private Color rolloverBorderColor;
    private int bitmapScale;

    public Button() {
        this.setIconTextGap(3);
        this.addMouseListener(IsguiUtility.mouseAdapter(mouseEvent -> {
            this.isMouseHovering = true;
            if (this.isEnabled()) {
                if (this.shouldManageBorder()) {
                    this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
                }
                if (this.rolloverBackground != null) {
                    this.updateBackground();
                }
                if (this.rolloverForeground != null) {
                    this.updateForeground();
                }
                if (this.rolloverBorderColor != null && this.flat) {
                    this.setBorder(this.getCustomRolloverBorder());
                }
            }
        }, mouseEvent -> {
            this.isMouseHovering = false;
            if (this.isEnabled()) {
                if (this.shouldManageBorder()) {
                    this.setBorder(null);
                }
                if (this.rolloverBackground != null) {
                    this.updateBackground();
                }
                if (this.rolloverForeground != null) {
                    this.updateForeground();
                }
                if (this.rolloverBorderColor != null && this.flat) {
                    this.setBorder(this.borderColor != null ? this.getCustomBorder() : null);
                }
            }
        }, mouseEvent -> {
            if (this.shouldManageBorder() && this.isEnabled()) {
                this.setBorder(BorderFactory.createLoweredSoftBevelBorder());
            }
        }, mouseEvent -> {
            if (this.shouldManageBorder() && this.isEnabled() && this.contains(mouseEvent.getPoint())) {
                this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            }
        }, null));
    }

    private MatteBorder getCustomRolloverBorder() {
        return this.getCustomBorder(this.rolloverBorderColor);
    }

    private MatteBorder getCustomBorder() {
        return this.getCustomBorder(this.borderColor != null ? this.borderColor : Color.darkGray);
    }

    private MatteBorder getCustomBorder(Color color) {
        if (this.borderWidth != null) {
            int n2 = this.borderWidth.size();
            return new MatteBorder(n2 > 0 ? this.borderWidth.elementAt(0) : 1, n2 > 1 ? this.borderWidth.elementAt(1) : 1, n2 > 2 ? this.borderWidth.elementAt(2) : 1, n2 > 3 ? this.borderWidth.elementAt(3) : 1, color);
        }
        return new MatteBorder(1, 1, 1, 1, color);
    }

    private boolean shouldManageBorder() {
        return this.hasBitmap && this.flat && this.borderWidth == null && this.rolloverBorderColor == null && this.rolloverBackground == null && this.rolloverForeground == null;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        this.updateBackground();
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        this.updateForeground();
    }

    public void setHasBitmap(boolean bl) {
        if (this.hasBitmap != bl) {
            this.hasBitmap = bl;
            this.origSize = this.getSize();
        }
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
        this.setTitle(this.title);
    }

    public void setBitmapNumber(int n2) {
        this.bitmapNumber = n2;
        if (this.image != null) {
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
    }

    public void setBitmapDisabled(int n2) {
        this.bitmapDisabled = n2;
        if (this.image != null) {
            this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        }
    }

    public void setBitmapRollover(int n2) {
        this.bitmapRollover = n2;
        if (this.image != null) {
            this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        }
    }

    public void setBitmapPressed(int n2) {
        this.bitmapPressed = n2;
        if (this.image != null) {
            this.setPressedIcon(this.getIcon(this.bitmapPressed));
        }
    }

    public void setBitmapWidth(int n2) {
        this.bitmapWidth = n2;
    }

    private Icon getIcon(int n2) {
        Image image;
        int n3;
        boolean bl;
        Image image2;
        if (n2 <= 0) {
            return null;
        }
        Dimension dimension = this.getSize();
        int n4 = this.bitmapWidth > 0 ? this.bitmapWidth : (this.scalebitmaptosize != null || this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageWidth : this.imageWidth + dimension.width - this.origSize.width);
        int n5 = this.scalebitmaptosize != null || this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageHeight : this.imageHeight + dimension.height - this.origSize.height;
        Image image3 = image2 = this.imageWithTC != null ? this.imageWithTC : this.image;
        if (image2 == null) {
            return null;
        }
        boolean bl2 = bl = this.scalebitmaptosize != null && this.scalebitmaptosize.height > 0 && this.getPreferredSize().height > this.scalebitmaptosize.height;
        if (!(this.bitmapScale <= 0 || bl || this.titlePosition != 0 && this.origSize == null)) {
            int n6;
            if (this.bitmapScale == 1) {
                n6 = 5;
                n3 = 0;
            } else {
                n6 = 7;
                n3 = 1;
            }
            if (this.titlePosition != 0) {
                image = ScreenUtility.getImage(n4, n5, image2, n2);
                float f2 = (float)dimension.width / (float)this.origSize.width;
                float f3 = (float)dimension.height / (float)this.origSize.height;
                if (image != null && (f2 != 1.0f || f3 != 1.0f)) {
                    n4 = Math.round(f2 * (float)image.getWidth(null));
                    n5 = Math.round(f3 * (float)image.getHeight(null));
                    image = IsguiUtility.scale(image, n4, n5, n3, n6, false);
                }
            } else {
                image = ScreenUtility.getImage(this.bitmapWidth == 0 ? image2.getWidth(null) : n4, image2.getHeight(null), image2, n2);
                if (dimension.width - 8 != image.getWidth(null) || dimension.height - 7 != image.getHeight(null)) {
                    image = IsguiUtility.scale(image, dimension.width - 8, dimension.height - 7, n3, n6, false);
                }
            }
        } else {
            image = ScreenUtility.getImage(n4, n5, image2, n2);
        }
        if (image != null) {
            if (bl) {
                return new ImageIcon(ScreenUtility.scale(image, this.scalebitmaptosize.width > 0 ? this.scalebitmaptosize.width : this.getPreferredSize().width, this.scalebitmaptosize.height > 0 ? this.scalebitmaptosize.height : this.getPreferredSize().height, 3, 5, this.scaleBestQuality));
            }
            if (this.usetextonicon && this.title != null) {
                StringBuffer stringBuffer = new StringBuffer(ScreenUtility.rightTrim(this.title));
                n3 = ScreenUtility.getMnemonicIdx(stringBuffer);
                TextOnIcon textOnIcon = new TextOnIcon(image, stringBuffer.toString(), this.titlePosition, this.getForeground(), this.getFont());
                textOnIcon.setMnemonicIndex(n3);
                return textOnIcon;
            }
            return new ImageIcon(image);
        }
        return null;
    }

    public void setImage(Image image, int n2, int n3, int n4) {
        if (this.image != image || this.imageWidth != n2 || this.imageHeight != n3 || this.transparentColor != n4) {
            this.setHasBitmap(image != null);
            this.image = image;
            this.imageHeight = n3;
            this.imageWidth = n2;
            if (this.bitmapNumber == 0) {
                this.bitmapNumber = 1;
            }
            this.transparentColor = n4;
            this.setImageWithTC();
            this.setIcons();
            if (this.hasBitmap) {
                if (this.bitmapPressed > 0 && this.flat) {
                    this.setBorderPainted(false);
                } else {
                    this.setBorderPainted(true);
                }
            }
        }
    }

    private void setImageWithTC() {
        this.imageWithTC = this.image != null && this.transparentColor >= 0 ? ScreenUtility.makeColorTransparent(this.image, this.transparentColor) : null;
    }

    private void setIcons() {
        this.setIcon(this.getIcon(this.bitmapNumber));
        this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        this.setPressedIcon(this.getIcon(this.bitmapPressed));
    }

    public void setTransparent(boolean bl) {
        if (this.transparent != bl) {
            this.transparent = bl;
            this.setOpaque(!this.transparent);
        }
    }

    public void setFlat(boolean bl) {
        if (this.flat != bl) {
            this.flat = bl;
            if (this.flat) {
                this.setBorder(null);
                this.setContentAreaFilled(false);
                if (!this.transparent) {
                    this.setOpaque(true);
                }
                if (this.bitmapPressed > 0) {
                    this.setBorderPainted(false);
                }
            } else {
                if (this.defaultBorder != null) {
                    this.setBorder(this.defaultBorder);
                }
                this.setContentAreaFilled(true);
            }
            this.updateColors();
        }
    }

    public void setTitle(String string) {
        this.title = string;
        string = ScreenUtility.rightTrim(this.title);
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = ScreenUtility.getMnemonicIdx(stringBuffer);
            if (n2 >= 0) {
                this.mnemonic = stringBuffer.charAt(n2);
            }
            if (this.hasBitmap && this.titlePosition <= 0) {
                this.setText(null);
                if (this.getToolTipText() == null || this.getToolTipText().length() == 0) {
                    super.setToolTipText(RemoteBaseGUIControl.buildTitle(stringBuffer.toString(), n2, false));
                }
            } else if (this.multiline) {
                if (!this.usetextonicon) {
                    this.setText(RemoteBaseGUIControl.buildTitle(stringBuffer.toString(), n2, true));
                }
            } else if (!this.usetextonicon) {
                this.setText(stringBuffer.toString());
                if (n2 >= 0 && n2 < stringBuffer.length()) {
                    this.setDisplayedMnemonicIndex(n2);
                }
            } else if (this.image != null) {
                this.setIcon(this.getIcon(this.bitmapNumber));
            }
        }
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if ((string == null || string.length() == 0) && this.title != null && this.hasBitmap && this.titlePosition <= 0) {
            this.setTitle(this.title);
        }
    }

    public char getMnemonicChar() {
        return this.mnemonic;
    }

    public void setTitlePosition(int n2) {
        int n3 = this.titlePosition;
        this.titlePosition = n2;
        this.usetextonicon = false;
        switch (this.titlePosition) {
            case 2: {
                this.setHorizontalTextPosition(4);
                this.setVerticalTextPosition(0);
                break;
            }
            case 1: {
                this.setHorizontalTextPosition(2);
                this.setVerticalTextPosition(0);
                break;
            }
            case 3: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(1);
                break;
            }
            case 4: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                break;
            }
            case 5: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(0);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.usetextonicon = true;
            }
        }
        if (this.image != null) {
            if (this.usetextonicon) {
                this.setText(null);
                this.setBorderPainted(false);
            } else if (this.bitmapPressed > 0 && this.flat) {
                this.setBorderPainted(false);
            } else {
                this.setBorderPainted(true);
            }
            this.setTitle(this.title);
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
        if (n3 == 0 ^ n2 == 0) {
            this.setTitle(this.title);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!bl && this.flat) {
            this.setBorder(null);
        }
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (bl2 != bl) {
            this.updateColors();
        }
    }

    public void setScaleBitmapToSize(Dimension dimension, boolean bl) {
        this.scalebitmaptosize = dimension;
        this.scaleBestQuality = bl;
    }

    public int getImageWidth() {
        return this.bitmapWidth;
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        Dimension dimension = this.getSize();
        super.setBounds(n2, n3, n4, n5);
        if (this.hasBitmap && this.scalebitmaptosize == null && (dimension.width != n4 || dimension.height != n5)) {
            if (this.bitmapScale > 0) {
                this.setIcons();
            } else if (this.titlePosition == 0 && (dimension.height != n5 || this.bitmapWidth == 0)) {
                this.setIcons();
            }
        }
    }

    public void setCustomBorder(Vector<Integer> vector, Color color) {
        this.borderWidth = vector;
        this.borderColor = color;
        if (this.flat && (this.borderColor != null || this.rolloverBorderColor == null)) {
            this.setBorder(this.getCustomBorder());
        }
    }

    public void setRolloverBorderColor(Color color) {
        this.rolloverBorderColor = color;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
        if (!this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color color) {
        this.disabledForeground = color;
        if (!this.isEnabled()) {
            this.updateForeground();
        }
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public void setRolloverBackground(Color color) {
        this.rolloverBackground = color;
        if (this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public void setRolloverForeground(Color color) {
        this.rolloverForeground = color;
        if (this.isEnabled()) {
            this.updateForeground();
        }
    }

    private void updateColors() {
        this.updateBackground();
        this.updateForeground();
    }

    private void updateBackground() {
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverBackground != null) {
                super.setBackground(this.rolloverBackground);
            } else {
                super.setBackground(this.background);
            }
        } else if (this.flat && this.disabledBackground != null) {
            super.setBackground(this.disabledBackground);
        }
    }

    private void updateForeground() {
        Color color = super.getForeground();
        Color color2 = null;
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverForeground != null) {
                color2 = this.rolloverForeground;
                super.setForeground(color2);
            } else {
                color2 = this.foreground;
                super.setForeground(color2);
            }
        } else if (this.flat && this.disabledForeground != null) {
            color2 = this.disabledForeground;
            super.setForeground(color2);
        } else {
            super.setForeground(defDisabledForeground);
        }
        if (this.usetextonicon && color2 != null && color2 != color) {
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public void setTransparentColor(int n2) {
        if (this.transparentColor != n2) {
            this.transparentColor = n2;
            this.setImageWithTC();
            this.setIcons();
        }
    }

    public int getBitmapScale() {
        return this.bitmapScale;
    }

    public void setBitmapScale(int n2) {
        switch (n2) {
            case 1: 
            case 2: {
                this.bitmapScale = n2;
                break;
            }
            default: {
                this.bitmapScale = 0;
            }
        }
    }

    static {
        Color color = UIManager.getColor("Button.disabledText");
        if (color == null) {
            color = UIManager.getColor("Button.disabledForeground");
        }
        if (color == null) {
            color = new ColorUIResource(153, 153, 153);
        }
        defDisabledForeground = color;
    }
}

