/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;

public class CheckBox
extends JCheckBox {
    private static final long serialVersionUID = 1L;
    private static final int LEFT_TEXT_LEFT = 1;
    private static Dimension dimcb;
    private static Insets inscb;
    private static Insets inscbbrd;
    private boolean flat;
    private String title;
    private Image image;
    private Border defaultBorder;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapDisabledSelected;
    private int bitmapPressed;
    private int bitmapRollover;
    private int bitmapSelected;
    private int bitmapRolloverSelected;
    private int bitmapWidth;
    private int imageHeight;
    private int imageWidth;
    private Dimension origSize;
    private boolean multiline;
    private int titlePosition;
    private boolean hasBitmap;
    private boolean vTop;
    private char mnemonic;
    private Integer defaultIconTextGap;
    private int leftTextAlignment;
    private boolean leftText;
    private Color background;
    private Color foreground;
    private Color disabledBackground;
    private Color disabledForeground;
    private Color rolloverBackground;
    private Color rolloverForeground;
    private boolean isMouseHovering;
    private boolean scaleDefaultIcon;
    private int bitmapScale;

    public CheckBox() {
        this.setOpaque(true);
        if (dimcb == null) {
            JCheckBox jCheckBox = new JCheckBox();
            dimcb = jCheckBox.getPreferredSize();
            inscb = jCheckBox.getMargin();
            if (jCheckBox.getBorder() != null) {
                inscbbrd = jCheckBox.getBorder().getBorderInsets(jCheckBox);
            }
            if (inscbbrd != null) {
                inscb = inscbbrd;
            }
        }
        this.addItemListener(itemEvent -> {
            this.drawBorder(this.isSelected());
            if (this.scaleDefaultIcon) {
                this.scaleDefaultIcon();
            }
        });
        this.addMouseListener(IsguiUtility.mouseAdapter(mouseEvent -> {
            this.isMouseHovering = true;
            if (this.isEnabled()) {
                if (this.flat && this.hasBitmap && this.bitmapSelected == 0 && !this.isSelected()) {
                    this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
                }
                if (this.rolloverBackground != null || this.rolloverForeground != null) {
                    this.updateColors();
                }
            }
        }, mouseEvent -> {
            this.isMouseHovering = false;
            if (this.isEnabled()) {
                if (this.flat && this.hasBitmap && this.bitmapSelected == 0 && !this.isSelected()) {
                    this.setBorder(null);
                }
                if (this.rolloverBackground != null || this.rolloverForeground != null) {
                    this.updateColors();
                }
            }
        }, null, mouseEvent -> {
            if (this.flat && this.hasBitmap && this.bitmapSelected == 0 && this.isEnabled() && !this.isSelected()) {
                this.setBorder(null);
            }
        }, null));
    }

    void setScaleDefaultIcon(boolean bl) {
        if (bl != this.scaleDefaultIcon) {
            this.scaleDefaultIcon = bl;
            if (!this.hasBitmap) {
                if (this.scaleDefaultIcon) {
                    Image[] imageArray = RemoteBaseGUIControl.getDefaultScalableCheckBoxImages(this.isSelected());
                    this.setIcon(new ImageIcon(imageArray[0]));
                    this.setDisabledIcon(new ImageIcon(imageArray[1]));
                } else {
                    this.setIcon(null);
                    this.setDisabledIcon(null);
                }
            }
        }
    }

    private void updateColors() {
        this.updateBackground();
        this.updateForeground();
    }

    private void updateBackground() {
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverBackground != null) {
                super.setBackground(this.rolloverBackground);
            } else {
                super.setBackground(this.background);
            }
        } else if (this.disabledBackground != null) {
            super.setBackground(this.disabledBackground);
        } else {
            super.setBackground(this.background);
        }
    }

    private void updateForeground() {
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverForeground != null) {
                super.setForeground(this.rolloverForeground);
            } else {
                super.setForeground(this.foreground);
            }
        } else if (this.disabledForeground != null) {
            super.setForeground(this.disabledForeground);
        } else {
            super.setForeground(this.foreground);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (bl2 != bl) {
            this.updateColors();
            if (this.scaleDefaultIcon) {
                this.scaleDefaultIcon();
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        this.updateBackground();
    }

    @Override
    public void setForeground(Color color) {
        if (color != null && !(color instanceof ColorUIResource)) {
            color = new ColorUIResource(color);
        }
        this.foreground = color;
        this.updateForeground();
    }

    public void setHasBitmap(boolean bl) {
        if (this.hasBitmap != bl) {
            this.hasBitmap = bl;
        }
        this.origSize = this.getSize();
    }

    public void setVTop(boolean bl) {
        this.vTop = bl;
        if (this.titlePosition != 3 && this.titlePosition != 4) {
            if (this.vTop) {
                this.setVerticalTextPosition(1);
                this.setVerticalAlignment(1);
            } else {
                this.setVerticalTextPosition(0);
                this.setVerticalAlignment(0);
            }
        }
    }

    public void setBoundsMinimized(int n2, int n3, int n4, int n5) {
        if (!(inscb == null || this.hasBitmap || this.title != null && this.title.length() != 0 || dimcb == null || CheckBox.dimcb.width <= 0 || n4 > CheckBox.dimcb.width - CheckBox.inscb.left - CheckBox.inscb.right + 1)) {
            this.setMargin(null);
            if (n4 <= CheckBox.dimcb.width - CheckBox.inscb.right - CheckBox.inscb.left + 1) {
                this.setBorder(BorderFactory.createEmptyBorder(CheckBox.inscb.top, 0, CheckBox.inscb.bottom, 0));
                n4 = CheckBox.dimcb.width - CheckBox.inscb.right - CheckBox.inscb.left;
            } else if (this.leftText) {
                this.setBorder(BorderFactory.createEmptyBorder(CheckBox.inscb.top, 0, CheckBox.inscb.bottom, CheckBox.inscb.right));
                n4 = this.getPreferredSize().width;
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(CheckBox.inscb.top, CheckBox.inscb.left, CheckBox.inscb.bottom, 0));
                n4 = this.getPreferredSize().width;
            }
            super.setBounds(n2, n3, n4, n5);
        }
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        Dimension dimension = this.getSize();
        super.setBounds(n2, n3, n4, n5);
        if (this.hasBitmap && (dimension.width != n4 || dimension.height != n5)) {
            if (this.bitmapScale > 0) {
                this.setIcons();
            } else if (this.titlePosition == 0 && (dimension.height != n5 || this.bitmapWidth == 0)) {
                this.setIcons();
            }
        }
        if (dimension.width != n4) {
            this.updateIconTextGap();
        }
        if (dimension.height != n5) {
            this.scaleDefaultIcon();
        }
    }

    private void scaleDefaultIcon() {
        if (this.hasBitmap || !this.scaleDefaultIcon || this.origSize == null) {
            return;
        }
        float f2 = (float)this.getSize().height / (float)this.origSize.height;
        Image[] imageArray = RemoteBaseGUIControl.getDefaultScalableCheckBoxImages(this.isSelected());
        imageArray[0] = RemoteBaseGUIControl.getScaledImage(imageArray[0], f2);
        imageArray[1] = RemoteBaseGUIControl.getScaledImage(imageArray[1], f2);
        this.setIcon(new ImageIcon(imageArray[0]));
        this.setDisabledIcon(new ImageIcon(imageArray[1]));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateIconTextGap();
    }

    public void setLeftText(boolean bl) {
        this.leftText = bl;
        if (this.leftText) {
            if (this.titlePosition != 3 && this.titlePosition != 4) {
                this.setTitlePosition(1);
            }
        } else if (this.titlePosition != 3 && this.titlePosition != 4) {
            this.setTitlePosition(2);
        }
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
        this.setTitle(this.title);
    }

    public void setBitmapNumber(int n2) {
        this.bitmapNumber = n2;
        if (this.image != null) {
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
    }

    public void setBitmapDisabled(int n2) {
        this.bitmapDisabled = n2;
        if (this.image != null) {
            this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        }
    }

    public void setBitmapDisabledSelected(int n2) {
        this.bitmapDisabledSelected = n2;
        if (this.image != null) {
            this.setDisabledSelectedIcon(this.getIcon(this.bitmapDisabledSelected));
        }
    }

    public void setBitmapRollover(int n2) {
        this.bitmapRollover = n2;
        if (this.image != null) {
            this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        }
    }

    public void setBitmapSelected(int n2) {
        this.bitmapSelected = n2;
        if (this.image != null) {
            this.setSelectedIcon(this.getIcon(this.bitmapSelected));
        }
    }

    public void setBitmapRolloverSelected(int n2) {
        this.bitmapRolloverSelected = n2;
        if (this.image != null) {
            this.setRolloverSelectedIcon(this.getIcon(this.bitmapRolloverSelected));
        }
    }

    public void setBitmapPressed(int n2) {
        this.bitmapPressed = n2;
        if (this.image != null) {
            this.setPressedIcon(this.getIcon(this.bitmapPressed));
        }
    }

    public void setBitmapWidth(int n2) {
        this.bitmapWidth = n2;
    }

    private Icon getIcon(int n2) {
        Image image;
        if (n2 <= 0) {
            return null;
        }
        Dimension dimension = this.getSize();
        int n3 = this.bitmapWidth > 0 ? this.bitmapWidth : (this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageWidth : this.imageWidth + dimension.width - this.origSize.width);
        int n4 = this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageHeight : this.imageHeight + dimension.height - this.origSize.height;
        if (this.bitmapScale > 0 && (this.titlePosition == 0 || this.origSize != null)) {
            int n5;
            int n6;
            if (this.bitmapScale == 1) {
                n6 = 5;
                n5 = 0;
            } else {
                n6 = 7;
                n5 = 1;
            }
            if (this.titlePosition != 0) {
                image = ScreenUtility.getImage(n3, n4, this.image, n2);
                float f2 = (float)dimension.width / (float)this.origSize.width;
                float f3 = (float)dimension.height / (float)this.origSize.height;
                if (image != null && (f2 != 1.0f || f3 != 1.0f)) {
                    n3 = Math.round(f2 * (float)image.getWidth(null));
                    n4 = Math.round(f3 * (float)image.getHeight(null));
                    image = IsguiUtility.scale(image, n3, n4, n5, n6, false);
                }
            } else if (this.image != null) {
                image = ScreenUtility.getImage(this.bitmapWidth == 0 ? this.image.getWidth(null) : n3, this.image.getHeight(null), this.image, n2);
                if (dimension.width - 8 != image.getWidth(null) || dimension.height - 7 != image.getHeight(null)) {
                    image = IsguiUtility.scale(image, dimension.width - 8, dimension.height - 7, n5, n6, false);
                }
            } else {
                image = null;
            }
        } else {
            image = ScreenUtility.getImage(n3, n4, this.image, n2);
        }
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public void setImage(Image image, int n2, int n3) {
        if (this.image != image || this.imageWidth != n2 || this.imageHeight != n3) {
            this.setHasBitmap(image != null);
            this.image = image;
            this.imageHeight = n3;
            this.imageWidth = n2;
            if (this.bitmapNumber == 0) {
                this.bitmapNumber = 1;
            }
            this.setIcons();
            if (this.hasBitmap) {
                if (this.bitmapSelected > 0 && this.flat) {
                    this.setBorderPainted(false);
                } else {
                    this.setBorderPainted(true);
                }
            }
        }
    }

    private void setIcons() {
        this.setIcon(this.getIcon(this.bitmapNumber));
        this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        this.setDisabledSelectedIcon(this.getIcon(this.bitmapDisabledSelected));
        this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        this.setPressedIcon(this.getIcon(this.bitmapPressed));
        this.setSelectedIcon(this.getIcon(this.bitmapSelected));
        this.setRolloverSelectedIcon(this.getIcon(this.bitmapRolloverSelected));
    }

    public void drawBorder(boolean bl) {
        if (this.hasBitmap && this.bitmapSelected == 0) {
            if (bl) {
                this.setBorder(BorderFactory.createLoweredSoftBevelBorder());
            } else if (this.flat) {
                this.setBorder(null);
            } else {
                this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.drawBorder(this.isSelected());
        }
    }

    public void setFlat(boolean bl) {
        this.flat = bl;
        if (this.flat) {
            this.defaultBorder = this.getBorder();
            this.setBorder(null);
            this.setContentAreaFilled(false);
            if (this.hasBitmap && this.titlePosition == 0 && this.title == null) {
                this.setHorizontalAlignment(0);
            }
            if (this.bitmapSelected > 0) {
                this.setBorderPainted(false);
            }
        } else {
            if (this.defaultBorder != null) {
                this.setBorder(this.defaultBorder);
            }
            this.setContentAreaFilled(true);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        string = ScreenUtility.rightTrim(this.title);
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = ScreenUtility.getMnemonicIdx(stringBuffer);
            if (n2 >= 0) {
                this.mnemonic = stringBuffer.charAt(n2);
            }
            if (this.hasBitmap && this.titlePosition <= 0) {
                this.setText(null);
                if (this.getToolTipText() == null || this.getToolTipText().length() == 0) {
                    super.setToolTipText(RemoteBaseGUIControl.buildTitle(stringBuffer.toString(), n2, false));
                }
            } else if (this.multiline) {
                this.setText(RemoteBaseGUIControl.buildTitle(stringBuffer.toString(), n2, false, false, true, false));
            } else {
                this.setText(stringBuffer.toString());
                if (n2 >= 0 && n2 < stringBuffer.length()) {
                    this.setDisplayedMnemonicIndex(n2);
                }
            }
        }
        this.updateIconTextGap();
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if ((string == null || string.length() == 0) && this.title != null && this.hasBitmap && this.titlePosition <= 0) {
            this.setTitle(this.title);
        }
    }

    public void setTitlePosition(int n2) {
        int n3 = this.titlePosition;
        this.titlePosition = n2;
        switch (this.titlePosition) {
            case 2: {
                this.setHorizontalTextPosition(4);
                this.setVerticalTextPosition(0);
                this.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.setHorizontalTextPosition(2);
                this.setVerticalTextPosition(0);
                if (this.leftText) {
                    this.setHorizontalAlignment(4);
                    break;
                }
                this.setHorizontalAlignment(2);
                break;
            }
            case 3: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(1);
                this.setHorizontalAlignment(0);
                break;
            }
            case 4: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setHorizontalAlignment(0);
            }
        }
        if (n3 == 0 ^ n2 == 0) {
            this.setTitle(this.title);
        }
    }

    public int getLeftTextAlignment() {
        return this.leftTextAlignment;
    }

    public void setLeftTextAlignment(int n2) {
        this.leftTextAlignment = n2;
        if (this.titlePosition == 1 && this.leftText) {
            this.updateIconTextGap();
        }
    }

    private int getDefaultIconTextGap() {
        if (this.defaultIconTextGap == null) {
            this.defaultIconTextGap = new Integer(this.getIconTextGap());
        }
        return this.defaultIconTextGap;
    }

    private void updateIconTextGap() {
        int n2;
        int n3;
        int n4 = this.getDefaultIconTextGap();
        this.setIconTextGap(n4);
        if (this.leftText && this.leftTextAlignment == 1 && this.titlePosition != 3 && this.titlePosition != 4 && (n3 = this.getSize().width) > (n2 = this.getPreferredSize().width)) {
            this.setIconTextGap(n3 - n2 + n4);
        }
    }

    public char getMnemonicChar() {
        return this.mnemonic;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
        if (!this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color color) {
        this.disabledForeground = color;
        if (!this.isEnabled()) {
            this.updateForeground();
        }
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public void setRolloverBackground(Color color) {
        this.rolloverBackground = color;
        if (this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public void setRolloverForeground(Color color) {
        this.rolloverForeground = color;
        if (this.isEnabled()) {
            this.updateForeground();
        }
    }

    public int getBitmapScale() {
        return this.bitmapScale;
    }

    public void setBitmapScale(int n2) {
        switch (n2) {
            case 1: 
            case 2: {
                this.bitmapScale = n2;
                break;
            }
            default: {
                this.bitmapScale = 0;
            }
        }
    }
}

