/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.ChipsBoxElement;
import com.iscobol.gui.client.swing.NotifyMouseEvent;
import com.iscobol.gui.client.swing.NotifyMouseListener;
import com.iscobol.gui.client.swing.RemoteChipsBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ChipsBoxContainer
extends JScrollPane
implements Constants {
    private static final long serialVersionUID = 1L;
    RemoteChipsBox parent;
    JPanel jpcb = new JPanel();
    Vector<ChipsBoxElement> cpvector = new Vector();
    private Image image;
    private Image imagemouseentered;
    private Image imagemouseexited;
    private int imageHeight = -1;
    private int imageWidth = -1;
    private int bitmapNumber = -1;
    private Dimension origSize;
    private Color background;
    private Color foreground;
    private Font font;
    private MouseListener ml = null;
    private int chipstype = 1;
    private int textheight = -1;
    private int chipsradius = 100;
    private int chipsborderwidth = -1;
    private int chipsrolloverborderwidth = -1;
    private NotifyMouseListener nmListener = null;

    public ChipsBoxContainer(RemoteChipsBox remoteChipsBox) {
        this.parent = remoteChipsBox;
        this.setHorizontalScrollBarPolicy(31);
        this.setViewportView(this.jpcb);
        this.jpcb.setLayout(new IsWrapLayout(3));
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                JViewport jViewport = jScrollPane.getViewport();
                Dimension dimension = jViewport.getSize();
                jViewport.getView().setSize(dimension);
            }
        });
    }

    public void setType(int n2) {
        this.chipstype = n2;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.ml = mouseListener;
    }

    public MouseListener getMouseListener() {
        return this.ml;
    }

    private Icon getIcon(int n2) {
        return null;
    }

    public void setImage(Image image, int n2, int n3) {
        if (this.image != image || this.imageWidth != n2 || this.imageHeight != n3) {
            this.image = image;
            this.imageHeight = n3;
            this.imageWidth = n2;
            if (this.bitmapNumber == 0) {
                this.bitmapNumber = 1;
            }
        }
    }

    public void setImageMouseEntered(Image image) {
        this.imagemouseentered = image;
    }

    public void setImageMouseExited(Image image) {
        this.imagemouseexited = image;
    }

    public int itemToAdd(String string, int n2, int n3, int n4) {
        this.textheight = n3;
        this.setChipsRadius(n4);
        ChipsBoxElement chipsBoxElement = new ChipsBoxElement(this, this.jpcb, string, n2, n3, this.imagemouseentered, this.imagemouseexited, this.chipstype, n4, this.chipsborderwidth, this.chipsrolloverborderwidth);
        this.cpvector.add(chipsBoxElement);
        if (this.foreground != null) {
            chipsBoxElement.setForegroundAndCheck(this.foreground);
        }
        if (this.background != null && this.parent != null && this.parent.isBackgroundSet()) {
            chipsBoxElement.setBackgroundAndCheck(this.background);
        }
        if (this.font != null) {
            chipsBoxElement.setFont(this.font);
        }
        this.jpcb.add(chipsBoxElement);
        this.jpcb.doLayout();
        this.getViewport().validate();
        return this.cpvector.size();
    }

    public int itemToDelete(int n2) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            this.jpcb.remove(chipsBoxElement);
            this.jpcb.doLayout();
            this.getViewport().validate();
            this.repaint();
            if (this.cpvector.indexOf(chipsBoxElement) >= 0) {
                this.cpvector.remove(chipsBoxElement);
            }
        }
        return n3;
    }

    public void resetList() {
        this.jpcb.removeAll();
        this.jpcb.doLayout();
        this.getViewport().validate();
        this.repaint();
        this.cpvector.clear();
    }

    public void setBitmapNumber(int n2, int n3) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            chipsBoxElement.setBitmapNumber(n3);
        }
    }

    public void setBitmapWidth(int n2, int n3) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            chipsBoxElement.setBitmapWidth(n3);
        }
    }

    public void setBitmap(int n2, int n3, Image image) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            chipsBoxElement.setBitmap(n3, image, false);
        }
    }

    public void setItemText(int n2, String string, int n3, int n4) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        this.textheight = n4;
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            chipsBoxElement.setItemText(string, n3, n4);
            this.doLayout();
        }
    }

    public void msgClose(int n2) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            this.jpcb.remove(chipsBoxElement);
            if (this.cpvector.indexOf(chipsBoxElement) >= 0) {
                this.cpvector.remove(chipsBoxElement);
            }
            this.jpcb.doLayout();
            this.getViewport().validate();
            this.repaint();
        }
    }

    public void setFontDimension(int n2) {
        int n3 = this.textheight;
        this.textheight = n2;
        ChipsBoxElement chipsBoxElement = null;
        if (this.jpcb != null) {
            for (int i2 = 0; i2 < this.cpvector.size(); ++i2) {
                chipsBoxElement = this.cpvector.elementAt(i2);
                chipsBoxElement.setTextHeight(this.textheight);
            }
            this.jpcb.doLayout();
            this.getViewport().validate();
            this.repaint();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        ChipsBoxElement chipsBoxElement = null;
        if (this.jpcb != null) {
            for (int i2 = 0; i2 < this.cpvector.size(); ++i2) {
                chipsBoxElement = this.cpvector.elementAt(i2);
                chipsBoxElement.setFont(font);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        ChipsBoxElement chipsBoxElement = null;
        if (this.jpcb != null) {
            for (int i2 = 0; i2 < this.cpvector.size(); ++i2) {
                chipsBoxElement = this.cpvector.elementAt(i2);
                chipsBoxElement.setForegroundAndCheck(color);
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.parent != null && this.parent.isBackgroundSet()) {
            this.background = color;
        }
        ChipsBoxElement chipsBoxElement = null;
        if (this.jpcb != null) {
            for (int i2 = 0; i2 < this.cpvector.size(); ++i2) {
                chipsBoxElement = this.cpvector.elementAt(i2);
                chipsBoxElement.setBackgroundAndCheck(color);
            }
        }
    }

    public void setChipsRadius(int n2) {
        if (this.chipsradius != n2 && n2 >= 0 && n2 <= 100) {
            this.chipsradius = n2;
            ChipsBoxElement chipsBoxElement = null;
            if (this.jpcb != null) {
                for (int i2 = 0; i2 < this.cpvector.size(); ++i2) {
                    chipsBoxElement = this.cpvector.elementAt(i2);
                    chipsBoxElement.setChipsRadius(n2);
                }
                this.repaint();
                this.doLayout();
                this.validate();
            }
        }
    }

    public RemoteChipsBox getCBParent() {
        return this.parent;
    }

    private ColorCmp setColor(ColorCmp colorCmp, int n2) {
        return this.setColor(colorCmp, n2, false, false, false);
    }

    private ColorCmp setColor(ColorCmp colorCmp, int n2, boolean bl, boolean bl2) {
        return this.setColor(colorCmp, n2, true, bl, bl2);
    }

    private ColorCmp setColor(ColorCmp colorCmp, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (n2 == 0 && !bl3) {
            return null;
        }
        if (bl) {
            if (colorCmp == null) {
                colorCmp = new ColorCmp(true);
            }
            if (bl2) {
                if (bl3 || ColorCmp.isRGB(n2)) {
                    colorCmp.setBackRGB(n2);
                } else {
                    colorCmp.setBackground(n2);
                }
            } else if (bl3 || ColorCmp.isRGB(n2)) {
                colorCmp.setForeRGB(n2);
            } else {
                colorCmp.setForeground(n2);
            }
        } else {
            if (colorCmp == null) {
                colorCmp = new ColorCmp(true);
            }
            colorCmp.setColor(n2, true);
        }
        return colorCmp;
    }

    public int getCBColor(int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            n3 = chipsBoxElement.getCBColor(bl, bl2, bl3);
        }
        return n3;
    }

    public void setCBColor(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        ColorCmp colorCmp = null;
        if (bl || bl2 || bl3) {
            colorCmp = chipsBoxElement.getCBColor();
        }
        chipsBoxElement.setCBColor(this.setColor(colorCmp, n3, bl, bl2, bl3), n3, bl, bl2, bl3);
    }

    public int getCBRolloverColor(int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            n3 = chipsBoxElement.getCBRolloverColor(bl, bl2, bl3);
        }
        return n3;
    }

    public void setCBRolloverColor(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        ColorCmp colorCmp = null;
        if (bl || bl2 || bl3) {
            colorCmp = chipsBoxElement.getCBRolloverColor();
        }
        chipsBoxElement.setCBRolloverColor(this.setColor(colorCmp, n3, bl, bl2, bl3), n3, bl, bl2, bl3);
    }

    public int getCBBorderColor(int n2, boolean bl) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            n3 = chipsBoxElement.getCBBorderColor(bl);
        }
        return n3;
    }

    public void setCBBorderColor(int n2, Color color, int n3, boolean bl) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        chipsBoxElement.setCBBorderColor(color, n3, bl);
    }

    public int getCBRolloverBorderColor(int n2, boolean bl) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            n3 = chipsBoxElement.getCBRolloverBorderColor(bl);
        }
        return n3;
    }

    public void setCBRolloverBorderColor(int n2, Color color, int n3, boolean bl) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        chipsBoxElement.setCBRolloverBorderColor(color, n3, bl);
    }

    public Color getColor(int n2) {
        return this.parent.getColor(n2);
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            this.setBorder(null);
        } else {
            this.setBorder(BorderFactory.createLineBorder(color));
        }
    }

    public void setHiddenData(int n2, Object object) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            chipsBoxElement.setHiddenData(object);
        }
    }

    public Object getHiddenData(int n2) {
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return null;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            return chipsBoxElement.getHiddenData();
        }
        return null;
    }

    public void sendClose(ChipsBoxElement chipsBoxElement) {
        this.parent.sendClose(this.cpvector.indexOf(chipsBoxElement));
    }

    public void sendClicked(ChipsBoxElement chipsBoxElement) {
        this.parent.sendClicked(this.cpvector.indexOf(chipsBoxElement));
    }

    public void sendMouseEntered(ChipsBoxElement chipsBoxElement) {
        if (this.nmListener != null) {
            this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(chipsBoxElement, 17023, this.cpvector.indexOf(chipsBoxElement) + 1, 1));
        }
    }

    public void sendMouseExited(ChipsBoxElement chipsBoxElement) {
        if (this.nmListener != null) {
            this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(chipsBoxElement, 17024, 0, 0));
        }
    }

    public int getLastChip() {
        return this.cpvector.size();
    }

    public String getItemText(int n2) {
        String string = "";
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return string;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            string = chipsBoxElement.getItemText();
        }
        return string;
    }

    public int getBitmap(int n2) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            n3 = chipsBoxElement.getBitmap();
        }
        return n3;
    }

    public int getBitmapNumber(int n2) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            n3 = chipsBoxElement.getBitmapNumber();
        }
        return n3;
    }

    public int getBitmapWidth(int n2) {
        int n3 = -1;
        if (n2 < 0 || n2 > this.cpvector.size()) {
            return n3;
        }
        ChipsBoxElement chipsBoxElement = this.cpvector.elementAt(n2);
        if (chipsBoxElement != null) {
            n3 = chipsBoxElement.getBitmapWidth();
        }
        return n3;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.jpcb != null) {
            this.jpcb.doLayout();
        }
    }

    public void setBorderWidth(int n2) {
        this.chipsborderwidth = n2;
    }

    public int getBorderWidth() {
        return this.chipsborderwidth;
    }

    public void setRolloverBorderWidth(int n2) {
        this.chipsrolloverborderwidth = n2;
    }

    public int getRolloverBorderWidth() {
        return this.chipsrolloverborderwidth;
    }

    public void addNotifyMouseListener(NotifyMouseListener notifyMouseListener) {
        this.nmListener = notifyMouseListener;
    }

    public void removeNotifyMouseListener() {
        this.nmListener = null;
    }

    public class IsWrapLayout
    extends FlowLayout {
        private Dimension preferredLayoutSize;

        public IsWrapLayout() {
        }

        public IsWrapLayout(int n2) {
            super(n2);
        }

        public IsWrapLayout(int n2, int n3, int n4) {
            super(n2, n3, n4);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.layoutSize(container, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.layoutSize(container, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container container, boolean bl) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n2 = container.getSize().width;
                if (n2 == 0) {
                    n2 = Integer.MAX_VALUE;
                }
                int n3 = this.getHgap();
                int n4 = this.getVgap();
                Insets insets = container.getInsets();
                int n5 = n2 - (insets.left + insets.right + n3 * 2);
                Dimension dimension = new Dimension(0, 0);
                int n6 = 0;
                int n7 = 0;
                int n8 = container.getComponentCount();
                for (int i2 = 0; i2 < n8; ++i2) {
                    Dimension dimension2;
                    Component component = container.getComponent(i2);
                    if (!component.isVisible()) continue;
                    Dimension dimension3 = dimension2 = bl ? component.getPreferredSize() : component.getMinimumSize();
                    if (n6 + dimension2.width > n5) {
                        this.addRow(dimension, n6, n7);
                        n6 = 0;
                        n7 = 0;
                    }
                    if (n6 > 0) {
                        n6 += n3;
                    }
                    n6 += dimension2.width;
                    n7 = Math.max(n7, dimension2.height);
                }
                this.addRow(dimension, n6, n7);
                dimension.width += insets.left + insets.right + n3 * 2;
                dimension.height += insets.top + insets.bottom + n4 * 2;
                return dimension;
            }
        }

        private void addRow(Dimension dimension, int n2, int n3) {
            dimension.width = Math.max(dimension.width, n2);
            if (dimension.height > 0) {
                dimension.height += this.getVgap();
            }
            dimension.height += n3;
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension = this.preferredLayoutSize(container);
            if (dimension.equals(this.preferredLayoutSize)) {
                super.layoutContainer(container);
            } else {
                this.preferredLayoutSize = dimension;
                container.invalidate();
                Container container2 = container;
                if (container2.getParent() != null) {
                    container2 = container2.getParent();
                }
                container2.validate();
            }
        }
    }
}

